/* Author: Tobi Vollebregt */

/*  TankZone: My second Allegro game.
 *  Copyright (C) 2003  Tobi Vollebregt
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See `License.txt', which contains a verbatim copy of the
 *  GNU General Public License, for details.
 *
 *  Please send your reaction to: tobivollebregt@hotmail.com
 */

#define USE_ENGINE

//#define MEMDEBUG    1

#include "tankzone.h"
#include "fade16.h"

#ifdef USE_ENGINE
#include "engine.h"
#endif

#define _getpixel   getpixel
#define _getpixel16 getpixel

#ifdef MEMDEBUG
void *debug_pointer=NULL;
int debug_memsize=0;
#endif

#ifdef ALLEGRO_DJGPP
unsigned long virtual_mem;
#endif

int scrw,scrh,colordepth;
int MAPW, MAPH;
int GLOW, GLOH;
#define CLEAR_MOUSE     \
{int xm,ym;position_mouse(scrw/2,scrh/2);get_mouse_mickeys(&xm, &ym);}

//#define SMART_TURRETS 1

  int av_green_age=0,av_red_age=0,av_blue_age=0;

int VIEW, VIEH;
int AANTAL_TURRETS=MAX_TURRETS-1;
bool use_sound,use_jgmod,use_randommap;
int sound_voices=10,jgmod_voices=32,jgmod_volume,jgmod_start_time,jgmod_count;
DATAFILE *sample;
int side_color[6][64];
BITMAP *explosion_light[30], *fire_light, *blue_light, *green_light, *red_light, *white_light;
BITMAP *fire_animation[256]; //*bigfire_animation[128];
int fire_color[256];
int explosion_light_radius[30]={256,247,239,230,222,213,205,196,188,179,170,162,154,145,136,128,119,110,102,94,85,77,68,60,51,43,34,26,17,9};
bool use_lighting,use_intro,use_turrets_vs_turrets;
FILE *input_file;
PALETTE lpal;
BITMAP *buffer, *buffer2,*page[2], *map;
DATAFILE *lnd, *expl;
// don't delete this stupid variable "ghfjkf"
// its here to validate the use of accessible[-1]
u_char ghfjkf=0, accessible[] = {/*tank0*/0,/*tank1*/0,/*grass*/1,/*dgrass1*/1,
/*dgrass2*/1,/*desertedge*/1,/*desert*/1,/*ddesert1*/1,/*ddesert2*/1,
/*shore*/1,/*water*/1,/*wall*/0,/*turret*/0,/*dturret*/1,/*rock*/0,
/*seaportl*/1,/*seaportr*/1,/*seaportb*/0,/*roadh*/1,/*roadv*/1,
/*crossroads*/1,/*woodv*/1,/*woodv*/1,/*woodh*/1,/*dwoodh*/1,
/* now, only accessible tiles will follow */
1,1,1,1,1,1,1,1,1,1,/* line 1*/
1,1,1,1,1,1,1,1,1,1,/* line 2*/
1,1,1,1,1,1,1,1,1,1,/* line 3*/
1,1,1,1,1,1,1,1,1,1,/* line 4*/
1,1,1,1,1,1,1,1,1,1,/* line 5*/
1,1,1,1,1,1,1,1,1,1,/* line 6*/
1,1,1,1,1,1,1,1,1,1,/* line 7*/
1,1,1,1,1,1,1,1,1,1,/* line 8*/
1,1,1,1,1,1,1,1,1,1,/* line 9*/
1,1,1,1,1,1,1,1,1,1,/* line 10*/
1};/* this must be enough */
VIEWPORT view[2];
PLAYERTANK tnk[2];
TURRET tur[MAX_TURRETS];
CANNONBALL can[MAX_CANNONBALLS + 1];
EXPLOSION ex[MAX_EXPLOSIONS + 1];
SMOKE smk[MAX_SMOKES + 1];
PLONS pls[MAX_PLONZEN + 1];
FIRE fir[MAX_FIRES + 1];
volatile int frame=0,fps=0,frame_tot=0,secs_tot=0,speed_counter=1; 
unsigned int game_time=0;
int white, grey, yellow, orange, l_red, d_red, l_green, vl_blue, l_blue, d_blue;
int winner=-1,disp_alarm=-1,sound_freq=1000,game_speed=30; 
int screenshot_count;
int turret_count=0;
BITMAP *turretmap;

void add_message(VIEWPORT *v, char *fmt, ...)
{   int i;
    char temp[256],*tmp;
    va_list va;
    va_start(va,fmt);
    vsprintf(temp,fmt,va);
    va_end(va);
    tmp=(char *)malloc(strlen(temp)+1);
    if(!tmp) MEMERR;
    strcpy(tmp,temp);
    for(i=0; i<MESSAGECOUNT; i++)
    if(!v->msg[i]) {v->msg[i]=tmp; break;}
    if(i>=MESSAGECOUNT)
    {   free(v->msg[0]);
    for(i=0; i<MESSAGECOUNT-1; i++) v->msg[i]=v->msg[i+1];
    v->msg[MESSAGECOUNT-1]=tmp;
    }
    if(i==0) v->count=600;
}

void handle_messages(VIEWPORT *v)
{   int i;
    v->count--;
    if(v->count<0)
    {   if(v->msg[0]) free(v->msg[0]);
    for(i=0; i<MESSAGECOUNT-1; i++) v->msg[i]=v->msg[i+1];
    v->msg[MESSAGECOUNT-1]=NULL;
    v->count=600;
    }
}

char *timeoftheday_list[12] = {"00:00 h","02:00 h","04:00 h","06:00 h","08:00 h","10:00 h","12:00 h","14:00 h","16:00 h","18:00 h","20:00 h","22:00 h"};
typedef struct { unsigned char r, g, b; } MY_RGB;
MY_RGB timeoftheday_color[12] = {{16,16,16},{0,0,0},{32,16,0},{64,48,32},{96,80,64},{128,96,80},{128,128,96},{128,128,128},{112,112,112},{96,96,96},{64,64,64},{32,32,32}};
int timeoftheday=0;

char *timeoftheday_getter(int index, int *list_size)
{   if(index < 0) *list_size = 12;
    else return timeoftheday_list[index];
    return NULL;
}

int lightlevel_select(int *color)
{   MY_RGB *rgb;
    DIALOG dialog[] = {
    /* int (*proc)(), int x, y, w, h, fg, bg, key, flags, d1, d2, void *dp, *dp2, *dp3 */
    {d_shadow_box_proc,0,0,312,158,0,0,0,0,0,0,NULL,NULL,NULL},
    {d_ctext_proc, 156,8,1,1,0,0,0,0,0,0,"Select time",NULL,NULL},
    {d_button_proc,196,105,100,16,0,0,0,D_EXIT,0,0,"Ok",NULL,NULL},
    {d_button_proc,196,127,100,16,0,0,27,D_EXIT,0,0,"Cancel",NULL,NULL},
    {d_list_proc,28,28,240,67,0,0,0,D_EXIT,1,0,timeoftheday_getter,NULL,NULL},
    {NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL}};
    clear_to_color(screen,makecol(128,128,128));
    set_dialog_color(dialog,gui_fg_color,gui_bg_color);
    centre_dialog(dialog);
    if(do_dialog(dialog,4)==3) return 0;
    rgb=&timeoftheday_color[dialog[4].d1];
    *color=makecol24(rgb->r,rgb->g,rgb->b);
    return -1;
}

void fps_proc(void)
{   fps=frame; frame=0; frame_tot+=fps; secs_tot++;
}END_OF_FUNCTION(fps_proc);

void increment_speed_counter(void)
{   speed_counter++;
}END_OF_FUNCTION(increment_speed_counter);

void load_map(char *name)
{ BITMAP *map24;
  int last = 2, i, turn = 0, get = 2, x, y, gras = makecol24(0,255,0),
      woestijn = makecol24(255,255,128), woestijnrand = makecol24(255,255,0),
      muur = makecol24(128,128,128), rots = makecol24(128,64,0),
      water = makecol24(0,0,255), waterrand = makecol24(0,0,128),
      turret = makecol24(0,128,0), p0turret = makecol24(255,0,0),
      p1turret = makecol24(64,0,255), p0tank = makecol24(255,0,128),
      p1tank = makecol24(128,128,255), havenrechts = makecol24(64,64,64),
      havenlinks = makecol24(96,96,96), havenhuis = makecol24(191,0,0), 
      weghor = makecol24(0,0,0), wegver = makecol24(32,32,32),
      wegkruis = makecol24(64,0,0), wood = makecol24(160,80,0),
      woodh = makecol24(140,70,0); 

  for(i = 0; i < MAX_TURRETS; i++) tur[i].used = FALSE;
  set_color_conversion(COLORCONV_NONE);
  map24 = load_bitmap(name, NULL);
  set_color_conversion(COLORCONV_TOTAL);
  MAPW = map24->w;
  MAPH = map24->h;
  GLOW = TILE_SIZE * MAPW;
  GLOH = TILE_SIZE * MAPH;
  map = create_bitmap_ex(8, MAPW, MAPH);
  if(!map) MEMERR;
  if(!(turretmap =create_bitmap_ex(16,MAPW,MAPH))) MEMERR;
    clear(map);
    clear(turretmap);
  for(x = 0; x < MAPW; x++)
  { for(y = 0; y < MAPH; y++)
    { last = get;
      get = getpixel(map24, x, y);
      if(get == gras) putpixel(map, x, y, TILE_GRASS);
      else
    if(get == woestijn) putpixel(map, x, y, TILE_DESERT);
    else
      if(get == woestijnrand) putpixel(map, x, y, TILE_DESERTEDGE);
      else
        if(get == water) putpixel(map, x, y, TILE_WATER);
        else
          if(get == waterrand) putpixel(map, x, y, TILE_SHORE);
          else
        if(get == muur) putpixel(map, x, y, TILE_WALL);
        else
          if(get == rots) putpixel(map, x, y, TILE_ROCK);
          else
            if(get == turret)
            { //if(use_ai_turrets)
              { tur[turn].used = TRUE;
            tur[turn].x = x * TILE_SIZE + TILE_SIZE / 2;
            tur[turn].y = y * TILE_SIZE + TILE_SIZE / 2;
            tur[turn].start = 0;
            tur[turn].stop = 2;
            putpixel(map, x, y, TILE_TURRET);
            putpixel(turretmap,x,y,turn+1);
            if(turn < MAX_TURRETS - 1) turn++;
            else
            { exitmsg("Overflow error: number of turrets > %d\n", MAX_TURRETS);
              }}
              //}else putpixel(map,x,y,TILE_DTURRET);
            }
            else
              if(get == p0turret)
              { tur[turn].used = TRUE;
            tur[turn].x = x * TILE_SIZE + TILE_SIZE / 2;
            tur[turn].y = y * TILE_SIZE + TILE_SIZE / 2;
            tur[turn].start = 1;
            tur[turn].stop = 2;
            putpixel(map, x, y, TILE_TURRET);
            putpixel(turretmap,x,y,turn+1);
            if(turn < MAX_TURRETS - 1) turn++;
            else
            { exitmsg("Overflow error: number of turrets > %d\n", MAX_TURRETS);
              }
              }
              else
            if(get == p1turret)
            { tur[turn].used = TRUE;
              tur[turn].x = x * TILE_SIZE + TILE_SIZE / 2;
              tur[turn].y = y * TILE_SIZE + TILE_SIZE / 2;
              tur[turn].start = 0;
              tur[turn].stop = 1;
              putpixel(map, x, y, TILE_TURRET);
              putpixel(turretmap,x,y,turn+1);
              if(turn < MAX_TURRETS - 1) turn++;
              else
              { exitmsg("Overflow error: number of turrets > %d\n", MAX_TURRETS);
                }
            }
            else
              if(get == p0tank)
              { tnk[0].x = (float)(x * TILE_SIZE + TILE_SIZE / 2);
                tnk[0].y = (float)(y * TILE_SIZE + TILE_SIZE / 2);
                putpixel(map24, x, y, last); y--;
              }
              else
                if(get == p1tank)
                { tnk[1].x = (float)(x * TILE_SIZE + TILE_SIZE / 2);
                  tnk[1].y = (float)(y * TILE_SIZE + TILE_SIZE / 2);
                  putpixel(map24, x, y, last); y--;
                }
                else
                if(get == havenrechts) putpixel(map, x, y, TILE_SEAPORTR);
                else
                  if(get == havenlinks) putpixel(map, x, y, TILE_SEAPORTL);
                  else
                    if(get == havenhuis) putpixel(map, x, y, TILE_SEAPORTB);
                      else
                    if(get == weghor) putpixel(map, x, y, TILE_ROADH);
                    else
                      if(get == wegver) putpixel(map, x, y, TILE_ROADV);
                      else
                        if(get == wegkruis) putpixel(map, x, y, TILE_CROSSROADS);
                        else
                          if(get == wood) putpixel(map, x, y, TILE_WOODV);
                          else
                        if(get == woodh) putpixel(map, x, y, TILE_WOODH);
    }
  }
  AANTAL_TURRETS = turn;
  destroy_bitmap(map24);
  fixup_map_ex(map);
}

int volume_distance(int x1, int y1, int x2, int y2, int volume_zero)
{ int xdis = x2 - x1, ydis = y2 - y1, temp;
  temp = volume_zero - (int)sqrt((xdis * xdis) + (ydis * ydis));
  return MID(0, temp, 255);
} 

void get_pan_vol(int *pan, int *vol, int x, int y, int v)
{ int vol0, vol1;
  vol0 = volume_distance(view[0].l+VIEW/2, view[0].t+VIEH/2, x, y, v);
  vol1 = volume_distance(view[1].l+VIEW/2, view[1].t+VIEH/2, x, y, v);
  *pan = (vol1 - vol0) / 2 + 128;
  *vol = MAX(vol0, vol1);
}

void fof_dummy(const char* name, int attrib, int param) { }

    //extern int engine_cache_hits,engine_cache_misses;

void exitmsg(const char *fmt, ...)
{
    va_list va;
    int i;
    char buf[4096];//buf2[4096];

    #ifdef USE_ENGINE
    engine_exit();
    #endif

    free_lighting_data();
    exit_mod_player();

    if(screen)
    {   if(game_time>31 && buffer && buffer2 && (bitmap_color_depth(screen)==15 || bitmap_color_depth(screen)==16))
    {   for(i=31; i>=0; i--)
        {   fade(buffer,buffer2,i);
        blit(buffer2,screen,0,0,0,0,SCREEN_W,SCREEN_H);
        if(use_sound) set_volume(i*255/32,-1);
        }
    }
    //set_gfx_mode(GFX_TEXT,0,0,0,0);
    }

    va_start(va,fmt);
    vsprintf(buf,fmt,va);
    va_end(va);

    /*sprintf(buf2,"game_time=%d\nview[0]=(l:%d,r:%d,t:%d,b:%d),count=%d\n"
        "view[1]=(l:%d,r:%d,t:%d,b:%d),count=%d\n"
        "fps=%f;hits=%f%%;hits=%d;misses=%d;total=%d\n",
        game_time,
        view[0].l,view[0].r,view[0].t,view[0].b,view[0].count,
        view[1].l,view[1].r,view[1].t,view[1].b,view[1].count,
        (double)frame_tot/secs_tot,engine_get_cache_hit_percent(),
        engine_cache_hits,engine_cache_misses,engine_cache_hits+engine_cache_misses
    );

    strcat(buf,buf2);*/

    allegro_exit();
    allegro_init();
    allegro_message("%s"
    "\nYou played TankZone: My second Allegro game."
    "\nCopyright (C) 2003  Tobi Vollebregt"
    "\nPlease send your reaction to: tobivollebregt@hotmail.com\n"
    "\nDevelopped with DJGPP by Delorie, http://www.delorie.com/djgpp"
    "\nUses Allegro "ALLEGRO_VERSION_STR", http://www.allegro.cc\n",buf);

    //if(expl) unload_datafile(expl);
    //if(lnd) unload_datafile(lnd);
    //if(sample) unload_datafile(sample);

    /*{   FILE *fp=fopen("memleaks.txt","w");

    if(fp)
    {   tj_memleak_dump(fp);
        fclose(fp);
    }
    else printf("Unable to write memleaks to \"memleaks.txt\".\n");
    }*/

    #ifdef MEMDEBUG
    if(debug_memsize)
    {   for(i=j=0; i<debug_memsize; i++)
            if(((char *)debug_pointer)[i]!=17) j++;
        printf("bytes at wrong locations: %d\n",j);
        free(debug_pointer);
    }
    #endif

    exit(0);
}

void initialize(int argc, char* argv[])
{
    char path[1024] = "./data/default.bmp";
    char buf[1024];
    //char *ptr;
    int i, c;
    bool fs;

    srandom((int)time(NULL));

    /* Initialize Allegro */
    /*#ifdef ALLEGRO_CONSOLE_OK
        printf("\nInitializing Allegro "ALLEGRO_VERSION_STR".....");
    #endif*/
    set_uformat(U_ASCII);
    allegro_init();

    /*#ifdef ALLEGRO_CONSOLE_OK
        printf("Done.\nInterpreting configuration.....");
    #endif*/
    override_config_file("tankzone.cfg");

    scrw=get_config_int(NULL,"width",640); // screen resolution
    scrh=get_config_int(NULL,"height",480);
    colordepth=get_config_int(NULL,"colordepth",16);
    fs = get_config_int(NULL, "fullscreen", FALSE);
    #ifdef USE_ENGINE
    if (colordepth != 15 && colordepth != 16)
        exitmsg("\nEngine supports only hicolor modes (that is: 15 or 16 bpp).\n");
    #endif
    use_lighting=get_config_int(NULL,"lighting",1); // lighting
    lighting_color_mask=get_config_hex(NULL,"lighting_color_mask",0xF8F8F8);
    lighting_cleanup_time=get_config_int(NULL,"lighting_cleanup_time",1800);
    use_sound=get_config_int(NULL,"sound",-1); // sound
    use_jgmod=get_config_int(NULL,"jgmod",-1);
    jgmod_volume=get_config_int(NULL,"jgmod_volume",-1);
    use_turrets_vs_turrets=get_config_int(NULL,"turrets_vs_turrets",0); // turrets
    use_randommap=get_config_int(NULL,"randommap",TRUE);
    use_intro=get_config_int(NULL,"intro",TRUE);
    c=TRUE;
    /*#define ARG(x,y)    \
    if(strcmp(argv[i]+1,#x)==0)    \
    {   use_##x=(argv[i][0]=='+') ? -1:0;   \
    printf("\n%s %s.",y,use_##x ? "on":"off");  \
    set_config_int(NULL,#x,use_##x);    \
    c=FALSE;    \
    continue;   \
    }
    for(i=1; i<argc; i++)
    {   ARG(lighting,"Lighting has been switched");
    ARG(sound,"Sound effects have been switched");
    ARG(jgmod,"Mod background music has been switched");
    ARG(intro,"Intro has been switched");
    ARG(randommap,"Random map had been switched");
    if(strncmp(argv[i],"vol",3)==0)
    {   jgmod_volume=atoi(argv[i]+3);
        set_config_int(NULL,"jgmod_volume",jgmod_volume);
        printf("\nMod music volume has been set to %d.",jgmod_volume);
        c=FALSE;
        continue;
    }
    if(strncmp(argv[i],"gamma",5)==0)
    {   int gamma=atoi(argv[i]+5);
        set_config_int(NULL,"gamma",gamma);
        printf("\nEngine gamma has been set to %d.",gamma);
        c=FALSE;
        continue;
    }
    if((ptr=strchr(argv[i],'x')))
    {   scrw=atoi(argv[i]);
        scrh=atoi(ptr+1);
        set_config_int(NULL,"width",scrw);
        set_config_int(NULL,"height",scrh);
        if((ptr=strchr(ptr+1,'x')))
        {   colordepth=atoi(ptr+1);
        set_config_int(NULL,"colordepth",colordepth);
        }
        printf("\nGraphics mode config has been set to %dx%dx%d.",scrw,scrh,colordepth);
        c=FALSE;
        continue;
    }
    }
    #undef ARG*/
    fade_out(4);
    set_color_depth(colordepth);
    if(set_gfx_mode(fs ? GFX_AUTODETECT_FULLSCREEN : GFX_AUTODETECT_WINDOWED,scrw,scrh,0,0)<0)
        exitmsg("Error setting %dx%dx%d (%s) graphics mode:\n%s\n",scrw,scrh,colordepth,
            fs ? "fullscreen" : "windowed", allegro_error);
    clear(screen);

    /*#ifdef ALLEGRO_CONSOLE_OK
        if(c) printf("Done.");
    
        printf("\nInstalling timer.....");
    #endif*/
    install_timer();
    LOCK_VARIABLE(frame);
    LOCK_VARIABLE(fps);
    LOCK_VARIABLE(frame_tot);
    LOCK_VARIABLE(secs_tot);
    LOCK_FUNCTION(fps_proc);
    LOCK_VARIABLE(speed_counter);
    LOCK_FUNCTION(increment_speed_counter);
    /*#ifdef ALLEGRO_CONSOLE_OK
        printf("Done.\nInstalling keyboard handler.....");
    #endif*/
    install_keyboard();
    /*#ifdef ALLEGRO_CONSOLE_OK
        printf("Done.\nInstalling mouse handler.....");
    #endif*/
    i=install_mouse();
    /*#ifdef ALLEGRO_CONSOLE_OK
        if(i<0) printf("Failed.\n");
        else printf("Done.\n");
    #endif*/

    /* Install sound */
    if(use_sound)
    {
    /*#ifdef ALLEGRO_CONSOLE_OK
            printf("Installing sound.....");
    #endif*/
    i=detect_digi_driver(DIGI_AUTODETECT);
    if(i==0)
    {
    /*#ifdef ALLEGRO_CONSOLE_OK
            printf("Failed.\n");
    #endif*/
        use_sound=use_jgmod=FALSE;
    }else
    {   i=MID(0,i,sound_voices+jgmod_voices);
        reserve_voices(i,-1);
        if(install_sound(DIGI_AUTODETECT,MIDI_NONE,NULL))
        { 
    /*#ifdef ALLEGRO_CONSOLE_OK
                printf("%s\n",allegro_error);
    #endif*/
        TRACE("%s\n", allegro_error);
        use_sound=use_jgmod=FALSE;
        }else
        {   set_volume(255,-1);
    /*#ifdef ALLEGRO_CONSOLE_OK
            printf("Done.\nLoading samples from \"samples.dat\".....");
    #endif*/
        sample=load_datafile(fix_filename_path(buf, "./data/samples.dat", sizeof(buf)));
        if(!sample)
        {
    /*#ifdef ALLEGRO_CONSOLE_OK
                printf("Failed.\n");
    #endif*/
            TRACE("%s: %s\n", buf, strerror(errno));
            use_sound=FALSE;
        } 
    /*#ifdef ALLEGRO_CONSOLE_OK
                else printf("Done.\n");
    #endif*/
        #ifdef USE_JGMOD
        if(use_jgmod)
        {   //printf("Installing jgmod.....");
            if(i<sound_voices+jgmod_voices)
            {   //printf("Failed.\n");
            use_jgmod=FALSE;
            }else
            {   if(install_mod(jgmod_voices)<0)
            {   //printf("Failed.\n");
                use_jgmod=FALSE;
            }else
            {   set_mod_volume(jgmod_volume);
                enable_lasttrk_loop=FALSE;
                //printf("Done.\nInitializing mod player.....");
                init_mod_player();
                if(use_jgmod)
                {   update_mod_player();
                /*if(jgmod_song_name) printf("\"%s\".\n",jgmod_song_name);
                else printf("Done.\n"); */
                }//else printf("Failed.\n");
            }
            }
        }
        #endif
        }
    }
    }else use_jgmod=FALSE;

    /*#ifdef ALLEGRO_CONSOLE_OK
        printf("Generating flame animation.....");
    #endif*/
    generate_flame(fire_animation,256,64,64,4,48,8,NULL);

    /*#ifdef ALLEGRO_CONSOLE_OK
        printf("Done.\nPress a key to enter tankzone.....");
        if((readkey()>>8)==KEY_ESC)
        { 
            printf("Failed.\n");
            allegro_exit();
            exit(1);
        }
        else printf("Done.\n");
    #endif*/

    //fade_out(4);

    /* Set graphics mode */
    /*set_color_depth(colordepth);
    if(set_gfx_mode(GFX_AUTODETECT_WINDOWED,scrw,scrh,0,0)<0)
    exitmsg("Error setting %dx%dx%d graphics mode: %s.\n",scrw,scrh,colordepth,allegro_error);
    clear(screen);*/

    /* Get user input (map and lightlevel) */
    gui_fg_color=makecol(0,0,0);
    gui_bg_color=makecol(255,255,255);
    if(use_randommap)
    {   text_mode(0);
    textout_centre(screen,font,"PLEASE WAIT WHILE CREATING RANDOM MAP...",scrw/2,scrh/2,makecol(0,255,0));
    create_random_map();
    }else
    {   clear_to_color(screen,makecol(128,128,128));
    if(!file_select("Select map", path, "BMP;PCX;TGA;LBM"))
        exitmsg("I suggest you accidentally pressed the cancel button?\n");
    load_map(path);
    }
    if(use_lighting)
    {   clear_to_color(screen,makecol(128,128,128));
        if(!lightlevel_select(&lighting_color))
            exitmsg("I suggest you accidentally pressed the cancel button?\n");
    //lighting_color=0; // I prefer dark
    }else lighting_color=makecol24(128,128,128);
    if(!(light_map=create_bitmap_ex(24,MAPW,MAPH))) MEMERR;
    clear_to_color(light_map,lighting_color); 

    clear(screen);
    text_mode(-1);
    textout_centre(screen,font,"PLEASE WAIT WHILE LOADING DATA...",scrw/2,scrh/2,makecol(255,255,255)); 

    //Laad de data
    lnd=load_datafile(fix_filename_path(buf, "./data/land.dat", sizeof(buf)));
    if (!lnd) exitmsg("%s: %s\n", buf, strerror(errno));
    expl=load_datafile(fix_filename_path(buf, "./data/explode.dat", sizeof(buf)));
    if (!expl) exitmsg("%s: %s\n", buf, strerror(errno));

    text_mode(-1);
    textout_centre(screen,font,"PLEASE WAIT WHILE INITIALIZING DATA...",scrw/2,scrh/2+10,makecol(255,255,255)); 

    #ifdef USE_ENGINE
    if(engine_init(32)
        || engine_enable_cache_ex(get_config_int(NULL,"cache_size",0),
            get_config_int(NULL,"cache_accuracy",8)) )
        exitmsg("Error initializing lighted tilemap engine.\n");
    for(i=0; i<TILE_NUM; i++)
    {   if(engine_set_tile(i,(BITMAP *)lnd[i].dat))
            exitmsg("Error uploading tiles to engine: failed to upload tile #%d.\n",i);
    }
    engine_set_gamma(get_config_int(NULL,"gamma",128));
    engine_set_tilemap(map,0,0);
    engine_set_lightmap(light_map,0,0);
    #endif

    VIEW = scrw / 2;
    #ifndef USE_ENGINE
    VIEW--;
    #endif
    VIEH = scrh - 24;

    /* fill fire color table */
    for(c=0; c<64-FIRE_LIGHT; c++)
    fire_color[c]=makecol(MIN(4*(c+FIRE_LIGHT),255)/2,0,0);
    for(c=64-FIRE_LIGHT; c<128-FIRE_LIGHT; c++)
    fire_color[c]=makecol(255/2,MIN(4*(c-64+FIRE_LIGHT),255)/2,0);
    for(c=128-FIRE_LIGHT; c<192-FIRE_LIGHT; c++)
    fire_color[c]=makecol(255/2,255/2,MIN(4*(c-128+FIRE_LIGHT),255)/2);
    for(c=192-FIRE_LIGHT; c<256; c++)
    fire_color[c]=makecol(255/2,255/2,255/2);
    fire_color[0]=0;

    /* fill side color table (not yet used) */
    for(i = 0; i < 64; i++)
    {   int val1=MIN(8*i,255), val2=MAX(8*i-255,0);
    side_color[0][i] = makecol(val1, val2, val2); // player 1, red
    side_color[1][i] = makecol(val2, val2, val1); // player 2, blue
    side_color[2][i] = makecol(val2, val1, val2); // computer, green
    side_color[3][i] = makecol(val1, val1, val2); // computer, yellow
    side_color[4][i] = makecol(val1, val2, val1); // computer, pink
    side_color[5][i] = makecol(val2, val1, val1); // computer, ??
    }

  buffer = create_bitmap(scrw, scrh);
  if(!buffer) MEMERR;
  if(!(buffer2=create_bitmap(scrw,scrh))) MEMERR;
  page[0] = create_sub_bitmap(buffer, 0, 8, VIEW, VIEH);
  page[1] = create_sub_bitmap(buffer, scrw/2, 8, VIEW, VIEH);
  if(!page[0] || !page[1]) MEMERR;
  clear(buffer);

    screenshot_count=for_each_file("shot*.*",1|32,fof_dummy,0);

  set_trans_blender(0,0,0,0);

    /* draw fire light */
    fire_light=create_light_bitmap(FIRE_LIGHT_RADIUS,FIRE_COL_R,FIRE_COL_G,FIRE_COL_B);
    if(!fire_light) MEMERR;
    /* draw explosion lights */
    for(i=0; i<30; i++)
    {   explosion_light_radius[i]/=(256/EXPLOSION_LIGHT_RADIUS);
    explosion_light[i]=create_light_bitmap(explosion_light_radius[i],(255-i)/5,(255-4*i)/5,(255-8*i)/5);
    if(!explosion_light[i]) MEMERR;
    }
    /* draw red light */
    red_light=create_light_bitmap(C_LIGHT_RADIUS,192,64,64);
    if(!red_light) MEMERR;

    /* draw green light */
    green_light=create_light_bitmap(C_LIGHT_RADIUS,64,192,64);
    if(!green_light) MEMERR;

    /* draw blue light */
    blue_light=create_light_bitmap(C_LIGHT_RADIUS,64,64,192);
    if(!blue_light) MEMERR;

    /* draw white light */
    white_light=create_light_bitmap(WHITE_LIGHT_RADIUS,128,128,128);
    if(!white_light) MEMERR;
    clear_keybuf();

    #ifdef MEMDEBUG
    readkey();
    i=64*1024*1024;
    while((debug_pointer=malloc(i))==NULL) i-=1024;
    memset(debug_pointer,17,i);
    debug_memsize=i;
    readkey();
    #endif
}

void reset()
{ int i, j;
  white  = makecol(255,255,255);
  grey   = makecol(128,128,128);
  yellow = makecol(255,192,  0);
  orange = makecol(255,128,  0);
  l_red  = makecol(255,  0,  0);
  d_red  = makecol(128,  0,  0);
  l_green= makecol(  0,255,  0); 
  vl_blue= makecol(64,64,255);
  l_blue = makecol(  0,  0,255);
  d_blue = makecol(  0,  0,128);

  tnk[0].tankang = atan2(tnk[1].y - tnk[0].y, tnk[1].x - tnk[0].x);
  tnk[0].polycolor = d_red;
  tnk[0].circcolor = l_red;

  tnk[1].tankang = atan2(tnk[0].y - tnk[1].y, tnk[0].x - tnk[1].x);
  tnk[1].polycolor = d_blue;
  tnk[1].circcolor = l_blue;

  for(i = 0; i < 2; i++)
  { for(j = 0; j < 16; j++) view[i].msg[j]=NULL;
    tnk[i].startx=tnk[i].x;
    tnk[i].starty=tnk[i].y;
    tnk[i].xs = 0;
    tnk[i].ys = 0;
    tnk[i].len = MAX_LEN;
    tnk[i].loopang = tnk[i].tankang;
    tnk[i].used = TRUE;
    tnk[i].mouse_scrolling = FALSE;
    tnk[i].speed = 0;
    tnk[i].strength = START_STRENGTH;
    tnk[i].vakje = _getpixel(map, tnk[i].x / TILE_SIZE, tnk[i].y / TILE_SIZE);
    tnk[i].light=TRUE;
    tnk[i].light_key=FALSE;
    tnk[i].target_prev=TRUE;
    tnk[i].com_time=32;
    tnk[i].deads = 0;
    view[i].l = tnk[i].x - VIEW / 2;
    view[i].t = tnk[i].y - scrh / 2;
    if(view[i].l < 0) view[i].l = 0;
    if(view[i].t < 0) view[i].t = 0;
    if(view[i].l > GLOW - VIEW) view[i].l = GLOW - VIEW;
    if(view[i].t > GLOH - scrh) view[i].t = GLOH - scrh;
    view[i].r = view[i].l + VIEW;
    view[i].b = view[i].t + scrh;

    /* initialization for ai tanks */
    tnk[i].cpu_state=0;
  }
  for(i = 0; i < MAX_TURRETS; i++)
  { if(tur[i].start == 0 && tur[i].stop == 2) tur[i].color = l_green;
    if(tur[i].start == 0 && tur[i].stop == 1) tur[i].color = l_blue;
    if(tur[i].start == 1 && tur[i].stop == 2) tur[i].color = l_red;
    tur[i].attacked = 0;
    tur[i].build = 100;
    tur[i].len = TURRET_MAX_LEN;
    tur[i].strength = TURRET_START_STRENGTH;
    tur[i].sangle=tur[i].angle=(float)random()/(float)RAND_MAX*2*PI;
    tur[i].kid=-1;
    tur[i].vakje=0;
    tur[i].everattacked=FALSE;
    tur[i].age=0;
  }

  for(i = 0; i < MAX_CANNONBALLS; i++) can[i].used = FALSE;
  for(i = 0; i < MAX_EXPLOSIONS; i++) ex[i].used = FALSE;
  for(i = 0; i < MAX_SMOKES; i++) smk[i].used = FALSE;
  for(i = 0; i < MAX_PLONZEN; i++) pls[i].used = FALSE;
  for(i = 0; i < MAX_FIRES; i++) fir[i].used = FALSE;
}

float angle_to_angle(float angle1, float angle2, float s, int *ready)
{ float verschil;
  while(angle1 < 0) angle1 += 2 * PI;
  while(angle1 > 2 * PI) angle1 -= 2 * PI;
  while(angle2 < 0) angle2 += 2 * PI;
  while(angle2 > 2 * PI) angle2 -= 2 * PI; 
  verschil = fabs(angle1 - angle2);
  *ready = FALSE;
  if(verschil < PI)
  { if(verschil <= s) 
    { *ready = TRUE; 
      return angle2;
    }
    if(angle1 > angle2) angle1 -= s;
    if(angle1 < angle2) angle1 += s;
    return angle1;
  }
  else
  { if(angle1 > angle2) angle1 += s;
    if(angle1 < angle2) angle1 -= s;
    if(angle1 > 2 * PI) angle1 -= 2 * PI;
    if(angle1 < 0) angle1 += 2 * PI;
    return angle1;
  }
}

int cc_or_c(float angle1, float angle2, float epsilon)
{
    float diff;

    while(angle1 < 0) angle1 += 2. * PI;
    while(angle1 >= 2. * PI) angle1 -= 2. * PI;
    while(angle2 < 0) angle2 += 2. * PI;
    while(angle2 >= 2. * PI) angle2 -= 2. * PI; 

    diff = fabs(angle1 - angle2);
    if(diff < PI)
    {   if(diff <= epsilon) return 0;
    if(angle1 > angle2) return -1;
    else return 1;
    }
    else
    {   if(angle1 > angle2) return 1;
    else return -1;
    }
    return 0;
}

static int midx, midy;

void draw_map(int v)
{ int mapx, mapy, mapxstart, scrx, scry, scrxstart, c;
  unsigned char get;
  BITMAP *tile;
  V3D v1,v2,v3,v4;
  fixed cs,sn;
  mapxstart = (view[v].l / TILE_SIZE);
  scrxstart = -(view[v].l % TILE_SIZE);
  mapy = (view[v].t / TILE_SIZE);
  for(scry = -(view[v].t % TILE_SIZE); scry < VIEH; scry += TILE_SIZE)
  { mapx = mapxstart;
    for(scrx = scrxstart; scrx < VIEW; scrx += TILE_SIZE)
    { get = _getpixel(map, mapx, mapy);
      if(get == TILE_TANK0) get = tnk[0].vakje;
      else if(get == TILE_TANK1) get = tnk[1].vakje;
      if(use_lighting && lighting_cleanup_time) tile=get_tile_from_tree(get,_getpixel24(light_map,mapx,mapy));
      else tile=lnd[get].dat;
      if(get==TILE_WATER || get==TILE_SHORE)
      { v1.x=v4.x=itofix(scrx);
    v1.y=v2.y=itofix(scry);
    v2.x=v3.x=itofix(scrx+TILE_SIZE);
    v3.y=v4.y=itofix(scry+TILE_SIZE);
    cs=fcos(itofix(game_time+mapx*32));
    sn=fsin(itofix(game_time+mapy*32));
    if(get==TILE_WATER)
    {   v1.u=v4.u=8*cs;
        v2.u=v3.u=v1.u+itofix(32)+8*cs;
        v1.v=v2.v=8*sn;
        v3.v=v4.v=v1.v+itofix(32)+8*sn;
    }else
    {   v1.u=v4.u=4*cs;
        v2.u=v3.u=v1.u+itofix(32)+4*cs;
        v1.v=v2.v=4*sn;
        v3.v=v4.v=v1.v+itofix(32)+4*sn;
    }
    quad3d(page[v],POLYTYPE_ATEX,tile,&v1,&v2,&v3,&v4);
      }
      else blit(tile,page[v],0,0,scrx,scry,TILE_SIZE,TILE_SIZE);
      if(lighting_cleanup_time==0)
      { set_mul_blender(0,0,0,0);
    drawing_mode(DRAW_MODE_TRANS,NULL,0,0);
    c=_getpixel24(light_map,mapx,mapy);
    rectfill(page[v],scrx,scry,scrx+TILE_SIZE-1,scry+TILE_SIZE-1,makecol(getr24(c),getg24(c),getb24(c)));
    solid_mode();
      }
      mapx++;
    }
    mapy++;
  }
}

void check_ray_and_light(BITMAP *bmp, int xc, int yc, int d)
{ float x = midx, y = midy, xs = xc - midx, ys = yc - midy;
  static float dis = 1.0/LIGHT_RADIUS;
  int c = LIGHT_RADIUS, q = LIGHT_RADIUS/8, get;
  xs *= dis; ys *= dis;
  _blender_alpha=255;
  while(c-- > 0 && (int)x >= 0 && (int)x < MAPW && (int)y >= 0 && (int)y < MAPH)
  { get = _getpixel(map, x, y);
    putpixel(light_map, x, y, makecol24(128,128,128));
    if(c%q==0) _blender_alpha/=2;
    if(get == TILE_WALL) return; // stop ray
    x += xs;
    y += ys;
  }
}

void calc_hit_pos(float *px, float *py, float xs, float ys, int v)
{   int mapx, mapy, mapx0=-1, mapy0=-1;
    float x = *px, y = *py;
    while(/*(int)x > view[v].l && (int)x < view[v].r-1 && (int)y > view[v].t && (int)y < view[v].b-1*/
    x>=0.0 && y>=0.0 && (int)x<GLOW && (int)y<GLOH)
    {   mapx = (int)x / TILE_SIZE; mapy = (int)y / TILE_SIZE;
    if(mapx0 == mapx && mapy0 == mapy) goto continue_;
    if(!accessible[_getpixel(map, mapx0=mapx, mapy0=mapy)]) break;
    continue_:
    x += xs; y += ys;
    }
    *px = x; *py = y;
}

void draw_alpha_sprite8(BITMAP *bmp, BITMAP *sprite, int xc, int yc, int table[])
{   int x,y;
    unsigned char *ptr;
    for(y=0; y<sprite->h; y++)
    {   ptr=sprite->line[y];
    for(x=0; x<sprite->w; x++,ptr++)
    {   _blender_alpha=255; //2*MIN(*ptr,127);
        putpixel(bmp,xc+x,yc+y,table[*ptr]);
    }
    }
}

void draw_lights()
{   int j,l,t,r,b;
    int radius=TILE_SIZE*C_LIGHT_RADIUS;
    if(use_lighting && (game_time&1))
    {   drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
    set_max_blender(0,0,0,0);
    for(j = 0; j < 2; j++)
    {   if(tnk[j].used)
        {   if(tnk[j].light) do_arc(light_map, midx = (int)tnk[j].x/TILE_SIZE, midy = (int)tnk[j].y/TILE_SIZE, itofix(256)-ftofix((tnk[j].loopang*128/PI)+1), itofix(256)-ftofix((tnk[j].loopang*128/PI)-1), LIGHT_RADIUS, 0, check_ray_and_light);
        }/*else
        {   _blender_alpha=128;
        draw_trans_sprite(light_map,white_light,(int)tnk[j].x/TILE_SIZE-WHITE_LIGHT_RADIUS,(int)tnk[j].y/TILE_SIZE-WHITE_LIGHT_RADIUS);
        }*/
    }
    _blender_alpha=255;
    if(tnk[0].used) draw_trans_sprite(light_map, red_light, (int)tnk[0].x/TILE_SIZE - C_LIGHT_RADIUS, (int)tnk[0].y/TILE_SIZE - C_LIGHT_RADIUS);
    if(tnk[1].used) draw_trans_sprite(light_map, blue_light, (int)tnk[1].x/TILE_SIZE - C_LIGHT_RADIUS, (int)tnk[1].y/TILE_SIZE - C_LIGHT_RADIUS);

    view[0].l-=radius; view[0].r+=radius;
    view[0].t-=radius; view[0].b+=radius;
    view[1].l-=radius; view[1].r+=radius;
    view[1].t-=radius; view[1].b+=radius;
    for(j = AANTAL_TURRETS-1; j >= 0; j--) 
    {   if(tur[j].used && ((tur[j].x>view[0].l&&tur[j].x<view[0].r&&tur[j].y>view[0].t&&tur[j].y<view[0].b) ||
        (tur[j].x>view[1].l&&tur[j].x<view[1].r&&tur[j].y>view[1].t&&tur[j].y<view[1].b)))
        {   BITMAP *bmp;
        if(tur[j].color == l_red) bmp = red_light;
        else if(tur[j].color == l_green) bmp = green_light;
        else if(tur[j].color == l_blue) bmp = blue_light;
        _blender_alpha=tur[j].strength*64/TURRET_START_STRENGTH;
        draw_trans_sprite(light_map, bmp, tur[j].x/TILE_SIZE - C_LIGHT_RADIUS, tur[j].y/TILE_SIZE - C_LIGHT_RADIUS);
        }
    }
    view[0].l+=radius; view[0].r-=radius;
    view[0].t+=radius; view[0].b-=radius;
    view[1].l+=radius; view[1].r-=radius;
    view[1].t+=radius; view[1].b-=radius;

    set_max_blender(0,0,0,8);
    for(j = MAX_FIRES-1; j >= 0; j--) if(fir[j].used)
        draw_trans_sprite(light_map, fire_light, fir[j].x/TILE_SIZE - FIRE_LIGHT_RADIUS, fir[j].y/TILE_SIZE - FIRE_LIGHT_RADIUS);
    set_add_blender(0,0,0,223);
    //_blender_alpha=255;
    for(j = MAX_EXPLOSIONS-1; j >= 0; j--) if(ex[j].used && ex[j].state<8)
        draw_trans_sprite(light_map, explosion_light[ex[j].state], ((int)ex[j].x/TILE_SIZE)-explosion_light_radius[ex[j].state], ((int)ex[j].y/TILE_SIZE)-explosion_light_radius[ex[j].state]);
    for(j=0; j<2; j++)
    {   //set_max_blender(0,0,0,2);
        l=view[j].l/TILE_SIZE-3; r=view[j].r/TILE_SIZE+3;
        t=view[j].t/TILE_SIZE-3; b=view[j].b/TILE_SIZE+3;
        //rectfill(light_map,l,t,r,b,lighting_color);
        set_min_blender(0,0,0,8);
        rectfill(light_map,l,t,r,b,lighting_color);
    }
    solid_mode();
    for(j=0; j<2; j++)
    {   l=view[j].l/TILE_SIZE-4; r=view[j].r/TILE_SIZE+4;
        t=view[j].t/TILE_SIZE-4; b=view[j].b/TILE_SIZE+4;
        if(!(view[1-j].r+4*TILE_SIZE>view[j].l-4*TILE_SIZE && view[1-j].b+4*TILE_SIZE>view[j].t-4*TILE_SIZE && view[1-j].l-4*TILE_SIZE<view[j].r+4*TILE_SIZE && view[1-j].t-4*TILE_SIZE<view[j].b+4*TILE_SIZE))
        rect(light_map,l,t,r,b,lighting_color);
        //blur light map
        blur_area(light_map,l,t,r,b);
    }
    }
}

void draw_all()
{ int i, j, pos[8], min, sec, hsec, t, l, b, r, x, y, color;
  char buf[512];
  text_mode(-1);

    #ifdef USE_ENGINE
    for(i=0; i<2; i++)
    _putpixel(map,(int)tnk[i].x>>5,(int)tnk[i].y>>5,tnk[i].vakje);
    for(i=0; i<2; i++)
    {   engine_set_destination(page[i]);
        engine_draw_scene(view[i].l,view[i].t);
    }
    for(i=0; i<2; i++)
    _putpixel(map,(int)tnk[i].x>>5,(int)tnk[i].y>>5,i);
    #else
    for(i = 0; i < 2; i++) draw_map(i);
    #endif

    drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
    set_trans_blender(0,0,0,0);
    for(i=0; i<2; i++)
    {   l = view[i].l;
    r = view[i].r;
    t = view[i].t;
    b = view[i].b;
    for(j = MAX_PLONZEN-1; j >= 0; j--) if(pls[j].used)
    { if((pls[j].x + pls[j].rad > l)
        && (pls[j].x - pls[j].rad < r)
        && (pls[j].y + pls[j].rad > t)
        && (pls[j].y - pls[j].rad < b))
        {   _blender_alpha = pls[j].a;
        color = getpixel(light_map, pls[j].x / TILE_SIZE, pls[j].y / TILE_SIZE);
        circle(page[i], pls[j].x - l, pls[j].y - t, pls[j].rad, mul_blender(color, pls[j].color));
        }
    }
    }
    solid_mode();
  for(i = 0; i < 2; i++)
  { if(tnk[i].used)
    { for(j = 0; j < 8; j += 2)
      { pos[j] = tnk[i].pos[j] - view[i].l;
    pos[j + 1] = tnk[i].pos[j + 1] - view[i].t;
      }
      color = getpixel(light_map, (int)tnk[i].x/TILE_SIZE, (int)tnk[i].y/TILE_SIZE);
      polygon(page[i], 4, pos, mul_blender(color, tnk[i].polycolor));
      line(page[i], tnk[i].x - view[i].l, tnk[i].y - view[i].t, tnk[i].loopx - view[i].l, tnk[i].loopy - view[i].t, mul_blender(color, grey));
      circlefill(page[i], tnk[i].x - view[i].l, tnk[i].y - view[i].t, TNK_CRADIUS, mul_blender(color, tnk[i].circcolor));
    for(j = 0; j < 8; j += 2)
    { pos[j] = tnk[i].pos[j] - view[1 - i].l;
      pos[j + 1] = tnk[i].pos[j + 1] - view[1 - i].t;
    }
    polygon(page[1 - i], 4, pos, mul_blender(color, tnk[i].polycolor));
    line(page[1 - i], tnk[i].x - view[1 - i].l, tnk[i].y - view[1 - i].t, tnk[i].loopx - view[1 - i].l, tnk[i].loopy - view[1 - i].t, mul_blender(color, grey));
    circlefill(page[1 - i], tnk[i].x - view[1 - i].l, tnk[i].y - view[1 - i].t, TNK_CRADIUS, mul_blender(color, tnk[i].circcolor));
      /* draw target *
      tnk[i].target_x -= view[i].l; tnk[i].target_y -= view[i].t;
      circle(page[i], tnk[i].target_x, tnk[i].target_y, TARGET_CIRCLE_SIZE, tnk[i].circcolor);
      hline(page[i], tnk[i].target_x - TARGET_LINE_SIZE, tnk[i].target_y, tnk[i].target_x + TARGET_LINE_SIZE, tnk[i].circcolor);
      vline(page[i], tnk[i].target_x, tnk[i].target_y - TARGET_LINE_SIZE, tnk[i].target_y + TARGET_LINE_SIZE, tnk[i].circcolor);
      tnk[i].target_x += view[i].l; tnk[i].target_y += view[i].t;*/
    }
  }
  for(i = 0; i < 2; i++)
  { l = view[i].l;
    r = view[i].r;
    t = view[i].t;
    b = view[i].b;
    for(j = AANTAL_TURRETS-1; j >= 0; j--) if(tur[j].used)
    { if((tur[j].x + tur[j].len > l)
    && (tur[j].x - tur[j].len < r)
    && (tur[j].y + tur[j].len > t)
    && (tur[j].y - tur[j].len < b))
      { if(tur[j].build == 100)
    {   line(page[i], tur[j].x - l, tur[j].y - t,
        tur[j].loopx - l, tur[j].loopy - t, 0);
        color = getpixel(light_map, tur[j].x / TILE_SIZE, tur[j].y / TILE_SIZE);
        circlefill(page[i], tur[j].x - l, tur[j].y - t, TURRET_RADIUS, mul_blender(color, tur[j].color));
    }
    else
    {
        BITMAP *tile;
        color = getpixel(light_map, tur[j].x / TILE_SIZE, tur[j].y / TILE_SIZE);
        circlefill(page[i], tur[j].x - l, tur[j].y - t, TURRET_RADIUS, mul_blender(color, tur[j].color));
        #ifdef USE_ENGINE
        tile=engine_get_tile_ex(tur[j].vakje,getr24(color),getg24(color),getb24(color));
        #else
        if(use_lighting) tile=get_tile_from_tree(tur[j].vakje, color);
        else tile=(BITMAP *)lnd[tur[j].vakje].dat;
        #endif
        set_dis_blender(0,0,0,(100-tur[j].build)*255/100);
        set_dis_seed(0);
        draw_trans_sprite(page[i],tile,tur[j].x-l-16,tur[j].y-t-16);
        textprintf(page[i], font, tur[j].x - l - 16, tur[j].y - t - 16, white, "%d%%", tur[j].build);
    }
    if(tur[j].disp == i) textprintf(page[i], font, tur[j].x - l, tur[j].y - t, white, "%d", tur[j].strength);
      }
    }
    for(j = MAX_CANNONBALLS-1; j >= 0; j--) if(can[j].used)
    {   x=(int)can[j].x-l;
    y=(int)can[j].y-t;
    putpixel(page[i], x, y, 0);
    putpixel(page[i], x+1, y+1, 0);
    }

    drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
    set_add_blender(0,0,0,0);
    //if(use_fire)
    {   for(j = MAX_FIRES-1; j >= 0; j--) if(fir[j].used)
    { if((fir[j].x + 15 > l)
        && (fir[j].x - 15 < r)
        && (fir[j].y + 40 > t)
        && (fir[j].y < b))
        {   draw_alpha_sprite8(page[i],fire_animation[fir[j].state],fir[j].x-fire_animation[0]->w/2-l,fir[j].y-fire_animation[0]->h-t,fire_color);
        }
    }
    }
    set_add_blender(0,0,0,223);
    for(j = MAX_EXPLOSIONS-1; j >= 0; j--) if(ex[j].used)
    { if((ex[j].x + EXPLOSION_LIGHT_RADIUS > l)
    && (ex[j].x - EXPLOSION_LIGHT_RADIUS < r)
    && (ex[j].y + EXPLOSION_LIGHT_RADIUS > t)
    && (ex[j].y - EXPLOSION_LIGHT_RADIUS < b))
      { //if(use_trans)
    {   //_blender_alpha = ex[j].a;
        draw_trans_sprite(page[i], (BITMAP*)expl[ex[j].state].dat, ex[j].x - l - 60, ex[j].y - t - 60);
    }
    //else draw_sprite(page[i], (BITMAP*)expl[ex[j].state].dat, ex[j].x - l - 60, ex[j].y - t - 60);
      }
    }
    set_trans_blender(0,0,0,0);
    //if(use_smoke)
    {   for(j = MAX_SMOKES-1; j >= 0; j--) if(smk[j].used)
    { if((smk[j].x + smk[j].rad > l)
        && (smk[j].x - smk[j].rad < r)
        && (smk[j].y + smk[j].rad > t)
        && (smk[j].y - smk[j].rad < b))
        {   _blender_alpha = smk[j].a;
        color = getpixel(light_map, smk[j].x / TILE_SIZE, smk[j].y / TILE_SIZE);
        if(color) circlefill(page[i], smk[j].x - l, smk[j].y - t, smk[j].rad, mul_blender(color, smk[j].color));
        }
    }
    }
    //if(tnk[i].used)
    //{   set_trans_blender(0,0,0,64);
    //line(page[i],tnk[i].x-l,tnk[i].y-t,tnk[i].target_x-l,tnk[i].target_y-t,tnk[i].circcolor);
    //_blender_alpha=96;
    //line(page[i],tnk[i].x-l,tnk[i].y-t,tnk[i].x-l+(int)(cos(tnk[i].tankang)*64),tnk[i].y-t+(int)(sin(tnk[i].tankang)*64),tnk[i].polycolor);
    //}
    solid_mode();
  }

    if(use_randommap) // to find your base back
    {   float x,y,len;
    for(i=0; i<2; i++)
    {   if(tnk[i].strength>0)
        {   x=tnk[i].startx-tnk[i].x;
        y=tnk[i].starty-tnk[i].y;
        len=sqrt(x*x+y*y);
        if(len>0.)
        {   len=24./len;
            x*=len; y*=len;
            if(i==0)
            line(page[i],24,page[i]->h-24,24+(int)x,page[i]->h-24+(int)y,tnk[i].circcolor);
            else
            line(page[i],page[i]->w-24,page[i]->h-24,page[i]->w-24+(int)x,page[i]->h-24+(int)y,tnk[i].circcolor);
        }
        }
    }
    }

  x = tnk[0].strength; y = tnk[1].strength;
  for(i = AANTAL_TURRETS-1; i >= 0; i--)
  { if(tur[i].used)
    {   if(tur[i].color == l_red) x += tur[i].strength;
    if(tur[i].color == l_blue) y += tur[i].strength;
    }
  } 

  text_mode(-1);
  for(i=0; i<2; i++)
  { for(j=0; j<MESSAGECOUNT && view[i].msg[j]; j++)
    textout(page[i],font,view[i].msg[j],4,text_height(font)*(j+1),tnk[i].circcolor);
  }
  text_mode(0);
  hsec = game_time * 3.333333;
  sec = hsec / 100;
  hsec %= 100;
  min = sec / 60;
  sec %= 60;

    if(jgmod_song_name)
    {   rectfill(buffer,scrw/2,0,scrw-1,7,0);
    textout_right(buffer,font,jgmod_song_name,scrw,0,white);
    }
    sprintf(buf, "%3d (%.2f) fps; %02d:%02d:%02d; %2.0f%% hits;", fps, (double)frame_tot/secs_tot, min, sec, hsec, engine_get_cache_hit_percent());//lighting_node_count);
    textout(buffer,font,buf,0,0,white);
    #ifdef DEBUGMODE
        textprintf(buffer,font,text_length(font,buf),0,l_green,"%d# %d|%d|%d(s)",turret_count,av_green_age/30,av_red_age/30,av_blue_age/30);
    #endif

    #ifdef ALLEGRO_DJGPP
    if(key[KEY_F4])
    {   //unsigned long p=_go32_dpmi_remaining_physical_memory()/1024UL;
        unsigned long v=_go32_dpmi_remaining_virtual_memory();
        sprintf(buf,"Used: %ldkb", (virtual_mem-v) >> 10);
        textout(buffer,font,buf,0,12,white);
        sprintf(buf,"Free: %ldkb", v >> 10);
        textout(buffer,font,buf,0,20,white);
    }
    #endif

  sec = (float)(game_time/30)/(float)(tnk[0].deads+1);
  min = sec / 60; sec %= 60;
  color = tnk[0].circcolor;
  if((disp_alarm == 0 || disp_alarm == 2) && (game_time % 30) > 14) color = white;
  textprintf_centre(buffer, font, scrw/4, scrh - 16, color, " strength=%d; damage=%d; ", tnk[0].strength, tnk[0].damage);
  textprintf_centre(buffer, font, scrw/4, scrh - 8, color, " total=%d; %d SL; %02d:%02d AL; ", x,tnk[0].deads,min,sec);
  sec = (float)(game_time/30)/(float)(tnk[1].deads+1);
  min = sec / 60; sec %= 60;
  color = tnk[1].circcolor;
  if((disp_alarm == 1 || disp_alarm == 2) && (game_time % 30) < 15) color = white;
  textprintf_centre(buffer, font, scrw*3/4, scrh - 16, color, " strength=%d; damage=%d; ", tnk[1].strength, tnk[1].damage);
  textprintf_centre(buffer, font, scrw*3/4, scrh - 8, color, " total=%d; %d SL; %02d:%02d AL; ", y,tnk[1].deads,min,sec);

    /* drawing code for (debugging) the ai system */
    text_mode(-1);
    if(tnk[0].used && tnk[0].com_time==0)
    textout_centre(page[0],font,"PRESS A KEY TO TAKE OVER",VIEW/2,(VIEH-text_height(font))/2,white);
    if(tnk[1].used && tnk[1].com_time==0)
    textout_centre(page[1],font,"PRESS A KEY TO TAKE OVER",VIEW/2,(VIEH-text_height(font))/2,white);

    if(key[KEY_F3])
    {   PALETTE old,grey;
    for(i=0; i<256; i++) grey[i].r=grey[i].g=grey[i].b=i/4;
    get_palette(old);
    set_palette(grey);
    //clear(page[0]);
    //clear(page[1]);
    if(tnk[0].cpu_state)
    {   blit(tnk[0].cpu_map,page[0],0,0,0,VIEH-MAPH,MAPW,MAPH);
        putpixel(page[0],tnk[0].cpu_black_list[0].x,VIEH-MAPH+tnk[0].cpu_black_list[0].y,l_green);
        putpixel(page[0],tnk[0].cpu_black_list[0].x-1,VIEH-MAPH+tnk[0].cpu_black_list[0].y,l_green);
        putpixel(page[0],tnk[0].cpu_black_list[0].x+1,VIEH-MAPH+tnk[0].cpu_black_list[0].y,l_green);
        putpixel(page[0],tnk[0].cpu_black_list[0].x,VIEH-MAPH+tnk[0].cpu_black_list[0].y-1,l_green);
        putpixel(page[0],tnk[0].cpu_black_list[0].x,VIEH-MAPH+tnk[0].cpu_black_list[0].y+1,l_green);
        for(i=1; i<tnk[0].cpu_black_list_size; i++)
        putpixel(page[0],tnk[0].cpu_black_list[i].x,VIEH-MAPH+tnk[0].cpu_black_list[i].y,l_red);
        textprintf(page[0],font,MAPW,VIEH-MAPH,white,"black_list_size = %d",tnk[0].cpu_black_list_size);
        textprintf(page[0],font,MAPW,VIEH-MAPH+10,white,"%3d %3d %3d %3d %3d",tnk[0].cpu_black_list[0].dist,tnk[0].cpu_black_list[1].dist,tnk[0].cpu_black_list[2].dist,tnk[0].cpu_black_list[3].dist,tnk[0].cpu_black_list[4].dist);
        textprintf(page[0],font,MAPW,VIEH-MAPH+20,white,"%3d %3d %3d %3d %3d",tnk[0].cpu_black_list[5].dist,tnk[0].cpu_black_list[6].dist,tnk[0].cpu_black_list[7].dist,tnk[0].cpu_black_list[8].dist,tnk[0].cpu_black_list[9].dist);
        textprintf(page[0],font,MAPW,VIEH-MAPH+30,white,"%3d %3d %3d %3d %3d",tnk[0].cpu_black_list[10].dist,tnk[0].cpu_black_list[11].dist,tnk[0].cpu_black_list[12].dist,tnk[0].cpu_black_list[13].dist,tnk[0].cpu_black_list[14].dist);
        textprintf(page[0],font,MAPW,VIEH-MAPH+40,white,"%3d %3d %3d %3d %3d",tnk[0].cpu_black_list[15].dist,tnk[0].cpu_black_list[16].dist,tnk[0].cpu_black_list[17].dist,tnk[0].cpu_black_list[18].dist,tnk[0].cpu_black_list[19].dist);
        textprintf(page[0],font,MAPW,VIEH-MAPH+50,white,"state = %d",tnk[0].cpu_state);
    }
    if(tnk[1].cpu_state)
    {   blit(tnk[1].cpu_map,page[1],0,0,VIEW-MAPW,VIEH-MAPH,MAPW,MAPH);
        putpixel(page[1],VIEW-MAPW+tnk[1].cpu_black_list[0].x,VIEH-MAPH+tnk[1].cpu_black_list[0].y,l_green);
        putpixel(page[1],VIEW-MAPW+tnk[1].cpu_black_list[0].x-1,VIEH-MAPH+tnk[1].cpu_black_list[0].y,l_green);
        putpixel(page[1],VIEW-MAPW+tnk[1].cpu_black_list[0].x+1,VIEH-MAPH+tnk[1].cpu_black_list[0].y,l_green);
        putpixel(page[1],VIEW-MAPW+tnk[1].cpu_black_list[0].x,VIEH-MAPH+tnk[1].cpu_black_list[0].y-1,l_green);
        putpixel(page[1],VIEW-MAPW+tnk[1].cpu_black_list[0].x,VIEH-MAPH+tnk[1].cpu_black_list[0].y+1,l_green);
        for(i=1; i<tnk[1].cpu_black_list_size; i++)
        putpixel(page[1],VIEW-MAPW+tnk[1].cpu_black_list[i].x,VIEH-MAPH+tnk[1].cpu_black_list[i].y,l_red);
        textprintf_right(page[1],font,VIEW-MAPW,VIEH-MAPH,white,"black_list_size = %d",tnk[1].cpu_black_list_size);
        textprintf_right(page[1],font,VIEW-MAPW,VIEH-MAPH+10,white,"%3d %3d %3d %3d %3d",tnk[1].cpu_black_list[0].dist,tnk[1].cpu_black_list[1].dist,tnk[1].cpu_black_list[2].dist,tnk[1].cpu_black_list[3].dist,tnk[1].cpu_black_list[4].dist);
        textprintf_right(page[1],font,VIEW-MAPW,VIEH-MAPH+20,white,"%3d %3d %3d %3d %3d",tnk[1].cpu_black_list[5].dist,tnk[1].cpu_black_list[6].dist,tnk[1].cpu_black_list[7].dist,tnk[1].cpu_black_list[8].dist,tnk[1].cpu_black_list[9].dist);
        textprintf_right(page[1],font,VIEW-MAPW,VIEH-MAPH+30,white,"%3d %3d %3d %3d %3d",tnk[1].cpu_black_list[10].dist,tnk[1].cpu_black_list[11].dist,tnk[1].cpu_black_list[12].dist,tnk[1].cpu_black_list[13].dist,tnk[1].cpu_black_list[14].dist);
        textprintf_right(page[1],font,VIEW-MAPW,VIEH-MAPH+40,white,"%3d %3d %3d %3d %3d",tnk[1].cpu_black_list[15].dist,tnk[1].cpu_black_list[16].dist,tnk[1].cpu_black_list[17].dist,tnk[1].cpu_black_list[18].dist,tnk[1].cpu_black_list[19].dist);
        textprintf_right(page[1],font,VIEW-MAPW,VIEH-MAPH+50,white,"state = %d",tnk[1].cpu_state);
    }
    set_palette(old);
    }

    //xor_effect(page[0],40);
    //xor_effect(page[1],40);

    /* blit to screen */
    if(game_time>=32 || (bitmap_color_depth(screen)!=15 && bitmap_color_depth(screen)!=16))
    blit(buffer, screen, 0, 0, 0, 0, scrw, scrh);
    else
    {   fade(buffer,buffer2,game_time);
    blit(buffer2, screen, 0, 0, 0, 0, scrw, scrh);
    }
}

int free_plons()
{ int i;
  //if(!use_trans) return MAX_PLONZEN;
  for(i = MAX_PLONZEN-1; i >= 0; i--) if(!pls[i].used) return i;
  return MAX_PLONZEN;
}

void create_plons(int x, int y, int growspeed, int color, int se)
{ int f;
  f = free_plons();
  pls[f].used = TRUE;
  pls[f].x = x;
  pls[f].y = y;
  pls[f].rad = 1;
  pls[f].growspeed = growspeed;
  pls[f].color = color;
  pls[f].a = PLONS_A;
  if(use_sound && se >= 0)
  { int pan, vol;
    get_pan_vol(&pan, &vol, x, y, 512);
    if(vol > 0)
    {   if(se == 0) play_sample((SAMPLE*)sample[SAMP_SPLISH].dat, vol, pan, sound_freq, FALSE);
    else if(se == 1) play_sample((SAMPLE*)sample[SAMP_SPLASH].dat, vol, pan, sound_freq, FALSE);
    }
  }
}

void do_plonzen()
{ int i;
  PLONS *p = &pls[MAX_PLONZEN-1];
  for(i = MAX_PLONZEN-1; i >= 0; p--, i--) if(p->used)
  { p->rad += p->growspeed;
    p->a -= 4;
    if(p->a < 1) p->used = FALSE;
  }
}

int free_smoke()
{ int i;
  //if(!use_smoke) return MAX_SMOKES;
  for(i = MAX_SMOKES-1; i >= 0; i--) if(!smk[i].used) return i;
  return MAX_SMOKES;
}

void create_smoke(int x, int y, int maxrad, int growspeed, int color, int a)
{
    int f;

    // some speed up code: cull smokes that arent and arent becoming visible
    if(distance(x,y,tnk[0].x,tnk[0].y)>320 && distance(x,y,tnk[1].x,tnk[1].y)>320) return;

  if(a < 6 || a > 255) return;
    f = free_smoke();
  smk[f].used = TRUE;
  smk[f].x=x;
  smk[f].y=y;
  smk[f].sx=x/TILE_SIZE;
  smk[f].sy=y/TILE_SIZE;
  smk[f].rad = 1;
  smk[f].maxrad = maxrad;
  smk[f].growspeed = growspeed;
  smk[f].color = color;
  smk[f].a = a;
}

void do_smokes()
{  int i;
  SMOKE *s = &smk[MAX_SMOKES-1];
  for(i = MAX_SMOKES-1; i >= 0; s--, i--) if(s->used)
  { s->x += (random() % 3) - 1;
    s->y += SMOKE_YSPEED;
    s->rad += s->growspeed;
    if(s->rad > s->maxrad) 
    { s->growspeed = 0;
      s->rad = s->maxrad;
    }
    s->a -= SMOKE_ASPEED;
    if(s->a < 1 || s->y < -s->rad || s->x > GLOW+s->rad)
      s->used = FALSE;
  }
}

int free_explosion()
{ int i;
  for(i = MAX_EXPLOSIONS-1; i >= 0; i--) if(!ex[i].used) return i;
  return MAX_EXPLOSIONS;
}

void create_explosion(float x, float y, float xs, float ys, int team, int num, int se)
{ int f;
  f = free_explosion();
  ex[f].used = TRUE;
  ex[f].x = x; ex[f].y = y;
  ex[f].xs = xs; ex[f].ys = ys;
  ex[f].a = EXPL_START_ALPHA;
  ex[f].state = 0;
  ex[f].team = team;
  ex[f].num = num;
  ex[f].sizzle = FALSE;
  if(use_sound && se >= 0)
  { int pan, vol;
    get_pan_vol(&pan, &vol, x, y, 512);
    if(vol > 0 && se < 3) play_sample((SAMPLE*)sample[SAMP_EXPLODE+se].dat, vol, pan, sound_freq, FALSE);
  }
}

void do_explosions()
{ int i, xdis, ydis, color, get, dam;
  EXPLOSION *e = &ex[MAX_EXPLOSIONS-1];
  for(i = MAX_EXPLOSIONS-1; i >= 0; e--, i--) if(e->used)
  { if(e->x >= 0.0 && e->y >= 0.0 && e->x < GLOW && e->y < GLOH) get = _getpixel(map, (int)e->x / TILE_SIZE, (int)e->y / TILE_SIZE);
    else get = -1;
    if(!accessible[get])
    { e->xs = 0.0; 
      e->ys = 0.0;
    }
    if((random()&0x1ff)==0) create_fire((int)e->x,(int)e->y);
    e->xs *= .9;
    e->ys *= .9;
    if(e->state < 10)
    { if(e->state == 0)
      { if(get == TILE_TANK0 || get == TILE_TANK1)
    { if(tnk[get].vakje == TILE_GRASS) tnk[get].vakje = TILE_DGRASS1;
      else if(tnk[get].vakje == TILE_DESERT) tnk[get].vakje = TILE_DDESERT1;
      else if(tnk[get].vakje == TILE_WOODV) tnk[get].vakje = TILE_DWOODV;
      else if(tnk[get].vakje == TILE_WOODH) tnk[get].vakje = TILE_DWOODH;
    }
    else if(get == TILE_GRASS)
      _putpixel(map, (int)e->x / TILE_SIZE, (int)e->y / TILE_SIZE, TILE_DGRASS1);
    else if(get == TILE_DESERT)
      _putpixel(map, (int)e->x / TILE_SIZE, (int)e->y / TILE_SIZE, TILE_DDESERT1);
    else if(get == TILE_WOODV)
      _putpixel(map, (int)e->x / TILE_SIZE, (int)e->y / TILE_SIZE, TILE_DWOODV);
    else if(get == TILE_WOODH)
      _putpixel(map, (int)e->x / TILE_SIZE, (int)e->y / TILE_SIZE, TILE_DWOODH);
      }
      dam = (10 - e->state); // / 2;
      if(get == TILE_TANK0 || get == TILE_TANK1)
      {   xdis = ABS(tnk[get].x - e->x);
      ydis = ABS(tnk[get].y - e->y);
      if(xdis < TILE_SIZE && ydis < TILE_SIZE) 
      { // autodetect difficulty
        dam = dam * (tnk[1-get].deads+1) / (tnk[get].deads+1);
        tnk[get].strength -= dam;
        tnk[get].mydamage += dam;
        if(e->team > -1)
        { if(tnk[get].strength < 0) tnk[e->team].kills++;
          tnk[e->team].damage += dam;
        }
      }
      }
      if(get == TILE_TURRET)
      { TURRET *t = &tur[_getpixel16(turretmap,(int)e->x/TILE_SIZE,(int)e->y/TILE_SIZE)-1];
    t->strength -= dam;
    t->attacked = 128;
    if(e->team > -1)
    {   if(t->strength < 0) tnk[e->team].kills++;
        tnk[e->team].damage += dam;
    }
      }
    }
    if(get == TILE_WATER && ex[i].state < 16)
    {   if(use_sound && e->state > 4 && !e->sizzle)
    {   int pan, vol;
        get_pan_vol(&pan, &vol, e->x, e->y, 512);
        if(vol > 0) play_sample((SAMPLE*)sample[SAMP_SIZZLE+(random()&1)].dat, vol, pan, sound_freq, FALSE);
        e->sizzle = TRUE;
    } 
    if(game_time & 1)
    {   color = RND(128) + 127;
        create_smoke(e->x + RND((30-e->state)*2) - RND((30-e->state)*2), e->y + RND((30-e->state)*2) - RND((30-e->state)*2),
        RND(15) + 10, 1, makecol(color, color, color), 96);
    }
    }
    e->x += e->xs;
    e->y += e->ys;
    e->state++;
    e->a -= EXPL_ALPHA_SPEED;
    if(e->state > 29 || e->a < 0) e->used = FALSE;
  }
}

int free_cannonball()
{ int i;
  for(i = MAX_CANNONBALLS-1; i >= 0; i--) if(!can[i].used) return i;
  return MAX_CANNONBALLS;
}

int create_cannonball(int x, int y, float angle, int time, int team, int num)
{ int f;
    f= free_cannonball();
  can[f].used = TRUE;
  can[f].x = x; can[f].y = y;
  can[f].xs = cos(angle);
  can[f].ys = sin(angle);
  can[f].time = time;
  can[f].team = team;
  can[f].num = num;
  return f;
}

void do_cannonballs()
{ int i, j, get;
  CANNONBALL *c = &can[MAX_CANNONBALLS-1];
  for(i = MAX_CANNONBALLS-1; i >= 0; c--, i--) if(c->used)
  { for(j = 29; j >= 0; j--)
    { if(c->x > 0 && c->x < GLOW && c->y > 0 && c->y < GLOH)
      { get = _getpixel(map, (int)c->x / TILE_SIZE, (int)c->y / TILE_SIZE);
    if((!accessible[get] && (c->num != -1 || get != c->team)) || c->time < 1)
    { c->used = FALSE;
        if(get == TILE_WATER)
        {   create_plons(c->x, c->y, 1, vl_blue, 1);
        }else
        {   create_explosion(c->x, c->y, 10*c->xs, 10*c->ys, c->team, c->num, random()%3);
        if(c->team >= 0 && c->num == -1 && (random()&7)==0)
        {   int b, p;
            float xs, ys;
            b = RND(360); p = RND(20);
            xs = p * cos((b/180.0)*PI) - c->xs;
            ys = p * sin((b/180.0)*PI) - c->ys;
            create_explosion(c->x+xs, c->y+ys, xs, ys, c->team, c->num, -1);
        }
        }
      break;
    }
      }
      else 
      { c->used = FALSE;
    break;
      }
      c->x += c->xs;
      c->y += c->ys;
      c->time--;
    }
  }
}

int free_fire()
{ int i;
  //if(!use_fire) return MAX_FIRES;
  for(i = MAX_FIRES-1; i >= 0; i--) if(!fir[i].used) return i;
  return MAX_FIRES;
}

void create_fire(int x, int y)
{ int j, f, get;
  f = free_fire();
  if(f == MAX_FIRES) return;
  if(x < 0 || y < 0 || x >= GLOW || y >= GLOH) return;
  for(j = MAX_FIRES-1; j >= 0; j--)
  { if(fir[j].used && x / TILE_SIZE == fir[j].x / TILE_SIZE && y / TILE_SIZE == fir[j].y / TILE_SIZE) return;
  }
  get = _getpixel(map, x / TILE_SIZE, y / TILE_SIZE);
  if(get == TILE_TANK0 || get == TILE_TANK1)
  { if(tnk[get].vakje == 2 || tnk[get].vakje == 3) tnk[get].vakje = 4;
    else if(tnk[get].vakje == 6 || tnk[get].vakje == 7) tnk[get].vakje = 8;
  }
  else if(get == TILE_GRASS || get == TILE_DGRASS1) _putpixel(map, x / TILE_SIZE, y / TILE_SIZE, TILE_DGRASS2);
  else if(get == TILE_DESERT || get == TILE_DDESERT1) _putpixel(map, x / TILE_SIZE, y / TILE_SIZE, TILE_DDESERT2);
  else if(get == TILE_WATER || get == TILE_WALL || get==TILE_ROCK) return;
  fir[f].used = TRUE;
  fir[f].x = x;
  fir[f].y = y;
  fir[f].state = 0;
}

void do_fires()
{ int i, get;
  FIRE *f = &fir[MAX_FIRES-1];
  for(i = MAX_FIRES-1; i >= 0; f--, i--) if(f->used)
  { f->state = (f->state + 1) & 0xFF;
    if((random() & 0x1FF) == 0) f->used = FALSE;
    if(game_time % 3 == 0)
    { get = _getpixel(map, f->x / TILE_SIZE, f->y / TILE_SIZE);
      if(get == TILE_TANK0 || get == TILE_TANK1)
      { tnk[get].strength--;
    tnk[get].mydamage++;
      }else if(get==TILE_TURRET)
      { TURRET *t=&tur[_getpixel16(turretmap,f->x/TILE_SIZE,f->y/TILE_SIZE)-1];
    t->strength--;
    t->everattacked=TRUE;
      }
    }
  }
}

float smart_angle(float tx, float ty, float txs, float tys, float sx, float sy, int time)
{ int t2 = 0, t1 = distance(tx, ty, sx, sy) / 30;
  while(t1 > t2 && t1 < time)
  { tx += txs;
    ty += tys;
    t2++;
    t1 = distance(tx, ty, sx, sy) / 30;
  }
  return atan2(ty - sy, tx - sx);
}

int check_shot(float x, float y, float a, int time, int t)
{ float xs = cos(a); //* 10.0;
  float ys = sin(a); //* 10.0;
  int get;
  int t1 = 0, t2 = 0;
  x += 2.2 * xs; y += 2.2 * ys;

  if(t == 0) t1 = t2 = 1;
  if(t < 0) t2 = 1;

  do
  { if(x > 0 && x < GLOW && y > 0 && y < GLOH)
    { get = _getpixel(map, (int)x / TILE_SIZE, (int)y / TILE_SIZE);
      if(!accessible[get])
      { if(get == t1 || get == t2) return get+1;
    else 
      if(get == TILE_TURRET)
      { TURRET *tr=&tur[_getpixel16(turretmap,(int)x/TILE_SIZE,(int)y/TILE_SIZE)-1];
        if(tr->start == t1 && tr->stop == t2+1) return 0;
        else return -1;
      }else return 0;
      }
    }else return 0;

    x += xs;
    y += ys;
    time--; //-=10;
  }
  while(time > 0);
  return 0;
}

void do_playertanks()
{ int i, j, f, get[4], pos[8], angle, veloc, color, x, y; 
  float xo, yo, xs, ys, tankango, newx, newy;
  PLAYERTANK *t = &tnk[0];
  /*if(load_input)
  { int c = fgetc(input_file);
    if(c == EOF) { load_input = FALSE; c = 0;}
    tnk[0].input_flags = c;
    c = fgetc(input_file);
    if(c == EOF) { load_input = FALSE; c = 0;}
    tnk[1].input_flags = c;
  }else*/{
  tnk[0].input_flags = tnk[1].input_flags = 0;

  if(tnk[0].used)
  { if(key[KEY_W]) tnk[0].input_flags |= SCAN_SPEEDUP;
    if(key[KEY_S]) tnk[0].input_flags |= SCAN_SLOWDOWN;
    if(key[KEY_A]) tnk[0].input_flags |= SCAN_GUNLEFT;
    if(key[KEY_D]) tnk[0].input_flags |= SCAN_GUNRIGHT;
    if(key[KEY_LSHIFT]) tnk[0].input_flags |= SCAN_SHOOT;
    if(key[KEY_Z]) tnk[0].input_flags |= SCAN_LIGHT;
    if(!key[KEY_LCONTROL] && tnk[0].com_time>0)
    {   switch(cc_or_c(tnk[0].tankang,tnk[0].loopang,1.1*TANKANG_SPEED))
    {   case -1: tnk[0].input_flags |= SCAN_BASELEFT; break;
        case 1: tnk[0].input_flags |= SCAN_BASERIGHT; break;
        default: break;
    }
    }
    if(tnk[0].com_time>0) tnk[0].com_time--;
    if(tnk[0].input_flags) tnk[0].com_time=TANK_COM_TIME;
    if(tnk[0].com_time==0) do_tank_ai(&tnk[0]);
  }

  if(tnk[1].used)
  { if(key[KEY_UP]) tnk[1].input_flags |= /*SCAN_SHOOT; / */SCAN_SPEEDUP;
    if(key[KEY_DOWN]) tnk[1].input_flags |= /*SCAN_LIGHT; / */SCAN_SLOWDOWN;
    if(key[KEY_LEFT]) tnk[1].input_flags |= SCAN_GUNLEFT;
    if(key[KEY_RIGHT]) tnk[1].input_flags |= SCAN_GUNRIGHT;
    if(key[KEY_RSHIFT]) tnk[1].input_flags |= SCAN_SHOOT;
    if(key[KEY_SLASH]) tnk[1].input_flags |= SCAN_LIGHT;
    if(!key[KEY_RCONTROL] && tnk[1].com_time>0)
    {   switch(cc_or_c(tnk[1].tankang,tnk[1].loopang,1.1*TANKANG_SPEED))
    {   case -1: tnk[1].input_flags |= SCAN_BASELEFT; break;
        case 1: tnk[1].input_flags |= SCAN_BASERIGHT; break;
        default: break;
    }
    }
    /*if(key[KEY_A]) tnk[1].input_flags |= SCAN_BASELEFT;
    if(key[KEY_D]) tnk[1].input_flags |= SCAN_BASERIGHT;
    if(key[KEY_W]) tnk[1].input_flags |= SCAN_SPEEDUP;
    if(key[KEY_S]) tnk[1].input_flags |= SCAN_SLOWDOWN;*/
    if(tnk[1].com_time>0) tnk[1].com_time--;
    if(tnk[1].input_flags) tnk[1].com_time=TANK_COM_TIME;
    if(tnk[1].com_time==0) do_tank_ai(&tnk[1]);
  }

  /*if(save_input)
  { if(fputc(tnk[0].input_flags, input_file) == EOF) save_input = FALSE;
    if(fputc(tnk[1].input_flags, input_file) == EOF) save_input = FALSE;
  }*/ }

  for(i = 0; i < 2; t++, i++)
  { if(t->used)
    { xo = t->x; yo = t->y;
      tankango = t->tankang;
      putpixel(map, (int)t->x / TILE_SIZE, (int)t->y / TILE_SIZE, t->vakje);
      if(t->len < MAX_LEN && game_time%RELOAD_SPEED==0) t->len++;
      if(t->speed > 0) t->speed--;
      if(t->speed < 0) t->speed++;

      if(t->input_flags & SCAN_SPEEDUP) 
      { if(t->vakje == 35 || t->vakje == 36 || t->vakje == 37)
      t->speed = WAY_FORSP;
    else
      t->speed = FOR_SPEED;
      }

      if(t->input_flags & SCAN_SLOWDOWN) t->speed = BACK_SPEED;

      if(t->input_flags & SCAN_LIGHT)
      { t->light_key=TRUE;
      }else if(t->light_key) {t->light_key=FALSE;t->light=!t->light;}

      if(t->input_flags & SCAN_GUNLEFT) t->loopang -= LOOPANG_SPEED;

      if(t->input_flags & SCAN_GUNRIGHT) t->loopang += LOOPANG_SPEED;

      if(((t->input_flags & SCAN_SHOOT) || t->auto_shoot) && t->len >= MAX_LEN)
      { f = create_cannonball(t->loopx, t->loopy, t->loopang, FIREDIS, i, -1);
    if(f != MAX_CANNONBALLS)
    { t->xs += (t->xs + can[f].xs) * TERUGSLAG;
      t->ys += (t->ys + can[f].ys) * TERUGSLAG;
      t->len = MIN_LEN;
    }
      }
      if(t->loopang < 0) t->loopang += 2 * PI;
      if(t->loopang >= 2 * PI) t->loopang -= 2 * PI;

      if(t->input_flags & SCAN_BASELEFT)
      { t->tankang -= TANKANG_SPEED;
    //if(t->com_time>=0) t->loopang -= TANKANG_SPEED;
      }

      if(t->input_flags & SCAN_BASERIGHT)
      { t->tankang += TANKANG_SPEED;
    //if(t->com_time>=0) t->loopang += TANKANG_SPEED;
      }

      if(t->loopang < 0.) t->loopang += 2. * PI;
      if(t->loopang >= 2. * PI) t->loopang -= 2. * PI;
      if(t->tankang < 0.) t->tankang += 2. * PI;
      if(t->tankang >= 2. * PI) t->tankang -= 2. * PI;

      xs = cos(t->tankang) * t->speed;
      ys = sin(t->tankang) * t->speed;
      t->xs = t->xs*SLIPDANGER+(1.-SLIPDANGER)*xs;//(xs - t->xs) * SLIPDANGER;
      t->ys = t->ys*SLIPDANGER+(1.-SLIPDANGER)*ys;//(ys - t->ys) * SLIPDANGER;

      newx = t->x + t->xs;
      if(newx < TNK_RADIUS || newx > GLOW - TNK_RADIUS) newx = xo;
      pos[0] = newx + cos(t->tankang + 3.6652) * (TNK_RADIUS+3);
      pos[1] = t->y + sin(t->tankang + 3.6652) * TNK_RADIUS;
      get[0] = !accessible[getpixel(map, pos[0] / TILE_SIZE, pos[1] / TILE_SIZE)];
      if(get[0])
      { j = ((pos[0] + 16) & 0xFFFFFFE0) - pos[0];
    newx += (float)j;
    //t->xs = 0.;
      }
      pos[2] = newx + cos(t->tankang + 5.7596) * (TNK_RADIUS+3);
      pos[3] = t->y + sin(t->tankang + 5.7596) * TNK_RADIUS;
      get[1] = !accessible[getpixel(map, pos[2] / TILE_SIZE, pos[3] / TILE_SIZE)];
      if(get[1])
      { j = ((pos[2] + 16) & 0xFFFFFFE0) - pos[2];
    newx += (float)j;
    //t->xs = 0.;
      }
      pos[4] = newx + cos(t->tankang + 0.5236) * (TNK_RADIUS+3);
      pos[5] = t->y + sin(t->tankang + 0.5236) * TNK_RADIUS;
      get[2] = !accessible[getpixel(map, pos[4] / TILE_SIZE, pos[5] / TILE_SIZE)];
      if(get[2])
      { j = ((pos[4] + 16) & 0xFFFFFFE0) - pos[4];
    newx += (float)j;
    //t->xs = 0.;
      }
      pos[6] = newx + cos(t->tankang + 2.6180) * (TNK_RADIUS+3);
      pos[7] = t->y + sin(t->tankang + 2.6180) * TNK_RADIUS;
      get[3] = !accessible[getpixel(map, pos[6] / TILE_SIZE, pos[7] / TILE_SIZE)];
      if(get[3])
      { j = ((pos[6] + 16) & 0xFFFFFFE0) - pos[6];
    newx += (float)j;
    //t->xs = 0.;
      }
      /*j=FALSE;
      if(get[0] || get[1] || get[2] || get[3])
      { newx = xo; //(int)xo / TILE_SIZE * TILE_SIZE + TILE_SIZE/2;
    //t->tankang = tankango;
    t->xs = 0.0;//-t->xs;
    //t->ys = 0.0;
    j=TRUE;
      }*/

      newy = t->y + t->ys;
      if(newy < TNK_RADIUS || newy > GLOH - TNK_RADIUS) newy = yo;
      pos[0] = t->x + cos(t->tankang + 3.6652) * TNK_RADIUS;
      pos[1] = newy + sin(t->tankang + 3.6652) * (TNK_RADIUS+3);
      get[0] = !accessible[getpixel(map, pos[0] / TILE_SIZE, pos[1] / TILE_SIZE)];
      if(get[0])
      { j = ((pos[1] + 16) & 0xFFFFFFE0) - pos[1];
    newy += (float)j;
    //t->ys = 0.;
      }
      pos[2] = t->x + cos(t->tankang + 5.7596) * TNK_RADIUS;
      pos[3] = newy + sin(t->tankang + 5.7596) * (TNK_RADIUS+3);
      get[1] = !accessible[getpixel(map, pos[2] / TILE_SIZE, pos[3] / TILE_SIZE)];
      if(get[1])
      { j = ((pos[3] + 16) & 0xFFFFFFE0) - pos[3];
    newy += (float)j;
    //t->ys = 0.;
      }
      pos[4] = t->x + cos(t->tankang + 0.5236) * TNK_RADIUS;
      pos[5] = newy + sin(t->tankang + 0.5236) * (TNK_RADIUS+3);
      get[2] = !accessible[getpixel(map, pos[4] / TILE_SIZE, pos[5] / TILE_SIZE)];
      if(get[2])
      { j = ((pos[5] + 16) & 0xFFFFFFE0) - pos[5];
    newy += (float)j;
    //t->ys = 0.;
      }
      pos[6] = t->x + cos(t->tankang + 2.6180) * TNK_RADIUS;
      pos[7] = newy + sin(t->tankang + 2.6180) * (TNK_RADIUS+3);
      get[3] = !accessible[getpixel(map, pos[6] / TILE_SIZE, pos[7] / TILE_SIZE)];
      if(get[3])
      { j = ((pos[7] + 16) & 0xFFFFFFE0) - pos[7];
    newy += (float)j;
    //t->ys = 0.;
      }

      /*if(get[0] || get[1] || get[2] || get[3])
      {  newy = yo; //(int)yo / TILE_SIZE * TILE_SIZE + TILE_SIZE/2;
     //t->tankang = tankango;
    //t->xs = 0.0;
    t->ys = 0.0;//-t->ys;
    j=TRUE;
      }
    if(j) t->klem=TRUE;
    else t->klem=FALSE;*/

    t->x = newx; t->y = newy;

      t->pos[0] = t->x + cos(t->tankang + 3.6652) * TNK_RADIUS;
      t->pos[1] = t->y + sin(t->tankang + 3.6652) * TNK_RADIUS;
      t->pos[2] = t->x + cos(t->tankang + 5.7596) * TNK_RADIUS;
      t->pos[3] = t->y + sin(t->tankang + 5.7596) * TNK_RADIUS;
      t->pos[4] = t->x + cos(t->tankang + 0.5236) * TNK_RADIUS;
      t->pos[5] = t->y + sin(t->tankang + 0.5236) * TNK_RADIUS;
      t->pos[6] = t->x + cos(t->tankang + 2.6180) * TNK_RADIUS;
      t->pos[7] = t->y + sin(t->tankang + 2.6180) * TNK_RADIUS;

      t->loopx = t->x + cos(t->loopang) * t->len;
      t->loopy = t->y + sin(t->loopang) * t->len;

      if(t->x != xo || t->y != yo)
    t->vakje = getpixel(map, (int)t->x / TILE_SIZE, (int)t->y / TILE_SIZE);
      putpixel(map, (int)t->x / TILE_SIZE, (int)t->y / TILE_SIZE, i);

      if(ABS(t->speed) > 1 && t->vakje == TILE_WATER && (game_time & 15) == 0)
    create_plons(t->x, t->y, 1, vl_blue, 0);
    if(t->vakje == TILE_WATER)
    {   t->xs=0.6*t->xs-0.6*cos((game_time+(int)t->x)*PI/128.0);
        t->ys=0.6*t->ys-0.6*sin((game_time+(int)t->y)*PI/128.0);
    }else if(t->vakje==TILE_SHORE) {t->xs*=0.9;t->ys*=0.9;}
      if(t->strength < SMOKE_STRENGTH)
      { if((game_time & 1) == 0)
    { color = RND(SMOKE_COLOR);
      create_smoke(t->x + RND(TNK_RADIUS) - TNK_RADIUS/2,
        t->y + RND(TNK_RADIUS) - TNK_RADIUS/2, RND(15) + 10, 1, 
        makecol(color, color, color), (SMOKE_STRENGTH - t->strength)/2);
    }
    if(t->strength < 0)
    { int x, y;
      if(use_sound)
      { int pan, vol;
        get_pan_vol(&pan, &vol, t->x, t->y, 512);
        for(x = 0; x < 3; x++) play_sample((SAMPLE*)sample[SAMP_BIGFIRE].dat, vol, pan, sound_freq, FALSE);
      }
      if(!tnk[1-i].mouse_scrolling) t->mouse_scrolling = TRUE;
      t->killed++;
      for(j = 0; j < EXPL_AANTAL; j++)
      { angle = RND(360); veloc = RND(EXPL_POWER);
        xs = cos(PI * angle / 180) * veloc;
        ys = -sin(PI * angle / 180) * veloc;
        create_explosion(t->x, t->y, xs, ys, i, -1, -1);
      }
      for(x = -4 * TILE_SIZE; x < 4 * TILE_SIZE; x += TILE_SIZE)
        for(y = -4 * TILE_SIZE; y < 4 * TILE_SIZE; y += TILE_SIZE)
        if((random() & 7) == 0) create_fire(x + t->x, y + t->y);
      for(x = -2 * TILE_SIZE; x < 2 * TILE_SIZE; x += TILE_SIZE)
        for(y = -2 * TILE_SIZE; y < 2 * TILE_SIZE; y += TILE_SIZE)
        create_smoke((int)t->x+x,(int)t->y+y,RND(20)+10,3,tnk[i].polycolor,128);
      _putpixel(map, t->x / TILE_SIZE, t->y / TILE_SIZE, t->vakje);
      t->used = FALSE;
      //if(use_lighting)
        clear_to_color(light_map,makecol24(255,255,255));
      //winner=1-i;
      t->deads++;
        tnk[i].x=tnk[i].loopx=tnk[i].startx;
        tnk[i].y=tnk[i].loopy=tnk[i].starty;
        tnk[i].xs = 0;
        tnk[i].ys = 0;
        tnk[i].len = MAX_LEN;
        tnk[i].tankang=atan2(tnk[1-i].y-tnk[i].y,tnk[1-i].x-tnk[i].y);
        tnk[i].loopang = tnk[i].tankang;
        tnk[i].used = TRUE;
        tnk[i].mouse_scrolling = FALSE;
        tnk[i].speed = 0;
        tnk[i].strength = START_STRENGTH;
        tnk[i].vakje = _getpixel(map, tnk[i].x / TILE_SIZE, tnk[i].y / TILE_SIZE);
        tnk[i].light=TRUE;
        tnk[i].light_key=FALSE;
        tnk[i].target_prev=TRUE;
        //tnk[i].com_time=32;
        if(tnk[i].com_time<=0) tnk[i].cpu_state=1;
        //if(use_sound)
          //  play_sample((SAMPLE*)sample[SAMP_KILLED+(random()%3)].dat,255,128,sound_freq,FALSE);
    }
      }

      xs = cos(t->loopang); ys = sin(t->loopang);
      //t->target_x = ((t->loopx/TILE_SIZE+TILE_SIZE/2)+xs)*TILE_SIZE; t->target_y = ((t->loopy/TILE_SIZE+TILE_SIZE/2)+ys)*TILE_SIZE;
      t->target_x = t->loopx + 25 * xs; t->target_y = t->loopy + 25 * ys;
      calc_hit_pos(&t->target_x, &t->target_y, xs, ys, i);
    f = t->auto_shoot;
    t->auto_shoot = FALSE;
      if(t->target_x >= 0 && t->target_y >= 0 && t->target_x < GLOW && t->target_y < GLOH)
      { j = getpixel(map, x = (int)t->target_x / TILE_SIZE, y = (int)t->target_y / TILE_SIZE);
    if(j == 1-i)
    {   t->target_x = tnk[1-i].x; t->target_y = tnk[1-i].y;
    }else if(j == TILE_TURRET)
    { TURRET *t = &tur[AANTAL_TURRETS-1];
        int l;
        for(l = AANTAL_TURRETS-1; l >= 0; t--, l--) if(t->used)
        {   if(t->x / TILE_SIZE == x && t->y / TILE_SIZE == y) 
        {   t->disp = i;
            if(t->color != tnk[i].circcolor)
            {   if(t->strength > TURRET_CAPTURE_STRENGTH || t->start!=0 || t->stop!=2)
            {   if(distance(tnk[i].x,tnk[i].y,tur[l].x,tur[l].y)<FIREDIS) tnk[i].auto_shoot = TRUE; 
                //tnk[i].loopang = atan2(t->y - tnk[i].y, t->x - tnk[i].x);
                break;
            }
            }
        }
        }
    }
    if(use_sound && t->auto_shoot && !f)
    {   int pan, vol;
        get_pan_vol(&pan, &vol, tnk[i].x, tnk[i].y, 512);
        if(vol > 0) play_sample((SAMPLE*)sample[SAMP_HOMING].dat, vol, pan, sound_freq, FALSE);
    }
    t->target_prev=j;
      }
      x = (int)t->x + (int)(xs*.8*VIEW)/2 - VIEW / 2;
      y = (int)t->y + (int)(ys*.8*VIEW)/2 - VIEH / 2;
      if(view[i].l <= x-INGAME_SCROLL_SPEED) view[i].l += INGAME_SCROLL_SPEED;
      if(view[i].l >= x+INGAME_SCROLL_SPEED) view[i].l -= INGAME_SCROLL_SPEED;
      if(view[i].t <= y-INGAME_SCROLL_SPEED) view[i].t += INGAME_SCROLL_SPEED;
      if(view[i].t >= y+INGAME_SCROLL_SPEED) view[i].t -= INGAME_SCROLL_SPEED;
    }
    else
    {   if(t->mouse_scrolling)
    { int xm, ym;
      get_mouse_mickeys(&xm, &ym);
      t->x += xm;
      t->y += ym;
    }
    if(t->x < VIEW / 2) t->x = VIEW / 2;
    if(t->x > GLOW - VIEW / 2) t->x = GLOW - VIEW / 2;
    if(t->y < VIEH / 2) t->y = VIEH / 2;
    if(t->y > GLOH - VIEH / 2) t->y = GLOH - VIEH / 2;
    view[i].l = t->x - VIEW/2;
    view[i].t = t->y - VIEH/2;
    }
    if(view[i].l < 0) view[i].l = 0;
    if(view[i].t < 0) view[i].t = 0;
    if(view[i].l > GLOW - VIEW) view[i].l = GLOW - VIEW;
    if(view[i].t > GLOH - VIEH) view[i].t = GLOH - VIEH;
    view[i].r = view[i].l + VIEW - 1;
    view[i].b = view[i].t + VIEH - 1;
  }
}

int free_turret()
{   int i;
    for(i = 0; i < AANTAL_TURRETS; i++) if(!tur[i].used) return i;
    if(AANTAL_TURRETS < MAX_TURRETS)
    {   AANTAL_TURRETS++;
    return AANTAL_TURRETS-1;
    }
    return -1;
}

int build_turret(int x, int y, int side)
{   int f;
    f = free_turret();
    if(f > -1)
    {   tur[f].x = tur[f].loopx = x * TILE_SIZE + TILE_SIZE/2;
    tur[f].y = tur[f].loopy = y * TILE_SIZE + TILE_SIZE/2;
    tur[f].color = l_green;
    if(side == 0) tur[f].color = l_red;
    else if(side == 1) tur[f].color = l_blue;
    tur[f].start = 0;
    tur[f].stop = 2;
    if(side == 0) tur[f].start = 1;
    else if(side == 1) tur[f].stop = 1;
    tur[f].len = TURRET_MAX_LEN;
    tur[f].strength = 1;
    tur[f].build = 0;
    tur[f].disp = -1;
    tur[f].used = TRUE;
    tur[f].attacked = FALSE;
    tur[f].sangle=tur[f].angle = 2*PI*(float)random()/(float)RAND_MAX;
    tur[f].vakje = _getpixel(map, x, y);
    tur[f].everattacked=FALSE;
    tur[f].kid=-2;
    tur[f].age=0;
    _putpixel(map, x, y, TILE_TURRET);
    _putpixel16(turretmap,x,y,f+1);
    }
    return f;
}

#define CHILDS

void do_turrets()
{ int x, y, i, j, color, t, ready, idle, alm = FALSE,c,shoot;
  char *warn="Warning: Your turrets are under attack";
  static int building=-1;
  int red_tur,blue_tur,green_tur;
#ifdef CHILDS
    static int children_enabled=-2;

    if(children_enabled==-2)
        children_enabled=get_config_int(NULL,"buildabase",TRUE);
#endif

  disp_alarm = -1;

    turret_count=0;
  av_green_age=0;av_red_age=0;av_blue_age=0;
  green_tur=0; red_tur=0; blue_tur=0;

  if(use_randommap)
  { if(building<0)
    {   x=random()%MAPW;
    y=random()%MAPH;
    if(accessible[_getpixel(map,x,y)] && 
        _getpixel(map,x-1,y-1)>1 && _getpixel(map,x,y-1)>1 && _getpixel(map,x+1,y-1)>1 &&
        _getpixel(map,x-1,y)>1 && _getpixel(map,x+1,y)>1 &&
        _getpixel(map,x-1,y+1)>1 && _getpixel(map,x,y+1)>1 && _getpixel(map,x+1,y+1)>1)
    {   building=build_turret(x,y,2);
        if(building>=0)
        {   tur[building].strength=TURRET_START_STRENGTH;
        tur[building].kid=-1;
        }
    }
    }else if((game_time&1)==0)
    {   tur[building].build++;
    if(tur[building].build>=100)
    {   tur[building].build=100;
        building=-1;
    }
    }
  }

  for(i = AANTAL_TURRETS-1; i >= 0; i--)
  { if(tur[i].used)
    {   if(tur[i].color==l_green) turret_count++;
    tur[i].disp = -1;
    t = 0;
    if(tur[i].start == 0 && tur[i].stop == 1) t = 1;
    else if(tur[i].start == 0 && tur[i].stop == 2) t = -1;

    // 0 = rood, 1 = blauw

    if(t==0) {av_red_age+=tur[i].age;red_tur++;}
    if(t==1) {av_blue_age+=tur[i].age; blue_tur++;}
    if(t==-1) {av_green_age+=tur[i].age; green_tur++;}

    if(t >= 0)
    {   // alarm
        if(tur[i].attacked)
        {   tur[i].attacked--;
        if(use_sound && !alm && game_time % 42 == 0)
        {   play_sample((SAMPLE *)sample[SAMP_ALARM].dat, 255, 128, sound_freq, FALSE);
            for(j=0; j<MESSAGECOUNT && view[t].msg[j]; j++) ;
            if(j==0 || strcmp(view[t].msg[j-1],warn)) add_message(&view[t], warn);
        }
        alm = TRUE;
        if(disp_alarm == -1) disp_alarm = t;
        if(disp_alarm == 1-t) disp_alarm = 2;
        }
    }
    if(tur[i].attacked) tur[i].everattacked=TRUE;

    if(tur[i].build == 100)
    {   idle = shoot=FALSE;
        // verleng loop
        if(tur[i].len < TURRET_MAX_LEN && (game_time & 3) == 0) tur[i].len++;

        /* // zoek dichtsbijzijnde vijandelijke tank waarop geschoten kan worden
        dis_ntank = TURRET_TIME + TURRET_MAX_LEN;
        ntank = -1;
        for(j = tur[i].start; j < tur[i].stop; j++)
        {   if(tnk[j].used)
        {   dis = distance(tnk[j].x, tnk[j].y, tur[i].x, tur[i].y);
            if(dis < dis_ntank && check_shot(tur[i].x, tur[i].y, wangle = atan2((int)tnk[j].y/TILE_SIZE - tur[i].y/TILE_SIZE, (int)tnk[j].x/TILE_SIZE - tur[i].x/TILE_SIZE), TURRET_TIME, t))
            {   ntank = j;
            dis_ntank = dis;
            a_ntank = wangle;
            }
        }
        }

        // zoek dichtsbijzijnde vijandelijke turret waarop geschoten kan worden
        if(use_turrets_vs_turrets)
        {
        if(check_shot(tur[i].x,tur[i].y,tur[i].sangle,TURRET_TIME+TURRET_MAX_LEN,t))
            shoot=TRUE;
        else 
        {   tur[j].sangle+=.999*TURRET_ROTATE_SPEED;
            if(tur[j].sangle>2*PI) tur[j].sangle-=2*PI;
        }

        for(j = AANTAL_TURRETS-1; j >= 0; j--)
        {   if(tur[j].used && tur[i].color != tur[j].color)
            {   dis = distance(tur[j].x, tur[j].y, tur[i].x, tur[i].y);
            if(dis < dis_nturret && check_shot(tur[i].x, tur[i].y, wangle = atan2(tur[j].y - tur[i].y, tur[j].x - tur[i].x), TURRET_TIME, t))
            {   nturret = j;
                dis_nturret = dis;
                a_nturret = wangle;
            }
            }
        }
        }

        // als er een tank is gevonden, schiet daar dan op
        if(ntank > -1)
        {   tur[i].angle = 
        #ifdef SMART_TURRETS
            angle_to_angle(tur[i].angle, smart_angle(tnk[ntank].x, tnk[ntank].y, tnk[ntank].xs, tnk[ntank].ys, tur[i].x, tur[i].y), TURRET_ROTATE_SPEED, &ready);
        #else
            angle_to_angle(tur[i].angle, a_ntank, TURRET_ROTATE_SPEED, &ready);
        #endif
        // bereken loop coords
        tur[i].loopx = tur[i].x + cos(tur[i].angle) * tur[i].len;
        tur[i].loopy = tur[i].y + sin(tur[i].angle) * tur[i].len;
        // en schiet op tank
        if(tur[i].len >= TURRET_MAX_LEN && ready && create_cannonball(tur[i].loopx, tur[i].loopy, tur[i].angle, TURRET_TIME, t, i) != MAX_CANNONBALLS) tur[i].len = TURRET_MIN_LEN;
        // als de tank te dichtbij is en de turret is genoeg beschadigd, zorg dat deze ingenomen wordt
        if(dis_ntank < TURRET_CAPTURE_DISTANCE && tur[i].strength < TURRET_CAPTURE_STRENGTH && tur[i].start==0 && tur[i].stop==2)
        {   tur[i].color = ntank ? l_blue : l_red;
            tur[i].start = 1-ntank;
            tur[i].stop = 2-ntank;
            tur[i].attacked = 0;
            tnk[ntank].captures++;
        }
        }

        // zo niet, schiet dan op de dichtsbijzijnde turret waar op geschoten kan worden
        else if(shootonturret)
        {   tur[i].angle = angle_to_angle(tur[i].angle, tur[i].sangle, TURRET_ROTATE_SPEED, &ready);
        // bereken loop coords
        tur[i].loopx = tur[i].x + cos(tur[i].angle) * tur[i].len;
        tur[i].loopy = tur[i].y + sin(tur[i].angle) * tur[i].len;
        // en schiet op turret
        if(tur[i].len>=TURRET_MAX_LEN && ready && create_cannonball(tur[i].loopx, tur[i].loopy, tur[i].angle, TURRET_TIME, t, i) != MAX_CANNONBALLS) tur[i].len = TURRET_MIN_LEN;
        }
        // is er niemand in de buurt richt op vijand tank
        else
        {   idle = TRUE;

        if(tur[i].color != l_green)
            tur[i].angle = angle_to_angle(tur[i].angle, atan2(tnk[1-t].y - tur[i].y, tnk[1-t].x - tur[i].x), TURRET_ROTATE_SPEED, &ready);
        // bereken loop coords
        tur[i].loopx = tur[i].x + cos(tur[i].angle) * tur[i].len;
        tur[i].loopy = tur[i].y + sin(tur[i].angle) * tur[i].len;
        // maak kid turret
        if(tur[i].color!=l_green && tur[i].strength==TURRET_START_STRENGTH && tur[i].build==100 && (random()&0xFF)==0)
        {   x=tur[i].x/TILE_SIZE+random()%3-1;
            y=tur[i].y/TILE_SIZE+random()%3-1;
            c=getpixel(map,x,y);
            if(c==TILE_GRASS||c==TILE_SHORE||c==TILE_DESERT||c==TILE_CROSSROADS||c==TILE_ROADH||c==TILE_ROADV)
            if((c=build_turret(x,y,t))>=0) tur[i].kid=c;
        }
        }*/

        c=check_shot(tur[i].x+TURRET_MAX_LEN*cos(tur[i].sangle),tur[i].y+TURRET_MAX_LEN*sin(tur[i].sangle),tur[i].sangle,TURRET_TIME+TURRET_MAX_LEN,t);
        if(c) shoot=TRUE;
        else
        {   tur[i].sangle+=0.1;
        if(tur[i].sangle>2*PI) tur[i].sangle-=2*PI;
        }

        if(shoot)
        {   if(c==1||c==2)
        {   tur[i].sangle=atan2(tnk[c-1].y-(float)tur[i].y,tnk[c-1].x-(float)tur[i].x);
        }
        tur[i].angle = angle_to_angle(tur[i].angle, tur[i].sangle, TURRET_ROTATE_SPEED, &ready);
        tur[i].loopx = tur[i].x + cos(tur[i].angle) * tur[i].len;
        tur[i].loopy = tur[i].y + sin(tur[i].angle) * tur[i].len;
        if(tur[i].len>=TURRET_MAX_LEN && ready && create_cannonball(tur[i].loopx, tur[i].loopy, tur[i].angle, TURRET_TIME, t, i) != MAX_CANNONBALLS) tur[i].len = TURRET_MIN_LEN;
        }else
        {   if(tur[i].color!=l_green)
            tur[i].angle=angle_to_angle(tur[i].angle,atan2(tnk[1-t].y-tur[i].y,tnk[1-t].x-tur[i].x),TURRET_ROTATE_SPEED,&ready);
        // bereken loop coords
        tur[i].loopx = tur[i].x + cos(tur[i].angle) * tur[i].len;
        tur[i].loopy = tur[i].y + sin(tur[i].angle) * tur[i].len;
        // maak kid turret
        #ifdef CHILDS
        if(children_enabled)
        {
            if(tur[i].color!=l_green && tur[i].strength>=TURRET_START_STRENGTH && tur[i].kid<0 && tur[i].build==100 && (random()&0xFF)==0)
            {   x=tur[i].x/TILE_SIZE+random()%3-1;
                y=tur[i].y/TILE_SIZE+random()%3-1;
                if(x>=0 && y>=0 && x<map->w && y<map->h && accessible[_getpixel(map,x,y)] &&
                _getpixel(map,x-1,y-1)>1 && _getpixel(map,x,y-1)>1 && _getpixel(map,x+1,y-1)>1 &&
                _getpixel(map,x-1,y)>1 && _getpixel(map,x+1,y)>1 &&
                _getpixel(map,x-1,y+1)>1 && _getpixel(map,x,y+1)>1 && _getpixel(map,x+1,y+1)>1)
                if((c=build_turret(x,y,t))>=0) tur[i].kid=c;
            }
        }
        #endif
        }

        // bouw kid turret
        #ifdef CHILDS
        if(children_enabled)
        {   if(tur[i].kid>=0 && (game_time%TURRET_SELFREPAIR_SPEED)==TURRET_SELFREPAIR_SPEED/2)
            {   if(tur[i].strength>=TURRET_START_STRENGTH)
            {   tur[tur[i].kid].strength++;
                c=tur[tur[i].kid].strength*100/(TURRET_START_STRENGTH/2);
                if(c>tur[tur[i].kid].build) tur[tur[i].kid].build=c;
                tur[i].strength--;
                if(tur[tur[i].kid].strength>TURRET_START_STRENGTH/2)
                {   tur[tur[i].kid].build=100;
                tur[i].kid=-2;
                }
            }
            }
            if(tur[i].kid>=0 && (tur[tur[i].kid].attacked || tur[i].attacked))
            {   tur[i].strength+=tur[tur[i].kid].strength;
            tur[tur[i].kid].used=FALSE;
            _putpixel(map,tur[tur[i].kid].x/TILE_SIZE,tur[tur[i].kid].y/TILE_SIZE,tur[tur[i].kid].vakje);
            _putpixel16(turretmap,tur[tur[i].kid].x/TILE_SIZE,tur[tur[i].kid].y/TILE_SIZE,0);
            //tur[tur[i].kid].strength=-1;
            tur[i].kid=-1;
            }
        }
        #endif

        // repareer vriend tank als in de buurt 
        if(tur[i].start == 0 && tur[i].stop == 1 && tnk[1].used)
        {   if(distance(tnk[1].x, tnk[1].y, tur[i].x, tur[i].y) < TURRET_REPAIR_DISTANCE)
        {   if(tur[i].build == 100)
            {   if(tnk[1].strength < START_STRENGTH && tur[i].strength > TURRET_CAPTURE_STRENGTH)
            {   tnk[1].strength++;
                tur[i].strength--;
            }
            }
        }
        }
        if(tur[i].start == 1 && tur[i].stop == 2 && tnk[0].used)
        {   if(distance(tnk[0].x, tnk[0].y, tur[i].x, tur[i].y) < TURRET_REPAIR_DISTANCE)
        {   if(tur[i].build == 100)
            {   if(tnk[0].strength < START_STRENGTH && tur[i].strength > TURRET_CAPTURE_STRENGTH)
            {   tnk[0].strength++;
                tur[i].strength--;
            }
            }
        }
        }
    }

    // check voor capturing 
    if(tur[i].color==l_green && tur[i].strength<TURRET_CAPTURE_STRENGTH)
    {   if(tnk[0].used && distance(tur[i].x,tur[i].y,tnk[0].x,tnk[0].y)<TURRET_CAPTURE_DISTANCE)
        {   tur[i].strength*=2;
        tur[i].color=l_red;
        tur[i].start=1;
        tur[i].stop=2;
        tur[i].attacked=0;
        tnk[0].captures++;
        }
        if(tnk[1].used && distance(tur[i].x,tur[i].y,tnk[1].x,tnk[1].y)<TURRET_CAPTURE_DISTANCE)
        {   tur[i].strength*=2;
        tur[i].color=l_blue;
        tur[i].start=0;
        tur[i].stop=1;
        tur[i].attacked=0;
        tnk[1].captures++;
        }
    }

      // laat turret overlopen als tank dood is
      if(tnk[0].used && !tnk[1].used && tur[i].start == 0 && tur[i].stop == 1 && (random() & 0xff) == 0)
      { create_explosion(tur[i].x, tur[i].y, 0.0, 0.0, 0, i, random()%3);
    //j = tur[i].strength;
    //if(tur[i].strength > 200) tur[i].strength = 200;
    //tnk[0].damage += j - tur[i].strength;
    tur[i].color = l_red;
    tur[i].start = 1;
    tur[i].stop = 2;
    tur[i].attacked = 0;
    tnk[0].captures++;
    tnk[t].killed++;
      }
      if(tnk[1].used && !tnk[0].used && tur[i].start == 1 && tur[i].stop == 2 && (random() & 0xff) == 0)
      { create_explosion(tur[i].x, tur[i].y, 0.0, 0.0, 1, i, random()%3);
    //j = tur[i].strength;
    //if(tur[i].strength > 200) tur[i].strength = 200;
    //tnk[1].damage += j - tur[i].strength;
    tur[i].color = l_blue;
    tur[i].start = 0;
    tur[i].stop = 1;
    tur[i].attacked = 0;
    tnk[1].captures++;
    tnk[t].killed++;
      }

    // laat turret roken en dood gaan
      if(tur[i].strength < TURRET_SMOKE_STRENGTH)
      { if(tur[i].everattacked && (game_time&3)==0)
    { color = RND(SMOKE_COLOR);
      create_smoke(tur[i].x + RND(15) - 7, tur[i].y + RND(15) - 7, RND(15) + 10, 1, 
        makecol(color, color, color), (TURRET_SMOKE_STRENGTH - tur[i].strength)/2);
    }
    if(tur[i].strength < 0) // doodgaan als strength < 0
    {   if(use_sound)
        {   int pan, vol;
        get_pan_vol(&pan, &vol, tur[i].x, tur[i].y, 512);
        if(vol > 0) play_sample((SAMPLE*)sample[SAMP_BIGFIRE].dat, vol, pan, sound_freq, FALSE);
        }
        for(x = tur[i].x - 15; x <= tur[i].x + 16; x += 15)
        for(y = tur[i].y - 15; y <= tur[i].y + 16; y += 15)
          create_smoke(x, y, 30+RND(30), 5, 0, 255);
      for(x = tur[i].x - TILE_SIZE; x <= tur[i].x + TILE_SIZE; x += TILE_SIZE)
        for(y = tur[i].y - TILE_SIZE; y <= tur[i].y + TILE_SIZE; y += TILE_SIZE)
          if((random() & 1) == 0) create_fire(x,y+TILE_SIZE/2-1);
      tur[i].used = FALSE;
      if(tur[i].kid>=0) tur[tur[i].kid].strength=-1;
      if(tur[i].vakje==TILE_WATER)
        _putpixel(map,tur[i].x/TILE_SIZE,tur[i].y/TILE_SIZE,TILE_WATER);
      else _putpixel(map, tur[i].x / TILE_SIZE, tur[i].y / TILE_SIZE, TILE_DTURRET);
      _putpixel16(turretmap,tur[i].x/TILE_SIZE,tur[i].y/TILE_SIZE,0);
    }
      }
    // repareer
    if(tur[i].strength < TURRET_START_STRENGTH && game_time % TURRET_SELFREPAIR_SPEED == 0) tur[i].strength++;
    }
    tur[i].age++;
  }

  if(red_tur) av_red_age/=red_tur;
  if(blue_tur) av_blue_age/=blue_tur;
  if(green_tur) av_green_age/=green_tur;
}

int main(int argc, char *argv[])
{
    int prev_game_time=-1;

    #ifdef ALLEGRO_DJGPP
    //physical_mem=(long)(_go32_dpmi_remaining_physical_memory()/1024UL);
    virtual_mem=_go32_dpmi_remaining_virtual_memory();
    #endif

    initialize(argc,argv);
    if(use_intro)
    {   if(intro(buffer,buffer2))
        exitmsg("Not enough memory while playing intro.\n");
    clear(buffer);
    clear(buffer2);
    }
    reset();

    do
    {
    /* install timers */
    install_int(fps_proc, 1000);
    install_int_ex(increment_speed_counter, BPS_TO_TIMER(game_speed));

    while(!key[KEY_ESC])
    {
        //frame++;
        /* play mods while playing game */
        if(use_jgmod) update_mod_player();

        while(speed_counter > 0 && !key[KEY_ESC])
        {
            handle_messages(&view[0]);
            handle_messages(&view[1]);
            do_cannonballs();
            do_explosions();
            do_smokes();
            do_plonzen();
            do_fires();
            do_turrets();
            do_playertanks();
            draw_lights();

            if(key[KEY_PAUSE])
            {   /* remove timers */
                remove_int(increment_speed_counter);
                remove_int(fps_proc);
                /* display pause message */
                text_mode(-1);
                textout_centre(screen,font,"PRESS PAUSE KEY AGAIN TO CONTINUE",scrw/2,(scrh-text_height(font))/2,makecol(255,255,255));
                /* wait until pause key is pressed again */
                while(key[KEY_PAUSE])
                {   /* continue playing mods while pausing */
                if(use_jgmod) update_mod_player();
                }
                /* reinstall timers */
                install_int(fps_proc, 1000);
                install_int_ex(increment_speed_counter, BPS_TO_TIMER(game_speed));
            }

            check_lighting_cleanup();
            game_time++;
            speed_counter--;
            if(key[KEY_F12])
            {   char temp[13];
                remove_int(increment_speed_counter);
                remove_int(fps_proc);
                sprintf(temp,"shot%04d.pcx",screenshot_count++);
                save_bitmap(temp,buffer,NULL);
                install_int(fps_proc,1000);
                install_int_ex(increment_speed_counter,BPS_TO_TIMER(game_speed));
            }
            if(key[KEY_PLUS_PAD] && game_speed < 240)
            {   game_speed++;
                sound_freq = game_speed * 1000 / 30;
                install_int_ex(increment_speed_counter, BPS_TO_TIMER(game_speed));
            }
            if(key[KEY_MINUS_PAD] && game_speed > 10)
            {   game_speed--;
                sound_freq = game_speed * 1000 / 30;
                install_int_ex(increment_speed_counter, BPS_TO_TIMER(game_speed));
            }
            if(key[KEY_F5])
            {   game_speed = 30;
                sound_freq = 1000;
                install_int_ex(increment_speed_counter, BPS_TO_TIMER(game_speed));
            }
            if(key[KEY_OPENBRACE])
            {   int gamma=get_config_int(NULL,"gamma",128)-1;
                engine_set_gamma(gamma);
                set_config_int(NULL,"gamma",gamma);
            }
            if(key[KEY_CLOSEBRACE])
            {   int gamma=get_config_int(NULL,"gamma",128)+1;
                engine_set_gamma(gamma);
                set_config_int(NULL,"gamma",gamma);
            }
        }
        //if(game_time!=prev_game_time)
        {   prev_game_time=game_time;
            draw_all();
            frame++;
        }
    }

    /* remove timers */
    remove_int(increment_speed_counter);
    remove_int(fps_proc);
    }
    while(!key[KEY_ESC]);

    exitmsg("Thanks for playing TankZone.\n");

    return 0;
}
END_OF_MAIN();
