/* Author: Tobi Vollebregt */

/*  TankZone: My second Allegro game.
 *  Copyright (C) 2003  Tobi Vollebregt
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See `License.txt', which contains a verbatim copy of the
 *  GNU General Public License, for details.
 *
 *  Please send your reaction to: tobivollebregt@hotmail.com
 */

#include <allegro.h>
#include <allegro/internal/aintern.h>
#include "fade16.h"

/* void fade_15(BITMAP *src, BITMAP *dst, int step)
 *  Will fade out a 15 bpp bitmap to black. 'step' should be in the range 0-32.
 *  You can cycle from 32 to 0 to fade out to black, or from 0 to 32 to fade
 *  back in.
 *  'dst' and 'src' must be 15bpp bitmaps, of the same size, and of even width.
 *  'src' must be a memory bitmap, and must be linear.
 */
void fade_15(BITMAP *src, BITMAP *dst, int step)
{
    int y, x;

    /* Incorrct color depths */
    if(bitmap_color_depth(src) != 15 || bitmap_color_depth(dst) != 15)
    return;

    /* Incorrect size */
    if((src->w != dst->w) || (src->h != dst->h) || (src->w & 1))
    return;

    acquire_bitmap(dst);

    for(y = 0; y < src->h; y++)
    {
    unsigned long d;
    unsigned long *s;

    d = bmp_write_line(dst, y);
    s = (unsigned long *)(src->line[y]);

    for(x = src->w; x; x -= 2)
    {
        unsigned long color1, color2;

        color1 = (((*s & 0x03E07C1F) * step) >> 5) & 0x03E07C1F;
        color2 = (((*s & 0x7C1F03E0) >> 5) * step) & 0x7C1F03E0;

        s++;
        bmp_write32(d, color2 | color1);
        d += sizeof(long);
    }
    }
    bmp_unwrite_line(dst);
    release_bitmap(dst);

    return;
}

/* void fade_16(BITMAP *src, BITMAP *dst, int step)
 *  Will fade out a 16 bpp bitmap to black. 'step' should be in the range 0-32.
 *  You can cycle from 32 to 0 to fade out to black, or from 0 to 32 to fade
 *  back in.
 *  'dst' and 'src' must be 16bpp bitmaps, of the same size, and of even width.
 *  'src' must be a memory bitmap, and must be linear.
 */
void fade_16(BITMAP *src, BITMAP *dst, int step)
{
    int y, x;

    /* Incorrct color depths */
    if(bitmap_color_depth(src) != 16 || bitmap_color_depth(dst) != 16)
    return;

    /* Incorrect size */
    if((src->w != dst->w) || (src->h != dst->h) || (src->w & 1))
    return;

    acquire_bitmap(dst);

    for(y = 0; y < src->h; y++)
    {
    unsigned long d;
    unsigned long *s;

    d = bmp_write_line(dst, y);
    s = (unsigned long *)(src->line[y]);

    for(x = src->w; x; x -= 2)
    {
        unsigned long color1, color2;

        // hehehe my algorithm looks nicer and is much faster:
        color1 = (((*s & 0x07E0F81F) * step) >> 5) & 0x07E0F81F;
        color2 = (((*s & 0xF81F07E0) >> 5) * step) & 0xF81F07E0;

        /* algo i found on the world wide web:
        color1 = *s;
        color1 = (color1 | (color1 << 16)) & 0x07E0F81F;
        color1 = ((color1 * step) >> 5) & 0x07E0F81F;
        color1 = color1 | (color1 >> 16);
        s++;

        color2 = *s;
        color2 = (color2 | (color2 << 16)) & 0x07E0F81F;
        color2 = ((color2 * step) >> 5) & 0x07E0F81F;
        color2 = (color2 | (color2 << 16)) & 0xFFFF0000;
        s++;*/

        /* 
        this is how to implement fast translucency
        by Tobi Vollebregt

        this draws two translucent/faded pixels at a time

        color1 = ((((src & 0x07E0F81F) * src_alpha) >> 5) & 0x07E0F81F) +
             ((((dst & 0x07E0F81F) * dst_alpha) >> 5) & 0x07E0F81F);
        color2 = ((((src & 0xF81F07E0) >> 5) * src_alpha) & 0xF81F07E0) +
             ((((dst & 0xF81F07E0) >> 5) * dst_alpha) & 0xF81F07E0);
        dst = color1 | color2;
        */
        s++;
        bmp_write32(d, color2 | color1);
        d += sizeof(long);
    }
    }
    bmp_unwrite_line(dst);
    release_bitmap(dst);

    return;
}

void fade(BITMAP *src, BITMAP *dst, int step)
{
    if(bitmap_color_depth(src)==16) fade_16(src,dst,step);
    else fade_15(src,dst,step);
}

void fade_to_color_16(BITMAP *dst, BITMAP *bmp, int color, int alpha1)
{
    int x, y;
    int w, h;
    unsigned long *p, *d;
    unsigned long c1, c2;
    unsigned long color1, color2;
    int alpha2 = 32 - alpha1;

    if(bitmap_color_depth(dst) != 16 || bitmap_color_depth(bmp) != 16)
    return;

    if(dst->w != bmp->w || dst->h != bmp->h || (dst->w & 1))
    return;

    w = dst->w;
    h = dst->h;

    color1 = color2 = ((unsigned long)color << 16) | color;
    color1 = ((((color1 & 0x07E0F81F) * alpha2) >> 5) & 0x07E0F81F);
    color2 = ((((color2 & 0xF81F07E0) >> 5) * alpha2) & 0xF81F07E0);

    for(y = 0; y < h; y++)
    {
    p = (unsigned long *)bmp->line[y];
    d = (unsigned long *)dst->line[y];

    for(x = 0; x < w; x += 2)
    {
        c1 = ((((*p & 0x07E0F81F) * alpha1) >> 5) & 0x07E0F81F) + color1;
        c2 = ((((*p & 0xF81F07E0) >> 5) * alpha1) & 0xF81F07E0) + color2;
        *d = c1 | c2;

        p++;
        d++;
    }
    }
}

void crossfade_16(BITMAP *dst, BITMAP *b1, BITMAP *b2, int alpha1, int alpha2)
{
    int x, y;
    int w, h;
    unsigned long *p1, *p2, *d;
    unsigned long c1, c2;

    if(bitmap_color_depth(dst) != 16 || bitmap_color_depth(b1) != 16 || bitmap_color_depth(b2) != 16)
    return;

    if(dst->w != b1->w || dst->h != b1->h || b1->w != b2->w || b1->h != b2->h || (dst->w & 1))
    return;

    w = dst->w;
    h = dst->h;

    for(y = 0; y < h; y++)
    {
    p1 = (unsigned long *)b1->line[y];
    p2 = (unsigned long *)b2->line[y];
    d = (unsigned long *)dst->line[y];

    for(x = 0; x < w; x += 2)
    {
        c1 = ((((*p1 & 0x07E0F81F) * alpha1) >> 5) & 0x07E0F81F) +
         ((((*p2 & 0x07E0F81F) * alpha2) >> 5) & 0x07E0F81F);
        c2 = ((((*p1 & 0xF81F07E0) >> 5) * alpha1) & 0xF81F07E0) +
         ((((*p2 & 0xF81F07E0) >> 5) * alpha2) & 0xF81F07E0);
        *d = c1 | c2;

        p1++;
        p2++;
        d++;
    }
    }
}

void xor_effect(BITMAP *buffer, int boundary)
{
    int x,y,vwidth=buffer->w,vheight=buffer->h;

    drawing_mode(DRAW_MODE_TRANS,NULL,0,0);
    set_trans_blender(0,0,0,0);

    for(y=0; y<boundary; y++)
    {   _blender_alpha=255-(y*255/boundary);
    for(x=y; x<vwidth-y; x++)
        putpixel(buffer,x,y,~getpixel(buffer,x,y));
    }

    for(y=vheight-boundary; y<vheight; y++)
    {   _blender_alpha=255-((vheight-y)*255/boundary);
    for(x=vheight-y; x<vwidth-(vheight-y); x++)
        putpixel(buffer,x,y,~getpixel(buffer,x,y));
    }

    for(y=0; y<vheight; y++)
    {   for(x=0; x<y && x<vheight-y && x<boundary; x++)
    {   _blender_alpha=255-(x*255/boundary);
        putpixel(buffer,x,y,~getpixel(buffer,x,y));
    }
    for(x=vwidth-MIN(MIN(y,vheight-y),boundary); x<vwidth; x++)
    {   _blender_alpha=255-((vwidth-x)*255/boundary);
        putpixel(buffer,x,y,~getpixel(buffer,x,y));
    }
    }
    solid_mode();
}

