/* Author: Tobi Vollebregt */

/*  TankZone: My second Allegro game.
 *  Copyright (C) 2003  Tobi Vollebregt
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See `License.txt', which contains a verbatim copy of the
 *  GNU General Public License, for details.
 *
 *  Please send your reaction to: tobivollebregt@hotmail.com
 */

#include "tankzone.h"

#define EPSILON 1.01

#define CPU_STATE_START         0
#define CPU_STATE_IDLE          1
#define CPU_STATE_MOVING        2
#define CPU_STATE_KILLING       3
#define CPU_STATE_TANKVSTANK    4

#define quick_sort_black_list(l,c)  {list=(l); _quick_sort_black_list(0,c-1);}

static int tank_color,find_enemies,find_turrets;
static BITMAP *a_map;
static CPU_BLACK_NODE *list;
static int listsize,listcount;

void advance_one_square(int x, int y, int c)
{
    /* !!warning: extremely recursive function!!
    This is the second time in one game I use such a function, and this is a
    much simpler implementation (although not supporting everything A* does)
    of the A* algorithm as described on www.generation5.com */

    int p;

    if(c>0 && x>=0 && y>=0 && x<MAPW && y<MAPH)
    {   p=map->line[y][x];
    if(accessible[p])
    {   if(a_map->line[y][x]<c)
        {   a_map->line[y][x]=c;
        if(p==TILE_ROADH && p<=TILE_CROSSROADS) c-=2;
        else if(p==TILE_SHORE || p==TILE_WATER) c-=9;
        else c-=3;
        //if(find_turrets && listcount>=listsize && c<191) return;
        advance_one_square(x-1,y,c);
        advance_one_square(x+1,y,c);
        advance_one_square(x,y-1,c);
        advance_one_square(x,y+1,c);
        }
    }else if(find_turrets && p==TILE_TURRET)
    {   p=(((unsigned short *)turretmap->line[y])[x])-1;
        if((find_enemies && tur[p].color!=tank_color) ||
        (!find_enemies && tur[p].color==tank_color))
        {   CPU_BLACK_NODE *node;
        int i,dist;
        for(i=0; i<listcount; i++)
            if(list[i].index==p)
            {   if(256-c<list[i].dist) list[i].dist=256-c;
            return;
            }
        if(listcount>=listsize)
        {   dist=list[0].dist;
            node=&list[0];
            for(i=1; i<listsize; i++)
            {   if(list[i].dist>dist)
            {   dist=list[i].dist;
                node=&list[i];
            }
            }
            if(256-c>=dist) return;
        }else node=&list[listcount++];
        node->index=p;
        node->x=x; node->y=y;
        node->dist=256-c;
        }
    }
    }
}

int make_a_map(BITMAP *bmp, int x, int y, CPU_BLACK_NODE *lst, int lstsize)
{
    a_map=bmp;
    list=lst;
    listsize=lstsize;
    listcount=0;

    clear(a_map);

    advance_one_square(x-1,y,254);
    advance_one_square(x+1,y,254);
    advance_one_square(x,y-1,254);
    advance_one_square(x,y+1,254);

    return listcount;
}

void _quick_sort_black_list(int low, int high)
{
    int i,j;
    CPU_BLACK_NODE partition,temp;

    if(low<high)
    {   if((high-low)==1)
    {   if(list[low].dist>list[high].dist)
        SWAP(list[low],list[high]);
    }else
    {   partition=list[high];
        i=low;
        j=high;
        do
        {   while((i<j) && (list[i].dist<=partition.dist)) i++;
        while((j>i) && (list[j].dist>=partition.dist)) j--;
        if(i<j) SWAP(list[i],list[j]);
        } while(i<j);
        SWAP(list[i],list[high]);
        _quick_sort_black_list(low,(i-1));
        _quick_sort_black_list((i+1),high);
    }
    }
}

void hit_pos(int *px, int *py, int xs, int ys)
{
    int mapx,mapy,cur,old,x,y,p;

    x=*px; y=*py;
    old=((x>>5)&0xFFFF0000)|(y>>21);

    label1:

    mapx=x>>21; mapy=y>>21;
    if((cur=(mapx<<16)|mapy)!=old)
    {   if(x<0 || y<0 || (x>>21)>=MAPW || (y>>21)>=MAPH) goto label2;
    p=map->line[mapy][mapx];
    if(!accessible[p]) goto label2;
    old=cur;
    }
    x+=xs; y+=ys;
    goto label1;

    label2:

    *px=x; *py=y;
}

int position_is_covered(int px, int py, TURRET *t)
{
    int tx,ty,x,y,deltax,deltay;
    //float angle;

    if(distance(t->x,t->y,((px<<5)+16),((py<<5)+16))<TURRET_TIME+TURRET_MAX_LEN+32)
    {
    tx=t->x<<16;
    ty=t->y<<16;

    x=(px<<21)+0x000F0000;
    y=(py<<21)+0x000F0000;
    //angle=atan2(ty-y,tx-x);
    //deltax=(int)(cos(angle)*65536.);
    //deltay=(int)(sin(angle)*65536.);
    deltax=tx-x; deltay=ty-y;
    if(deltax>deltay)
    {   deltay/=(deltax>>16)+1;
        deltax=0x10000;
    }else
    {   deltax/=(deltay>>16)+1;
        deltay=0x10000;
    }
    hit_pos(&x,&y,deltax,deltay);
    if((x>>21)==(tx>>21) && (y>>21)==(ty>>21))
        return 1;
    }

    return 0; 
}

void do_tank_ai(PLAYERTANK *t)
{
    int flags=0;
    PLAYERTANK *enemy;

    // Generate pointer to the enemy's tank

    if(t==tnk) enemy=&tnk[1];
    else enemy=&tnk[0];

    // Store tank color in global variable because its needed
    // by some helper functions

    tank_color=t->circcolor;

    // Main idea behind the ai: a finite state machine for the base of the
    // tank, and a turret-like ai for the gun of the tank.

    switch(t->cpu_state)
    {
    case CPU_STATE_START:
    {
        // Initialize ai, allocate memory and such things

        t->cpu_map=create_bitmap_ex(8,MAPW,MAPH);
        if(!t->cpu_map) MEMERR;
        t->cpu_black_list_size=0;
        memset(t->cpu_black_list,0,sizeof(CPU_BLACK_NODE)*20);
        t->cpu_repairing=0;

        t->cpu_state=CPU_STATE_IDLE;

        break;
    }
    case CPU_STATE_IDLE:
    {
        if((t->strength>START_STRENGTH*3/4 && !t->cpu_repairing) || t->strength>=START_STRENGTH)
        {
        killmodeinsteadofrepairmode:

        // Find nearest enemy turret(s) (create A* map),
        // store positions in black list and switch to MOVING mode,
        // so the gun of the tank can automatically destroy the enemy
        // turret when we reached the target position.

        find_turrets=find_enemies=1;

        t->cpu_black_list_size=
            make_a_map(t->cpu_map,(int)t->x>>5,(int)t->y>>5,t->cpu_black_list,20);
        quick_sort_black_list(t->cpu_black_list,t->cpu_black_list_size);

        find_turrets=0;

        if(t->cpu_black_list_size>0)
        {
            //int x,y,i,covered;

            // Now we have a list containing N (i think usually 20) enemy
            // turrets sorted from near to far. We take the first turret
            // and generate an A* map with the top at the turret, so that
            // we can simly follow the values on the A* map.

            make_a_map(t->cpu_map,t->cpu_black_list[0].x,t->cpu_black_list[0].y,NULL,0);

            if(tur[t->cpu_black_list[0].index].color!=l_green)
            t->cpu_killmode=1;
            else
            {
            /*x=t->cpu_black_list[0].x;
            y=t->cpu_black_list[0].y;
            covered=0;

            for(i=1; i<t->cpu_black_list_size; i++)
                if(position_is_covered(x,y,&tur[t->cpu_black_list[i].index]))
                {   covered=1;
                break;
                }

            if(covered) t->cpu_killmode=1;
            else*/ t->cpu_killmode=0;
            }
        }else
        {
            // If we did not found any enemy turrets we will take a
            // random reachable position at the map and move to it
            // with the help of the A* map.

            int x,y;

            make_a_map(t->cpu_map,(int)t->x>>5,(int)t->y>>5,NULL,0);

            do
            {   x=random()%MAPW;
            y=random()%MAPH;
            }while(!accessible[map->line[y][x]] || t->cpu_map->line[y][x]==0);

            map->line[(int)t->y>>5][(int)t->x>>5]=t->vakje;

            make_a_map(t->cpu_map,x,y,NULL,0);

            t->cpu_map->line[y][x]=255;
            map->line[(int)t->y>>5][(int)t->x>>5]=(int)t-(int)tnk;
        }

        t->cpu_squarex=(int)t->x>>5;
        t->cpu_squarey=(int)t->y>>5;
        t->cpu_state=CPU_STATE_MOVING;
        t->cpu_repairing=0;
        }else
        {
        // When we are smoking: find friendly turrets to repair at.

        find_turrets=1;
        find_enemies=0;

        t->cpu_black_list_size=
            make_a_map(t->cpu_map,(int)t->x>>5,(int)t->y>>5,t->cpu_black_list,20);
        quick_sort_black_list(t->cpu_black_list,t->cpu_black_list_size);

        find_turrets=0;

        if(t->cpu_black_list_size>0)
        {
            // Now we have a list containing N (i think usually 20)
            // turrets sorted from near to far. We take the first
            // turret that has enough strength to repair at and
            // generate an A* map with the top at the turret, so that
            // we can simly follow the values on the A* map.

            int i;

            for(i=0; i<t->cpu_black_list_size && (tur[t->cpu_black_list[i].index].strength<TURRET_START_STRENGTH*3/4 || tur[t->cpu_black_list[i].index].build<100); i++) ;

            if(i<t->cpu_black_list_size)
            {
            CPU_BLACK_NODE temp;

            SWAP(t->cpu_black_list[0],t->cpu_black_list[i]);
            }else
            {
            // When all turrets have been damaged too much,
            // continue killing and/or capturing enemy turrets.

            goto killmodeinsteadofrepairmode;
            }

            make_a_map(t->cpu_map,t->cpu_black_list[0].x,t->cpu_black_list[0].y,NULL,0);
        }else
        { 
            // When there are no friendly turrets, continue killing
            // and/or capturing enemy turrets.

            goto killmodeinsteadofrepairmode;
        }

        t->cpu_squarex=(int)t->x>>5;
        t->cpu_squarey=(int)t->y>>5;
        t->cpu_state=CPU_STATE_MOVING;
        t->cpu_repairing=1;
        }

        break;
    }
    case CPU_STATE_MOVING:
    {
        float angle,diff;

        //if(distance(((int)t->x&~31)+16,((int)t->y&~31)+16,t->x,t->y)<13)
        {

        int //x=t->cpu_squarex,y=t->cpu_squarey,
            x=(int)t->x>>5,y=(int)t->y>>5,c=t->cpu_map->line[y][x];
        int le,to,ri,bo,leto,rito,lebo,ribo;
        int al,at,ar,ab,alt,art,alb,arb;

        leto=getpixel(t->cpu_map,x-1,y-1);
        rito=getpixel(t->cpu_map,x+1,y-1);
        lebo=getpixel(t->cpu_map,x-1,y+1);
        ribo=getpixel(t->cpu_map,x+1,y+1);
        le=getpixel(t->cpu_map,x-1,y);
        ri=getpixel(t->cpu_map,x+1,y);
        to=getpixel(t->cpu_map,x,y-1);
        bo=getpixel(t->cpu_map,x,y+1);
        alt=accessible[getpixel(map,x-1,y-1)];
        art=accessible[getpixel(map,x+1,y-1)];
        alb=accessible[getpixel(map,x-1,y+1)];
        arb=accessible[getpixel(map,x+1,y+1)];
        al=accessible[getpixel(map,x-1,y)];
        ar=accessible[getpixel(map,x+1,y)];
        at=accessible[getpixel(map,x,y-1)];
        ab=accessible[getpixel(map,x,y+1)];

        if(leto>rito && leto>lebo && leto>ribo && leto>le && leto>ri && leto>to && leto>bo && al && at)
        {   t->cpu_squarex=x-1;
            t->cpu_squarey=y-1;
            if(!alt) t->cpu_state=CPU_STATE_IDLE;
        }else if(rito>leto && rito>lebo && rito>ribo && rito>le && rito>ri && rito>to && rito>bo && ar && at)
        {   t->cpu_squarex=x+1;
            t->cpu_squarey=y-1;
            if(!art) t->cpu_state=CPU_STATE_IDLE;
        }else if(lebo>leto && lebo>rito && lebo>ribo && lebo>le && lebo>ri && lebo>to && lebo>bo && al && ab)
        {   t->cpu_squarex=x-1;
            t->cpu_squarey=y+1;
            if(!alb) t->cpu_state=CPU_STATE_IDLE;
        }else if(ribo>leto && ribo>rito && ribo>lebo && ribo>le && ribo>ri && ribo>to && ribo>bo && ar && ab)
        {   t->cpu_squarex=x+1;
            t->cpu_squarey=y+1;
            if(!arb) t->cpu_state=CPU_STATE_IDLE;
        }else if(le>ri && le>to && le>bo)
        {   t->cpu_squarex=x-1;
            t->cpu_squarey=y;
            if(!al) t->cpu_state=CPU_STATE_IDLE;
        }else if(ri>le && ri>to && ri>bo)
        {   t->cpu_squarex=x+1;
            t->cpu_squarey=y;
            if(!ar) t->cpu_state=CPU_STATE_IDLE;
        }else if(to>le && to>ri && to>bo)
        {   t->cpu_squarex=x;
            t->cpu_squarey=y-1;
            if(!at) t->cpu_state=CPU_STATE_IDLE;
        }else if(bo>le && bo>ri && bo>to)
        {   t->cpu_squarex=x;
            t->cpu_squarey=y+1;
            if(!ab) t->cpu_state=CPU_STATE_IDLE;
        }else if(le>c)
        {   t->cpu_squarex=x-1;
            t->cpu_squarey=y;
            if(!al) t->cpu_state=CPU_STATE_IDLE;
        }else if(ri>c)
        {   t->cpu_squarex=x+1;
            t->cpu_squarey=y;
            if(!ar) t->cpu_state=CPU_STATE_IDLE;
        }else if(to>c)
        {   t->cpu_squarex=x;
            t->cpu_squarey=y-1;
            if(!at) t->cpu_state=CPU_STATE_IDLE;
        }else if(bo>c)
        {   t->cpu_squarex=x;
            t->cpu_squarey=y+1;
            if(!ab) t->cpu_state=CPU_STATE_IDLE;
        }

        if(t->cpu_state==CPU_STATE_IDLE && t->cpu_black_list_size>0 &&
            abs(t->cpu_black_list[0].x-x)<=1 && abs(t->cpu_black_list[0].y-y)<=1)
            t->cpu_state=CPU_STATE_MOVING;
        }

        angle=atan2(((t->cpu_squarey<<5)+16)-t->y,((t->cpu_squarex<<5)+16)-t->x);

        switch(cc_or_c(t->tankang,angle,1.1*TANKANG_SPEED))
        {   case -1: flags|=SCAN_BASELEFT; break;
        case 1: flags|=SCAN_BASERIGHT; break;
        //default: flags|=SCAN_SPEEDUP; break;
        }

        diff=fabs(t->tankang-angle);
        if(diff>PI) diff=(2.*PI)-diff;
        if(diff<.25*PI) flags|=SCAN_SPEEDUP;
        else if(diff>.5*PI)
        {   if(fabs(t->xs)>.1 || fabs(t->ys)>.1)
        {   if(t->speed>0) flags|=SCAN_SLOWDOWN;
            if(t->speed<0) flags|=SCAN_SPEEDUP;
        }
        }

        // Switch back to IDLE when we reached destination

        if(t->cpu_map->line[(int)t->y>>5][(int)t->x>>5]==255)
        t->cpu_state=CPU_STATE_IDLE;

        break;
    }

    case CPU_STATE_KILLING:
    {
        /*if(distance(t->cpu_black_list[0].x*TILE_SIZE+TILE_SIZE/2,t->cpu_black_list[0].y*TILE_SIZE+TILE_SIZE/2,t->x,t->y)<FIREDIS)
        {
        int x,y,deltax,deltay;

        x=(int)(t->x*65536.);
        y=(int)(t->y*65536.);
        deltax=(int)(cos(t->loopang)*65536.);
        deltay=(int)(sin(t->loopang)*65536.);
        hit_pos(&x,&y,deltax,deltay);
        x>>=21; y>>=21;

        if(x==t->cpu_black_list[0].x && y==t->cpu_black_list[0].y)
            flags|=SCAN_SHOOT;
        else t->cpu_state=CPU_STATE_MOVING;
        }else
        t->cpu_state=CPU_STATE_MOVING;*/

        break;
    }

    case CPU_STATE_TANKVSTANK:
    {
        break;
    }
    }

    if(t->cpu_black_list_size>0)
    {
    // When there are targets, aim at the first in the list and shoot
    // when we can hit it

    switch(cc_or_c(t->loopang,atan2((float)(t->cpu_black_list[0].y*TILE_SIZE+TILE_SIZE/2)-t->y,(float)(t->cpu_black_list[0].x*TILE_SIZE+TILE_SIZE/2)-t->x),1.1*LOOPANG_SPEED))
    {   case -1: flags|=SCAN_GUNLEFT; break;
        case 1: flags|=SCAN_GUNRIGHT; break;
        default: break;
    }

    if(!t->cpu_repairing)
    {
        float dist=distance(t->cpu_black_list[0].x*TILE_SIZE+TILE_SIZE/2,t->cpu_black_list[0].y*TILE_SIZE+TILE_SIZE/2,t->x,t->y);

        // shoot when possible, but dont shoot when turret can be captured

        if(dist<FIREDIS && tur[t->cpu_black_list[0].index].color!=tank_color && !(dist<TURRET_TIME && tur[t->cpu_black_list[0].index].color==l_green
        && tur[t->cpu_black_list[0].index].strength<TURRET_CAPTURE_STRENGTH))
        {
        int x,y,deltax,deltay;

        x=(int)(t->x*65536.);
        y=(int)(t->y*65536.);
        deltax=(int)(cos(t->loopang)*65536.);
        deltay=(int)(sin(t->loopang)*65536.);
        hit_pos(&x,&y,deltax,deltay);
        x>>=21; y>>=21;

        if(x==t->cpu_black_list[0].x && y==t->cpu_black_list[0].y)
        {
            flags|=SCAN_SHOOT;

            if(t->cpu_killmode && dist<FIREDIS*7/8)
            {
            int i,covered=0;

            x=(int)t->x>>5;
            y=(int)t->y>>5;

            for(i=0; i<t->cpu_black_list_size; i++)
                if(position_is_covered(x,y,&tur[t->cpu_black_list[i].index]))
                {   covered=1;
                break;
                }

            if(covered)
            {   switch(cc_or_c(t->tankang,t->loopang,1.1*(TANKANG_SPEED+LOOPANG_SPEED)))
                {   case -1: flags|=SCAN_BASELEFT; break;
                case 1: flags|=SCAN_BASERIGHT; break;
                default: flags|=SCAN_SLOWDOWN; break;
                }
            }
            t->cpu_state=CPU_STATE_KILLING;
            }else
            t->cpu_state=CPU_STATE_MOVING;
        }else
            t->cpu_state=CPU_STATE_MOVING;
        }else
        t->cpu_state=CPU_STATE_MOVING;

        // Be smart: Stop shooting when turret has been captured.
        if(tur[t->cpu_black_list[0].index].color==tank_color)
        t->cpu_state=CPU_STATE_IDLE;

        // Stop when tank has been damaged too much
        //if(t->strength<=START_STRENGTH*3/4) t->cpu_state=CPU_STATE_IDLE;
    }

    // Be smart: Stop shooting when turret has been destroyed.
    // Need such a large 'if' because turret can be reallocated before
    // we detected it was destroyed.
    if(!tur[t->cpu_black_list[0].index].used ||
        tur[t->cpu_black_list[0].index].x/TILE_SIZE!=t->cpu_black_list[0].x ||
        tur[t->cpu_black_list[0].index].y/TILE_SIZE!=t->cpu_black_list[0].y)
        t->cpu_state=CPU_STATE_IDLE;

    // Be smart: Stop repairing when turrets has not enough strength.
    // !!! or tank has enough strength !!!
    if(t->cpu_repairing && (tur[t->cpu_black_list[0].index].strength<TURRET_CAPTURE_STRENGTH+10
        || t->strength>=START_STRENGTH))
        t->cpu_state=CPU_STATE_IDLE;
    }else
    {
    // Else aim at the enemy tank, this is fair enough, because you can
    // calculate, theoretically, the enemy's tank position from the angles
    // of two or more of your turrets. Shoot when we can hit the enemy

    switch(cc_or_c(t->loopang,atan2(enemy->y-t->y,enemy->x-t->x),1.1*LOOPANG_SPEED))
    {   case -1: flags|=SCAN_GUNLEFT; break;
        case 1: flags|=SCAN_GUNRIGHT; break;
        default: break;
    }
    if(enemy->used && distance(enemy->x,enemy->y,t->x,t->y)<FIREDIS)
        flags|=SCAN_SHOOT;
    }

    if(enemy->used) //&& enemy->com_time>0)
    {   if(distance(enemy->x,enemy->y,t->x,t->y)<FIREDIS)
    {
           int x,y,i,covered=0;

            if(!t->cpu_repairing)
            {
                x=(int)t->x>>5;
                y=(int)t->y>>5;

                for(i=0; i<t->cpu_black_list_size; i++)
                    if(position_is_covered(x,y,&tur[t->cpu_black_list[i].index]))
                    {   covered=1;
                    break;
                    }
            }

        if(!covered)
        {

        int x,y,deltax,deltay;
        float angle=//smart_angle(enemy->x,enemy->y,enemy->xs,enemy->ys,t->x,t->y,FIREDIS);
        atan2(enemy->y-t->y,enemy->x-t->x);

        x=(int)(t->x*65536.);
        y=(int)(t->y*65536.);
        deltax=(int)(cos(angle)*65536.);
        deltay=(int)(sin(angle)*65536.);
        hit_pos(&x,&y,deltax,deltay);
        x>>=21; y>>=21;

        if(x==(int)enemy->x>>5 && y==(int)enemy->y>>5)
        {
        flags&=~(SCAN_GUNLEFT|SCAN_GUNRIGHT);

        //switch(cc_or_c(t->tankang,angle,1.1*LOOPANG_SPEED))
        //{   case -1: flags|=SCAN_BASELEFT; break;
        //    case 1: flags|=SCAN_BASERIGHT; break;
        //}
        switch(cc_or_c(t->loopang,angle,EPSILON*LOOPANG_SPEED))
        {   case -1: flags|=SCAN_GUNLEFT; break;
            case 1: flags|=SCAN_GUNRIGHT; break;
            default: flags|=SCAN_SHOOT; break;
        }

        //flags|=SCAN_SPEEDUP;

        //t->cpu_state=CPU_STATE_TANKVSTANK;
        }/*else
        {
        if(t->cpu_state==CPU_STATE_TANKVSTANK)
            t->cpu_state=CPU_STATE_IDLE;
        }*/
        }
    }/*else
    {
        if(t->cpu_state==CPU_STATE_TANKVSTANK)
        t->cpu_state=CPU_STATE_IDLE;
    }*/
    }

    if(t->light && (game_time&1)) flags|=SCAN_LIGHT;

    t->input_flags=flags;
}
