#ifndef SHELLSHOCK_VISUALS_H
#define SHELLSHOCK_VISUALS_H

/* -----------------------------------------------------------------------------
 SOME VISUAL SHNIZZLE
------------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/

#include <alleggl.h>
#include "linkage.h"
#include "common.h"

/* ---------------------------------------------------------------------------*/

typedef struct {
  GLuint frame;                         // OpenGL texture ID
  int ttl;                              // time displayed
} ss_anim_frame;                        // the definition of an animation frame

typedef struct {
  ss_anim_frame **frame;                // the array of frames
  unsigned char frames;                 // the count of frames
  char dir, loop;                       // animation direction, looping
  char *name;                           // animation name
} ss_anim;                              // the definition of an animation

typedef struct {
  int cur_frame, cur_ttl;               // current frame and current time left for this frame
  char dir, loop;                       // current firection, looping
} ss_anim_props;                        // the definition of animation properties
    // if for ex two entities share one animation, they point to the same
    // animation data but have their own ss_anim_props

/* ---------------------------------------------------------------------------*/

struct {
  ss_linkage *list;                     // a linked list of animations
} ss_anim_sys;

/* ---------------------------------------------------------------------------*/

void ss_anim_init(void);
// Initialize the animation system

void ss_anim_exit(void);
// Uninitialize the animation system

int ss_visuals_init(void);
// Initialize video

void ss_visuals_exit(void);
// Uninitialize video

void ss_blit(void);
// Draw the backbuffer to screen

void ss_cycle_start(void);
// Beginning of the drawing cycle

void ss_normcycle_start(void);

void ss_cycle_end(void);
// End of the drawing cycle

ss_anim_props *ss_anim_props_create(void);
// Create local animation properties

void ss_anim_props_reset(ss_anim *a, ss_anim_props *t);
// Reset local animation properties

void ss_anim_props_destroy(ss_anim_props *t);
// Destroy local animation properties

void ss_anim_flush(void);
// Flush (delete all) animations

ss_anim *ss_anim_create(unsigned char frames);
// Create an animation

void ss_anim_destroy(ss_anim *anim);
// Destroy an animation

ss_anim_frame *ss_anim_frame_create(void);
// Create an animation frame

void ss_anim_frame_destroy(ss_anim_frame *t);
// Destroy an animation frame

ss_anim_frame **ss_anim_frames_create(unsigned char frames);
// Create a whole bunch of animation frames

void ss_anim_frames_destroy(unsigned char frames, ss_anim_frame **f);
// Destroy a whole bunch of animation frames

ss_anim *ss_anim_load(char *name);
// Load an animation from the disk

ss_anim *ss_anim_fetch(char *name);
// "Determine" best way to get the animation (first search animlist, then load)

#endif
