#ifndef SHELLSHOCK_LINKAGE_C
#define SHELLSHOCK_LINKAGE_C

#include <malloc.h>
#include "linkage.h"
#include "system.h"

ss_linkage *ss_linkage_node_new(void *o) {
  ss_linkage *t=NULL;
  t=malloc(sizeof(ss_linkage));
  if (t) {
    t->o=o;
    t->n=NULL; t->p=NULL;
  }
  else system_event(0, "Linkage: Unable to create a node");
  return t;
}

void ss_linkage_node_kill(ss_linkage *t) {
  if (t) {
    t->o=NULL; t->n=NULL; t->p=NULL;
    free(t);
  }
  else system_event(0, "Linkage: Invalid node for kill");
}

ss_linkage *ss_linkage_node_push(ss_linkage *list, ss_linkage *node) {
  if (!node) { system_event(0, "Linkage: Invalid node for push"); return list; }
  node->n=list;
  if (list) list->p=node;  
  return node;
}

ss_linkage *ss_linkage_node_pop(ss_linkage *list, ss_linkage *node) {
  ss_linkage *x=NULL, *ret=list;
  if (!list || !node) { system_event(0, "Linkage: Invalid list/node for pop"); return list; }
  x=list;
  while(x) {
    if (x==node) {
      if (list==node) { // if the node is the first one on the list
        list=node->n; ss_linkage_node_kill(node); x=NULL;
      }
      else if (!(x->n)) { // if the node is the last one on the list
        if (node->p) { node->p->n=node->n; ret=node->p; }
        ss_linkage_node_kill(node); x=NULL;
      }
      else { // if the node is, well, somewhere
        if (node->n) { node->n->p=node->p; ret=node->n; }
        if (node->p) { node->p->n=node->n; ret=node->p; }
        ss_linkage_node_kill(node);
        x=NULL;
      }
    }
    else x=x->n;
  }
  return list;
}

ss_linkage *ss_linkage_object_push(ss_linkage *list, void *object) {
  if (!object) { system_event(0, "Linkage: Invalid object for push"); return list; }
  ss_ll_npush(list,ss_linkage_node_new(object));
  return list;
}

ss_linkage *ss_linkage_object_pop(ss_linkage *list, void *object) {
  ss_linkage *x=NULL, *ret=list;
  if (!list || !object) { system_event(0, "Linkage: Invalid list/object for pop"); return list; }
  x=list;
  while(x) {
    if (object==ss_ll_access(x)) {
      if (x->n) { x->n->p=x->p; ret=x->n; }
      if (x->p) { x->p->n=x->n; ret=x->p; }
      ss_linkage_node_kill(x);
      x=NULL;
    }
    else x=list->n;
  }
  return ret;
}

#endif
