#ifndef SHELLSHOCK_SYSTEM_C
#define SHELLSHOCK_SYSTEM_C

#include "visuals.h"
#include "entity.h"
#include "system.h"
#include "compflag.h"
#include "sshock.h"
#include "sounds.h"

int system_init(void) {
  FILE *fx=NULL;
  fx=fopen("language.dat", "r");
  if (!fx) lang=0;
  else { lang=fgetc(fx); fclose(fx); }
  ss_sys.log=fopen(ss_file_log, "w");
  system_event(0, "System: Starting");
  allegro_init();
  system_event(0, "Initialized: Allegro");
  if (install_keyboard()>=0) system_event(0, "Initialized: Keyboard");
  else system_event(2, "System: Unable to initialize keyboard");
  if (!install_timer()) {
    if (install_int_ex(ss_bps1, BPS_TO_TIMER(1))<0) 
      system_event(2, "System: Unable to initialize 1hz timer");
    if (install_int_ex(ss_bps60, BPS_TO_TIMER(60))<0) 
      system_event(2, "System: Unable to initialize 60hz timer");
    system_event(0, "Initialized: Timers");
  }
  else system_event(2, "System: Unable to initialize timers");
  ss_visuals_init();
  ss_anim_init();
  ss_entity_init();
  ss_sounds_init();
  system_event(0, "System: Startup complete");
  ss_sys.bps1=0; ss_sys.bps60=0; ss_sys.timers=0;
  ss_game.sea=ss_entity_create();
  ss_entity_anim_assign(ss_game.sea, ss_anim_fetch("sea"), 0);
  ss_game.arrows[0]=ss_entity_create();
  ss_entity_anim_assign(ss_game.arrows[0], ss_anim_fetch("ar01"), 0);
  ss_game.arrows[1]=ss_entity_create();
  ss_entity_anim_assign(ss_game.arrows[1], ss_anim_fetch("ar02"), 0);
  ss_game.arrows[2]=ss_entity_create();
  ss_entity_anim_assign(ss_game.arrows[2], ss_anim_fetch("ar03"), 0);
  ss_game.flags[0]=ss_entity_create();
  ss_entity_anim_assign(ss_game.flags[0], ss_anim_fetch("fg"), 0);
  ss_game.flags[1]=ss_entity_create();
  ss_entity_anim_assign(ss_game.flags[1], ss_anim_fetch("fo"), 0);
  ss_game.pows[0]=ss_entity_create();
  ss_entity_anim_assign(ss_game.pows[0], ss_anim_fetch("pow1"), 0);
  ss_game.pows[1]=ss_entity_create();
  ss_entity_anim_assign(ss_game.pows[1], ss_anim_fetch("pow2"), 0);
  ss_game.pows[2]=ss_entity_create();
  ss_entity_anim_assign(ss_game.pows[2], ss_anim_fetch("pow3"), 0);
  ss_game.pows[3]=ss_entity_create();
  ss_entity_anim_assign(ss_game.pows[3], ss_anim_fetch("pow4"), 0);
  ss_load_res();
  
  return 1;
}

void system_exit(void) {
  FILE *fx=NULL;
  fx=fopen("language.dat", "w");
  if (fx) { fputc(lang,fx); fclose(fx); }
  ss_unload_res();
  system_event(0, "System: Shutting down");
  ss_sounds_exit();
  ss_entity_exit();
  ss_anim_exit();
  ss_visuals_exit();
  remove_int(ss_bps60);  
  remove_int(ss_bps1);
  remove_timer();
  system_event(0, "Uninitialized: Timers");
  remove_keyboard();
  system_event(0, "Uninitialized: Keyboard");
  system_event(0, "Uninitialized: Allegro");
  system_event(0, "System: Shutdown complete");
  if (ss_sys.log) {
    fclose(ss_sys.log);
    ss_sys.log=NULL;
  }
  allegro_exit();
}

void system_die(int code) {
  system_event(0, "System: The Reaper calls");
  system_exit();
  exit(code);
}

void system_event(unsigned char type, const char *format, ...) {
  char buf[1024], fbuf[1024]; 
  #ifdef SHELLSHOCK_LOG
  va_list ap;
  va_start(ap, format);
  uvszprintf(buf, sizeof(buf), format, ap);
  va_end(ap);
  snprintf(fbuf, 1023, "%03d: %s\n", type, buf);
  switch(type) {
    #ifndef SHELLSHOCK_LOG_IGNORE_INFO
    case 0:
      #ifdef SHELLSHOCK_LOG_FILE
      if (ss_sys.log) fprintf(ss_sys.log, fbuf);
      #endif
      #ifdef SHELLSHOCK_LOG_CONSOLE
      printf("%s\n", buf);
      #endif
      break;
    #endif
    #ifndef SHELLSHOCK_LOG_IGNORE_WARNING
    case 1:
      #ifdef SHELLSHOCK_LOG_FILE
      if (ss_sys.log) fprintf(ss_sys.log, fbuf);
      #endif
      #ifdef SHELLSHOCK_LOG_CONSOLE
      printf("%s\n", buf);
      #endif
      #ifdef SHELLSHOCK_LOG_ALLEGRO
      if (system_driver) allegro_message("%s", buf);
      #endif
      break;
    #endif
    #ifndef SHELLSHOCK_LOG_IGNORE_ERROR
    case 2:
      #ifdef SHELLSHOCK_LOG_FILE
      if (ss_sys.log) fprintf(ss_sys.log, fbuf);
      #endif
      #ifdef SHELLSHOCK_LOG_CONSOLE
      printf("%s\n", buf);
      #endif
      #ifdef SHELLSHOCK_LOG_ALLEGRO
      if (system_driver) allegro_message("%s", buf);
      #endif
      system_event(1, "System: Fatal error encountered, program termination necessary"); system_die(1);
      break;
    #endif
    default:
      break;
  }
  #else
  buf[0]=0; fbuf[0]=0;  type=*format; 
  #endif
}

void ss_bps1(void) { char buf[128]; if (ss_sys.timers) ss_sys.bps1=1; 
  if (ss_game.timing) if (ss_game.secs>60) {
    ss_game.secs-=60;
    ss_game.mins++;
    if (ss_game.mins>99) ss_game.mins=99;
  }
  snprintf(buf, 127, "Duckie Dash for Speedhack '04 by Inphernic - FPS: %d", fpsc);
  fpsc=0;
  set_window_title(buf);
}
void ss_bps60(void) { if (ss_sys.timers) ss_sys.bps60=1; ss_game.fx+=.01; if (ss_game.fx>M_DPI) ss_game.fx-=M_DPI; 
  if (ss_game.timing) {
  ss_game.msecs+=100/60.0;
  if (ss_game.msecs>100) {
    ss_game.msecs-=100;
    ss_game.secs++;
  }
  }
}

#endif
