#ifndef SHELLSHOCK_C
#define SHELLSHOCK_C

#include <math.h>
#include "sshock.h"
#include "system.h"
#include <alleggl.h>
#include <GL/glu.h>
#include "common.h"

// definition of language strings
char *stringlets[]={
  "LEVEL",
  "PRESS 'SPACE' TO START",
  "GAME PAUSED",
  "PRESS 'Q' TO QUIT",
  "PRESS 'P' TO RESUME",
  "RACE OVER",
  "WINNER - YOU!",
  "PRESS 'SPACE' TO CONTINUE",
  "WINNER - THE ENEMY..",
  "PRESS 'SPACE' TO RETRY",
  "CONTINUES",
  "PRESS 'SPACE' TO EXIT",
  "NO CONTINUES",
  "PRESENTS",
  "NEW GAME",
  "EXIT GAME",
  "CHOOSE LANGUAGE",
  "ENGLISH",
  "GAME COMPLETE",
  "YOU ARE NOW THE NEW GENERAL",
  "OF THE MIGHTY DUCKIE HORDE.",
  "MAY YOUR BATTLES AGAINST EVIL",
  "BE VICTORIUS!",
  "GAME OVER",
  "YOU DID NOT BECOME THE NEW",
  "GENERAL OF THE HORDE. YOU WILL",
  "ALWAYS BE KNOWN AS FAILURE.",
  "TRY AGAIN!",
  "ERROR",

  "IKKE",
  "TRYCK 'SPACE' PLZ",
  "SPEL INTE FUNKAR",
  "TRYCK 'Q' TO QUIT",
  "TRYCK 'P' TO RESUME",
  "AVENTYR OVER",
  "WINNER - DU!",
  "TRYCK 'SPACE' INNAN KONTINUE",
  "VINSTER - INTE DU..",
  "TRYCK 'SPACE' PA RETRY",
  "AVENTYRS",
  "TRYCK 'SPACE' ATT EXIT",
  "LOL INGEN KONTINUES",
  "MA IKKE TILDEKKES",
  "EN NY AVENTYR OKEJ",
  "EXIT PLZ",
  "SPRAK",
  "NORWEGIAN? OR SWEDISH?",
  "GAME COMPLETE",
  "DU AR DEN NY GENERAL AV DEN",
  "MIGHTY DUCKIE HORDE.",
  "SKA DINA BATTLAR VARA MYCKET",
  "VICTORIAN!",
  "SPEL OVER",
  "DU AR INTE DEN NY GENERAL AV DEN",
  "HORDE. DU SKA VARA KOM IHAG",
  "SOM EN FAILURE.",
  "DU MASTE GA IGEN!",
  "OMG",
  
  "TASO",
  "PAINA 'VALILYONTIA' ALOITTAAKSESI",
  "TAUKO",
  "PAINA 'Q:TA' POISTUAKSESI",
  "PAINA 'P:TA' JATKAAKSESI",
  "KISA OHI",
  "VOITTAJA - SINA!",
  "PAINA 'VALILYONTIA' JATKAAKSESI",
  "VOITTAJA - VASTUSTAJA..",
  "PAINA 'VALILYONTIA' JA YRITA UUDELLEEN",
  "JATKOMAHDOLLISUUKSIA",
  "PAINA 'VALILYONTIA' POISTUAKSESI",
  "EI JATKOMAHDOLLISUUKSIA",
  "ESITTAA",
  "UUSI PELI",
  "POISTU",
  "VALITSE KIELI",
  "SUOMI",
  "GAME COMPLETE",
  "OLET NYT SUUREN KUMIANKKARMEIJAN",
  "SUURPAALLIKKOKENRAALI.",
  "OLKOOT TULEVAT TAISTELUSI",
  "VOITOKKAITA!",
  "PELI OHI",
  "SINUSTA EI TULLUT ARMEIJAN UUTTA",
  "KENRAALIA. SINUT TULLAAN",
  "MUISTAMAAN ALISUORIUTUJANA.",
  "YRITA UUDELLEEN!",
  "VIRHE",

  "LEVELZ0RZ",
  "HIT SPACE LOL U NOOBZ0RZ0RZ0RZ0R",
  "GAME PAUZZED LOLZ",
  "'Q' TO EXITZ0R",
  "'P' TO CONTINUEZ0R",
  "RACVE OVERZ0R",
  "LOL U WON",
  "HIT SPACE OKZ0R?",
  "LOL U NOT WON..",
  "HIT SPACE OKZ0R?",
  "CONTINUEZ0RZ0R",
  "'SPACEZ+0R' To COMNNTIURE",
  "NO CONTINUEZ0RZ0R",
  "LOLZ",
  "NEW GAME LOL!",
  "EXIT LOL",
  "CHOOZE URZ LANGUAGE!",
  "BAFSOFT",
  "GAME COMPLETE",
  "UR NOW DA NEW GENERALZ0R",
  "OF DE M8TY DUCKIE HORDEZ0R.",
  "MAY UR BATTLEZ AGAINST EVILZ",
  "BE VICTORIUSZ0R!",
  "GAME OVERZ0R",
  "U DIDNT BECOME NEW",
  "GENERAL OF HORDE. U R WILL",
  "BE REMEMBERDE AS FAILUREZ0R.",
  "TRY AGAIN LOL!",
  "WTF ERROR",

  "LEVEL",
  "PRESS 'SPACE' TO START LOSING",
  "GAME PAUSED",
  "PRESS 'Q' TO QUIT",
  "PRESS 'P' TO RESUME LOSING",
  "RACE OVER, THANK GOD",
  "YOU WON, BUT THAT'S JUST LUCK",
  "PRESS 'SPACE' TO CONTINUE",
  "YOU TOTALLY AND UTTERLY FAILED",
  "PRESS 'SPACE' TO FAIL AGAIN",
  "CONTINUES",
  "PRESS 'SPACE' TO EXIT",
  "NO CONTINUES - YOU SUCK",
  "PRESENTS A GAME YOU CAN'T WIN",
  "NEW GAME - BUT YOU'LL FAIL ANYWAY",
  "EXIT - THE RIGHT CHOICE FOR YOU",
  "CHOOSE LANGUAGE YOU CAN'T SPEAK ANYWAY",
  "DEMOTIVATOR",
  "GAME COMPLETE",
  "YOU ARE NOW THE NEW GENERAL",
  "OF THE MIGHTY DUCKIE HORDE.",
  "MAY YOUR BATTLES AGAINST EVIL",
  "BE VICTORIUS!",
  "GAME OVER",
  "YOU DID NOT BECOME THE NEW",
  "GENERAL OF THE HORDE. YOU WILL",
  "ALWAYS BE KNOWN AS FAILURE.",
  "TRY AGAIN!",
  "ERROR"
  
};

void ss_flush_particles(void) {
  unsigned int i;
  for(i=0; i<MAX_PARTICLES; i++) {
    ss_particles[i].ttl=0;
    ss_particles[i].mttl=0;
    ss_particles[i].x=0;    
    ss_particles[i].y=0;    
    ss_particles[i].a=0;    
    ss_particles[i].v=0;    
    ss_particles[i].type=0;        
  }
  partcount=0;
}

void ss_add_particles(unsigned char type, unsigned char count, float x, float y) {
  unsigned int i;
  for(i=0; i<count; i++) {
    switch(type) {
      case 0:
        ss_particles[partcount].ttl=100;
        ss_particles[partcount].mttl=100;
        ss_particles[partcount].x=x;    
        ss_particles[partcount].y=y;    
        ss_particles[partcount].a=0.0; 
        ss_particles[partcount].v=0.0; 
        ss_particles[partcount].type=type;        
        break;
      default:
        ss_particles[partcount].ttl=100;
        ss_particles[partcount].mttl=100;
        ss_particles[partcount].x=x;    
        ss_particles[partcount].y=y;    
        ss_particles[partcount].a=(rand()%(int)(M_DPI*100.0))/100.0; 
        ss_particles[partcount].v=.1+((rand()%100)/100.0); 
        ss_particles[partcount].type=type;        
        break;
    }
    partcount++;
    if (partcount>=MAX_PARTICLES) partcount=0;
  }
}

void ss_draw_particles(void) {
  unsigned int i;
  glEnable(GL_BLEND);
  glEnable(GL_TEXTURE_2D);
  glEnable(GL_TEXTURE);
  glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_COLOR);
  glDisable(GL_DEPTH_TEST);
  for(i=0; i<MAX_PARTICLES; i++) if (ss_particles[i].ttl>0) {
    glColor3f((.5/ss_particles[i].mttl*ss_particles[i].ttl),(.5/ss_particles[i].mttl*ss_particles[i].ttl),(.5/ss_particles[i].mttl*ss_particles[i].ttl));
    switch(ss_particles[i].type) {
      case 0:
        glBindTexture(GL_TEXTURE_2D, ss_game.res.particle[ss_particles[i].type]);
        glBegin(GL_QUADS);
        glTexCoord2f(0,1); glVertex3f(ss_particles[i].x-4-(16.0-(16.0/ss_particles[i].mttl*ss_particles[i].ttl)), ss_particles[i].y+4+(16.0-(16.0/ss_particles[i].mttl*ss_particles[i].ttl)), -1.01);
        glTexCoord2f(1,1); glVertex3f(ss_particles[i].x+4+(16.0-(16.0/ss_particles[i].mttl*ss_particles[i].ttl)), ss_particles[i].y+4+(16.0-(16.0/ss_particles[i].mttl*ss_particles[i].ttl)), -1.01);
        glTexCoord2f(1,0); glVertex3f(ss_particles[i].x+4+(16.0-(16.0/ss_particles[i].mttl*ss_particles[i].ttl)), ss_particles[i].y-4-(16.0-(16.0/ss_particles[i].mttl*ss_particles[i].ttl)), -1.01);
        glTexCoord2f(0,0); glVertex3f(ss_particles[i].x-4-(16.0-(16.0/ss_particles[i].mttl*ss_particles[i].ttl)), ss_particles[i].y-4-(16.0-(16.0/ss_particles[i].mttl*ss_particles[i].ttl)), -1.01);
        glEnd();
        break;
      default:
        break;
    }
  }
  glEnable(GL_DEPTH_TEST);
  glDisable(GL_BLEND);
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_TEXTURE);
}

void ss_update_particles(void) {
  unsigned int i;
  for(i=0; i<MAX_PARTICLES; i++) if (ss_particles[i].ttl>0) {
    ss_particles[i].x+=cos(ss_particles[i].a)*ss_particles[i].v;
    ss_particles[i].y+=sin(ss_particles[i].a)*ss_particles[i].v;
    ss_particles[i].ttl--;
  }
}

char *ss_stringlet(unsigned char language, unsigned char id) {
  if (language>4) language=0;
  if (id>27) id=28;
  return stringlets[(language*29)+id];
}

float ss_angle(float x1, float x2, float y1, float y2) {
  float dx=x2-x1; float dy=y2-y1;
  if (dx<0.0) return (M_PI)+atan(dy/dx);
  else return atan(dy/dx);
}

void ss_grant_powerup(unsigned char car, unsigned char type) {
  int i;
  if (car>=MAX_CARS) return;
  if (type>3) return;
  switch(type) {
    case 0:
      ss_game.cars[car].health+=(MAX_HEALTH/5.0);
      if (ss_game.cars[car].health>MAX_HEALTH) ss_game.cars[car].health=MAX_HEALTH;
      break;
    case 1:
      for(i=0; i<MAX_CARS; i++) if (i!=car) {
        ss_game.cars[i].velocity=MAX_VELOCITY/2.0;
        ss_game.cars[i].angle+=M_PI;
        ss_game.cars[i].aiangle+=M_PI;
      }
      break;
    case 2:
      for(i=0; i<MAX_CARS; i++) if (i!=car) {
        ss_game.cars[i].velocity=0;
        ss_game.cars[i].freeze=180;
        if (ss_game.cars[i].freeze>720) ss_game.cars[i].freeze=720;
      }
      break;
    case 3:
      ss_game.cars[car].sspeed+=(MAX_VELOCITY*100);
      if (ss_game.cars[car].sspeed>(MAX_VELOCITY*200)) ss_game.cars[car].sspeed=(MAX_VELOCITY*200);
      ss_game.cars[car].velocity+=MAX_VELOCITY;
      break;
  }
}

BITMAP *ss_texture_make(unsigned char type) {
  BITMAP *c=NULL;
  c=create_bitmap(32,32);
  switch(type) {
    case 0:
      clear(c);
      circlefill(c, 16, 16, 16, makecol(155,155,255));
      circlefill(c, 16, 16, 14, makecol(255,255,255));
      circlefill(c, 16, 16, 12, makecol(155,155,255));
      circlefill(c, 16, 16, 10, makecol(0,0,255));
      circlefill(c, 16, 16, 8, makecol(0,0,155));
      circlefill(c, 16, 16, 6, makecol(0,0,0));
      break;
  }
  return c;
}

void ss_load_res(void) {
  DATAFILE *dat; BITMAP *t;
  ss_game.res.dat=NULL;
  ss_game.res.logo=0; ss_game.res.gamelogo=0; ss_game.res.end[0]=0; ss_game.res.end[1]=0;
  ss_game.res.aglf=NULL; ss_game.res.particle[0]=0; ss_game.res.orif=NULL;
  dat=load_datafile("./data/system.dat");
  if (!dat) system_event(2, "SShock: Unable to load vital resources");
  ss_game.res.dat=dat;
  system_event(0, "SShock: Resources loaded");
  ss_game.res.orif=dat[0].dat;
  ss_game.res.aglf=allegro_gl_convert_allegro_font(ss_game.res.orif, AGL_FONT_TYPE_TEXTURED, 1.0);
  ss_game.res.logo=allegro_gl_make_masked_texture(dat[1].dat);
  ss_game.res.gamelogo=allegro_gl_make_masked_texture(dat[2].dat);
  ss_game.res.end[0]=allegro_gl_make_masked_texture(dat[3].dat);
  ss_game.res.end[1]=allegro_gl_make_masked_texture(dat[4].dat);
  t=ss_texture_make(0);
  if (t) {
    ss_game.res.particle[0]=allegro_gl_make_masked_texture(ss_texture_make(0));
    destroy_bitmap(t); t=NULL;
  }
}

void ss_unload_res(void) {
  if (ss_game.res.particle[0]) glDeleteTextures(1, &ss_game.res.particle[0]);
  ss_game.res.particle[0]=0;
  if (ss_game.res.end[0]) glDeleteTextures(1, &ss_game.res.end[0]);
  ss_game.res.end[0]=0;
  if (ss_game.res.end[1]) glDeleteTextures(1, &ss_game.res.end[1]);
  ss_game.res.end[1]=0;
  if (ss_game.res.logo) glDeleteTextures(1, &ss_game.res.logo);
  ss_game.res.logo=0;
  if (ss_game.res.gamelogo) glDeleteTextures(1, &ss_game.res.gamelogo);
  ss_game.res.gamelogo=0;
  if (ss_game.res.aglf) allegro_gl_destroy_font(ss_game.res.aglf);
  ss_game.res.aglf=NULL;
  ss_game.res.orif=NULL;
  if (ss_game.res.dat) unload_datafile(ss_game.res.dat);  
  ss_game.res.dat=NULL;
  system_event(0, "SShock: Resources unloaded");
}

void ss_sea_draw(void) {
  glEnable(GL_TEXTURE);
  glEnable(GL_TEXTURE_2D);
  glBindTexture(GL_TEXTURE_2D, ss_get_currentframe(ss_game.sea));
  glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
  glBegin(GL_QUADS);
  glColor3f(1,1,1);
  glTexCoord2f(0+sin(ss_game.fx),12+cos(ss_game.fx)); glVertex3f(0-320, 0+240, -1.01);
  glTexCoord2f(16+sin(ss_game.fx),12+cos(ss_game.fx)); glVertex3f(0+320, 0+240, -1.01);
  glColor3f(0,0,1);
  glTexCoord2f(16+sin(ss_game.fx),0+cos(ss_game.fx)); glVertex3f(0+320, 0-240, -1.01);
  glTexCoord2f(0+sin(ss_game.fx),0+cos(ss_game.fx)); glVertex3f(0-320, 0-240, -1.01);
  glEnd();
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_TEXTURE);  
}

void ss_hud_draw(void) {
  unsigned char i, p[MAX_CHECKPOINTS];
  glLoadIdentity();
  glEnable(GL_BLEND);
  glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
  glBegin(GL_QUADS);
  if (!ss_game.cars[0].sspeed) glColor4f(0,1,0,1);
  else glColor4f(1,0,0,1);
  glVertex3f(-320, -230, -1.01);
  glVertex3f(-320+(640.0/MAX_VELOCITY*ss_game.cars[0].velocity), -230, -1.01);
  glColor4f(1,1,1,0);
  glVertex3f(-320+(640.0/MAX_VELOCITY*ss_game.cars[0].velocity), -240, -1.01);
  glVertex3f(-320, -240, -1.01);
  glEnd();
  glEnable(GL_TEXTURE);
  glEnable(GL_TEXTURE_2D);
  // draw race progress
  for(i=0; i<MAX_CHECKPOINTS; i++) p[i]=0;
  for(i=0; i<MAX_CARS; i++) {
    if (!i) glColor3f(0,1,0);
    else glColor3f(1,0,0);
    glBindTexture(GL_TEXTURE_2D, ss_get_currentframe(ss_game.cars[i].entity));
    glBegin(GL_QUADS);
    glTexCoord2f(0,1); glVertex3f(300-CAR_SIZE-(p[ss_game.cars[i].phase]*(CAR_SIZE/2.0)), -210+CAR_SIZE+(ss_game.cars[i].phase*(420.0/MAX_CHECKPOINTS)), -1.01);
    glTexCoord2f(1,1); glVertex3f(300+CAR_SIZE-(p[ss_game.cars[i].phase]*(CAR_SIZE/2.0)), -210+CAR_SIZE+(ss_game.cars[i].phase*(420.0/MAX_CHECKPOINTS)), -1.01);
    glTexCoord2f(1,0); glVertex3f(300+CAR_SIZE-(p[ss_game.cars[i].phase]*(CAR_SIZE/2.0)), -210-CAR_SIZE+(ss_game.cars[i].phase*(420.0/MAX_CHECKPOINTS)), -1.01);
    glTexCoord2f(0,0); glVertex3f(300-CAR_SIZE-(p[ss_game.cars[i].phase]*(CAR_SIZE/2.0)), -210-CAR_SIZE+(ss_game.cars[i].phase*(420.0/MAX_CHECKPOINTS)), -1.01);
    p[ss_game.cars[i].phase]++;
    glEnd();
  }
  glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_COLOR);
  glDisable(GL_DEPTH_TEST);
  allegro_gl_printf(ss_game.res.aglf, -309, 229, -1, makecol(255,55,55), "%02d:%02d:%02d", ss_game.mins, ss_game.secs, (int)ss_game.msecs);
  allegro_gl_printf(ss_game.res.aglf, -310, 230, -1, makecol(255,255,255), "%02d:%02d:%02d", ss_game.mins, ss_game.secs, (int)ss_game.msecs);
  if (gp==10) {
    allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf,0, -99, -1, makecol(255,255,255), "%s %02d", ss_stringlet(lang, 0), level);
    allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -139, -1, makecol(255,255,255), ss_stringlet(lang, 1));
  }
  if (gp==12) {
    allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf,0, -59, -1, makecol(255,255,255), ss_stringlet(lang, 2));
    allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf,0, -139, -1, makecol(255,255,255), ss_stringlet(lang, 3));
    allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -99, -1, makecol(255,255,255), ss_stringlet(lang, 4));
  }
  if (gp==13) {
    ss_game.c_lock=winner;
    allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf,0, 59, -1, makecol(255,255,255), ss_stringlet(lang, 5));
    if (!winner) {
      allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf,0, -59, -1, makecol(255,255,255), ss_stringlet(lang, 6));
      allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -99, -1, makecol(255,255,255), ss_stringlet(lang, 7));
    }
    else {
      allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf,0, -59, -1, makecol(255,255,255), ss_stringlet(lang, 8));
      if (continues>0) {
        allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -99, -1, makecol(255,255,255), ss_stringlet(lang, 9));
        allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -139, -1, makecol(255,255,0), "%s: %d", ss_stringlet(lang, 10), continues);
      }
      else {
        allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -99, -1, makecol(255,255,255), ss_stringlet(lang, 11));
        allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -139, -1, makecol(255,0,0), ss_stringlet(lang, 12));
      }
    }
  }
  glEnable(GL_DEPTH_TEST);
  glDisable(GL_TEXTURE);
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_BLEND);
}

void ss_intro_draw(void) {
  glLoadIdentity();
  glEnable(GL_TEXTURE);
  glEnable(GL_TEXTURE_2D);
  glEnable(GL_BLEND);
  if (tx>60) glColor3f(1,1,1);
  else glColor3f(1/60.0*tx,1/60.0*tx,1/60.0*tx);  
  glBindTexture(GL_TEXTURE_2D, ss_game.res.logo);
  glBegin(GL_QUADS);
  glTexCoord2f(0,1); glVertex3f(0-128, 40+128, -1.01);
  glTexCoord2f(1,1); glVertex3f(0+128, 40+128, -1.01);
  glTexCoord2f(1,0); glVertex3f(0+128, 40-128, -1.01);
  glTexCoord2f(0,0); glVertex3f(0-128, 40-128, -1.01);
  glEnd();
  glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_COLOR);
  if (tx>60) allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -100, -1, makecol(255,255,255), ss_stringlet(lang,13));
  else allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -100, -1, makecol(255/60.0*tx,255/60.0*tx,255/60.0*tx), ss_stringlet(lang,13));
  glDisable(GL_DEPTH_TEST);
  glEnable(GL_DEPTH_TEST);
  glDisable(GL_TEXTURE);
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_BLEND);
}

void ss_ending_draw(void) {
  glLoadIdentity();
  glEnable(GL_TEXTURE);
  glEnable(GL_TEXTURE_2D);
  glEnable(GL_BLEND);
  if (comp) glBindTexture(GL_TEXTURE_2D, ss_game.res.end[1]);
  else glBindTexture(GL_TEXTURE_2D, ss_game.res.end[0]);
  glBegin(GL_QUADS);
  glColor3f(1,1,1);
  glTexCoord2f(0,1); glVertex3f(0-320, 80+240, -1.01);
  glTexCoord2f(1,1); glVertex3f(0+320, 80+240, -1.01);
  glColor3f(0,0,0);
  glTexCoord2f(1,0); glVertex3f(0+320, 80-240, -1.01);
  glTexCoord2f(0,0); glVertex3f(0-320, 80-240, -1.01);
  glEnd();
  glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_COLOR);
  if (comp) {
    allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, 20, -1, makecol(0,255,255), ss_stringlet(lang,18));
    allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -20, -1, makecol(255,255,255), ss_stringlet(lang,19));
    allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -60, -1, makecol(255,255,255), ss_stringlet(lang,20));
    allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -100, -1, makecol(255,255,255), ss_stringlet(lang,21));
    allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -140, -1, makecol(255,255,255), ss_stringlet(lang,22));
  }
  else {
    allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, 20, -1, makecol(0,255,255), ss_stringlet(lang,23));
    allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -20, -1, makecol(255,255,255), ss_stringlet(lang,24));
    allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -60, -1, makecol(255,255,255), ss_stringlet(lang,25));
    allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -100, -1, makecol(255,255,255), ss_stringlet(lang,26));
    allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -140, -1, makecol(255,255,255), ss_stringlet(lang,27));
  }
  allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -200, -1, makecol(255,255,255), ss_stringlet(lang,7));
  glDisable(GL_DEPTH_TEST);
  glEnable(GL_DEPTH_TEST);
  glDisable(GL_TEXTURE);
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_BLEND);
}

void ss_menu_draw(void) {
  glLoadIdentity();
  glEnable(GL_BLEND);
  glBegin(GL_QUADS);
  glColor3f(0,0,0);
  glVertex3f(-320, 240, -1.01);
  glVertex3f(320, 240, -1.01);
  glColor3f(0,0,1);
  glVertex3f(320, -240, -1.01);
  glVertex3f(-320, -240, -1.01);
  glEnd(); 
  glBegin(GL_QUADS);
  glColor3f(flabs(sin(ss_game.fx+(M_PI/2.0)))/1.3,flabs(sin(ss_game.fx+(M_PI/2.0)))/1.3,1);
  glVertex3f(-320, -40-(menusel*50), -1.01);
  glColor3f(flabs(sin(ss_game.fx))/1.3,flabs(sin(ss_game.fx))/1.3,1);
  glVertex3f(320, -40-(menusel*50), -1.01);
  glVertex3f(320, 0-(menusel*50), -1.01);
  glColor3f(flabs(sin(ss_game.fx+(M_PI/2.0)))/1.3,flabs(sin(ss_game.fx+(M_PI/2.0)))/1.3,1);
  glVertex3f(-320, 0-(menusel*50), -1.01);
  glEnd(); 
  glEnable(GL_TEXTURE);
  glEnable(GL_TEXTURE_2D);
  glColor3f(1,1,1);
  glBindTexture(GL_TEXTURE_2D, ss_game.res.gamelogo);
  glBegin(GL_QUADS);
  glTexCoord2f(0,1); glVertex3f(0-256, 140+64, -1.01);
  glTexCoord2f(1,1); glVertex3f(0+256, 140+64, -1.01);
  glTexCoord2f(1,0); glVertex3f(0+256, 140-64, -1.01);
  glTexCoord2f(0,0); glVertex3f(0-256, 140-64, -1.01);
  glEnd();
  glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_COLOR);
  switch(menu) {
    case 0:
      allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, 0, -1, makecol(255,255,255), ss_stringlet(lang,14));
      allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -50, -1, makecol(255,255,255), ss_stringlet(lang,16));
      allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -100, -1, makecol(255,255,255), ss_stringlet(lang,15));
      break;
    case 1:
      allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, 0, -1, makecol(255,255,255), ss_stringlet(0,17));
      allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -50, -1, makecol(255,255,255), ss_stringlet(1,17));
      allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -100, -1, makecol(255,255,255), ss_stringlet(2,17));
      allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -150, -1, makecol(255,255,255), ss_stringlet(3,17));
      break;
  }
  allegro_gl_printf_center(ss_game.res.orif, ss_game.res.aglf, 0, -190, -1, makecol(255,0,0), "INPHERNIC 2004");
  glDisable(GL_TEXTURE);
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_BLEND);
}

void ss_cars_flush(void) {
  int i;
  for(i=0; i<MAX_CARS; i++) ss_car_reset(i);
}

void ss_cars_init(void) {
  int i;
  for(i=0; i<MAX_CARS; i++) ss_car_init(i);
}

void ss_checkpoints_flush(void) {
  int i;
  for(i=0; i<MAX_CARS; i++) ss_checkpoint_reset(i);
}

void ss_cars_update(void) {
  int i;
  for(i=0; i<MAX_CARS; i++) ss_car_update(i);
}

void ss_cars_draw(void) {
  int i;
  for(i=0; i<MAX_CARS; i++) ss_car_draw(i);
}

void ss_checkpoint_reset(unsigned char point) {
  if (point>=MAX_CHECKPOINTS) return;
  ss_game.checkpoints[point].active=0;
  ss_vector_set(&ss_game.checkpoints[point].pos, 0.0, 0.0, 0.0); 
}

void ss_car_reset(unsigned char car) {
  if (car>=MAX_CARS) return;
  ss_game.cars[car].health=0;
  ss_game.cars[car].active=0;
  ss_vector_set(&ss_game.cars[car].pos, 0.0, 0.0, 0.0); 
  ss_game.cars[car].angle=0;  
  ss_game.cars[car].velocity=0;  
  ss_game.cars[car].phase=0;
  if (ss_game.cars[car].entity) ss_entity_destroy(ss_game.cars[car].entity);
  ss_game.cars[car].entity=NULL;
}

void ss_car_init(unsigned char car) {
  if (car>=MAX_CARS) return;
  ss_game.cars[car].entity=NULL;
  ss_car_reset(car);
}

void ss_car_setup(unsigned char car) {
  if (car>=MAX_CARS) return;
  ss_game.cars[car].health=MAX_HEALTH;
  ss_game.cars[car].active=1;
  ss_vector_set(&ss_game.cars[car].pos, 0.0, 0.0, 0.0); 
  ss_game.cars[car].angle=0;  
  ss_game.cars[car].velocity=0;  
  ss_game.cars[car].phase=0;
  ss_game.cars[car].sspeed=0;
  ss_game.cars[car].freeze=0;  
  if (ss_game.cars[car].entity) ss_entity_destroy(ss_game.cars[car].entity);
  ss_game.cars[car].entity=ss_entity_create();
  if (!ss_game.cars[car].entity) printf("NO ENTITY");
  ss_entity_anim_assign(ss_game.cars[car].entity, ss_anim_fetch("kwak"), 0);
}

void ss_car_update(unsigned char car) {
  unsigned char i; float d1,d2,d1c,d2c;
  if (car>=MAX_CARS) return;
  if (!ss_game.cars[car].active) return;
  if (car) {
    ss_game.cars[car].velocity+=.019;
    ss_game.cars[car].aiangle=
    ss_angle(
      ss_game.cars[car].pos.x, ss_game.checkpoints[ss_game.cars[car].phase].pos.x,
      ss_game.cars[car].pos.y, ss_game.checkpoints[ss_game.cars[car].phase].pos.y
    )+(M_PI/2.0);
    while (ss_game.cars[car].aiangle<0.0) { ss_game.cars[car].aiangle+=M_DPI; }
    while (ss_game.cars[car].aiangle>=M_DPI) { ss_game.cars[car].aiangle-=M_DPI; }
    while (ss_game.cars[car].angle<0.0) { ss_game.cars[car].angle+=M_DPI; }
    while (ss_game.cars[car].angle>=M_DPI) { ss_game.cars[car].angle-=M_DPI; }
    d1=ss_game.cars[car].angle-ss_game.cars[car].aiangle; if (d1<0.0) d1c=d1*-1; else d1c=d1;
    d2=M_DPI-d1c; if (d2<0.0) d2c=d2*-1; else d2c=d2;
    if (d2c<d1c) {
      if (ss_game.cars[car].angle>ss_game.cars[car].aiangle) ss_game.cars[car].angle+=d2c/40.0;
      if (ss_game.cars[car].angle<ss_game.cars[car].aiangle) ss_game.cars[car].angle-=d2c/40.0;
    }
    if (d1c<d2c) {
      if (ss_game.cars[car].angle>ss_game.cars[car].aiangle) ss_game.cars[car].angle-=d1c/40.0;
      if (ss_game.cars[car].angle<ss_game.cars[car].aiangle) ss_game.cars[car].angle+=d1c/40.0;
    }
    d1c=ss_game.cars[car].aiangle-ss_game.cars[car].angle;
    if (d1c>(M_PI/4.0) || d1c<(M_PI/-4.0)) {
      ss_game.cars[car].velocity*=0.99;
    }
  }
  if (!(rand()%8)) ss_add_particles(0, 1, ss_game.cars[car].pos.x, ss_game.cars[car].pos.y);
  if (ss_game.cars[car].active==2) {
    ss_game.cars[car].velocity=0;
    ss_game.cars[car].health++;
    if (ss_game.cars[car].health>=(MAX_HEALTH/20.0)) ss_game.cars[car].active=1;
  }
  if (ss_game.cars[car].freeze) {
    ss_game.cars[car].velocity=0;
    ss_game.cars[car].freeze--;
    if (ss_game.cars[car].freeze<0) ss_game.cars[i].freeze=0;
  }
  if (ss_game.cars[car].sspeed>0) {
    ss_game.cars[car].sspeed--;
  }
  ss_game.cars[car].pos.x+=(cos(ss_game.cars[car].angle-(M_PI/2.0)))*ss_game.cars[car].velocity;
  ss_game.cars[car].pos.y+=(sin(ss_game.cars[car].angle-(M_PI/2.0)))*ss_game.cars[car].velocity;
  for(i=0; i<MAX_CARS;i++) 
    if (ss_game.cars[i].active && i!=car) if (ss_distance(&ss_game.cars[car].pos,&ss_game.cars[i].pos)<20) {
      ss_game.cars[i].velocity+=0.02;
      ss_game.cars[i].velocity*=1.2;
      ss_game.cars[car].velocity/=1.2;
      ss_game.cars[car].health-=3;
      ss_game.cars[car].angle-=.02;
      ss_game.cars[i].health-=3;
      ss_game.cars[i].angle+=.04;
    }
  ss_game.cars[car].velocity/=1.005;
  if (ss_game.cars[car].health<=0) {
    ss_game.cars[car].active=2;
  }
  if (ss_distance(&ss_game.cars[car].pos, &ss_game.checkpoints[ss_game.cars[car].phase].pos)<(CAR_SIZE*2)) {
    ss_game.cars[car].phase++;
    if (ss_game.cars[car].phase==MAX_CHECKPOINTS) {
      ss_game.cars[car].phase--;
      winner=car;
      gp=13;
    }
  }
  if (ss_game.cars[car].entity) ss_entity_anim_update(ss_game.cars[car].entity);
  
  if (ss_game.cars[car].velocity>(MAX_VELOCITY+(ss_game.cars[car].sspeed/100.0))) ss_game.cars[car].velocity=(MAX_VELOCITY+(ss_game.cars[car].sspeed/100.0));
}

/*
void ss_car_update(unsigned char car) {
  unsigned char i;
  if (car>=MAX_CARS) return;
  if (!ss_game.cars[car].active) return;
  if (car) {
    ss_game.cars[car].velocity+=.019;
    ss_game.cars[car].aiangle=
    ss_angle(
      ss_game.cars[car].pos.x, ss_game.checkpoints[ss_game.cars[car].phase].pos.x,
      ss_game.cars[car].pos.y, ss_game.checkpoints[ss_game.cars[car].phase].pos.y
    )+(M_PI/2.0);
    ss_game.cars[car].angle+=(ss_game.cars[car].aiangle+M_DPI-ss_game.cars[car].angle)/(50.0+(rand()%100));
  }
  if (!(rand()%8)) ss_add_particles(0, 1, ss_game.cars[car].pos.x, ss_game.cars[car].pos.y);
  if (ss_game.cars[car].active==2) {
    ss_game.cars[car].velocity=0;
    ss_game.cars[car].health++;
    if (ss_game.cars[car].health>=(MAX_HEALTH/20.0)) ss_game.cars[car].active=1;
  }
  if (ss_game.cars[car].freeze) {
    ss_game.cars[car].velocity=0;
    ss_game.cars[car].freeze--;
    if (ss_game.cars[car].freeze<0) ss_game.cars[i].freeze=0;
  }
  if (ss_game.cars[car].sspeed>0) {
    ss_game.cars[car].sspeed--;
  }
  ss_game.cars[car].pos.x+=(cos(ss_game.cars[car].angle-(M_PI/2.0)))*ss_game.cars[car].velocity;
  ss_game.cars[car].pos.y+=(sin(ss_game.cars[car].angle-(M_PI/2.0)))*ss_game.cars[car].velocity;
  for(i=0; i<MAX_CARS;i++) 
    if (ss_game.cars[i].active && i!=car) if (ss_distance(&ss_game.cars[car].pos,&ss_game.cars[i].pos)<20) {
      ss_game.cars[i].velocity+=0.02;
      ss_game.cars[i].velocity*=1.2;
      ss_game.cars[car].velocity/=1.2;
      ss_game.cars[car].health-=3;
      ss_game.cars[car].angle-=.02;
      ss_game.cars[i].health-=3;
      ss_game.cars[i].angle+=.04;
    }
  ss_game.cars[car].velocity/=1.005;
  if (ss_game.cars[car].health<=0) {
    ss_game.cars[car].active=2;
  }
  if (ss_distance(&ss_game.cars[car].pos, &ss_game.checkpoints[ss_game.cars[car].phase].pos)<(CAR_SIZE*2)) {
    ss_game.cars[car].phase++;
    if (ss_game.cars[car].phase==MAX_CHECKPOINTS) {
      ss_game.cars[car].phase--;
      winner=car;
      gp=13;
    }
  }
  if (ss_game.cars[car].entity) ss_entity_anim_update(ss_game.cars[car].entity);
  
  if (ss_game.cars[car].velocity>(MAX_VELOCITY+(ss_game.cars[car].sspeed/100.0))) ss_game.cars[car].velocity=(MAX_VELOCITY+(ss_game.cars[car].sspeed/100.0));
}
*/

void ss_car_draw(unsigned char car) {
  if (car>=MAX_CARS) return;
  float xa, dist, vx[8]; unsigned char i;
  if (!ss_game.cars[car].active) return;
  glEnable(GL_TEXTURE);
  glEnable(GL_TEXTURE_2D);
  glEnable(GL_BLEND);
  glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
  glColor3f(1,1,1);
  // draw checkpoint/goal
  if (!car) {
  if (ss_game.cars[car].phase==MAX_CHECKPOINTS-1) glBindTexture(GL_TEXTURE_2D, ss_get_currentframe(ss_game.flags[1]));
  else glBindTexture(GL_TEXTURE_2D, ss_get_currentframe(ss_game.flags[0]));
  glBegin(GL_QUADS);
  glTexCoord2f(0,1); glVertex3f(ss_game.checkpoints[ss_game.cars[car].phase].pos.x-CAR_SIZE, ss_game.checkpoints[ss_game.cars[car].phase].pos.y+CAR_SIZE, -1.01);
  glTexCoord2f(1,1); glVertex3f(ss_game.checkpoints[ss_game.cars[car].phase].pos.x+CAR_SIZE, ss_game.checkpoints[ss_game.cars[car].phase].pos.y+CAR_SIZE, -1.01);
  glTexCoord2f(1,0); glVertex3f(ss_game.checkpoints[ss_game.cars[car].phase].pos.x+CAR_SIZE, ss_game.checkpoints[ss_game.cars[car].phase].pos.y-CAR_SIZE, -1.01);
  glTexCoord2f(0,0); glVertex3f(ss_game.checkpoints[ss_game.cars[car].phase].pos.x-CAR_SIZE, ss_game.checkpoints[ss_game.cars[car].phase].pos.y-CAR_SIZE, -1.01);
  glEnd();
  }
  // draw powerups
  for(i=0; i<MAX_POWERUPS; i++) if ((ss_game.powerups[i].ttl>0)) {
    if (!car) {
      glColor3f(1.0, 1.0/10.0*ss_game.powerups[i].ttl, 1.0/10.0*ss_game.powerups[i].ttl);
      glBindTexture(GL_TEXTURE_2D, ss_get_currentframe(ss_game.pows[(int)ss_game.powerups[i].type]));
      glBegin(GL_QUADS);
      glTexCoord2f(0,1); glVertex3f(ss_game.powerups[i].pos.x-CAR_SIZE, ss_game.powerups[i].pos.y+CAR_SIZE, -1.01);
      glTexCoord2f(1,1); glVertex3f(ss_game.powerups[i].pos.x+CAR_SIZE, ss_game.powerups[i].pos.y+CAR_SIZE, -1.01);
      glTexCoord2f(1,0); glVertex3f(ss_game.powerups[i].pos.x+CAR_SIZE, ss_game.powerups[i].pos.y-CAR_SIZE, -1.01);
      glTexCoord2f(0,0); glVertex3f(ss_game.powerups[i].pos.x-CAR_SIZE, ss_game.powerups[i].pos.y-CAR_SIZE, -1.01);
      glEnd();
    }
    if (ss_distance(&ss_game.cars[car].pos, &ss_game.powerups[i].pos)<(CAR_SIZE*2)) {
      ss_grant_powerup(car, ss_game.powerups[i].type);
      ss_game.powerups[i].ttl=-1;
    }
  }
  glTranslatef(ss_game.cars[car].pos.x, ss_game.cars[car].pos.y, 0);
  // draw enemy pointer
  for(i=1; i<MAX_CARS; i++) if (ss_game.cars[i].active) {
    xa=(
    ss_angle(
      ss_game.cars[0].pos.x, ss_game.cars[i].pos.x,
      ss_game.cars[0].pos.y, ss_game.cars[i].pos.y
    ));
    glBindTexture(GL_TEXTURE_2D, ss_get_currentframe(ss_game.arrows[2]));
    if (!car) {
      dist=ss_distance(&ss_game.cars[car].pos, &ss_game.cars[i].pos);
      if (dist<200) { vx[0]=cos(xa)*(dist); vx[1]=sin(xa)*(dist); }
      else { vx[0]=cos(xa)*200.0; vx[1]=sin(xa)*200.0; }
      glColor3f(1,1,1);
      if (dist<200) {
        vx[2]=vx[0]+(cos(xa+(M_PI/2.0))*(dist/16.0));
        vx[3]=vx[1]+(sin(xa+(M_PI/2.0))*(dist/16.0));
        vx[4]=vx[0]+(cos(xa-(M_PI/2.0))*(dist/16.0));
        vx[5]=vx[1]+(sin(xa-(M_PI/2.0))*(dist/16.0));
      }
      else {
        vx[2]=vx[0]+(cos(xa+(M_PI/2.0))*(12.5));
        vx[3]=vx[1]+(sin(xa+(M_PI/2.0))*(12.5));
        vx[4]=vx[0]+(cos(xa-(M_PI/2.0))*(12.5));
        vx[5]=vx[1]+(sin(xa-(M_PI/2.0))*(12.5));
      }
      if (dist<200) { vx[0]=cos(xa)*(dist/4.0*3.0); vx[1]=sin(xa)*(dist/4.0*3.0); }
      else { vx[0]=cos(xa)*150.0; vx[1]=sin(xa)*150.0; }
      if (dist<200) {
        vx[6]=vx[0]+(cos(xa+(M_PI/2.0))*(dist/16.0));
        vx[7]=vx[1]+(sin(xa+(M_PI/2.0))*(dist/16.0));
        vx[0]=vx[0]+(cos(xa-(M_PI/2.0))*(dist/16.0));
        vx[1]=vx[1]+(sin(xa-(M_PI/2.0))*(dist/16.0));
      }
      else {
        vx[6]=vx[0]+(cos(xa+(M_PI/2.0))*(12.5));
        vx[7]=vx[1]+(sin(xa+(M_PI/2.0))*(12.5));
        vx[0]=vx[0]+(cos(xa-(M_PI/2.0))*(12.5));
        vx[1]=vx[1]+(sin(xa-(M_PI/2.0))*(12.5));
      }
      glBegin(GL_QUADS);
      glTexCoord2f(0,1); glVertex3f(vx[2], vx[3], -1.01);
      glTexCoord2f(0,0); glVertex3f(vx[6], vx[7], -1.01);
      glTexCoord2f(1,0); glVertex3f(vx[0], vx[1], -1.01);
      glTexCoord2f(1,1); glVertex3f(vx[4], vx[5], -1.01);
      glEnd();
    }
  }
  // draw checkpoint/goal pointer
  xa=(
    ss_angle(
      ss_game.cars[car].pos.x, ss_game.checkpoints[ss_game.cars[car].phase].pos.x,
      ss_game.cars[car].pos.y, ss_game.checkpoints[ss_game.cars[car].phase].pos.y
    ));
  glColor3f(1.0,1.0,1.0);
  if (ss_game.cars[car].phase==MAX_CHECKPOINTS-1) glBindTexture(GL_TEXTURE_2D, ss_get_currentframe(ss_game.arrows[1]));
  else glBindTexture(GL_TEXTURE_2D, ss_get_currentframe(ss_game.arrows[0]));  
  if (!car) {
    dist=ss_distance(&ss_game.cars[car].pos, &ss_game.checkpoints[ss_game.cars[car].phase].pos);
    if (dist<200) { vx[0]=cos(xa)*(dist); vx[1]=sin(xa)*(dist); }
    else { vx[0]=cos(xa)*200.0; vx[1]=sin(xa)*200.0; }
    if (dist<200) { vx[2]=vx[0]+(cos(xa+(M_PI/2.0))*(dist/16.0)); vx[3]=vx[1]+(sin(xa+(M_PI/2.0))*(dist/16.0)); vx[4]=vx[0]+(cos(xa-(M_PI/2.0))*(dist/16.0)); vx[5]=vx[1]+(sin(xa-(M_PI/2.0))*(dist/16.0)); }
    else { vx[2]=vx[0]+(cos(xa+(M_PI/2.0))*(12.5)); vx[3]=vx[1]+(sin(xa+(M_PI/2.0))*(12.5)); vx[4]=vx[0]+(cos(xa-(M_PI/2.0))*(12.5)); vx[5]=vx[1]+(sin(xa-(M_PI/2.0))*(12.5)); }
    if (dist<200) { vx[0]=cos(xa)*(dist/4.0*3.0); vx[1]=sin(xa)*(dist/4.0*3.0); }
    else { vx[0]=cos(xa)*150.0; vx[1]=sin(xa)*150.0; }
    if (dist<200) {
      vx[6]=vx[0]+(cos(xa+(M_PI/2.0))*(dist/16.0));
      vx[7]=vx[1]+(sin(xa+(M_PI/2.0))*(dist/16.0));
      vx[0]=vx[0]+(cos(xa-(M_PI/2.0))*(dist/16.0));
      vx[1]=vx[1]+(sin(xa-(M_PI/2.0))*(dist/16.0));
    }
    else {
      vx[6]=vx[0]+(cos(xa+(M_PI/2.0))*(12.5));
      vx[7]=vx[1]+(sin(xa+(M_PI/2.0))*(12.5));
      vx[0]=vx[0]+(cos(xa-(M_PI/2.0))*(12.5));
      vx[1]=vx[1]+(sin(xa-(M_PI/2.0))*(12.5));
    }
    glBegin(GL_QUADS);
    glTexCoord2f(0,1); glVertex3f(vx[2], vx[3], -1.01);
    glTexCoord2f(0,0); glVertex3f(vx[6], vx[7], -1.01);
    glTexCoord2f(1,0); glVertex3f(vx[0], vx[1], -1.01);
    glTexCoord2f(1,1); glVertex3f(vx[4], vx[5], -1.01);
    glEnd();
  }
  glColor3f(1,1,1);
  glRotatef((ss_game.cars[car].angle-(M_PI))/M_PI*180.0, 0, 0, 1);  
  // draw car
  glBindTexture(GL_TEXTURE_2D, ss_get_currentframe(ss_game.cars[car].entity));
  glBegin(GL_QUADS);
  glTexCoord2f(0,1); glVertex3f(0-CAR_SIZE, 0+CAR_SIZE, -1.01);
  glTexCoord2f(1,1); glVertex3f(0+CAR_SIZE, 0+CAR_SIZE, -1.01);
  glTexCoord2f(1,0); glVertex3f(0+CAR_SIZE, 0-CAR_SIZE, -1.01);
  glTexCoord2f(0,0); glVertex3f(0-CAR_SIZE, 0-CAR_SIZE, -1.01);
  glEnd();
  glDisable(GL_BLEND);
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_TEXTURE);
  // health bar
  glBegin(GL_QUADS);
  glColor3f(0.0, 0.0, 0.0);
  glVertex3f(0-CAR_SIZE, -CAR_SIZE-10, -1.01);
  glVertex3f(0+CAR_SIZE, -CAR_SIZE-10, -1.01);
  glVertex3f(0+CAR_SIZE, -CAR_SIZE, -1.01);
  glVertex3f(0-CAR_SIZE, -CAR_SIZE, -1.01);
  glEnd();
  if (ss_game.cars[car].health>0) {
  glBegin(GL_QUADS);
  if (ss_game.cars[car].active==1) glColor3f(0.0, 1.0, 0.0);
  if (ss_game.cars[car].active==2) glColor3f(1.0, 1.0, 0.0);
  glVertex3f(0-CAR_SIZE+1, -CAR_SIZE-10+1, -1.01);
  glVertex3f(0-CAR_SIZE+((CAR_SIZE*2.0/MAX_HEALTH)*ss_game.cars[car].health)-1, -CAR_SIZE-10+1, -1.01);
  glColor3f(1.0, 1.0, 1.0);
  glVertex3f(0-CAR_SIZE+((CAR_SIZE*2.0/MAX_HEALTH)*ss_game.cars[car].health)-1, -CAR_SIZE-1, -1.01);
  glVertex3f(0-CAR_SIZE+1, -CAR_SIZE-1, -1.01);
  glEnd();
  }
  glRotatef((ss_game.cars[car].angle-(M_PI))/M_PI*180.0, 0, 0, -1);
  glTranslatef(-ss_game.cars[car].pos.x, -ss_game.cars[car].pos.y, 0);
}

void ss_cam_update(void) {
  float d1,d2,d1c,d2c;
  if ((ss_game.c_lock>=0) && (ss_game.c_lock<MAX_CARS)) {
    if (ss_game.cars[ss_game.c_lock].active) {
      ss_game.tx=ss_game.cars[ss_game.c_lock].pos.x;
      ss_game.ty=ss_game.cars[ss_game.c_lock].pos.y;
      ss_game.ta=ss_game.cars[ss_game.c_lock].angle;
    }
  }
  while (ss_game.ta<0.0) { ss_game.ta+=M_DPI; }
  while (ss_game.ta>=M_DPI) { ss_game.ta-=M_DPI; }
  while (ss_game.ca<0.0) { ss_game.ca+=M_DPI; }
  while (ss_game.ca>=M_DPI) { ss_game.ca-=M_DPI; }
  d1=ss_game.ca-ss_game.ta; if (d1<0.0) d1c=d1*-1; else d1c=d1;
  d2=M_DPI-d1c; if (d2<0.0) d2c=d2*-1; else d2c=d2;
  if (d2c<d1c) {
    if (ss_game.ca>ss_game.ta) ss_game.ca+=d2c/20.0;
    if (ss_game.ca<ss_game.ta) ss_game.ca-=d2c/20.0;
  }
  if (d1c<d2c) {
    if (ss_game.ca>ss_game.ta) ss_game.ca-=d1c/20.0;
    if (ss_game.ca<ss_game.ta) ss_game.ca+=d1c/20.0;
  }
  ss_game.cx+=(ss_game.tx-ss_game.cx)/10.0;
  ss_game.cy+=(ss_game.ty-ss_game.cy)/10.0;
}

void ss_checkpoint_set(unsigned char point, float x, float y) {
  if (point>=MAX_CHECKPOINTS) return;
  ss_game.checkpoints[point].active=1;
  ss_vector_set(&ss_game.checkpoints[point].pos, x, y, 0.0);  
}

void ss_powerups_clear(void) {
  int i;
  for(i=0; i<MAX_POWERUPS; i++) {
    ss_game.powerups[i].ttl=0;
    ss_game.powerups[i].pos.x=0;
    ss_game.powerups[i].pos.y=0;
    ss_game.powerups[i].type=0;
  }
}


void ss_powerups_update(void) {
  int i;
  for(i=0; i<MAX_POWERUPS; i++) {
    ss_game.powerups[i].ttl--;
    if (ss_game.powerups[i].ttl<=0) {
      ss_game.powerups[i].ttl=10;
      ss_game.powerups[i].pos.x=2000-(rand()%4000);
      ss_game.powerups[i].pos.y=2000-(rand()%4000);
      ss_game.powerups[i].type=rand()%4;
    }
  }
}

#endif 
