#ifndef SHELLSHOCK_ENTITY_C
#define SHELLSHOCK_ENTITY_C

#include "entity.h"
#include "system.h"

void ss_entity_init(void) {
  ss_entity_sys.list=NULL;
  system_event(0, "Initialized: Entity");
}

void ss_entity_exit(void) {
  ss_entity_flush();
  system_event(0, "Uninitialized: Entity");
}

void ss_entity_flush(void) {
  while(ss_entity_sys.list) {
    ss_entity_destroy(ss_ll_access(ss_entity_sys.list));
    ss_ll_npop(ss_entity_sys.list,ss_entity_sys.list);
  }
  ss_entity_sys.list=NULL;
  system_event(0, "Entity: Entity pool flushed");
}

ss_entity *ss_entity_create(void) {
  ss_entity *t=NULL;
  t=malloc(sizeof(ss_entity));
  if (t) {
    t->cur_anim=0;
    t->anims=0;
    t->animp=NULL;
    t->anim=NULL;
    ss_ll_opush(ss_entity_sys.list, t);
  }
  return t;
}

void ss_entity_destroy(ss_entity *entity) {
  unsigned char i;
  if (entity) {
    for(i=0; i<entity->anims; i++) if (entity->animp[i]) ss_anim_props_destroy(entity->animp[i]);      
  }
}

int ss_entity_anim_assign(ss_entity *e, ss_anim *a, unsigned char slot) {
  void *tmp; unsigned char i;
  if (!e || !a) return 0;
  if (slot<e->anims) {
    e->anim[slot]=a;
    return 1;
  }
  else {
    tmp=e->anim;
    e->anim=realloc(e->anim, sizeof(ss_anim *)*(slot+1));
    if (!e->anim) { e->anim=tmp; return 0; }
    tmp=e->animp;
    e->animp=realloc(e->animp, sizeof(ss_anim_props *)*(slot+1));
    if (!e->animp) { 
      e->animp=tmp; e->anim=realloc(e->anim, sizeof(ss_anim *)*e->anims); return 0; 
    }
    for(i=e->anims; i<(slot+1); i++) { e->anim[i]=NULL; e->animp[i]=NULL; }
    e->anim[slot]=a; e->animp[slot]=ss_anim_props_create();
    ss_anim_props_reset(a, e->animp[slot]);
    e->anims++;
  }
  return 1;
}

void ss_entity_update(ss_entity *t) {
  ss_entity_anim_update(t);
  if (!t) return; 
}

void ss_entity_anim_update(ss_entity *t) {
  if (!t) return;
  if (t->animp[t->cur_anim]->cur_frame<0) t->animp[t->cur_anim]->cur_frame=0;
  if (t->animp[t->cur_anim]->cur_frame>=t->anim[t->cur_anim]->frames) return;
  if (t->animp[t->cur_anim]->cur_ttl>0) t->animp[t->cur_anim]->cur_ttl--;
  if (!t->animp[t->cur_anim]->cur_ttl) {
    t->animp[t->cur_anim]->cur_frame+=t->animp[t->cur_anim]->dir;
    if (t->animp[t->cur_anim]->cur_frame>=0 && t->animp[t->cur_anim]->cur_frame<t->anim[t->cur_anim]->frames)
      t->animp[t->cur_anim]->cur_ttl=t->anim[t->cur_anim]->frame[t->animp[t->cur_anim]->cur_frame]->ttl;
  }
  if (t->animp[t->cur_anim]->cur_frame<0) {
    switch(t->animp[t->cur_anim]->loop) {
      default: case 0: 
        t->animp[t->cur_anim]->cur_frame=0;
        t->animp[t->cur_anim]->dir=0;
        t->animp[t->cur_anim]->cur_ttl=-1;
        break;
      case 1: 
        t->animp[t->cur_anim]->cur_frame=t->anim[t->cur_anim]->frames-1;
        t->animp[t->cur_anim]->cur_ttl=t->anim[t->cur_anim]->frame[t->animp[t->cur_anim]->cur_frame]->ttl;
        break;
      case 2: 
        t->animp[t->cur_anim]->cur_frame=1;
        if (t->animp[t->cur_anim]->cur_frame>t->anim[t->cur_anim]->frames-1) t->animp[t->cur_anim]->cur_frame=t->anim[t->cur_anim]->frames-1;
        t->animp[t->cur_anim]->dir=1;
        t->animp[t->cur_anim]->cur_ttl=t->anim[t->cur_anim]->frame[t->animp[t->cur_anim]->cur_frame]->ttl;
        break;      
    }
  }
  if (t->animp[t->cur_anim]->cur_frame>=t->anim[t->cur_anim]->frames) {
    switch(t->animp[t->cur_anim]->loop) {
      default: case 0: 
        t->animp[t->cur_anim]->cur_frame=t->anim[t->cur_anim]->frames-1;
        t->animp[t->cur_anim]->dir=0;
        t->animp[t->cur_anim]->cur_ttl=-1;
        break;
      case 1: 
        t->animp[t->cur_anim]->cur_frame=0;
        t->animp[t->cur_anim]->cur_ttl=t->anim[t->cur_anim]->frame[t->animp[t->cur_anim]->cur_frame]->ttl;
        break;
      case 2: 
        t->animp[t->cur_anim]->cur_frame=t->anim[t->cur_anim]->frames-1;
        if (t->animp[t->cur_anim]->cur_frame<0) t->animp[t->cur_anim]->cur_frame=0;
        t->animp[t->cur_anim]->dir=-1;
        t->animp[t->cur_anim]->cur_ttl=t->anim[t->cur_anim]->frame[t->animp[t->cur_anim]->cur_frame]->ttl;
        break;      
    }
  }
}

GLuint ss_get_currentframe(ss_entity *t) {
  if (!t) return 0;
  return t->anim[t->cur_anim]->frame[t->animp[t->cur_anim]->cur_frame]->frame;
}

void ss_entities_update(void) {
  ss_linkage *t=NULL;
  t=ss_entity_sys.list;
  while(t) {
    ss_entity_update(ss_ll_access(t));
    t=t->n;
  }
}

#endif
