#ifndef SHELLSHOCK_H
#define SHELLSHOCK_H

#include "entity.h"
#include "common.h"

#define MAX_CARS        8
#define MAX_CHECKPOINTS 20
#define MAX_POWERUPS    20
#define MAX_VELOCITY    15
#define MAX_HEALTH      10000
#define MAX_PARTICLES   100
#define CAR_SIZE        24

struct {
  struct {
    int health, freeze, sspeed;
    unsigned char active, phase;
    ss_vector pos;
    float angle, aiangle, velocity;
    ss_entity *entity;
  } cars[MAX_CARS];
  struct {
    ss_vector pos;
    unsigned char active;
  } checkpoints[MAX_CHECKPOINTS];
  struct {
    char ttl, type;
    ss_vector pos;
  } powerups[MAX_POWERUPS];
  struct {
    FONT *aglf;
    FONT *orif;
    GLuint logo, gamelogo, end[2], particle[1];
    DATAFILE *dat;
  } res;
  unsigned char mins, secs; float msecs;
  int c_lock;
  float cx, cy, ca, tx, ty, ta;
  ss_entity *sea, *arrows[3], *flags[2], *pows[4];
  float fx;
  unsigned char timing;
} ss_game;

struct {
  float x, y, a, v;
  unsigned char ttl, mttl, type;
} ss_particles[MAX_PARTICLES];
unsigned int partcount;

float c;

BITMAP *ss_texture_make(unsigned char type);
void ss_flush_particles(void);
void ss_add_particles(unsigned char type, unsigned char count, float x, float y);
void ss_draw_particles(void);
void ss_update_particles(void);
char *ss_stringlet(unsigned char language, unsigned char id);
float ss_angle(float x1, float x2, float y1, float y2);
void ss_grant_powerup(unsigned char car, unsigned char type);
void ss_load_res(void);
void ss_unload_res(void);
void ss_sea_draw(void);
void ss_hud_draw(void);
void ss_intro_draw(void);
void ss_ending_draw(void);
void ss_menu_draw(void);
void ss_cars_flush(void);
void ss_checkpoints_flush(void);
void ss_cars_init(void);
void ss_car_init(unsigned char car);
void ss_cars_update(void);
void ss_cars_draw(void);
void ss_checkpoint_reset(unsigned char point);
void ss_car_reset(unsigned char car);
void ss_car_setup(unsigned char car);
void ss_car_update(unsigned char car);
void ss_car_draw(unsigned char car);
void ss_cam_update(void);
void ss_checkpoint_set(unsigned char point, float x, float y);
void ss_powerups_clear(void);
void ss_powerups_update(void);

#endif
