#ifndef SHELLSHOCK_SOUNDS_C
#define SHELLSHOCK_SOUNDS_C

#include "sounds.h"

void ss_sounds_init(void) {
  int i;
  for(i=0; i<2; i++) ss_sounds_sys.sfx[i]=NULL;
  for(i=0; i<5; i++) ss_sounds_sys.mus[i]=NULL;  
  if (install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL)) ss_sounds_sys.use=0;
  ss_sounds_sys.use=1;
  dumb_register_stdfiles();
  ss_sounds_sys.mus[0]=dumb_load_xm("data/ingame.xm");
  ss_sounds_sys.mus[1]=dumb_load_xm("data/menu.xm");
  ss_sounds_sys.mus[2]=dumb_load_xm("data/intro.xm");
  ss_sounds_sys.mus[3]=dumb_load_xm("data/over.xm");
  ss_sounds_sys.mus[4]=dumb_load_xm("data/comp.xm");
  ss_sounds_sys.amus=-1;
  ss_sounds_sys.asfx=-1;  
  ss_sounds_sys.dp=NULL;
}
void ss_sounds_exit(void) {
  int i;
  if (!ss_sounds_sys.use) return;
  if (ss_sounds_sys.dp) {
    al_stop_duh(ss_sounds_sys.dp);
    ss_sounds_sys.dp=NULL;
  }
  for(i=0; i<2; i++) if (ss_sounds_sys.sfx[i]) { destroy_sample(ss_sounds_sys.sfx[i]); ss_sounds_sys.sfx[i]=NULL; }
  for(i=0; i<5; i++) if (ss_sounds_sys.mus[i]) { unload_duh(ss_sounds_sys.mus[i]); ss_sounds_sys.mus[i]=NULL; }
  dumb_exit();
}
void ss_sounds_poll(void) {
  al_poll_duh(ss_sounds_sys.dp);
}

void ss_sounds_play_mus(unsigned char mus) {
  if (!ss_sounds_sys.use || mus>4) return;
  if (mus==ss_sounds_sys.amus) return;
  if (!ss_sounds_sys.mus[mus]) return;
  if (ss_sounds_sys.dp) al_stop_duh(ss_sounds_sys.dp);
  ss_sounds_sys.dp=al_start_duh(ss_sounds_sys.mus[mus],2,0,.6,4096,44100);
  ss_sounds_sys.amus=mus;
}

void ss_sounds_stop_mus(void) {
  if (!ss_sounds_sys.use) return;
  if (ss_sounds_sys.dp) al_stop_duh(ss_sounds_sys.dp);
  ss_sounds_sys.amus=-1;
}

#endif
