#ifndef SHELLSHOCK_LINKAGE_H
#define SHELLSHOCK_LINKAGE_H

/* -----------------------------------------------------------------------------
 BI-DIR GENERAL PURPOSE LINKED LIST
------------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/

// Some ghetto defines for my convenience!

#define ss_ll_npush(list,node)  list=ss_linkage_node_push(list,node)
#define ss_ll_npop(list,node)   list=ss_linkage_node_pop(list,node)
#define ss_ll_opush(list,node)  list=ss_linkage_object_push(list,node)
#define ss_ll_opop(list,node)   list=ss_linkage_object_pop(list,node)
#define ss_ll_access(node)      (node->o)

/* ---------------------------------------------------------------------------*/

typedef struct _ss_linkage {
  void *o;                      // pointer to data
  struct _ss_linkage *p, *n;    // pointer to the next and prev nodes
} ss_linkage;                   // the node definition

/* ---------------------------------------------------------------------------*/

ss_linkage *ss_linkage_node_new(void *o);
// Create a new node

void ss_linkage_node_kill(ss_linkage *t);
// Destroy a node

ss_linkage *ss_linkage_node_push(ss_linkage *list, ss_linkage *node);
// Push the node onto the given list

ss_linkage *ss_linkage_node_pop(ss_linkage *list, ss_linkage *node);
// Pop the node from the given list

ss_linkage *ss_linkage_object_push(ss_linkage *list, void *object);
// Push the object onto the given list (automagically creates a node too)

ss_linkage *ss_linkage_object_pop(ss_linkage *list, void *object);
// Pop the object from the given list

#endif

