#ifndef SHELLSHOCK_ENTITY_H
#define SHELLSHOCK_ENTITY_H

#include "linkage.h"
#include "visuals.h"

typedef struct {
  ss_anim **anim; unsigned char cur_anim;
  ss_anim_props **animp;
  unsigned char anims;
} ss_entity;

struct {
  ss_linkage *list;
} ss_entity_sys;

void ss_entity_init(void);
void ss_entity_exit(void);
void ss_entity_flush(void);
ss_entity *ss_entity_create(void);
void ss_entity_destroy(ss_entity *entity);
int ss_entity_anim_assign(ss_entity *e, ss_anim *a, unsigned char slot);
void ss_entity_update(ss_entity *t);
void ss_entity_anim_update(ss_entity *t);
GLuint ss_get_currentframe(ss_entity *t);
void ss_entities_update(void);

#endif
