#ifndef SHELLSHOCK_COMMON_C
#define SHELLSHOCK_COMMON_C

#include <allegro.h>
#include <alleggl.h>
#include <malloc.h>
#include <string.h>
#include <math.h>
#include "common.h"

// set a vector to something
void ss_vector_set(ss_vector *t, float x, float y, float z) {
  if (!t) return;  
  t->x=x; t->y=y; t->z=z;    
}

// modify a vector
void ss_vector_mod(ss_vector *t, float x, float y, float z) {
  if (!t) return;
  ss_vector_set(t, t->x+x, t->y+y,t->z+z);
}

// sum a single component
float ss_vector_sum_x(ss_vector *t, ss_vector *c) { float x=0.0; if (t) x+=t->x; if (c) x+=c->x; return x; }
float ss_vector_sum_y(ss_vector *t, ss_vector *c) { float y=0.0; if (t) y+=t->y; if (c) y+=c->y; return y; }
float ss_vector_sum_z(ss_vector *t, ss_vector *c) { float z=0.0; if (t) z+=t->z; if (c) z+=c->z; return z; }

// determine the 2D distance between two points
float ss_distance(ss_vector *t, ss_vector *c) {
  return sqrt(((t->x-c->x)*(t->x-c->x))+((t->y-c->y)*(t->y-c->y)));
}

// absolute value of a float
float flabs(float a) { if (a<0) return -a; return a; } 

// make a copy of the string
char *ss_stringcopy(char *string) {
  unsigned int x,i; char *c=NULL;
  if (!string) return NULL;
  i=strlen(string);
  c=malloc(sizeof(unsigned char)*(i+1));
  if (c) {
    for(x=0; x<i; x++) c[x]=string[x];
    c[i]=0;
  }
  return c;
}

// print a centered string
void allegro_gl_printf_center(FONT *orig, FONT *font, float x, float y, float z, int color, char *format, ...) {
  char buf[512]; float xi=x,yi=y;
  va_list ap; 
  va_start(ap, format);
  uvszprintf(buf, sizeof(buf), format, ap);
  va_end(ap);
  xi-=((float)(text_length(orig, buf))/2.0);
  allegro_gl_printf(font, xi, yi, z, color, buf);
}

#endif
