/* Author: Tobi Vollebregt */

/*  Bataafje -- A small game written for the Allegro SpeedHack 2003
 *  Copyright (C) 2003  Tobi Vollebregt
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See `License.txt', which contains a verbatim copy of the
 *  GNU General Public License, for details.
 *
 *  Please send your reaction to: tobivollebregt@hotmail.com
 */

#include <allegro.h>
#include "object.h"

IObject::Class* IObject::classes;

void IObject::DumpClassList ()
{
    TRACE ("---Dumping class list---\n");
    for (Class* cl = classes; cl; cl = cl->next) {
        TRACE ("Class: %s\n", cl->name); }
}

// This searches the class list for a class with the name, and calls the 
// creator() function of the class, thus returning an instance of the class.
IObject* IObject::New (const char* name)
{
    TRACE ("Creating %s...\n", name);
    for (Class* cl = classes; cl; cl = cl->next)
        if (ustrcmp (cl->name, name) == 0) return cl->creator ();
    FatalError ("Couldn't create instance of class %s.", name);
    return 0;
}

//for debugging:
class CTestObject : public IObject
{
    NO_COPY (CTestObject);
    DECLARE_CLASS (CTestObject);
 public:
    CTestObject () {}
    ~CTestObject () {}
    bool Initialize (int) {return true;}
    void Draw (BITMAP*, int) {}
    bool Update (int) { return true; }
};
IMPLEMENT_CLASS (CTestObject);
