/* Author: Tobi Vollebregt */

/*  Bataafje -- A small game written for the Allegro SpeedHack 2003
 *  Copyright (C) 2003  Tobi Vollebregt
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See `License.txt', which contains a verbatim copy of the
 *  GNU General Public License, for details.
 *
 *  Please send your reaction to: tobivollebregt@hotmail.com
 */

#ifndef __tjv_DEBUG_H__
#define __tjv_DEBUG_H__

#ifdef DJGPP
# define rand random
# define srand srandom
#endif

// forbid to copy class cl
#define NO_COPY(cl) cl(const cl&); cl& operator = (const cl&)

// from main.cpp: close the program and display message
void FatalError (const char* fmt, ...);
// add an object to the list
class IObject;
void AddObject (IObject* obj);
IObject* GetObjects ();

// from player.cpp
void PlayerIncAmmo (int w);

extern int frame_id; // incremented each frame

extern int score;
extern int game_time;

extern "C" { extern FONT* game_font; }
void LoadBigFont ();

extern float global_vx, global_vy;

#endif
