/* Author: Tobi Vollebregt */

/*  Bataafje -- A small game written for the Allegro SpeedHack 2003
 *  Copyright (C) 2003  Tobi Vollebregt
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See `License.txt', which contains a verbatim copy of the
 *  GNU General Public License, for details.
 *
 *  Please send your reaction to: tobivollebregt@hotmail.com
 */

#include <allegro.h>
#include <math.h>
#include "anim.h"
#include "object.h"

//////////// enemies
class CEnemy : public IObject
{
    DECLARE_CLASS (CEnemy);
    NO_COPY (CEnemy);

 public:

    CEnemy () : anim (0) {}
    ~CEnemy () { if (anim) delete anim; }

    bool Initialize (int ix)
    {
        speed = get_config_int (0, "enemy.speed", -1);
        x = ix;
        anim = 0;
        dead = 0;
        return true;
    }

    void Draw (BITMAP* b, int dx)
    {
        ASSERT (anim);
        if (dead)
        {
            set_dissolve_blender (0, 0, 0, 255 - (dead << 3));
            anim->DrawTrans (b, x - anim->GetWidth () / 2 - dx,
                SCREEN_H - anim->GetHeight ());
        }
        else anim->Draw (b, x - anim->GetWidth () / 2 - dx,
            SCREEN_H - anim->GetHeight ());
    }

    bool Update (int ms)
    {
        ASSERT (anim);
        if (dead) ++dead;
        else
        {
            anim->Update (ms);
            x += speed;
            if (x < -anim->GetWidth () / 2) return false;
        }
        return dead < 32;
    }

    void SetAnimation (const char* s)
    {
        anim = new CAnimation (s);
        const char* name= ustrchr(s, '#');
        if (name) s = name+1;
        w= get_config_int (s, "weapon", -1);
    }

    bool IsEnemy () const { return true; }

    void Die ()
    {
        dead = 1;
    }

    bool Hit (int hx, int hy)
    {
        if (dead) return false;
        if (hx > x - anim->GetWidth () / 2 && hx < x + anim->GetWidth () / 2
            && hy > SCREEN_H - anim->GetHeight () && hy < SCREEN_H)
        {
            /*int dx, dy;
            BITMAP* b = anim->GetBitmap (&dx, &dy);
            int c = getpixel (b, hx - dx, hy - dy);
            if (c < 0 || c == makecol (255, 0, 255)) return false;*/
            return true;
        }
        return false;
    }

    int GetWeapon () const { return w; }

 private:

    CAnimation* anim;
    int speed;
    int dead;
    int w;
};

IMPLEMENT_CLASS (CEnemy);

/////////// bullets

class CBullet : public IObject
{
    DECLARE_CLASS (CBullet);
    NO_COPY (CBullet);

 public:

    CBullet () : bmp (0), anim (0) {}
    ~CBullet () { if (anim) delete anim; destroy_bitmap (bmp); }

    bool Initialize (int) { return false;}
    bool Initialize2 (int ix, int iy)
    {
        px = ix;
        py = iy;
        angle = 0;
        anim = 0;
        return true;
    }

    void Draw (BITMAP* d, int dx)
    {
        clear_to_color (bmp, makecol (255, 0, 255));
        anim->Draw (bmp, 0, 0);
        pivot_sprite (d, bmp, int (px) - dx, int (py), bmp->w/2, bmp->h/2, angle);
    }

    bool Update (int ms)
    {
        anim->Update (ms);
        // physics???
        px += vx;
        py += vy;
        vy += g;
        angle += rotatespeed;
        angle &= 0xffffff;
        if (px > SCREEN_W || py > SCREEN_H || px < 0) return false;

        bool ret=true;
        for (IObject*obj = GetObjects (); obj; obj = obj->next)
        {
            //CEnemy* en = dynamic_cast<CEnemy*> (obj);
            if (obj->IsEnemy ())
            {
                CEnemy* en = (CEnemy*) obj;
                if (/*en->Hit (int (px) - bmp->w/3, int (py) - bmp->h/3) ||
                    en->Hit (int (px) - bmp->w/3, int (py) + bmp->h/3) ||
                    en->Hit (int (px) + bmp->w/3, int (py) - bmp->h/3) ||
                    en->Hit (int (px) + bmp->w/3, int (py) + bmp->h/3) ||*/
                    en->Hit (int (px), int (py)))
                {
                    score += int (vy * vy);
                    if (en->GetWeapon () >= 0)
                        PlayerIncAmmo (en->GetWeapon ());
                    en->Die ();
                    ret = false;
                    break;
                }
            }
        }
        return ret;
    }

    void SetAnimation (const char* s)
    {
        anim = new CAnimation (s);
        // here we can load g because we now know the type of the bullet now
        vx = global_vx;
        vy = global_vy;
        //TRACE("%s: vx=%g; vy=%g\n", s, vx, vy);
        char* name = ustrchr(s, '#');
        if (name) s = name+1;
        g = get_config_float (s, "g", 0.0);
        rotatespeed = itofix (get_config_int (s, "rotatespeed", 0));
        bmp = create_bitmap (anim->GetWidth (), anim->GetHeight ());
        if (!(bmp)) FatalError ("not enough memory");
    }

 private:
    BITMAP* bmp;
    CAnimation* anim;
    float px, py;
    float vx, vy;
    float g;
    fixed angle;
    fixed rotatespeed;
};

IMPLEMENT_CLASS (CBullet);
