/* Author: Tobi Vollebregt */

/*  Bataafje -- A small game written for the Allegro SpeedHack 2003
 *  Copyright (C) 2003  Tobi Vollebregt
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See `License.txt', which contains a verbatim copy of the
 *  GNU General Public License, for details.
 *
 *  Please send your reaction to: tobivollebregt@hotmail.com
 */

// merely a test of the object system

#include <allegro.h>
#include "anim.h"
#include "object.h"

class CCloud : public IObject
{
    DECLARE_CLASS (CCloud);
    NO_COPY (CCloud);

 public:

    CCloud () : anim (0) {}
    ~CCloud () { if (anim) delete anim; }

    bool Initialize (int ix)
    {
        const char* s = get_config_string ("cloud.animations", "0", 0);
        if (!s) return false;
        anim = new CAnimation (s);
        x = ix;
        y = rand () % (SCREEN_H / 4);
        speed = (rand () & 1) ? -1 : 1;
        return true;
    }

    void Draw (BITMAP* b, int dx)
    {
        ASSERT (anim);
        //set_trans_blender (0, 0, 0, 127);
        anim->Draw (b, x - dx, y);
    }

    bool Update (int ms)
    {
        anim->Update (ms);
        if ((game_time & 1) == 0)
        {
            x += speed;
            int r = rand () & 127;
            if (r == 0) speed = -speed;
            if (r == 1)
            {
                y += rand () % 11 - 5;
                if (y < 0) y = 0;
                if (y > SCREEN_H / 4) y = SCREEN_H / 4;
            }
            if ((x > SCREEN_W && speed > 0) || (x < -anim->GetWidth () && speed < 0))
                speed = -speed;
        }
        return true;
    }

 private:

    CAnimation* anim;
    int y;
    int speed;
};

IMPLEMENT_CLASS (CCloud);
