/* Author: Tobi Vollebregt */

/*  Bataafje -- A small game written for the Allegro SpeedHack 2003
 *  Copyright (C) 2003  Tobi Vollebregt
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See `License.txt', which contains a verbatim copy of the
 *  GNU General Public License, for details.
 *
 *  Please send your reaction to: tobivollebregt@hotmail.com
 */

#ifndef __tjv_ANIM_H__
#define __tjv_ANIM_H__

#include "debug.h"

#define MAX_ANIMATIONS 128

class CAnimationData
{
public:

    // read the animation from config file
    CAnimationData (const char* file);
    ~CAnimationData ();

    int GetHeight () const { return height; }
    int GetWidth () const { return width; }

private:

    struct Frame
    {
        BITMAP* bmp;
        int x, y;
        int x_flip;
        int dt;
    };

    int num_frames;
    Frame* frames;
    int width, height;

    friend class CAnimation;
};

class CAnimation
{
 public:

    CAnimation (const char* file);
    ~CAnimation ();

    // draw the current frame of the animation at (x,y) on d
    void Draw (BITMAP* d, int x, int y, bool flip=false);
    void DrawTrans (BITMAP* d, int x, int y, bool flip=false);

    // update the animation ms milliseconds
    void Update (int ms);

    int GetWidth () const { return anim->width; }
    int GetHeight () const { return anim->height; }
    BITMAP* GetBitmap (int *x, int*y) const {
        *x = anim->frames[pos].x;
        *y = anim->frames[pos].y;
        return anim->frames[pos].bmp;
    }

 public:

    // this struct is actually private but in gcc I can't declare a global
    // with a private struct
    struct Anim
    {
        char filename[128];
        CAnimationData* data;
    };

 private:

    static Anim anims[MAX_ANIMATIONS];
    static int ref_count;

    const CAnimationData* anim;
    int t, pos;
};

#endif
