//
//  **************************************************************************
//
//  widget.h 
//
//  (C) 2003 Bosco K. Ho 
//
//  **************************************************************************
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published
//  by the Free Software Foundation; either version 2.1 of the License, or (at
//  your option) any later version.
//  
//  This program is distributed in the hope that it will be useful,  but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details. 
//  
//  You should have received a copy of the GNU Lesser General Public License 
//  along with this program; if not, write to the Free Software Foundation, 
//  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//  **************************************************************************
//

#ifndef _widget_h
#define _widget_h

#include <allegro.h>
#include <string>
#include <vector>

#define WHITE         255
#define BLACK         0
#define OUTLINE_COLOR 197
#define PURPLE        5



void setMouseText(std::string newMouseText);
void drawMouse(BITMAP *buffer);



typedef enum 
{
  WGT_MOUSE_B1_DOWN, 
  WGT_MOUSE_B1_DRAG, 
	WGT_MOUSE_B1_RELEASE, 
	WGT_MOUSE_B2_DOWN, 
	WGT_MOUSE_B2_DRAG, 
	WGT_MOUSE_B2_RELEASE, 
};



///////////////////////////////////
/// a widget

class Widget 
{
public:
  Widget(int x, int y, int w, int h) :
	  _x(x), _y(y), _w(w), _h(h) {}
	~Widget() {}

	virtual int  handle (int event) { return 0; }
	virtual bool isInside (int x, int y)
	  {  return ( (x >= _x) && (x < (_x + _w)) && (y >= _y) && (y < (_y + _h))); }
	virtual void draw (BITMAP *b)  {}

	int  _x, _y, _w, _h;
};



class WidgetList
{
public:
  WidgetList(): mouseB1Index(-1), mouseB2Index(-1) {}
	~WidgetList() { clear(); }

  void clear()
	{
	  for (int i=0; i<_widgets.size(); i++) delete _widgets[i];
		_widgets.clear();
  }

  void push_back(Widget* w) { _widgets.push_back(w); }
  void draw(BITMAP *bmp);
  void handle_mouse();

  std::vector<Widget*> _widgets;
  int mouseB1Index;
  int mouseB2Index;
};



///////////////////////////////////
/// transparent button classes

typedef void CallBack (void);

class Button : public Widget
{
public:
  Button (int x, int y, int w, int h, std::string name, CallBack* proc) :
	    Widget(x, y, w, h),	_name(name), _proc(proc), _isMouseDown(false) {}
	~Button () {}

	virtual int  handle (int event);
	virtual void draw (BITMAP *b);
public:
	CallBack*   _proc;
	std::string _name;
  bool        _isMouseDown;
};




class ToggleButton : public Button 
{
public:
  ToggleButton (int x, int y, int w, int h, bool* flagPtr, std::string name, CallBack* proc) :
	  Button(x, y, w, h, name, proc), _flagPtr(flagPtr) {}
	~ToggleButton () {}
	virtual int  handle (int event);
	virtual void draw (BITMAP *b);
public:
	bool*       _flagPtr;
};



class StateSelector : public Button
{
public:
  StateSelector (int x, int y, int w, int h, int* valPtr, int val, std::string name, CallBack* proc) :
	  Button (x, y, w, h, name, proc), _val(val), _valPtr(valPtr) {}
	int  handle (int event);
	void draw (BITMAP *b);
private:
  int* _valPtr;
  int  _val;
};


#endif
