//
//  **************************************************************************
//
//  protdisp.h 
//
//  (C) Mar 15, 2004 Bosco K. Ho
//
//  **************************************************************************
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published
//  by the Free Software Foundation; either version 2.1 of the License, or (at
//  your option) any later version.
//  
//  This program is distributed in the hope that it will be useful,  but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details. 
//  
//  You should have received a copy of the GNU Lesser General Public License 
//  along with this program; if not, write to the Free Software Foundation, 
//  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//  **************************************************************************
//

#ifndef _protdisp_h
#define _protdisp_h

#include <math.h>
#include <string>
#include <vector>
#include <list>
#include <fstream>

#include <allegro.h>
#include "protein.h"
#include "vector3d.h"
#include "graphic3d.h"

#define WHITE         255
#define LIGHT_GREY    248
#define GREY          210
#define DARK_GREY     201
#define BLACK         0
#define RED           1
#define BLUE          2
#define YELLOW        3
#define GREEN         4
#define DARK_GREEN    6
#define LIGHT_BLUE    7
#define ORANGE        8
#define LIGHT_ORANGE  9

// dimensions for ball and stick show
static double   DISPLAY_ATOM_RADIUS = 0.20;
static double   DISPLAY_LINE_WIDTH  = 0.06;

// this class is a wrapper for a protein and contains
// extra display information for a protein to pump
// to a GraphicsView object
class ProteinDisplay : public Protein
{
public:
  bool     isSolid;
  bool     isHydrogen;
  bool     isSidechain;

  // indicates which residue/atom is under the mouse
  int      highlight_res;
  int      highlight_atom;
  int      highlight_z;

  void rebuild(void);

  void draw_line(int i, int a, int j, int b, int color);
  void draw_bond(int i, int a, int j, int b);
  void draw_atom(int res, int atom);
  void draw_highlight_atom(int res, int atom, int color, int highlight_size);
  void draw_peptide_plane(int i);
  void draw_distance_measure(int i, int a, int j, int b);
  void draw_residue(int i);

  void setGraphicsView(GraphicsView* g) { graphicsView = g; };

  GraphicsView* graphicsView;
};

#endif

