
//
//  ****************************************************************************
//
//  control.h
//
//  (C) Thu Mar 29 2004 Bosco K. Ho 
//
//  ****************************************************************************
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published
//  by the Free Software Foundation; either version 2.1 of the License, or (at
//  your option) any later version.
//  
//  This program is distributed in the hope that it will be useful,  but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details. 
//  
//  You should have received a copy of the GNU Lesser General Public License 
//  along with this program; if not, write to the Free Software Foundation, 
//  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//  ****************************************************************************
//

#ifndef _control_h_
#define _control_h_

#include "display.h"


void normalise(double& out);



class RamaBox : public Widget
{
  public:
    RamaBox(DisplayBox* box, int x, int y, int w, int h)
	  : Widget(x, y, w, h), _box(box) {};
	  int handle(int event);
	  void draw(BITMAP *b);
  private:
    DisplayBox* _box;
};



class ChiBox : public Widget
{
  public:
    ChiBox(DisplayBox* box, int x, int y, int w, int h)
	    : Widget(x, y, w, h), _box(box)  {}
  	int handle(int event);
	  void draw(BITMAP *b);
  	virtual bool isInside(int x, int y);
	  int active_chi;
  private:
    DisplayBox* _box;
};



class SequenceBox : public Widget
{
  public:
    SequenceBox(DisplayBox* box, int x, int y, int w, int h)
  	  : Widget(x, y, w, h), _box(box), _mutate_flag(false) {}

    bool isInside(int x, int y);
		int handle(int event);
		void draw(BITMAP *b);
    int convertedSeqNo(int x);
    void checkBounds();

  protected:
    int         _anchor_res;
		int         _mutate_res;
		int         _mutate_flag;
    DisplayBox* _box;
};



/// Sequence focus showState
class SeqFocusBox : public SequenceBox
{
  public:
    SeqFocusBox(DisplayBox* box, int x, int y, int w, int h)
      : SequenceBox(box, x, y, w, h)  {}
    int handle(int event);
    void draw(BITMAP *b);
};



/// Scroll - Bar
class ScrollBar : public Widget
{
  public:
    ScrollBar(DisplayBox* box, int x, int y, int w, int h)
	  : Widget(x, y, w, h), _box(box) {}
	  int handle(int event);
	  void draw(BITMAP *b);
    bool isInside(int x, int y);
  private:
    int         _centreResidueOffset;
    DisplayBox* _box;
};

#endif

