//
//  ****************************************************************************
//
//  bond.h
//
//  (C) Thu Mar 25 2004 Bosco K. Ho 
//
//  ****************************************************************************
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published
//  by the Free Software Foundation; either version 2.1 of the License, or (at
//  your option) any later version.
//  
//  This program is distributed in the hope that it will be useful,  but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details. 
//  
//  You should have received a copy of the GNU Lesser General Public License 
//  along with this program; if not, write to the Free Software Foundation, 
//  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//  ****************************************************************************
//
//

#ifndef _bond_h
#define _bond_h

#include <list>
#include "protein.h"



class HbondStruct
{
  public:
    HbondStruct(int i, int c, int o, int j, int n, int h) :
      _i(i), _c(c), _o(o), _j(j), _n(n), _h(h) {}
    int _i, _c, _o, _j, _n, _h;
};



class HbondList
{
  public:
    void checkHbond(Protein* protein, int i, int c, int o, int j, int n, int h);
    void countHbondDonors(Protein* protein, int res1No, int c, int o, int res2No);
    void countHbondsBetweenResidues(Protein* protein, int res1No, int res2No);
    void countBackboneHbondsBetweenResidues(Protein* protein, int res1No, int res2No);
    void countHbondsWithinRes(Protein* protein, int i);
    void clear(void) { list.clear(); };
    std::deque<HbondStruct> list;
};



class WeakHbondList
{
  public:
    void checkWeakHbond(Protein* protein, int i, int c, int o, int j, int n, int h);
    void countHbondDonors(Protein* protein, int res1No, int c, int o, int res2No);
    void countHbondsBetweenResidues(Protein* protein, int res1No, int res2No);
    void countBackboneHbondsBetweenResidues(Protein* protein, int res1No, int res2No);
    void clear(void) { list.clear(); };
    std::deque<HbondStruct> list;
};



class DisulfideBondList
{
  public:
    void countBondsBetweenResidues(Protein* protein, int i, int j);
    void clear(void) { list.clear(); };
    std::deque<HbondStruct> list;
};


#endif
