//
//  ***************************************************************************
//
//  atoms.h
//
//  (C) 2003 Bosco K. Ho 
//  Adapted from The Biomolecule Toolkit (C) 2001, Eric Alm 
//
//  ***************************************************************************
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published
//  by the Free Software Foundation; either version 2.1 of the License, or (at
//  your option) any later version.
//  
//  This program is distributed in the hope that it will be useful,  but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details. 
//  
//  You should have received a copy of the GNU Lesser General Public License 
//  along with this program; if not, write to the Free Software Foundation, 
//  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//  ****************************************************************************
//


#ifndef _atoms_h
#define _atoms_h

#include <string>
#include <iostream>
#include <list>
#include <deque>
#include <vector>
#include "vector3d.h"


const double WATER_RADIUS     =  1.4;
const double defaultOccupancy =  1.0;
const double defaultBFactor   = -1.0;


/// Atom is a public data storage container
class Atom 
{
	public:
		Atom(): pos(), isOn(false), atomName(""),
		      atomKey(0), resName("XXX"), resNo(0), resKey(0) {}
  
    Vector3d       pos;       // coordinates

	  bool           isOn;

    char           chainId;
    int            atomNo;       
    int            resNo;     // residue number in the sequence 
    char           altLocNo; 

  	std::string    atomName;  // name of atom type
    int            atomKey;   // atom type

    int            resKey;    // amino acid type
    std::string    resName;   // name of amino acid 

    char           insertCode;
		double         occup;
    double         bFactor;
};


std::ostream& operator << (std::ostream& os, const Atom& a);

static Atom nullAtom;

typedef std::list<Atom>        AtomList;
typedef AtomList::size_type    AtomSizeType;
typedef AtomList::iterator     AtomIter;
typedef std::vector<AtomIter>  AtomIterList;

void applyMatrix(AtomIter begin, AtomIter end, Matrix3d transMatrix);

std::ostream& operator << (std::ostream& os, const Atom& a);



#endif
