/*

  * New in v2.4
  - Generally optimized the code.
  - Added tokens to your ships that get awarded as you race.
  - Removed some references to Ants that somehow still existed.
  - Tweaked the AI's steering numbers.

  * New in v2.3
  - Grouped up the parts in The Shop.
  - Now AI racers shoot at the fastest target, and not always at you.
  - Updated the charge and weapon status HUD.
  - Slowed the firing rate of all weapons by a factor of 4.
  - Now all the time trial nodes have the same distance between them, so you can use the time trials more
    reliably.
  - Now your charge's state won't depend on the last race's charge state.
  - Now you can target other ships more reliably.

  * New in v2.2
  - Changed days for the loan to 25.
  - Made a new menu screen with a wider bottom window.
  - Increased the number of available races and parts.

  * New in v2.1
  - Now you can take out a $1000 loan for 20 days when you are debt free.
  - A red box shows over your ship when you have a lock on you.
  - Changed the indicators to circles instead of lines.
  - Added structure to the race listings.

  * New in v2.0
  - Speeds and distances have been adjusted so there is a 1:1 X to Y ratio.
  - Completely changed the weapons system.
  - Added two time trial races, including a drone and the ability to race your owned ships.
  - Fixed a crashing bug that occurred when AI ships floated toward the last node.
  - Tweaked the code for efficiency.

  * Everything working according to plan.
  * Make a time trial with a drone to attack?
    - No, these are time trials, a drone will not affect your time.
	- Yes, they only really serve as a practice mode, and there is currently no weapons practice.

   * Mysterious crash at Last line: "Updating a ship_obj..." *FIXED: Anticipating a node after the final one*
    - Found a bmp_obj
	- Drawing that bmp_obj
	- Updating an object.
	- Updating a ship_obj
	- CRASH TO WINDOWS
   * Weapons do not always home correctly. Sometimes they home fine, others they just go in circles.
   * Weapons are horribly priced.

   = Had a mysterious crash just when a race started... seemed very rare.

	- Problem with allowed devices... just doesn't work right. *FIXED*

	- Make sure the prices are fine with the weapons (reduced damage) and reactors
	  (the charging might be too important)

  LightSpeed v1.73

  *Changes from v1.72 to v1.73
  -AI racers should anticipate the next node better.

  *Changes from v1.7 to v1.72
  -Added a node distance indicator to the GUI.
  -Reduced the debt from 3000 to 2500.
  -Tweaked the menu help messages.

  *Changes from v1.63 to v1.7
  -Tweaked the AI's Afterburners just a bit.
  -Increased the maximum number of races for a championship.
  -Now the 'pick slot' menu is in color and shows each slot's credits.
  -Fixed an armour related bug that may have caused crashes and ship purchasing problems.
  -Now a sound plays when you select different ships in the 'Buy Ship' menu.
  -The ship icons are now better centered on the menus.

  *Changes from v1.62 to v1.63
  -Now ship specific races actually have the specific ship.
  -Tweaked the Afterburner's properties to make them more viable at all levels.

  *Changes from v1.6 to v1.62
  -Hopefully fixed a strange E-Charge mass bug.
  -Made the first few races increment by 1 instead of 0.5
  -Now 0 difficulty races are actually 0 difficulty.
  -Made the amount of difficulty variance rely on difficulty.

  *Changes from v1.47 to v1.6 (NOT RELEASED - HERE)
  -Added championship racing!
  -Added a debt system.
  -Tweaked the economy.
  -Ships now line up at the start better.
  -Reduced weapon allowed races.

  *Changes from v1.46 to v1.47
  -Added support for multiple game files.

  *Changes from v1.45 to v1.46 (RELEASED)
  -Now parts swap if possible in the Manage menu.
  -Fixed crashes in the Manage menu that may have happend.

  *Changes from v1.44 to v1.45 (NOT - RELEASED)
  -Fixed intermediate engine sound problem.

  *Changes from v1.43 to v1.44
  -Made your selection in the ship shop green.

  *Changes from v1.4 to v1.43
  -Made afterburners yellow in flight.
  -Tweaked the properties of M-Charges
  -Saves game every start of every race.
  -Reduced the number of ships for sale.
  -Increased the number of races available.
  -Tweaked the minimum mass of races.
  -Removed the mouse icon when you have no weapons during race.

  *Changes from v1.22 to v1.4
  -Many many many changes.
  -Fixed a handful of bugs.
  -Made a few minor gameplay changes
  -Shortened easy tracks.
  -Made starting ship better.
  -Fixed the incorect allowed stuff.

  *Changes from v1.15 to v1.22
  -Added a detail level control.
  -Fixed some AI popping up in the time trials.
  -Added some background objects.
  -Made lower-end races more profitable.

  Fucking mad annoying crashing problems.

  Crashing problems go away if either you make less than 8 nodes, make no engine particles, or don't draw
  anything. Heh. Fuck fuck fuck.

  Bugs fixed. Yay yay yay.

  -Had a mysterious crash when the engine sounds were playing.
    -Had more than 3 AI ships.
	-I lost the race. *FIXED* Weapon problem

  What to do:
  -Buy trash or something to add mass (DONE)
  -Saving and loading (DONE)
  -Weapons and armour (DONE)
  -Lower the starting lights so they don't interfere with radar. (RAISED THEM, DONE)
  -Make ship specific races to make buying more ships more profitable.
	-Or make ship specific properties?
	-Make 'special' races appear when you have a specific type of ship selected that gives extra money.
  -Smooth out economy
  -Sounds (STARTED)
   -Need better engine sound. (DONE)
   -Lower volume of other sounds?

 */

#include "allegro.h"
#include "winalleg.h"
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <fstream>
#include <iostream>
#include <time.h>
#include <string>
#include "ls.h"
using namespace std; // So we can use strings correctly.

bool GamePlaying = true;

bool racing = true, locked_player = false;

bool NewShop = true, NewRace = true, NewShips = true;

double c_tick=0;

string game_file;

int ticks=0, minutes=0, seconds=0, detail_lvl=4;

DATAFILE *data;

ifstream i_game_file;
ofstream o_game_file;

int int_df[10];

int Screen_X=0, Screen_Y=0;

int RedFade[255], BlueFade[255], GreenFade[255], WhiteFade[255], YellowFade[255];

BITMAP *bmp_ship[9];

BITMAP *spacething[3];

BITMAP *buffer, *title, *menu, *end_1, *end_2, *end_3, *end_comp, *end_out;

BITMAP *hull_bar, *energy_bar, *speed_bar;

SAMPLE *SND_engine, *SND_blip, *SND_hit, *SND_fire, *SND_charge, *SND_beep, *SND_move, *SND_select, *SND_buy;
SAMPLE *SND_fp, *SND_sp, *SND_tp, *SND_out, *SND_comp, *SND_click;

bool __inline play_sound(SAMPLE *the_sound, double X, double Y, int rate=1000);

void init_stars();
void create_random_track(int p_nodes,int angle_variation,int node_dist,bool dist_var = true);
void reset_player();
void create_ai_ships(int amount, double difficulty, double dif_variance, bool &charges, bool &ab, bool &weap, int ship_type, bool all_ships = false);
void race_game();

class Ship;
class Particle;
class Object;
class Component;

double credits=0, debt=0;

int debt_days=0, times_done=-1, race_num=0, point_holder[10];

Object *player_obj;

//ofstream df;

int int_math[20], position=1;
double double_math[21];

Particle *stars[40];

Object *path_node[25];
int max_nodes=0, max_ai=0;
double max_purse=0;

int __inline TurnWay(double a, double b)
{
	if( (a-b) >= 0 && (a-b) <= 180 || (a-b) < -180 ) return 1;
	else return -1;
}

double __inline ang_dist(double a, double b)
{
	b = fabs(b-a);
	a = 360-b;

	if(a>b)return b;
	else return a;
}

double __inline PointAtValue(double X1, double Y1, double X2, double Y2)
{
	return (((atan2( X1-X2, Y1-Y2 ))-3.1415926536)*57.2957795786) + 360;
}

double __inline MoveToValue(double ang, bool IsY)
{                            
	if(IsY) return (sin(((270-ang) * 0.0174520069808)));

	return (cos(((270-ang) * 0.0174520069808)));
}

class Object
{
public:
	Object *next_obj;
	Object *prev_obj;

	Ship *ship_obj;
	Particle *part_obj;

	double X, Y, Z;
	double W, H, mass;

	double speed_X, speed_Y, speed;

	double angle, dest_angle;

	BITMAP *bmp_obj;

	Object(int p_EFL = false);

	Remove();

	void Update();

	bool Draw_Obj();
};

class Component
{
public:
	string name;

	double engine_force;
	double engine_usage;
	double engine_mass;

	double ab_force;
	double ab_usage;
	double ab_mass;

	double charge_force;
	double charge_usage;
	int charge_wait;
	int charge_tick;
	double charge_mass;
	int charge_count;
	int charge_max;

	double enrgy_mtr_rate;
	double enrgy_max;
	double enrgy_mtr_mass;

	double turner_force;
	double turner_mass;

	double armour_protection;
	double armour_mass;

	double antimatter_mass;

	double trash_mass;

	int w_accuracy;
	int w_distortion;
	int w_damage;
	int w_shot_wait;
	int w_shot_tick;
	double w_usage;
	double w_mass;

	SAMPLE *snd_w_fire;
	SAMPLE *snd_w_miss;
	SAMPLE *snd_w_hit;

	double price;

	Component() : engine_force(0), ab_force(0), charge_force(0), charge_count(0), enrgy_max(0), turner_force(0),
		armour_protection(0), antimatter_mass(0), name(""), engine_usage(0), engine_mass(0), ab_usage(0),
		ab_mass(0), charge_wait(120), enrgy_mtr_rate(0), enrgy_mtr_mass(0), armour_mass(0), w_accuracy(0), 
		w_distortion(0), w_damage(0), w_shot_wait(0), w_mass(0), price(0), turner_mass(0),
		charge_mass(0), charge_usage(0), trash_mass(0), w_shot_tick(0), w_usage(0) { }

	int Type()
	{
		if( engine_force>0 ) return 0;
		else if( ab_force>0 ) return 1;
		else if( antimatter_mass>0 ) return 2;
		else if( armour_protection>0 ) return 3;
		else if( charge_force>0 ) return 4;
		else if( enrgy_max>0 ) return 5;
		else if( turner_force>0 ) return 6;
		else if( w_mass>0 ) return 7;
		else if( trash_mass>0 ) return 8;

		return -1;
	}

	bool Apply(Ship *to_ship, bool taking_off = false, int part_num=-1);

	void Clear()
	{
		engine_force=0;	ab_force=0;	charge_force=0; charge_count=0; enrgy_max=0; turner_force=0;
		armour_protection=0; antimatter_mass=0; name=""; engine_usage=0; engine_mass=0; ab_usage=0;
		ab_mass=0; charge_wait=120; enrgy_mtr_rate=0; enrgy_mtr_mass=0; armour_mass=0; w_accuracy=0; 
		w_distortion=0; w_damage=0; w_shot_wait=0; w_mass=0; price=0; turner_mass=0;
		charge_mass=0; charge_usage=0; trash_mass=0; w_shot_tick=0; w_usage=0;
	}

	double Calculate_Cost(double depreciation = 1)
	{
		double_math[0] = engine_mass + (ab_mass*1.2) + (enrgy_mtr_mass*0.75) + turner_mass + armour_mass + (w_mass*.6);
		double_math[1] = (engine_usage*6)+(ab_usage*4.0)+(w_shot_wait*0.3)+(w_usage*0.15);
		double_math[2] = (engine_force*2700)+(w_accuracy*15);
		double_math[2]+= (charge_count*11)+(antimatter_mass*125)+(trash_mass*2.5)+(w_damage*67)+(w_distortion*77);

		if( enrgy_max>0 ) double_math[2]+=((enrgy_max-200)*8)+((enrgy_mtr_rate-0.075)*5800);
		else if( ab_force>0 ) double_math[2]+=((ab_force-0.6)*2400);
		else if( turner_force>0 ) double_math[2]+=((turner_force-10)*60);
		else if( armour_protection>0 ) double_math[2]+=((armour_protection-0.3)*7000);

		if(charge_force>0)
		{
			if(charge_max>0)
			{
				double_math[2]+=charge_force*5;
				double_math[0]+=charge_mass*1.2;
			}
			else
			{
				double_math[2]+=(charge_force-10)*97;
				double_math[1]+=charge_usage*0.175;
				double_math[0]+=charge_mass*0.75;
			}
		}
		
		price = (double_math[2]/(double_math[1]+double_math[0]+1))*depreciation;

		return price;
	}

	void Make_Random_Component(int type = -1)
	{
		Clear();

		int_math[0] = type;
		if(type==-1) int_math[0] = rand()%10;

		//int_math[0] = 8;

		switch( int_math[0] )
		{
		case 0:
			engine_force = (((rand()%80+1)*0.25)*0.1)+0.4;
			engine_mass = (rand()%8*0.25)+6.5;
			engine_usage = (rand()%16*0.0075)+0.04;
			name = "Engine";
			break;
		case 1:
			enrgy_max = (rand()%38*5)+215;
			enrgy_mtr_rate = (rand()%19*0.025)+0.1;
			enrgy_mtr_mass = (rand()%8*0.25)+4;
			name = "Reactor";
			break;
		case 2:
			turner_force = (rand()%40*2)+25;
			turner_mass = (rand()%8*0.25)+4;
			name = "Turner";
			break;
		case 3:
			ab_force = (rand()%40*0.1)+0.7;
			ab_mass = (rand()%8*0.25)+3;
			ab_usage = (rand()%40*0.03)+0.11;
			name = "AfterBurner";
			break;
		case 4:
			charge_usage = 0;
			charge_max = rand()%10+5;
			charge_count = charge_max;
			charge_mass = (rand()%8*0.125)+0.2;
			charge_force = (rand()%40*6.5)+25;
			name = "M-Charge";
			break;
		case 5:
			charge_count = 0;
			charge_max = 0;
			charge_mass = (rand()%8*0.25)+4;
			charge_force = (rand()%40*6)+20;
			charge_usage = (rand()%80*2+60);
			name = "E-Charge";
			break;
		case 6:
			antimatter_mass = (rand()%20*0.35)+3;
			name = "Anti-Matter";
			break;
		case 7:
			trash_mass = (rand()%16*0.25)+2;
			name = "Trash";
			break;
		case 8:
			armour_mass = (rand()%8*0.25)+4;
			armour_protection = (rand()%50*0.01)+0.4;
			name = "Armour";
			break;
		case 9:
			w_accuracy = (rand()%80)+10;
			w_damage = (rand()%20)+3;
			w_distortion = (rand()%90)+30;
			w_mass = (rand()%8*0.25)+1;
			w_shot_wait = (rand()%50)+5;
			w_usage = (rand()%50)+15;
			name = "Weapon";
			break;
		}

		Calculate_Cost((rand()%10*0.01)+0.93);
	}
};

class Race
{
public:
	int ai_amt;
	double dif;
	double dif_var;
	int length;
	int nodes;
	double curviness;
	double purse;

	double min_weight;
	double max_weight;

	bool ab_allowed;
	bool ch_allowed;
	bool w_allowed;

	int ship_type;

	int num_of_races;

	void Clear()
	{
		ai_amt=0;
		dif=0;
		dif_var=0;
		length=0;
		nodes=0;
		curviness=0;
		purse=0;
		min_weight = 0;
		max_weight = 0;
		ab_allowed=false;
		ch_allowed=false;
		w_allowed=false;
		ship_type=-1;
		num_of_races=0;
	}

	void Make_Random_Race(double p_dif=-1, int p_ship_type=-1)
	{
		Clear();

		if(p_dif==-1||p_dif>0)
		{
			if(rand()%2==0)ab_allowed=true;
			else ab_allowed=false;
			if(rand()%2==0)ch_allowed=true;
			else ch_allowed=false;
			if(rand()%2==0)w_allowed=true;
			else w_allowed=false;
		}

		ai_amt=rand()%5+1;
		if(p_dif==-1) dif=(rand()%51*.5);
		else dif=p_dif;

		int_math[4] = (dif*2)+3;

		dif_var=6;
		length=rand()%1000+500;
		nodes=(rand()%int_math[4])+3;
		if(nodes>20)nodes=20;
		curviness=rand()%360;
		purse=((((dif*(10+(ai_amt*0.3)))+(nodes*2))*((w_allowed*.2)+1))*0.6)+20;

		if(p_ship_type==-1)ship_type=-1;
		else
		{
			ship_type = p_ship_type;
			purse*=1.50;
		}

		min_weight = rand()%15+10;
	}
};

Component shop_inv[20];
Race race[30];

Object F_Obj(true);
Object L_Obj(true);

Object::Object(int p_EFL) : X(0), Y(0), W(0), H(0), speed_X(0), speed_Y(0),
	mass(1), angle(0), ship_obj(NULL), part_obj(NULL), Z(1), speed(0)
{
	if( !p_EFL )
	{
		//df << "Object made an object." << endl;

		L_Obj.prev_obj->next_obj = this;
		prev_obj = L_Obj.prev_obj;
		L_Obj.prev_obj = this;
		next_obj = &L_Obj;
	}
	else if( p_EFL == 2 ) // Add it in the first position.
	{
		next_obj = F_Obj.next_obj;
		prev_obj = &F_Obj;
		F_Obj.next_obj->prev_obj = this;
		F_Obj.next_obj = this;
	}

	bmp_obj = NULL;
}

Object::Remove()
{
	next_obj->prev_obj = prev_obj;
	prev_obj->next_obj = next_obj;
}

class Particle
{
public:
	Object *parent_obj;

	Object *target;
	Ship *owner;

	int cur_color;
	int color_type;

	int radius;

	bool stay_on_screen;

	int life_tick, max_life;

	Particle(int p_life, int p_color) : radius(0), life_tick(p_life), owner(NULL),
		max_life(p_life), stay_on_screen(false), color_type(p_color), target(NULL)
	{
		switch( p_color )
		{
		case 0:
			cur_color = RedFade[254];
			break;
		case 1:
			cur_color = BlueFade[254];
			break;
		case 2:
			cur_color = GreenFade[254];
			break;
		case 3:
			cur_color = YellowFade[254];
			break;
		case 4:
			cur_color = WhiteFade[254];
			break;
		}

		Object *np = new Object();
		np->part_obj = this;
		parent_obj = np;
	}
};

bool eng_playing = false;

class Ship
{
public:
	Object *parent_obj;

	bool use_ab;

	Object *targetting;

	Component part[9];
	Component temp;

	double total_price;

	int type;

	int stars;

	double engine_force;
	double engine_usage;
	double engine_mass;

	double ab_force;
	double ab_usage;
	double ab_mass;

	double charge_force;
	double charge_usage;
	int charge_wait;
	int charge_tick;
	double charge_mass;
	int charge_count;
	int charge_max;

	double enrgy_mtr_rate;
	double enrgy_max;
	double enrgy_mtr_mass;

	double turner_force;
	double turner_mass;

	double armour_protection;
	double armour_mass;

	double antimatter_mass;

	double trash_mass;

	int w_accuracy;
	int w_distortion;
	int w_damage;
	int w_shot_wait;
	double w_shot_tick;
	double w_usage;
	double w_mass;

	SAMPLE *snd_w_fire;
	SAMPLE *snd_w_miss;
	SAMPLE *snd_w_hit;

	double total_mass;

	double energy;
	double hull;

	int cur_node;

	int points, position;

	bool made_adj;

	BITMAP *bmp_ship_obj;

	Ship();

	void __inline CalculateMass()
	{
		total_mass = w_mass + armour_mass + parent_obj->mass + engine_mass + ab_mass + (charge_count*charge_mass) + enrgy_mtr_mass + turner_mass + trash_mass - antimatter_mass;
		if(charge_count==0) total_mass+=charge_mass;
		if(total_mass<0.1)total_mass=0.1;
	}

	void Turn(bool p_left)
	{
		if( !p_left )
		{
			parent_obj->angle-=turner_force/total_mass;
			if(parent_obj->angle<0) { parent_obj->angle+=360; }
		}
		else
		{
			parent_obj->angle+=turner_force/total_mass;
			if(parent_obj->angle>360) { parent_obj->angle-=360; }
		}
	}

	void Accelerate(double p_force, double p_angle, bool relative = false, bool ShowParticles = true, int part_clr=0)
	{
		p_force*=(hull/100);

		if( relative )
		{
			double_math[0]=parent_obj->angle;
			double_math[0]+=p_angle;
			if(double_math[0]>360)double_math[0]-=360;
			else if(double_math[0]<0)double_math[0]+=360;
		}
		else
		{
			double_math[0]=p_angle;
		}

		if( ShowParticles && ((detail_lvl>1)|(rand()%2==0)) )
		{
			if( parent_obj->X-Screen_X >= 0 && parent_obj->Y-Screen_Y >= 0 && parent_obj->X-Screen_X <= 640 && parent_obj->Y-Screen_Y <= 640 )
			{
				//df << "Making a particle..." << endl;

				Particle *fluff = new Particle(15,part_clr);

				int_math[0] = (rand()%10-5);
				double_math[1] = parent_obj->angle-180;
				double_math[2] = parent_obj->angle-90;
				fluff->parent_obj->X = (parent_obj->X-(MoveToValue(double_math[1],false)*(parent_obj->bmp_obj->h*.45)))-(MoveToValue(double_math[2],false)*int_math[0]);
				fluff->parent_obj->Y = (parent_obj->Y-(MoveToValue(double_math[1],true)*(parent_obj->bmp_obj->h*.45)))-(MoveToValue(double_math[2],true)*int_math[0]);
				fluff->parent_obj->speed_X = parent_obj->speed_X + MoveToValue(double_math[0]-180,false)*(p_force*.9);
				fluff->parent_obj->speed_Y = parent_obj->speed_Y + MoveToValue(double_math[0]-180,true)*(p_force*.9);
			}
		}

		double_math[1] = (parent_obj->speed+1)*.95;          // Your Speed.
		double_math[2] = PointAtValue(0,0,parent_obj->speed_X,parent_obj->speed_Y);      // Where you're floating.
		double_math[3] = ((120-ang_dist(double_math[0],double_math[2])))*1.5;// Difference of floating vs. accelerating angle.
		if(double_math[3]<0)double_math[3]=0;
		double_math[4] = (1-(double_math[3]+1)*0.005524862)*(1-(1/((double_math[1]*1.5)+1))); // How to affect speed.
		// FUCKIN PHEW!!!
		p_force-=(p_force*double_math[4]);

		if(double_math[1]<19)
		{
			parent_obj->speed_X += (MoveToValue(double_math[0],false)*p_force)/total_mass;
			parent_obj->speed_Y += (MoveToValue(double_math[0],true)*p_force)/total_mass;
		}
		else
		{
			parent_obj->speed_X*=.995;
			parent_obj->speed_Y*=.995;
		}

		if( this == player_obj->ship_obj )
		{
			if(!eng_playing) { play_sample(SND_engine,255,128,800*((p_force*.4)+1),true); eng_playing = true; }
			else { adjust_sample(SND_engine,255,128,800*((p_force*.4)+1),true); }
		}
	}

	void UseCharge()
	{
		if( charge_tick>charge_wait && ((energy>charge_usage && charge_usage>0)|(charge_count>0)) )
		{
			play_sound(SND_charge,parent_obj->X,parent_obj->Y,950+rand()%100);

			Particle *np = new Particle(10,3);

			double_math[1] = parent_obj->angle-180;
			np->parent_obj->X = (parent_obj->X-(MoveToValue(double_math[1],false)*(parent_obj->bmp_obj->h*.48)));
			np->parent_obj->Y = (parent_obj->Y-(MoveToValue(double_math[1],true)*(parent_obj->bmp_obj->h*.48)));
			np->parent_obj->speed_X = parent_obj->speed_X;
			np->parent_obj->speed_Y = parent_obj->speed_Y;
			np->radius = 10;

			Accelerate(charge_force, 0, true, false);
			charge_tick=0;
			if(charge_usage>0) energy-=charge_usage;
			else
			{
				charge_count--;
				CalculateMass();
			}
		}

	}

	void Fire(Object *attacking = NULL)
	{
		//df << "Fire request." << endl;

		if( w_mass > 0 && cur_node>0 )
		{
			if( w_shot_tick >= w_shot_wait && energy >= w_usage )
			{
				//df << "Checking for target..." << endl;

				Object *target_made = attacking;
				double t_speed=0.0;

				if( !target_made )
				{
					//df << "No target, doing search..." << endl;

					for(Object *w_scan=F_Obj.next_obj;w_scan!=&L_Obj;w_scan=w_scan->next_obj)
					{
						if( w_scan->ship_obj )
						{
							if( w_scan->ship_obj != this )
							{
								//df << "Found a ship thats not me..." << endl;

								if( ang_dist( PointAtValue(parent_obj->X,parent_obj->Y,w_scan->X,w_scan->Y), parent_obj->angle ) < 45 && abs(w_scan->X-parent_obj->X)+abs(w_scan->Y-parent_obj->Y) < 500 )
								{
									double_math[0] = w_scan->speed;

									if( double_math[0]>t_speed )
									{
										target_made = w_scan;
										t_speed = double_math[0];
									}
								}
							}
						}
					}
					if( !target_made ) return;
				}				

				//df << "Target made found:" << target_made << endl;

				w_shot_tick = 0;

				energy-=w_usage;

				Particle *np = new Particle(110,3);

				np->parent_obj->X = parent_obj->X;
				np->parent_obj->Y = parent_obj->Y;
				np->parent_obj->speed_X = parent_obj->speed_X+MoveToValue(parent_obj->angle,false);
				np->parent_obj->speed_Y = parent_obj->speed_Y+MoveToValue(parent_obj->angle,true);
				np->owner = this;
				np->parent_obj->angle = parent_obj->angle-180;
				if( np->parent_obj->angle<0 ) np->parent_obj->angle+=360;
				np->radius = 1;
				np->target = target_made;

				play_sound(SND_fire,parent_obj->X,parent_obj->Y,950+rand()%100);

				//df << "Just made a bullet." << endl;
			}
		}
	}
};

Ship *ship_owned[9];

Ship::Ship() : engine_force(0), engine_usage(0), engine_mass(0), ab_force(0), ab_usage(0), ab_mass(0),
	charge_force(0), charge_wait(120), charge_mass(0), charge_count(0), enrgy_mtr_rate(0), enrgy_mtr_mass(0),
	use_ab(false), armour_mass(0), antimatter_mass(0), w_accuracy(0), w_damage(0), w_distortion(0), w_mass(0),
	w_shot_wait(0), charge_max(0), trash_mass(0), w_shot_tick(0), hull(100), w_usage(0), made_adj(false),
	points(0), position(0), type(0), armour_protection(0), targetting(NULL), stars(0)
{
	Object *ns = new Object();
	ns->ship_obj = this;
	parent_obj = ns;

	temp.Clear();
}

Ship *shop_ships[16];

bool Object::Draw_Obj()
{
	//df << "Starting to draw something.." << endl;
	//df << "X:" << X << "Y:" << Y << endl;
	if( bmp_obj )
	{
		//df << "Found a bmp_obj.." << endl;
		if( X-Screen_X+bmp_obj->w*0.5 >= 0 && X-Screen_X-bmp_obj->w*0.5 <= 640/Z && Y-Screen_Y+bmp_obj->h*0.5 >= 0 && Y-Screen_Y-bmp_obj->h*0.5 <= 480/Z )
		{
			//df << "Drawing that bmp_obj.." << endl;
			if( Z == 1 ) rotate_sprite(buffer,bmp_obj,(X-Screen_X)+640-(bmp_obj->w*.5),(Y-Screen_Y)-(bmp_obj->h*.5),256-itofix((angle-180)*.7111) );
			else rotate_sprite(buffer,bmp_obj,((X-Screen_X)*(Z*1.17))+640-(bmp_obj->w),((Y-Screen_Y)*(Z*1.17))-(bmp_obj->h),256-itofix((angle-180)*.7111) );			
			return true;
		}
		else { return false; }
	}
	else
	{
		//df << "No bmp_obj.." << endl;
		if( part_obj )
		{
			//df << "Found part_obj.." << endl;
			if( X-Screen_X >= 0 && X-Screen_X <= 640/Z && Y-Screen_Y >= 0 && Y-Screen_Y < 480/Z )
			{
				//df << "Drawing that part_obj.." << endl;
				//df << "Drawing at X" << X << "Y" << Y << endl;
				//df << "Placing at X" << ((X-Screen_X)*Z)+640 << "Y" << (Y-Screen_Y)*Z << endl;
				if( part_obj->radius == 0 ) { _putpixel16(buffer,((X-Screen_X)*Z)+640,(Y-Screen_Y)*Z,part_obj->cur_color); }
				else { circlefill(buffer,X-Screen_X+640,Y-Screen_Y,part_obj->radius,part_obj->cur_color); }
				return true;
			}
			else { return false; }
		}
	}

	return false;
}

bool __inline play_sound(SAMPLE *the_sound, double X, double Y, int rate)
{
	int DistanceFromPlayer = abs(X-player_obj->X)+abs(Y-player_obj->Y);

	if( DistanceFromPlayer < 400 )
	{
		play_sample(the_sound,255-(DistanceFromPlayer*0.6),128+((player_obj->X-X)*0.2),rate,0);
		return true;
	}
	else { return false; }
}

bool Component::Apply(Ship *to_ship, bool taking_off, int part_num)
{
	//df << "Applying, taking off:" << taking_off << endl;
	bool good=false;

	if((engine_force>0&&!taking_off||to_ship->engine_force>0&&taking_off)&&((part_num==-1)|(part_num==0)) )
	{
		//df << "Doing an engine..." << endl;
		if( taking_off )
		{
			engine_force = to_ship->engine_force;
			engine_usage = to_ship->engine_usage;
			engine_mass = to_ship->engine_mass;
			to_ship->engine_force = 0;
			to_ship->engine_usage = 0;
			to_ship->engine_mass = 0;
			//df << "Did the engine." << endl;
		}
		else
		{
			to_ship->engine_force = engine_force;
			to_ship->engine_usage = engine_usage;
			to_ship->engine_mass = engine_mass;
			engine_force = 0;
			engine_usage = 0;
			engine_mass = 0;
		}
		good=true;
	}
	else if((ab_force>0&&!taking_off||to_ship->ab_force>0&&taking_off)&&((part_num==-1)|(part_num==1)) )
	{
		if( taking_off )
		{
			ab_force = to_ship->ab_force;
			ab_usage = to_ship->ab_usage;
			ab_mass = to_ship->ab_mass;
			to_ship->ab_force = 0;
			to_ship->ab_usage = 0;
			to_ship->ab_mass = 0;
		}
		else
		{
			to_ship->ab_force = ab_force;
			to_ship->ab_usage = ab_usage;
			to_ship->ab_mass = ab_mass;
			ab_force = 0;
			ab_usage = 0;
			ab_mass = 0;
		}
		good=true;
	}
	else if((antimatter_mass>0&&!taking_off||to_ship->antimatter_mass>0&&taking_off)&&((part_num==-1)|(part_num==2)) )
	{
		if( taking_off )
		{
			antimatter_mass = to_ship->antimatter_mass;
			to_ship->antimatter_mass = 0;
		}
		else
		{
			to_ship->antimatter_mass = antimatter_mass;
			antimatter_mass = 0;
		}
		good=true;
	}
	else if((armour_protection>0&&!taking_off||to_ship->armour_protection>0&&taking_off)&&((part_num==-1)|(part_num==3)) )
	{
		if( taking_off )
		{
			armour_protection = to_ship->armour_protection;
			armour_mass = to_ship->armour_mass;
			to_ship->armour_protection = 0;
			to_ship->armour_mass = 0;
		}
		else
		{
			to_ship->armour_protection = armour_protection;
			to_ship->armour_mass = armour_mass;
			armour_protection = 0;
			armour_mass = 0;
		}
		good=true;
	}
	else if((charge_force>0&&!taking_off||to_ship->charge_force>0&&taking_off)&&((part_num==-1)|(part_num==4)) )
	{
		if( taking_off )
		{
			charge_force = to_ship->charge_force;
			charge_usage = to_ship->charge_usage;
			charge_mass = to_ship->charge_mass;
			charge_max = to_ship->charge_max;
			charge_wait = to_ship->charge_wait;
			charge_count = to_ship->charge_max;
			to_ship->charge_force = 0;
			to_ship->charge_usage = 0;
			to_ship->charge_wait = 0;
			to_ship->charge_count = 0;
			to_ship->charge_max = 0;
			to_ship->charge_mass = 0;
		}
		else
		{
			to_ship->charge_force = charge_force;
			to_ship->charge_usage = charge_usage;
			to_ship->charge_mass = charge_mass;
			to_ship->charge_count = charge_max;
			to_ship->charge_max = charge_max;
			to_ship->charge_wait = charge_wait;
			charge_force = 0;
			charge_usage = 0;
			charge_mass = 0;
			charge_wait = 0;
			charge_max = 0;
			charge_count = 0;
		}
		good=true;
	}
	else if((enrgy_max>0&&!taking_off||to_ship->enrgy_max>0&&taking_off)&&((part_num==-1)|(part_num==5)) )
	{
		if( taking_off )
		{
			enrgy_max = to_ship->enrgy_max;
			enrgy_mtr_mass = to_ship->enrgy_mtr_mass;
			enrgy_mtr_rate = to_ship->enrgy_mtr_rate;
			to_ship->enrgy_max = 0;
			to_ship->enrgy_mtr_mass = 0;
			to_ship->enrgy_mtr_rate = 0;
		}
		else
		{
			to_ship->enrgy_max = enrgy_max;
			to_ship->enrgy_mtr_mass = enrgy_mtr_mass;
			to_ship->enrgy_mtr_rate = enrgy_mtr_rate;
			enrgy_max = 0;
			enrgy_mtr_mass = 0;
			enrgy_mtr_rate = 0;
		}
		good=true;
	}
	else if((turner_force>0&&!taking_off||to_ship->turner_force>0&&taking_off)&&((part_num==-1)|(part_num==6)) )
	{
		if( taking_off )
		{
			turner_force = to_ship->turner_force;
			turner_mass = to_ship->turner_mass;
			to_ship->turner_force = 0;
			to_ship->turner_mass = 0;
		}
		else
		{
			to_ship->turner_force = turner_force;
			to_ship->turner_mass = turner_mass;
			turner_force = 0;
			turner_mass = 0;
		}
		good=true;
	}
	else if((w_mass>0&&!taking_off||to_ship->w_mass>0&&taking_off)&&((part_num==-1)|(part_num==7)) )
	{
		if( taking_off )
		{
			w_accuracy = to_ship->w_accuracy;
			w_damage = to_ship->w_damage;
			w_distortion = to_ship->w_distortion;
			w_mass = to_ship->w_mass;
			w_shot_wait = to_ship->w_shot_wait;
			w_usage = to_ship->w_usage;
			to_ship->w_accuracy = 0;
			to_ship->w_damage = 0;
			to_ship->w_distortion = 0;
			to_ship->w_mass = 0;
			to_ship->w_shot_wait = 0;
			to_ship->w_usage = 0;
		}
		else
		{
			to_ship->w_accuracy = w_accuracy;
			to_ship->w_damage = w_damage;
			to_ship->w_distortion = w_distortion;
			to_ship->w_mass = w_mass;
			to_ship->w_shot_wait = w_shot_wait;
			to_ship->w_usage = w_usage;
			w_accuracy = 0;
			w_damage = 0;
			w_distortion = 0;
			w_mass = 0;
			w_usage = 0;
			w_shot_wait = 0;
		}
		good=true;
	}
	else if((trash_mass>0&&!taking_off||to_ship->trash_mass>0&&taking_off)&&((part_num==-1)|(part_num==8)) )
	{
		if( taking_off )
		{
			trash_mass = to_ship->trash_mass;
			to_ship->trash_mass = 0;
		}
		else
		{
			to_ship->trash_mass = trash_mass;
			trash_mass = 0;
		}
		good=true;
	}

	Calculate_Cost();

	return good;
}

Object *scan;

void reset_lists();

void FreeMemory()
{
	for(scan=F_Obj.next_obj;F_Obj.next_obj!=&L_Obj;scan=F_Obj.next_obj)
	{
		//df << "Removing an object at X" << scan->X << "Y" << scan->Y << endl;
		scan->Remove();
	}

	//df << "Done destroying objects, now deleting the scan object..." << endl;

	reset_lists();
}

void save_game();

void Quit()
{
	//df << "Freeing memory..." << endl;

	save_game();

	FreeMemory();

	//df << "Destroy bitmaps..." << endl;

	for(scan=F_Obj.next_obj;F_Obj.next_obj!=&L_Obj;scan=F_Obj.next_obj)
	{
		if( scan->bmp_obj ) destroy_bitmap(scan->bmp_obj);
		scan->Remove();
	}

	destroy_bitmap(buffer);
	destroy_bitmap(title);
	destroy_bitmap(menu);
	destroy_bitmap(energy_bar);
	destroy_bitmap(speed_bar);
	destroy_bitmap(hull_bar);

	//df << "Exit allegro..." << endl;

	allegro_exit();

	//df << "Done." << endl;

	exit(1);
}

void Object::Update()
{
	X-=speed_X;
	Y-=speed_Y*.75;
	speed=fabs(speed_X)+fabs(speed_Y);

	//df << "Updating an object.." << endl;
	if( part_obj )
	{
		//df << "Updating a part_obj.." << endl;

		if( part_obj->stay_on_screen )
		{
			if( X-Screen_X > 640/Z ) X-=640/Z;
			if( Y-Screen_Y > 480/Z ) Y-=480/Z;
			if( X-Screen_X < 0 ) X+=640/Z;
			if( Y-Screen_Y < 0 ) Y+=480/Z;
		}
		else if( part_obj->target ) // Homing Projectile Code
		{
			if( part_obj->target == player_obj ) locked_player = true;

			//df << "Starting a projectile." << endl;
			//p->AttackingWho->X_Pos-((p->AttackingWho->X_Speed-p->X_Speed)*(DistanceFromTarget/p->CurWeap->Speed)),
			double_math[14] = abs(X-part_obj->target->X)+abs(Y-part_obj->target->Y)*1.3333;
			double_math[15] = (speed*.8)+1;
			double_math[18] = double_math[14]/double_math[15];

			double_math[12] = part_obj->target->X-((part_obj->target->speed_X-speed_X)*(double_math[18]));
			double_math[13] = part_obj->target->Y-((part_obj->target->speed_Y-speed_Y)*(double_math[18]));

			dest_angle = PointAtValue(X,Y, double_math[12],double_math[13]);
			//angle+=TurnWay(angle,PointAtValue(X,Y,double_math[12],double_math[13]))*.05*part_obj->owner->w_accuracy;

			if( ang_dist(angle,dest_angle)>2 )
			{
				angle+=TurnWay(angle,dest_angle)*.03*part_obj->owner->w_accuracy;

				if( angle>360 ) angle-=360;
				else if( angle<0 ) angle+=360;
			}

			if( double_math[15] > part_obj->target->speed+1 ) { speed_X*=.99; speed_Y*=.99; }
			speed_X -= MoveToValue(angle,false)*0.15;
			speed_Y -= MoveToValue(angle,true)*0.15;

			//double_math[16] = abs(X-part_obj->target->X)+abs(Y-part_obj->target->Y);
			//double_math[17] = fabs(speed_X)+fabs(speed_Y);
			//double_math[19] = fabs(part_obj->target->speed_X)+fabs(part_obj->target->speed_Y);
			//double_math[18] = (double_math[16]/double_math[17])*0.3;

			//angle+=TurnWay(angle, PointAtValue(X,Y,part_obj->target->X,part_obj->target->Y)*.05*part_obj->owner->w_accuracy;

			//circle(buffer,double_math[12]-Screen_X+640,double_math[13]-Screen_Y,5,GreenFade[250]);

			//df << "Doing angle and speed update..." << endl;

			//df << "Doing detail level..." << endl;

			if( detail_lvl>2 && rand()%2==0 )
			{
				Particle *np = new Particle(20,1);

				np->parent_obj->X = X;
				np->parent_obj->Y = Y;
				np->parent_obj->speed_X = 0;
				np->parent_obj->speed_Y = 0;
			}

			//df << "doing some crap..." << endl;

			if( abs(X-part_obj->target->X)+abs(Y-part_obj->target->Y) < 17 )
			{

				//df << "taking a hit!" << endl;

				if( detail_lvl>2)
				{
					for(int i=0;i<5;i++)
					{
						Particle *np = new Particle(20,4);

						np->parent_obj->X = X;
						np->parent_obj->Y = Y;
						np->parent_obj->speed_X = part_obj->target->speed_X+(rand()%4-2);
						np->parent_obj->speed_Y = part_obj->target->speed_Y+(rand()%4-2);
					}
				}

				//df << "assinging hit stuff.." << endl;

				double_math[12] = 1 - (part_obj->owner->w_distortion*0.006);

				part_obj->target->speed_X*=double_math[12];
				part_obj->target->speed_Y*=double_math[12];
				part_obj->target->angle+=(rand()%part_obj->owner->w_distortion)-(part_obj->owner->w_distortion*.5);

				if(part_obj->target->angle>360)part_obj->target->angle-=360;
				else if(part_obj->target->angle<0)part_obj->target->angle+=360;

				//df << "almost done.." << endl;

				part_obj->target->ship_obj->hull-=(part_obj->owner->w_damage*0.75)*(1-part_obj->target->ship_obj->armour_protection);

				if(part_obj->target->ship_obj->hull<10)part_obj->target->ship_obj->hull=10;

				play_sound(SND_hit,X,Y,1050);

				part_obj->life_tick = 0;

				//df << "done with that." << endl;
			}
		}
		else
		{
			int_math[0] = 254*((double)part_obj->life_tick/part_obj->max_life);
			switch( part_obj->color_type )
			{
			case 0:
				part_obj->cur_color = RedFade[int_math[0]];
				break;
			case 1:
				part_obj->cur_color = BlueFade[int_math[0]];
				break;
			case 2:
				part_obj->cur_color = GreenFade[int_math[0]];
				break;
			case 3:
				part_obj->cur_color = YellowFade[int_math[0]];
				break;
			case 4:
				part_obj->cur_color = WhiteFade[int_math[0]];
			}
			if( part_obj->radius > 0 ) part_obj->radius--;
		}
		if( part_obj->life_tick-- == 0 ) Remove();
	}
	else if( ship_obj )
	{
		//df << "Updating a ship_obj.." << endl;

		int_math[9] = abs(X-path_node[ship_obj->cur_node+1]->X) + abs(Y-path_node[ship_obj->cur_node+1]->Y)*1.3333;

		if( this != player_obj )
		{
			//df << "Not the player ship." << endl;
			if( dest_angle != angle )
			{
				if( TurnWay(dest_angle,angle)==1 ) ship_obj->Turn(true);
				else ship_obj->Turn(false);

				if( ang_dist(angle,dest_angle) < 2 ) angle = dest_angle;
			}

			double_math[15] = PointAtValue(path_node[ship_obj->cur_node+1]->X,path_node[ship_obj->cur_node+1]->Y,X,Y);
			double_math[16] = path_node[ship_obj->cur_node+1]->X-MoveToValue(double_math[15],false)*40;
			double_math[17] = path_node[ship_obj->cur_node+1]->Y-MoveToValue(double_math[15],true)*30;
			
			//df << "Should I change my dest_angle?" << endl;
			double_math[6] = 180-ang_dist( PointAtValue(0,0,speed_X,speed_Y ), PointAtValue(X,Y,double_math[16],double_math[17]) );
			//df << "1" << endl;
			double_math[5] = abs(X-double_math[16])+abs(Y-double_math[17])*1.3333;
			//df << "2" << endl;
			double_math[0] = PointAtValue(X,Y,double_math[16],double_math[17]);
			//df << "3" << endl;
			double_math[8] = ang_dist(dest_angle,double_math[0]);
			//df << "4" << endl;
			double_math[3] = (speed*.8) + 1;
			//df << "5" << endl;
			if( double_math[6] < 8 && double_math[5] < 300 && double_math[3]>1.5 && ship_obj->cur_node<max_nodes-2 )
			{
				//df << "6" << endl;
				//df << "CurNode:" << ship_obj->cur_node << " MaxNode:" << max_nodes << endl;
				dest_angle = PointAtValue(X,Y,path_node[ship_obj->cur_node+2]->X,path_node[ship_obj->cur_node+2]->Y);
			}
			if( double_math[6] > (7+(ship_obj->made_adj*6)) )
			{
				//df << "7" << endl;
				ship_obj->made_adj = false;
				//df << "8" << endl;
				double_math[18] = double_math[5]/double_math[3];
				//df << "9" << endl;
				dest_angle = PointAtValue(X,Y,double_math[16]+((speed_X)*(double_math[18])),double_math[17]+((speed_Y)*(double_math[18])));
			}
			else
			{
				dest_angle = double_math[0];
				ship_obj->made_adj = true;
				//df << "10" << endl;
			}

			//df << "Movement code starting..." << endl;
			double_math[2] = (ship_obj->energy/ship_obj->enrgy_max);
			double_math[7] = ang_dist(dest_angle,angle);
			if( double_math[7] < 30 )
			{
				if( (double_math[7] < 10) && ship_obj->ab_force>0 )
				{
					if( !ship_obj->use_ab && double_math[2] > 0.6 ) ship_obj->use_ab = true;
					else if( ship_obj->use_ab && double_math[2] > 0.2 )
					{
						ship_obj->Accelerate(ship_obj->ab_force,0,true,true,3);
						ship_obj->energy-=ship_obj->ab_usage;
					}
					else ship_obj->use_ab = false;
				}
				else { ship_obj->use_ab = false; }
				
				if( ship_obj->energy>ship_obj->engine_usage && !ship_obj->use_ab )
				{
					ship_obj->Accelerate(ship_obj->engine_force,0,true,true);
					ship_obj->energy-=ship_obj->engine_usage;
				}

				if( double_math[8] < 90 && double_math[7] < 5 && ship_obj->charge_force>0 && ((double_math[2]>0.5&&ship_obj->charge_usage>0)|(ship_obj->charge_count>0)) )
				{
					if( double_math[5] > 600 )
					{
						ship_obj->UseCharge();
					}
				}
			}
			else if( double_math[7] > 110 )
			{
				if( ship_obj->energy>ship_obj->engine_usage )
				{
					ship_obj->Accelerate(ship_obj->engine_force,180,true,true);
					ship_obj->energy-=ship_obj->engine_usage;
					//df << "Reverse engine." << endl;
				}
			}

			//df << "Make a line." << endl;
			double_math[0] = PointAtValue(player_obj->X,player_obj->Y,X,Y);
			double_math[1] = MoveToValue(double_math[0],false);
			double_math[2] = MoveToValue(double_math[0],true);
			int_math[0] = 300*(1-((abs(player_obj->X-X)+abs(player_obj->Y-Y)))*.000285);
			if(int_math[0]>254)int_math[0]=254;
			if(int_math[0]>0) line(buffer,960-(double_math[1]*100),240-(double_math[2]*100),960-(double_math[1]*106),240-(double_math[2]*106),RedFade[int_math[0]]);
		
			if( int_math[9] < int_math[8] && ship_obj->cur_node == player_obj->ship_obj->cur_node || ship_obj->cur_node > player_obj->ship_obj->cur_node ) position++;

			if( player_obj->ship_obj->w_mass>0 )
			{
				if( abs(player_obj->X-X)+abs(player_obj->Y-Y) < 500 )
				{ 
					double_math[14] = ang_dist( PointAtValue(player_obj->X,player_obj->Y,X,Y), player_obj->angle );
					if( double_math[14] < double_math[20] )
					{
						player_obj->ship_obj->targetting = this;
						double_math[20] = double_math[14];
					}
				}
			}

			if(rand()%5==0) ship_obj->Fire(NULL);
		}
		else
		{
			Screen_X = X-320;
			Screen_Y = Y-240;

			int_math[8] = int_math[9];
			//df << "Player." << endl;
		}

		if( int_math[9] < 150 )
		{
			//df << "Found a node." << endl;
			if(++ship_obj->cur_node==max_nodes-1)
			{
				//Completed!
				//df << "Done with track!" << endl;
				racing = false;
				//return;
			}
			else if( this == player_obj )
			{
				path_node[ship_obj->cur_node]->bmp_obj = (BITMAP *)data[ls_node_OK].dat; // load_pcx("node_OK.pcx",NULL);
				play_sound(SND_blip,path_node[ship_obj->cur_node]->X,path_node[ship_obj->cur_node]->Y);
			}
		}

		if( ship_obj->energy < ship_obj->enrgy_max )
		{
			//df << "Add some energy..." << endl;
			ship_obj->energy+=ship_obj->enrgy_mtr_rate;
			if( ship_obj->energy > ship_obj->enrgy_max ) ship_obj->energy = ship_obj->enrgy_max;
		}

		ship_obj->charge_tick++;
		ship_obj->w_shot_tick+=0.25;
		//df << "Done with the ship." << endl;
	}
}

void reset_lists()
{
	F_Obj.next_obj = &L_Obj;
	L_Obj.prev_obj = &F_Obj;

	max_nodes = 0;
	max_ai = 0;
}

void init_graphics()
{
	set_color_depth(16);
	request_refresh_rate(60);
	set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
	text_mode(-1);

	//df << "Setting buffer." << endl;

	buffer = create_video_bitmap(1280,480);
	if(!buffer) { buffer = create_system_bitmap(1280,480); }
	if(!buffer) { buffer = create_bitmap(1280,480); }
	clear_bitmap(buffer);

	
	//df << "Doing color table..." << endl;

	for(int i=0;i<255;i++)
	{
		RedFade[i] = makecol16(i,0,0);
		YellowFade[i] = makecol16(i,i,0);
		WhiteFade[i] = makecol16(i,i,i);
		GreenFade[i] = makecol16(0,i,0);
		BlueFade[i] = makecol16(0,0,i);
	}

	//df << "Loading ship graphics..." << endl;

	packfile_password("e=mc2");
	data = load_datafile("ls.dat");
	packfile_password(NULL);

	bmp_ship[0] = (BITMAP *)data[ls_b_ship_1].dat; // load_pcx("b_ship_1.pcx",NULL);
	bmp_ship[1] = (BITMAP *)data[ls_b_ship_2].dat; // load_pcx("b_ship_2.pcx",NULL);
	bmp_ship[2] = (BITMAP *)data[ls_b_ship_3].dat; // load_pcx("b_ship_3.pcx",NULL);
	bmp_ship[3] = (BITMAP *)data[ls_b_ship_4].dat; // load_pcx("b_ship_4.pcx",NULL);
	bmp_ship[4] = (BITMAP *)data[ls_b_ship_5].dat; // load_pcx("b_ship_5.pcx",NULL);
	bmp_ship[5] = (BITMAP *)data[ls_b_ship_6].dat; // load_pcx("b_ship_6.pcx",NULL);
	bmp_ship[6] = (BITMAP *)data[ls_b_ship_7].dat; // load_pcx("b_ship_7.pcx",NULL);
	bmp_ship[7] = (BITMAP *)data[ls_b_ship_8].dat; // load_pcx("b_ship_8.pcx",NULL);
	bmp_ship[8] = (BITMAP *)data[ls_b_ship_9].dat; // load_pcx("b_ship_9.pcx",NULL);

	//df << "Loading ending graphics..." << endl;

	end_out = (BITMAP *)data[ls_out].dat; // load_pcx("out.pcx",NULL);
	end_1 = (BITMAP *)data[ls_first].dat; // load_pcx("first.pcx",NULL);
	end_2 = (BITMAP *)data[ls_second].dat; // load_pcx("second.pcx",NULL);
	end_3 = (BITMAP *)data[ls_third].dat; // load_pcx("third.pcx",NULL);
	end_comp = (BITMAP *)data[ls_complete].dat; // load_pcx("complete.pcx",NULL);

	//df << "Loading bar graphics..." << endl;

	hull_bar = (BITMAP *)data[ls_hull_bar].dat; // load_pcx("hull_bar.pcx",NULL);
	energy_bar = (BITMAP *)data[ls_energy_bar].dat; // load_pcx("energy_bar.pcx",NULL);
	speed_bar = (BITMAP *)data[ls_speed_bar].dat; // load_pcx("speed_bar.pcx",NULL);

	//df << "Loading screen graphics..." << endl;

	title = (BITMAP *)data[ls_title].dat; // load_pcx("title.pcx",NULL);
	menu = (BITMAP *)data[ls_menu].dat; // load_pcx("menu.pcx",NULL); 

	//Okay, load some sounds... I know this is init_graphics, but oh well.

	SND_engine = (SAMPLE *)data[ls_engine].dat; // load_sample("engine.wav");
	SND_blip = (SAMPLE *)data[ls_blip].dat; // load_sample("blip.wav");
	SND_buy = (SAMPLE *)data[ls_buy].dat; // load_sample("buy.wav");
	SND_charge = (SAMPLE *)data[ls_charge].dat; // load_sample("charge.wav");
	SND_beep = (SAMPLE *)data[ls_beep].dat; // load_sample("beep.wav");
	SND_fire = (SAMPLE *)data[ls_fire].dat; // load_sample("fire.wav");
	SND_move = (SAMPLE *)data[ls_move].dat; // load_sample("move.wav");
	SND_select = (SAMPLE *)data[ls_select].dat; // load_sample("select.wav");
	SND_hit = (SAMPLE *)data[ls_hit].dat; // load_sample("hit.wav");
	SND_click = (SAMPLE *)data[ls_click].dat; // load_sample("click.wav");

	SND_comp = (SAMPLE *)data[ls_completed].dat; // load_sample("completed.wav");
	SND_fp = (SAMPLE *)data[ls_first_place].dat; // load_sample("first_place.wav");
	SND_sp = (SAMPLE *)data[ls_second_place].dat; // load_sample("second_place.wav");
	SND_tp = (SAMPLE *)data[ls_third_place].dat; // load_sample("third_place.wav");
	SND_out = (SAMPLE *)data[ls_out_snd].dat; // oad_sample("out.wav");

	spacething[0] = (BITMAP *)data[ls_ast1].dat;
	spacething[1] = (BITMAP *)data[ls_ast2].dat;
	spacething[2] = (BITMAP *)data[ls_ast3].dat;
}

bool DownKey = false, mouse_down = false;

int Ship_Selected = 0;

void selection_menu(int Menu_Type)
{
	bool InSelectionMenu = true;
	int i, amt, amt2, viewing_ship=0;

	play_sample(SND_select,255,128,1000,false);

	char x,y,z;

	if( Menu_Type == 1 && NewShips )
	{
		NewShips = false;

		amt = rand()%4+3;

		for(i=0;i<15;i++)
		{
			shop_ships[i] = NULL;

			if(i<amt)
			{
				shop_ships[i] = new Ship();

				shop_ships[i]->type = rand()%9;
				shop_ships[i]->bmp_ship_obj = bmp_ship[shop_ships[i]->type];

				shop_ships[i]->part[0].Clear();
				shop_ships[i]->part[1].Clear();
				shop_ships[i]->part[2].Clear();
				shop_ships[i]->part[3].Clear();
				shop_ships[i]->part[4].Clear();
				shop_ships[i]->part[5].Clear();
				shop_ships[i]->part[6].Clear();
				shop_ships[i]->part[7].Clear();
				shop_ships[i]->part[8].Clear();

				shop_ships[i]->part[0].Make_Random_Component(0);
				shop_ships[i]->part[5].Make_Random_Component(1);
				shop_ships[i]->part[6].Make_Random_Component(2);

				shop_ships[i]->total_price = shop_ships[i]->part[0].Calculate_Cost() + shop_ships[i]->part[5].Calculate_Cost() + shop_ships[i]->part[6].Calculate_Cost();
				shop_ships[i]->total_price = (rand()%5*0.01+0.97)*(shop_ships[i]->total_price+300);

				shop_ships[i]->part[0].Apply(shop_ships[i],false,0);
				shop_ships[i]->part[5].Apply(shop_ships[i],false,5);
				shop_ships[i]->part[6].Apply(shop_ships[i],false,6);

				shop_ships[i]->CalculateMass();
			}
		}
	}
	else if( Menu_Type == 2 && NewShop )
	{
		NewShop = false;
		int part=0,modif=0;

		amt = 18;

		//df << "-- New Shop Items --" << endl;

		for(i=0;i<amt;i++)
		{
			//if(part==4) modif=rand()%2;
			//else modif=0;
			
			shop_inv[i].Make_Random_Component(part);
			
			if(i%2==1||part==4) ++part;

			//df << shop_inv[i].name << endl;
			//df << "i:" << i << endl;
			//df << "eng_f" << shop_inv[i].engine_force << endl;
			//df << "afb_f" << shop_inv[i].ab_force << endl;
			//df << "ant_m" << shop_inv[i].antimatter_mass << endl;
			//df << "arm_p" << shop_inv[i].armour_protection << endl;
			//df << "chg_f" << shop_inv[i].charge_force << endl;
			//df << "egy_x" << shop_inv[i].enrgy_max << endl;
			//df << "trn_f" << shop_inv[i].turner_force << endl;
			//df << "w_mss" << shop_inv[i].w_mass << endl;
		}
	}
	else if( Menu_Type == 3 && NewRace )
	{
		amt = 11;
		amt2 = 5;

		NewRace = false;

		for(i=0;i<30;i++)
		{
			race[i].Clear();

			if(i<amt)
			{
				if(i<4)race[i].Make_Random_Race(i);
				else race[i].Make_Random_Race((rand()%43+8)*0.5);
			}
		}

		race[11].Make_Random_Race();
		race[11].num_of_races = rand()%4+1;
		race[11].ai_amt = 9;
		race[11].purse*=(race[11].num_of_races+1);

		race[12].Make_Random_Race();
		race[12].num_of_races = rand()%4+1;
		race[12].ai_amt = 9;
		race[12].purse*=(race[12].num_of_races+1);

		for(i=0;i<amt2;i++)
		{
			race[i+13].Clear();
			race[i+13].Make_Random_Race(-1,rand()%9);
		}

	}
	else if( Menu_Type == 4 )
	{
		for(i=25;i<30;i++)
			race[i].Clear();

		race[25].ab_allowed=true;
		race[25].ai_amt=0;
		race[25].ch_allowed=true;
		race[25].w_allowed=true;
		race[25].curviness=0;
		race[25].dif=0;
		race[25].dif_var=0;
		race[25].length=1000;
		race[25].min_weight=0;
		race[25].nodes=20;
		race[25].purse=0;
		race[25].ship_type=-1;

		race[26].ab_allowed=true;
		race[26].ai_amt=0;
		race[26].ch_allowed=true;
		race[26].w_allowed=true;
		race[26].curviness=360;
		race[26].dif=0;
		race[26].dif_var=0;
		race[26].length=900;
		race[26].min_weight=0;
		race[26].nodes=10;
		race[26].purse=0;
		race[26].ship_type=-1;

		race[27].ab_allowed=true;
		race[27].ai_amt=0;
		race[27].ch_allowed=true;
		race[27].w_allowed=true;
		race[27].curviness=90;
		race[27].dif=0;
		race[27].dif_var=0;
		race[27].length=1000;
		race[27].min_weight=0;
		race[27].nodes=15;
		race[27].purse=0;
		race[27].ship_type=-1;

		race[28].ab_allowed=true;
		race[28].ai_amt=1;
		race[28].ch_allowed=true;
		race[28].w_allowed=true;
		race[28].curviness=180;
		race[28].dif=12.5;
		race[28].dif_var=0;
		race[28].length=1000;
		race[28].min_weight=0;
		race[28].nodes=15;
		race[28].purse=0;
		race[28].ship_type=-1;

		race[29].ab_allowed=true;
		race[29].ai_amt=-1;
		race[29].ch_allowed=true;
		race[29].w_allowed=true;
		race[29].curviness=180;
		race[29].dif=0;
		race[29].dif_var=0;
		race[29].length=1000;
		race[29].min_weight=0;
		race[29].nodes=15;
		race[29].purse=0;
		race[29].ship_type=-1;
	}

	//df << "Positioning mouse..." << endl;

//	position_mouse(320, 5);

	//df << "Entering ESC loop..." << endl;

	while( key[KEY_ESC] ) { yield_timeslice(); }

	//df << "Starting menu..." << endl;

	while( InSelectionMenu )
	{
		//df << "Starting frame..." << endl;

		c_tick = retrace_count;

		if( key[KEY_ESC] ) InSelectionMenu = false;

		if( mouse_b & 1 || mouse_b & 2 )
		{
			if( !mouse_down )
			{
			mouse_down = true;
			//df << "Mouse button down..." << endl;
			if( mouse_y > 48 )
			{
				//df << "Below limit..." << endl;
				if( mouse_y < 106 )
				{
					int_math[0] = (mouse_x-45)/61;

					if(int_math[0] >= 0 && int_math[0] < 9 && int_math[0] != Ship_Selected )
					{
						Ship_Selected = int_math[0];
						play_sample(SND_click,255,128,1000,false);
					}
					//df << "Selected ship..." << endl;
				}
				else if( mouse_y < 230 )
				{
					int_math[0] = (mouse_y-112)/10;
					if(int_math[0] >= 0 && int_math[0] < 15 )
					{
						if( Menu_Type == 1 && shop_ships[int_math[0]] )
						{
							if( mouse_b & 1 && viewing_ship != int_math[0] ) { viewing_ship = int_math[0]; play_sample(SND_blip,255,128,500,false); }
							else if( credits>=shop_ships[int_math[0]]->total_price && !ship_owned[Ship_Selected] )
							{
								credits-=shop_ships[int_math[0]]->total_price;
								ship_owned[Ship_Selected] = shop_ships[int_math[0]];
								ship_owned[Ship_Selected]->parent_obj->bmp_obj = shop_ships[int_math[0]]->bmp_ship_obj;
								ship_owned[Ship_Selected]->type = 9;
								shop_ships[int_math[0]] = NULL;
								play_sample(SND_buy,255,128,1000,false);
							}
						}
						else if( Menu_Type == 5 && ship_owned[Ship_Selected] )
						{
							if( mouse_b & 1 && int_math[0] < 9 )
							{
								//df << "im[0]:" << int_math[0] << endl;
								//df << "m_y..:" << mouse_y << endl;
								ship_owned[Ship_Selected]->temp = ship_owned[Ship_Selected]->part[int_math[0]];
								int_math[1] = ship_owned[Ship_Selected]->part[int_math[0]].Type();
								if( int_math[1]>-1 )
								{
									ship_owned[Ship_Selected]->temp = ship_owned[Ship_Selected]->part[int_math[0]];
									if( !ship_owned[Ship_Selected]->part[int_math[0]].Apply(ship_owned[Ship_Selected],true,int_math[0]) ) ship_owned[Ship_Selected]->part[int_math[0]].Clear();
									ship_owned[Ship_Selected]->temp.Apply(ship_owned[Ship_Selected],false,int_math[0]);
									play_sample(SND_move,255,128,1000,false);
									ship_owned[Ship_Selected]->CalculateMass();
								}
								else
								{
									if( ship_owned[Ship_Selected]->part[int_math[0]].Apply(ship_owned[Ship_Selected],true,int_math[0]) )
									{
										play_sample(SND_move,255,128,1000,false);
										ship_owned[Ship_Selected]->CalculateMass();
									}
								}
							}
						}
					}
				}
				else if( mouse_y < 420 )
				{
					int_math[0] = (mouse_y-239)/10;
					//df << "int_math[0]:" << int_math[0] << endl;
					if(int_math[0] >= 0 && int_math[0] < 20)
					{
						if( Menu_Type == 2 && ship_owned[Ship_Selected])
						{
							if( mouse_b & 1 )
							{
								if( credits>=shop_inv[int_math[0]].price && shop_inv[int_math[0]].name!="")
								{
									credits-=shop_inv[int_math[0]].price;
									if( shop_inv[int_math[0]].Apply(ship_owned[Ship_Selected],false) ) play_sample(SND_buy,255,128,1000,false);
									ship_owned[Ship_Selected]->CalculateMass();
								}
							}
						}
						else if( Menu_Type == 5 && ship_owned[Ship_Selected] && int_math[0] < 9 )
						{
							if( mouse_b & 1 )
							{
								int_math[1] = ship_owned[Ship_Selected]->part[int_math[0]].Type();
								if( int_math[1]>-1 )
								{
									ship_owned[Ship_Selected]->temp = ship_owned[Ship_Selected]->part[int_math[0]];
									if( !ship_owned[Ship_Selected]->part[int_math[0]].Apply(ship_owned[Ship_Selected],true,int_math[0]) ) ship_owned[Ship_Selected]->part[int_math[0]].Clear();
									ship_owned[Ship_Selected]->temp.Apply(ship_owned[Ship_Selected],false,int_math[0]);
									play_sample(SND_move,255,128,1000,false);
									ship_owned[Ship_Selected]->CalculateMass();
								}
							}
							else
							{
								if(ship_owned[Ship_Selected]->part[int_math[0]].price>0)
								{
									credits+=ship_owned[Ship_Selected]->part[int_math[0]].price*0.6;
									ship_owned[Ship_Selected]->part[int_math[0]].Clear();
									play_sample(SND_buy,255,128,1250,false);
								}
							}
						}
						else if( Menu_Type == 3 || Menu_Type == 4 )
						{
							if( Menu_Type == 4 )
							{
								int_math[0]+=25;
								if(int_math[0]>29)int_math[0]=29;
							}
							//df << "Menu type 3" << endl;
							if( ship_owned[Ship_Selected] && race[int_math[0]].nodes>0 )
							{
								if( ((ship_owned[Ship_Selected]->ab_force==0 && !race[int_math[0]].ab_allowed)|(race[int_math[0]].ab_allowed)) &&
									((ship_owned[Ship_Selected]->charge_force==0 && !race[int_math[0]].ch_allowed)|(race[int_math[0]].ch_allowed)) &&
									((ship_owned[Ship_Selected]->w_mass==0 && !race[int_math[0]].w_allowed)|(race[int_math[0]].w_allowed)) &&
									ship_owned[Ship_Selected]->total_mass>=race[int_math[0]].min_weight &&
									((race[int_math[0]].ship_type==-1)|(ship_owned[Ship_Selected]->bmp_ship_obj == bmp_ship[race[int_math[0]].ship_type])) &&
									credits>=race[int_math[0]].purse*0.1)
								{
									//df << "Starting race." << endl;
									race_num=int_math[0];
									credits-=race[race_num].purse*0.1;

									times_done = -1;

									for(int i=0;i<10;i++)
										point_holder[i] = 0;

									while( times_done < race[race_num].num_of_races )
									{
										max_purse=race[race_num].purse;
										FreeMemory();
										init_stars();
										create_random_track(race[race_num].nodes,race[race_num].curviness,race[race_num].length,(race[race_num].purse>0)?true:false);
										reset_player();
										create_ai_ships(race[race_num].ai_amt,race[race_num].dif,race[race_num].dif_var,race[race_num].ch_allowed,race[race_num].ab_allowed,race[race_num].w_allowed,race[race_num].ship_type,(race[race_num].num_of_races>0)?true:false);
										race_game();

										times_done++;
									}

									FreeMemory();

									if( Menu_Type == 3)
									{
										NewRace = true;
										NewShips = true;
										NewShop = true;
										if( debt>0 )
										{
											if( debt_days>-1 ) debt_days--;
											debt*=1.00225;
										}
									}

									InSelectionMenu = false;
								}
							}
						}
					}
				}
			}
			}
		}
		else { mouse_down = false; }

		//df << "Blitting menu..." << endl;

		blit(menu,buffer,0,0,640,0,640,480);
		textprintf_centre(buffer,font,960,449,65535,"Credits: %.3f",credits);
		for(i=0;i<9;i++)
		{
			//df << "Showing ship owned #" << i << endl;
			if(ship_owned[i])
			{
				masked_blit(ship_owned[i]->bmp_ship_obj,buffer,0,0,640+(75-ship_owned[i]->bmp_ship_obj->w*.5)+(61*i),56,ship_owned[i]->bmp_ship_obj->w,ship_owned[i]->bmp_ship_obj->h);
				textprintf_centre(buffer,font,640+75+(i*61),86,65535,"Mass");
				textprintf_centre(buffer,font,640+75+(i*61),94,65535,"%.1f",ship_owned[i]->total_mass);

				for(int j=0;j<ship_owned[i]->stars;j++)
					circlefill(buffer,640+53+(i*61),98-(j*7),2,YellowFade[254]);
			}
		}
		if( Menu_Type > 1 )
		{
			//df << "Showing ship owned status #" << Ship_Selected << endl;
			if(ship_owned[Ship_Selected])
			{
				if(ship_owned[Ship_Selected]->engine_force>0) textprintf_centre(buffer,font,960,112,WhiteFade[200],"Engine:Force[%.3f]:Usage[%.3f]:Mass[%.2f]",ship_owned[Ship_Selected]->engine_force,ship_owned[Ship_Selected]->engine_usage,ship_owned[Ship_Selected]->engine_mass);
				else textprintf_centre(buffer,font,960,112,WhiteFade[100],"------------------ NO ENGINE MOUNTED ----------------");
				if(ship_owned[Ship_Selected]->ab_force>0) textprintf_centre(buffer,font,960,122,YellowFade[150],"AfterBurner:Force[%.3f]:Usage[%.3f]:Mass[%.2f]",ship_owned[Ship_Selected]->ab_force,ship_owned[Ship_Selected]->ab_usage,ship_owned[Ship_Selected]->ab_mass);
				else textprintf_centre(buffer,font,960,122,WhiteFade[100],"--------------- NO AFTERBURNER MOUNTED --------------");
				if(ship_owned[Ship_Selected]->antimatter_mass>0) textprintf_centre(buffer,font,960,132,GreenFade[225],"Anti-Matter:Mass[-%.2f]",ship_owned[Ship_Selected]->antimatter_mass);
				else textprintf_centre(buffer,font,960,132,WhiteFade[100],"--------------- NO ANTI-MATTER MOUNTED --------------");
				if(ship_owned[Ship_Selected]->armour_protection>0) textprintf_centre(buffer,font,960,142,WhiteFade[250],"Armour:Protection[%.0f%%]:Mass[%.2f]",ship_owned[Ship_Selected]->armour_protection*100,ship_owned[Ship_Selected]->armour_mass);
				else textprintf_centre(buffer,font,960,142,WhiteFade[100],"------------------ NO ARMOUR MOUNTED ----------------");
				if(ship_owned[Ship_Selected]->charge_force>0)
				{
					if(ship_owned[Ship_Selected]->charge_usage==0) textprintf_centre(buffer,font,960,152,RedFade[250],"M-Charge:Force[%.3f]:Count[%.2i]:Mass/Chg[%.2f]",ship_owned[Ship_Selected]->charge_force,ship_owned[Ship_Selected]->charge_max,ship_owned[Ship_Selected]->charge_mass);
					else textprintf_centre(buffer,font,960,152,RedFade[175],"E-Charge:Force[%.3f]:Usage[%.3f]:Mass[%.2f]",ship_owned[Ship_Selected]->charge_force,ship_owned[Ship_Selected]->charge_usage,ship_owned[Ship_Selected]->charge_mass);
				}
				else textprintf_centre(buffer,font,960,152,WhiteFade[100],"----------------- NO CHARGE MOUNTED -----------------");
				if(ship_owned[Ship_Selected]->enrgy_max>0) textprintf_centre(buffer,font,960,162,YellowFade[250],"Reactor:Max Energy[%.3f]:Rate[%.3f]:Mass[%.2f]",ship_owned[Ship_Selected]->enrgy_max,ship_owned[Ship_Selected]->enrgy_mtr_rate,ship_owned[Ship_Selected]->enrgy_mtr_mass);
				else textprintf_centre(buffer,font,960,162,WhiteFade[100],"----------------- NO REACTOR MOUNTED ----------------");
				if(ship_owned[Ship_Selected]->turner_force>0) textprintf_centre(buffer,font,960,172,GreenFade[150],"Turner:Force[%.3f]:Mass[%.2f]",ship_owned[Ship_Selected]->turner_force,ship_owned[Ship_Selected]->turner_mass);
				else textprintf_centre(buffer,font,960,172,WhiteFade[100],"----------------- NO TURNER MOUNTED -----------------");
				if(ship_owned[Ship_Selected]->w_mass>0) textprintf_centre(buffer,font,960,182,BlueFade[250],"Weapon:Dam[%i]:Dis[%i]:Use[%.0f]:Rate[%i]:Hom[%i%%]:Mass[%.3f]",ship_owned[Ship_Selected]->w_damage,ship_owned[Ship_Selected]->w_distortion,ship_owned[Ship_Selected]->w_usage,ship_owned[Ship_Selected]->w_shot_wait,ship_owned[Ship_Selected]->w_accuracy,ship_owned[Ship_Selected]->w_mass);
				else textprintf_centre(buffer,font,960,182,WhiteFade[100],"----------------- NO WEAPON MOUNTED -----------------");
				if(ship_owned[Ship_Selected]->trash_mass>0) textprintf_centre(buffer,font,960,192,GreenFade[150],"Trash:Mass[%.2f]",ship_owned[Ship_Selected]->trash_mass);
				else textprintf_centre(buffer,font,960,192,WhiteFade[100],"------------------ NO TRASH MOUNTED -----------------");
			}
			else
			{
				textprintf_centre(buffer,font,960,142,65535,"No ship in the selected slot.");
			}
		}
		rect(buffer,640+49+(61*Ship_Selected),53,640+98+(61*Ship_Selected),102,YellowFade[200]);

		switch( Menu_Type )
		{
		case 1:
			textprintf_centre(buffer,font,960,427,WhiteFade[10],"Click to view ship details. Right click to buy to an empty slot. [ESC] returns.");
			if(shop_ships[viewing_ship])
			{
				textprintf_centre(buffer,font,960,24,65535,"Buy Ship - Viewing Ship #%i",viewing_ship+1);
				masked_blit(shop_ships[viewing_ship]->bmp_ship_obj,buffer,0,0,960-(shop_ships[viewing_ship]->bmp_ship_obj->w*.5),375,shop_ships[viewing_ship]->bmp_ship_obj->w,shop_ships[viewing_ship]->bmp_ship_obj->h);
			}
			else textprintf_centre(buffer,font,960,24,65535,"Buy Ship",viewing_ship);
			for(i=0;i<15;i++)
			{
				if(shop_ships[i]) textprintf_centre(buffer,font,960,112+(i*10),(viewing_ship==i)?GreenFade[250]:65535,"Ship - Price[%.3f] - Mass[%.2f]",shop_ships[i]->total_price,shop_ships[i]->total_mass);
				if(shop_ships[viewing_ship])
				{
					if(shop_ships[viewing_ship]->engine_force>0) textprintf_centre(buffer,font,960,271,WhiteFade[200],"Engine:Force[%.3f]:Usage[%.3f]:Mass[%.2f]",shop_ships[viewing_ship]->engine_force,shop_ships[viewing_ship]->engine_usage,shop_ships[viewing_ship]->engine_mass);
					else textprintf_centre(buffer,font,960,271,WhiteFade[100],"------------------ NO ENGINE MOUNTED ----------------");
					if(shop_ships[viewing_ship]->ab_force>0) textprintf_centre(buffer,font,960,281,YellowFade[150],"AfterBurner:Force[%.3f]:Usage[%.3f]:Mass[%.2f]",shop_ships[viewing_ship]->ab_force,shop_ships[viewing_ship]->ab_usage,shop_ships[viewing_ship]->ab_mass);
					else textprintf_centre(buffer,font,960,281,WhiteFade[100],"--------------- NO AFTERBURNER MOUNTED --------------");
					if(shop_ships[viewing_ship]->antimatter_mass>0) textprintf_centre(buffer,font,960,291,GreenFade[225],"Anti-Matter:Mass[-%.2f]",shop_ships[viewing_ship]->antimatter_mass);
					else textprintf_centre(buffer,font,960,291,WhiteFade[100],"--------------- NO ANTI-MATTER MOUNTED --------------");
					if(shop_ships[viewing_ship]->armour_protection>0) textprintf_centre(buffer,font,960,301,WhiteFade[250],"Armour:Protection[%.0f%%]:Mass[%.2f]",shop_ships[viewing_ship]->armour_protection*100,shop_ships[viewing_ship]->armour_mass);
					else textprintf_centre(buffer,font,960,301,WhiteFade[100],"------------------ NO ARMOUR MOUNTED ----------------");
					if(shop_ships[viewing_ship]->charge_force>0)
					{
						if(shop_ships[viewing_ship]->charge_usage==0) textprintf_centre(buffer,font,960,311,RedFade[250],"M-Charge:Force[%.3f]:Count[%.2i]:Mass/Chg[%.2f]",shop_ships[viewing_ship]->charge_force,shop_ships[viewing_ship]->charge_max,shop_ships[viewing_ship]->charge_mass);
						else textprintf_centre(buffer,font,960,311,RedFade[175],"E-Charge:Force[%.3f]:Usage[%.3f]:Mass[%.2f]",shop_ships[viewing_ship]->charge_force,shop_ships[viewing_ship]->charge_usage,shop_ships[viewing_ship]->charge_mass);
					}
					else textprintf_centre(buffer,font,960,311,WhiteFade[100],"----------------- NO CHARGE MOUNTED -----------------");
					if(shop_ships[viewing_ship]->enrgy_max>0) textprintf_centre(buffer,font,960,321,YellowFade[250],"Reactor:Max Energy[%.3f]:Rate[%.3f]:Mass[%.2f]",shop_ships[viewing_ship]->enrgy_max,shop_ships[viewing_ship]->enrgy_mtr_rate,shop_ships[viewing_ship]->enrgy_mtr_mass);
					else textprintf_centre(buffer,font,960,321,WhiteFade[100],"----------------- NO REACTOR MOUNTED ----------------");
					if(shop_ships[viewing_ship]->turner_force>0) textprintf_centre(buffer,font,960,331,GreenFade[150],"Turner:Force[%.3f]:Mass[%.2f]",shop_ships[viewing_ship]->turner_force,shop_ships[viewing_ship]->turner_mass);
					else textprintf_centre(buffer,font,960,331,WhiteFade[100],"----------------- NO TURNER MOUNTED -----------------");
					if(shop_ships[viewing_ship]->w_mass>0) textprintf_centre(buffer,font,960,341,BlueFade[250],"Weapon:Dam[%i]:Dis[%i]:Use[%.0f]:Rate[%i]:Hom[%i%%]:Mass[%.3f]",shop_ships[viewing_ship]->w_damage,shop_ships[viewing_ship]->w_distortion,shop_ships[viewing_ship]->w_usage,shop_ships[viewing_ship]->w_shot_wait,shop_ships[viewing_ship]->w_accuracy,shop_ships[viewing_ship]->w_mass);
					else textprintf_centre(buffer,font,960,341,WhiteFade[100],"----------------- NO WEAPON MOUNTED -----------------");
					if(shop_ships[viewing_ship]->trash_mass>0) textprintf_centre(buffer,font,960,351,GreenFade[150],"Trash:Mass[%.2f]",shop_ships[viewing_ship]->trash_mass);
					else textprintf_centre(buffer,font,960,351,WhiteFade[100],"----------------- NO TRASH MOUNTED ------------------");
				}
			}
			break;
		case 2:
			textprintf_centre(buffer,font,960,24,65535,"The Shop");
			textprintf_centre(buffer,font,960,427,WhiteFade[10],"Click bottom list to buy for selected ship. [ESC] returns.");
			for(i=0;i<19;i++)
			{
				if(shop_inv[i].name!="")
				{
					if(shop_inv[i].engine_force>0) textprintf_centre(buffer,font,960,239+(i*10),WhiteFade[200],"%.15s:Price[%.3f]:Force[%.3f]:Usage[%.3f]:Mass[%.2f]",shop_inv[i].name.c_str(),shop_inv[i].price,shop_inv[i].engine_force,shop_inv[i].engine_usage,shop_inv[i].engine_mass);
					else if(shop_inv[i].ab_force>0) textprintf_centre(buffer,font,960,239+(i*10),YellowFade[150],"%.15s:Price[%.3f]:Force[%.3f]:Usage[%.3f]:Mass[%.2f]",shop_inv[i].name.c_str(),shop_inv[i].price,shop_inv[i].ab_force,shop_inv[i].ab_usage,shop_inv[i].ab_mass);
					else if(shop_inv[i].antimatter_mass>0) textprintf_centre(buffer,font,960,239+(i*10),GreenFade[225],"%.15s:Price[%.3f]:Mass[-%.2f]",shop_inv[i].name.c_str(),shop_inv[i].price,shop_inv[i].antimatter_mass);
					else if(shop_inv[i].armour_protection>0) textprintf_centre(buffer,font,960,239+(i*10),WhiteFade[250],"%.15s:Price[%.3f]:Protection[%.0f%%]:Mass[%.2f]",shop_inv[i].name.c_str(),shop_inv[i].price,shop_inv[i].armour_protection*100,shop_inv[i].armour_mass);
					else if(shop_inv[i].charge_force>0)
					{
						if(shop_inv[i].charge_usage==0) textprintf_centre(buffer,font,960,239+(i*10),RedFade[250],"%.15s:Price[%.3f]:Force[%.3f]:Count[%.2i]:Mass/Chg[%.2f]",shop_inv[i].name.c_str(),shop_inv[i].price,shop_inv[i].charge_force,shop_inv[i].charge_max,shop_inv[i].charge_mass);
						else textprintf_centre(buffer,font,960,239+(i*10),RedFade[175],"%.15s:Price[%.3f]:Force[%.3f]:Usage[%.3f]:Mass[%.2f]",shop_inv[i].name.c_str(),shop_inv[i].price,shop_inv[i].charge_force,shop_inv[i].charge_usage,shop_inv[i].charge_mass);
					}
					else if(shop_inv[i].enrgy_max>0) textprintf_centre(buffer,font,960,239+(i*10),YellowFade[250],"%.15s:Price[%.3f]:Max Energy[%.3f]:Rate[%.3f]:Mass[%.2f]",shop_inv[i].name.c_str(),shop_inv[i].price,shop_inv[i].enrgy_max,shop_inv[i].enrgy_mtr_rate,shop_inv[i].enrgy_mtr_mass);
					else if(shop_inv[i].turner_force>0) textprintf_centre(buffer,font,960,239+(i*10),GreenFade[150],"%.15s:Price[%.3f]:Force[%.3f]:Mass[%.2f]",shop_inv[i].name.c_str(),shop_inv[i].price,shop_inv[i].turner_force,shop_inv[i].turner_mass);
					else if(shop_inv[i].w_mass>0) textprintf_centre(buffer,font,960,239+(i*10),BlueFade[250],"%.15s:Price[%.3f]:Dam[%i]:Dis[%i]:Use[%.0f]:Rate[%i]:Hom[%i%%]:Mass[%.3f]",shop_inv[i].name.c_str(),shop_inv[i].price,shop_inv[i].w_damage,shop_inv[i].w_distortion,shop_inv[i].w_usage,shop_inv[i].w_shot_wait,shop_inv[i].w_accuracy,shop_inv[i].w_mass);
					else if(shop_inv[i].trash_mass>0) textprintf_centre(buffer,font,960,239+(i*10),GreenFade[150],"%.15s:Price[%.3f]:Mass[%.2f]",shop_inv[i].name.c_str(),shop_inv[i].price,shop_inv[i].trash_mass);
					if(shop_inv[i].price>credits) hline(buffer,640+10,243+(i*10),640+630,WhiteFade[140]);
				}
			}
			break;
		case 3:
			textprintf_centre(buffer,font,960,24,65535,"Race - 10%% Purse Entry Fee");
			textprintf_centre(buffer,font,960,427,WhiteFade[10],"Click to enter a race with the selected ship. [ESC] returns.");
			//df << "Showing amt of races:" << amt << endl;
			if( ship_owned[Ship_Selected] )
			{
				for(i=0;i<19;i++)
				{
					if(race[i].nodes>0 && ((race[i].ship_type==-1)|(ship_owned[Ship_Selected]->bmp_ship_obj == bmp_ship[race[i].ship_type])) )
					{
						if(!race[i].ab_allowed)x='N';
						else x='Y';
						if(!race[i].ch_allowed)y='N';
						else y='Y';
						if(!race[i].w_allowed)z='N';
						else z='Y';
						if(race[i].ship_type==-1) int_math[0] = WhiteFade[240-(70*(i%2))];
						else int_math[0] = YellowFade[240];
						if(race[i].num_of_races==0)textprintf_centre(buffer,font,960,239+(i*10),int_math[0],"Race:Purse[%5.1f]:MassRq[%2.0f]:Diff[%4.1f]:Nodes[%2i]:Curve[%3.0f]:AB[%c]:CH[%c]:W[%c]",race[i].purse,race[i].min_weight,race[i].dif,race[i].nodes-2,race[i].curviness,x,y,z);
						else textprintf_centre(buffer,font,960,239+(i*10),GreenFade[250],"Race:Purse[%6.1f]:MassRq[%2.0f]:Diff[%4.1f]:Curve[%3.0f]:Races[%i]:AB[%c]:CH[%c]:W[%c]",race[i].purse,race[i].min_weight,race[i].dif,race[i].curviness,race[i].num_of_races+1,x,y,z);
						if( !(((ship_owned[Ship_Selected]->ab_force==0 && !race[i].ab_allowed)|(race[i].ab_allowed)) &&
							((ship_owned[Ship_Selected]->charge_force==0 && !race[i].ch_allowed)|(race[i].ch_allowed)) &&
							((ship_owned[Ship_Selected]->w_mass==0 && !race[i].w_allowed)|(race[i].w_allowed)) &&
							ship_owned[Ship_Selected]->total_mass>=race[i].min_weight &&
							credits>=race[i].purse*0.1) )
						{
							hline(buffer,640+10,243+(i*10),640+630,RedFade[225]);
						}
					}
				}
			}
			break;
		case 4:
			textprintf_centre(buffer,font,960,24,65535,"Time Trials");
			textprintf_centre(buffer,font,960,427,WhiteFade[10],"Click to enter with selected ship. [UP/DOWN] changes difficulty. [ESC] returns.");
			if( ship_owned[Ship_Selected] )
			{
				for(i=25;i<30;i++)
				{
					if(race[i].nodes>0)
					{
						if( race[i].ai_amt==0 ) textprintf_centre(buffer,font,960,239+((i-25)*10),WhiteFade[240-(70*(i%2))],"Single Trial - Nodes[%i]:Curve[%.0f]:All Allowed",race[i].nodes-2,race[i].curviness);
						else if( race[i].ai_amt>0 ) textprintf_centre(buffer,font,960,239+((i-25)*10),WhiteFade[240-(70*(i%2))],"Drone Trial - Nodes[%i]:Curve[%.0f]:Diff[%.1f]:All Allowed",race[i].nodes-2,race[i].curviness,race[i].dif);
						else if( race[i].ai_amt<0 ) textprintf_centre(buffer,font,960,239+((i-25)*10),WhiteFade[240-(70*(i%2))],"Owned Ships Trial - Nodes[%2i]:Curve[%.0f]:All Allowed",race[i].nodes-2,race[i].curviness);
					}
				}
			}

			if( key[KEY_UP] )
			{
				if( !DownKey )
				{
					DownKey = true;
					if( race[28].dif<25) race[28].dif+=0.5;
				}
			}
			else if( key[KEY_DOWN] )
			{
				if( !DownKey )
				{
					DownKey = true;
					if( race[28].dif>0) race[28].dif-=0.5;
				}
			}
			else DownKey = false;

			break;
		case 5:
			textprintf_centre(buffer,font,960,24,65535,"Manage");
			textprintf_centre(buffer,font,960,427,WhiteFade[10],"Click to transfer between supply and ship. Right click to sell. [ESC] returns.");
			if(ship_owned[Ship_Selected])
			{
				if(ship_owned[Ship_Selected]->part[0].engine_force>0) textprintf_centre(buffer,font,960,239,WhiteFade[200],"Engine:Value[%.3f]:Force[%.3f]:Usage[%.3f]:Mass[%.2f]",ship_owned[Ship_Selected]->part[0].price*0.6,ship_owned[Ship_Selected]->part[0].engine_force,ship_owned[Ship_Selected]->part[0].engine_usage,ship_owned[Ship_Selected]->part[0].engine_mass);
				else textprintf_centre(buffer,font,960,239,WhiteFade[100],"------------------ NO ENGINE SUPPLY -----------------");
				if(ship_owned[Ship_Selected]->part[1].ab_force>0) textprintf_centre(buffer,font,960,249,YellowFade[150],"AfterBurner:Value[%.3f]:Force[%.3f]:Usage[%.3f]:Mass[%.2f]",ship_owned[Ship_Selected]->part[1].price*0.6,ship_owned[Ship_Selected]->part[1].ab_force,ship_owned[Ship_Selected]->part[1].ab_usage,ship_owned[Ship_Selected]->part[1].ab_mass);
				else textprintf_centre(buffer,font,960,249,WhiteFade[100],"--------------- NO AFTERBURNER SUPPLY ---------------");
				if(ship_owned[Ship_Selected]->part[2].antimatter_mass>0) textprintf_centre(buffer,font,960,259,GreenFade[225],"Anti-Matter:Value[%.3f]:Mass[-%.2f]",ship_owned[Ship_Selected]->part[2].price*0.6,ship_owned[Ship_Selected]->part[2].antimatter_mass);
				else textprintf_centre(buffer,font,960,259,WhiteFade[100],"--------------- NO ANTI-MATTER SUPPLY ---------------");
				if(ship_owned[Ship_Selected]->part[3].armour_protection>0) textprintf_centre(buffer,font,960,269,WhiteFade[250],"Armour:Value[%.3f]:Protection[%.0f%%]:Mass[%.2f]",ship_owned[Ship_Selected]->part[3].price*0.6,ship_owned[Ship_Selected]->part[3].armour_protection*100,ship_owned[Ship_Selected]->part[3].armour_mass);
				else textprintf_centre(buffer,font,960,269,WhiteFade[100],"------------------ NO ARMOUR SUPPLY -----------------");
				if(ship_owned[Ship_Selected]->part[4].charge_force>0)
				{
					if(ship_owned[Ship_Selected]->part[4].charge_usage==0) textprintf_centre(buffer,font,960,279,RedFade[250],"M-Charge:Value[%.3f]:Force[%.3f]:Count[%.2i]:Mass/Chg[%.2f]",ship_owned[Ship_Selected]->part[4].price*0.6,ship_owned[Ship_Selected]->part[4].charge_force,ship_owned[Ship_Selected]->part[4].charge_max,ship_owned[Ship_Selected]->part[4].charge_mass);
					else textprintf_centre(buffer,font,960,279,RedFade[175],"E-Charge:Value[%.3f]:Force[%.3f]:Usage[%.3f]:Mass[%.2f]",ship_owned[Ship_Selected]->part[4].price*0.6,ship_owned[Ship_Selected]->part[4].charge_force,ship_owned[Ship_Selected]->part[4].charge_usage,ship_owned[Ship_Selected]->part[4].charge_mass);
				}
				else textprintf_centre(buffer,font,960,279,WhiteFade[100],"----------------- NO CHARGE SUPPLY ------------------");
				if(ship_owned[Ship_Selected]->part[5].enrgy_max>0) textprintf_centre(buffer,font,960,289,YellowFade[250],"Reactor:Value[%.3f]:Max Energy[%.3f]:Rate[%.3f]:Mass[%.2f]",ship_owned[Ship_Selected]->part[5].price*0.6,ship_owned[Ship_Selected]->part[5].enrgy_max,ship_owned[Ship_Selected]->part[5].enrgy_mtr_rate,ship_owned[Ship_Selected]->part[5].enrgy_mtr_mass);
				else textprintf_centre(buffer,font,960,289,WhiteFade[100],"----------------- NO REACTOR SUPPLY -----------------");
				if(ship_owned[Ship_Selected]->part[6].turner_force>0) textprintf_centre(buffer,font,960,299,GreenFade[150],"Turner:Value[%.3f]:Force[%.3f]:Mass[%.2f]",ship_owned[Ship_Selected]->part[6].price*0.6,ship_owned[Ship_Selected]->part[6].turner_force,ship_owned[Ship_Selected]->part[6].turner_mass);
				else textprintf_centre(buffer,font,960,299,WhiteFade[100],"----------------- NO TURNER SUPPLY ------------------");
				if(ship_owned[Ship_Selected]->part[7].w_mass>0) textprintf_centre(buffer,font,960,309,BlueFade[250],"Weapon:Value[%.3f]:Dam[%i]:Dis[%i]:Use[%.0f]:Rate[%i]:Hom[%i%%]:Mass[%.3f]",ship_owned[Ship_Selected]->part[7].price*0.6,ship_owned[Ship_Selected]->part[7].w_damage,ship_owned[Ship_Selected]->part[7].w_distortion,ship_owned[Ship_Selected]->part[7].w_usage,ship_owned[Ship_Selected]->part[7].w_shot_wait,ship_owned[Ship_Selected]->part[7].w_accuracy,ship_owned[Ship_Selected]->part[7].w_mass);
				else textprintf_centre(buffer,font,960,309,WhiteFade[100],"----------------- NO WEAPON SUPPLY ------------------");
				if(ship_owned[Ship_Selected]->part[8].trash_mass>0) textprintf_centre(buffer,font,960,319,GreenFade[150],"Trash:Value[%.3f]:Mass[%.2f]",ship_owned[Ship_Selected]->part[8].price*0.6,ship_owned[Ship_Selected]->part[8].trash_mass);
				else textprintf_centre(buffer,font,960,319,WhiteFade[100],"------------------ NO TRASH SUPPLY ------------------");
			}
		}

		//df << "Blitting frame to screen..." << endl;
		show_mouse(NULL);
		blit(buffer,screen,640,0,0,0,640,480);
		show_mouse(screen);

		while( !(retrace_count - c_tick) ) { yield_timeslice(); }
	}
}

void main_menu()
{
	bool InMainMenu = true, ComingBack = false, DownKey = true, Redraw = true;

//	blit(title,screen,0,0,0,0,640,480);

//	textprintf_centre(screen,font,553,5,65535,"Credits: %.3f",credits);
//	textprintf_centre(screen,font,600,266,65535,"v1.15");

//	textprintf_centre(screen,font,60,200,WhiteFade[100],"Detail Level: %i", detail_lvl);
//	textprintf_centre(screen,font,60,208,WhiteFade[100],"[UP/DOWN to Change]");

	show_mouse(screen);

//	position_mouse(320, 5);

	while( InMainMenu )
	{
		c_tick = retrace_count;

		if( mouse_b & 1 )
		{
			if( !mouse_down )
			{
				mouse_down = true;

				if( mouse_x > 30 && mouse_x < 160 && mouse_y > 330 && mouse_y < 384 ) { selection_menu(1); ComingBack = true; }
				else if( mouse_x > 30 && mouse_x < 160 && mouse_y > 405 && mouse_y < 460 ) { selection_menu(2); ComingBack = true; }
				else if( mouse_x > 250 && mouse_x < 400 && mouse_y > 330 && mouse_y < 384 ) { selection_menu(3); ComingBack = true; }
				else if( mouse_x > 250 && mouse_x < 400 && mouse_y > 405 && mouse_y < 460 ) { selection_menu(4); ComingBack = true; }
				else if( mouse_x > 466 && mouse_x < 610 && mouse_y > 330 && mouse_y < 384 ) { selection_menu(5); ComingBack = true; }
				else if( mouse_x > 466 && mouse_x < 610 && mouse_y > 405 && mouse_y < 460 ) InMainMenu = false;
			}
		}
		else mouse_down = false;

		if( key[KEY_UP] )
		{
			if( !DownKey )
			{
				DownKey = true;

				if(detail_lvl<4) { detail_lvl++; Redraw = true; }
			}
		}
		else if( key[KEY_DOWN] )
		{
			if( !DownKey )
			{
				DownKey = true;

				if(detail_lvl>1) { detail_lvl--; Redraw = true; }
			}
		}
		else if( key[KEY_P] )
		{
			if( !DownKey )
			{
				DownKey = true;

				if( ((credits >= 50)|(credits >= debt)) && debt > 0 )
				{
					Redraw = true;

					play_sample(SND_buy,255,128,1000,false);

					if( debt > 50 ) { credits-=50; debt-=50; }
					else
					{
						credits-=debt;
						debt=0;
					}
				}
			}
		}
		else if( key[KEY_L] )
		{
			if( !DownKey )
			{
				DownKey = true;

				if( !debt )
				{
					debt = 1000;
					debt_days = 25;

					credits+=1000;

					play_sample(SND_buy,255,128,1000,false);

					Redraw = true;
				}
			}
		}
		else DownKey = false;

		if( ComingBack || Redraw ) 
		{
			show_mouse(NULL); Redraw = false;
			blit(title,screen,0,0,0,0,640,480);
			textprintf_centre(screen,font,553,5,GreenFade[250],"Credits: %.3f",credits);
			if( debt>0 )
			{
				textprintf_centre(screen,font,553,25,RedFade[150],"Debt: %.3f",debt);
				textprintf_centre(screen,font,553,35,RedFade[150],"Days Left: %i",debt_days);
				textprintf_centre(screen,font,553,45,WhiteFade[100],"[P] makes $50 payment");
				if( debt_days == -1 )
				{
					clear_bitmap(screen);

					textprintf_centre(screen,font,320,220,RedFade[250],"You defaulted on your load. All your assets have been repossessed.");
					textprintf_centre(screen,font,320,260,RedFade[225],"Press [SPACE] to quit.");

					save_game();

					while( !key[KEY_SPACE] ) { yield_timeslice(); }

					Quit();
				}
			}
			else
			{
				textprintf_centre(screen,font,553,25,WhiteFade[150],"[ No Debt ]",debt);
				textprintf_centre(screen,font,553,35,WhiteFade[100],"Press [L] to take out");
				textprintf_centre(screen,font,553,45,WhiteFade[100],"1000 credits, 25 days");
			}
			textprintf_centre(screen,font,600,266,65535,"v2.4");
			textprintf_centre(screen,font,100,210,WhiteFade[100],"Detail Level: %i", detail_lvl);
			textprintf_centre(screen,font,100,218,WhiteFade[100],"[UP/DOWN to Change]");
			set_mouse_sprite(NULL);
			set_mouse_sprite_focus(0,0);
			show_mouse(screen);
//			position_mouse(320, 5);
			ComingBack = false;
		}

		while( !(retrace_count - c_tick) ) { yield_timeslice(); }
	}

}

void draw_gui()
{
	textprintf(buffer,font,640,455,65535,"Speed::");
	textprintf(buffer,font,640,464,65535,"Energy:");
	textprintf(buffer,font,640,473,65535,"Hull:::");

	textprintf_centre(buffer,font,800,0,65535,"Position %i/%i",position,max_ai+1);
	textprintf_centre(buffer,font,1120,0,65535,"Time %.1i:%.2i.%.2i",minutes,seconds,ticks);
	if( race[race_num].num_of_races>0 ) textprintf_centre(buffer,font,960,0,65535,"Race %i/%i",times_done+2,race[race_num].num_of_races+1);
	else if( max_purse==0 ) textprintf_centre(buffer,font,960,0,65535,"TRIAL");

	blit(speed_bar,buffer,0,0,704,455,player_obj->speed*22,7);
	blit(energy_bar,buffer,0,0,704,464,player_obj->ship_obj->energy,7);
	blit(hull_bar,buffer,0,0,704,473,player_obj->ship_obj->hull*4,7);

	textprintf(buffer,font,1150,455,65535,"Node %i/%i",player_obj->ship_obj->cur_node,max_nodes-2);
	if( player_obj->ship_obj->charge_force>0 )
	{
		if( player_obj->ship_obj->charge_usage == 0 )
		{
			if( player_obj->ship_obj->charge_tick<=player_obj->ship_obj->charge_wait ) textprintf(buffer,font,1150,464,YellowFade[220],"Loading..",player_obj->ship_obj->charge_count);
			else if(player_obj->ship_obj->charge_count>0) textprintf(buffer,font,1150,464,GreenFade[220],"Charges %i",player_obj->ship_obj->charge_count);
			else textprintf(buffer,font,1150,464,RedFade[220],"Charges %i",player_obj->ship_obj->charge_count);
		}
		else
		{
			if( player_obj->ship_obj->charge_tick<=player_obj->ship_obj->charge_wait ) textprintf(buffer,font,1150,464,YellowFade[220],"Loading Charge",player_obj->ship_obj->charge_count);
			else if(player_obj->ship_obj->charge_usage<player_obj->ship_obj->energy) textprintf(buffer,font,1150,464,GreenFade[220],"Charge OK");
			else textprintf(buffer,font,1150,464,RedFade[220],"Charge Offline");
		}
	}

	if( player_obj->ship_obj->w_mass>0 )
	{
		if( player_obj->ship_obj->energy<player_obj->ship_obj->w_usage || player_obj->ship_obj->cur_node==0 ) textprintf(buffer,font,1150,472,RedFade[220],"Weapon Offline");
		else if( player_obj->ship_obj->w_shot_tick < player_obj->ship_obj->w_shot_wait ) textprintf(buffer,font,1150,472,YellowFade[200],"Loading Weapon");
		else if( !player_obj->ship_obj->targetting ) textprintf(buffer,font,1150,472,YellowFade[200],"No Lock");
		else textprintf(buffer,font,1150,472,GreenFade[220],"Weapon OK");
	}

	int_math[0] = player_obj->ship_obj->cur_node+1;
	if(int_math[0]<max_nodes)
	{
		int_math[1] = abs(player_obj->X-path_node[int_math[0]]->X)+abs(player_obj->Y-path_node[int_math[0]]->Y);
		double_math[0] = PointAtValue(player_obj->X,player_obj->Y,path_node[int_math[0]]->X,path_node[int_math[0]]->Y);
		double_math[1] = MoveToValue(double_math[0],false);
		double_math[2] = MoveToValue(double_math[0],true);
		//line(buffer,960-(double_math[1]*100),240-(double_math[2]*100),960-(double_math[1]*106),240-(double_math[2]*106),GreenFade[254]);
		circle(buffer,960-(double_math[1]*103),240-(double_math[2]*103),3,GreenFade[254]);
		textprintf_centre(buffer,font,960-(double_math[1]*120),240-(double_math[2]*120),WhiteFade[110],"%.1f",int_math[1]*.01);
		int_math[0] = player_obj->ship_obj->cur_node+2;
		if(int_math[0]<max_nodes)
		{
			double_math[0] = PointAtValue(player_obj->X,player_obj->Y,path_node[int_math[0]]->X,path_node[int_math[0]]->Y);
			circle(buffer,960-(MoveToValue(double_math[0],false)*103),240-(MoveToValue(double_math[0],true)*103),2,GreenFade[110]);
			//line(buffer,960-(MoveToValue(double_math[0],false)*100),240-(MoveToValue(double_math[0],true)*100),960-(double_math[1]*106),240-(double_math[2]*106),GreenFade[100]);
		}
	}
}

void load_game()
{
	string check="";

	i_game_file.open(game_file.c_str());
	i_game_file.precision(5);

	i_game_file >> credits;
	i_game_file >> debt;
	i_game_file >> debt_days;

	for(int i=0;i<9;i++)
	{
		i_game_file >> check;

		if( strstr(check.c_str(),"REALSHIP") )
		{
			ship_owned[i] = new Ship();
			
			if( strstr(check.c_str(),"_AA") ) ship_owned[i]->stars = 1;
			else if( strstr(check.c_str(),"_CB") ) ship_owned[i]->stars = 2;
			else if( strstr(check.c_str(),"_EC") ) ship_owned[i]->stars = 3;
			else if( strstr(check.c_str(),"_WQ") ) ship_owned[i]->stars = 4;
			else if( strstr(check.c_str(),"_6T") ) ship_owned[i]->stars = 5;

			i_game_file >> int_math[0];
			ship_owned[i]->bmp_ship_obj = bmp_ship[int_math[0]];
			i_game_file >> ship_owned[i]->ab_force;
			i_game_file >> ship_owned[i]->ab_mass;
			i_game_file >> ship_owned[i]->ab_usage;
			i_game_file >> ship_owned[i]->antimatter_mass;
			i_game_file >> ship_owned[i]->armour_mass;
			i_game_file >> ship_owned[i]->armour_protection;
			i_game_file >> ship_owned[i]->charge_count;
			i_game_file >> ship_owned[i]->charge_force;
			i_game_file >> ship_owned[i]->charge_mass;
			i_game_file >> ship_owned[i]->charge_max;
			i_game_file >> ship_owned[i]->charge_usage;
			i_game_file >> ship_owned[i]->charge_wait;
			i_game_file >> ship_owned[i]->engine_force;
			i_game_file >> ship_owned[i]->engine_mass;
			i_game_file >> ship_owned[i]->engine_usage;
			i_game_file >> ship_owned[i]->enrgy_max;
			i_game_file >> ship_owned[i]->enrgy_mtr_mass;
			i_game_file >> ship_owned[i]->enrgy_mtr_rate;
			i_game_file >> ship_owned[i]->total_mass;
			i_game_file >> ship_owned[i]->total_price;
			i_game_file >> ship_owned[i]->trash_mass;
			i_game_file >> ship_owned[i]->turner_force;
			i_game_file >> ship_owned[i]->turner_mass;
			i_game_file >> ship_owned[i]->w_accuracy;
			i_game_file >> ship_owned[i]->w_damage;
			i_game_file >> ship_owned[i]->w_distortion;
			i_game_file >> ship_owned[i]->w_mass;
			i_game_file >> ship_owned[i]->w_shot_wait;
			i_game_file >> ship_owned[i]->w_usage;

			for(int w=0;w<9;w++)
			{
				i_game_file >> ship_owned[i]->part[w].ab_force;
				i_game_file >> ship_owned[i]->part[w].ab_mass;
				i_game_file >> ship_owned[i]->part[w].ab_usage;
				i_game_file >> ship_owned[i]->part[w].antimatter_mass;
				i_game_file >> ship_owned[i]->part[w].armour_mass;
				i_game_file >> ship_owned[i]->part[w].armour_protection;
				i_game_file >> ship_owned[i]->part[w].charge_count;
				i_game_file >> ship_owned[i]->part[w].charge_force;
				i_game_file >> ship_owned[i]->part[w].charge_mass;
				i_game_file >> ship_owned[i]->part[w].charge_max;
				i_game_file >> ship_owned[i]->part[w].charge_usage;
				i_game_file >> ship_owned[i]->part[w].charge_wait;
				i_game_file >> ship_owned[i]->part[w].engine_force;
				i_game_file >> ship_owned[i]->part[w].engine_mass;
				i_game_file >> ship_owned[i]->part[w].engine_usage;
				i_game_file >> ship_owned[i]->part[w].enrgy_max;
				i_game_file >> ship_owned[i]->part[w].enrgy_mtr_mass;
				i_game_file >> ship_owned[i]->part[w].enrgy_mtr_rate;
				i_game_file >> ship_owned[i]->part[w].price;
				i_game_file >> ship_owned[i]->part[w].trash_mass;
				i_game_file >> ship_owned[i]->part[w].turner_force;
				i_game_file >> ship_owned[i]->part[w].turner_mass;
				i_game_file >> ship_owned[i]->part[w].w_accuracy;
				i_game_file >> ship_owned[i]->part[w].w_damage;
				i_game_file >> ship_owned[i]->part[w].w_distortion;
				i_game_file >> ship_owned[i]->part[w].w_mass;
				i_game_file >> ship_owned[i]->part[w].w_shot_wait;
				i_game_file >> ship_owned[i]->part[w].w_usage;
			}
		}
	}

	i_game_file.close();
}

void save_game()
{
	o_game_file.open(game_file.c_str());
	o_game_file.precision(5);

	o_game_file << credits << endl;
	o_game_file << debt << endl;
	o_game_file << debt_days << endl;

	for(int i=0;i<9;i++)
	{
		if( ship_owned[i] )
		{
			if( ship_owned[i]->stars==1 ) o_game_file << "REALSHIP_AA" << endl;
			else if( ship_owned[i]->stars==2 ) o_game_file << "REALSHIP_CB" << endl;
			else if( ship_owned[i]->stars==3 ) o_game_file << "REALSHIP_EC" << endl;
			else if( ship_owned[i]->stars==4 ) o_game_file << "REALSHIP_WQ" << endl;
			else if( ship_owned[i]->stars==5 ) o_game_file << "REALSHIP_6T" << endl;
			else o_game_file << "REALSHIP" << endl;

			for(int z=0;z<9;z++)
				if( ship_owned[i]->bmp_ship_obj == bmp_ship[z] ) o_game_file << z << endl;

			o_game_file << ship_owned[i]->ab_force << endl;
			o_game_file << ship_owned[i]->ab_mass << endl;
			o_game_file << ship_owned[i]->ab_usage << endl;
			o_game_file << ship_owned[i]->antimatter_mass << endl;
			o_game_file << ship_owned[i]->armour_mass << endl;
			o_game_file << ship_owned[i]->armour_protection << endl;
			o_game_file << ship_owned[i]->charge_count << endl;
			o_game_file << ship_owned[i]->charge_force << endl;
			o_game_file << ship_owned[i]->charge_mass << endl;
			o_game_file << ship_owned[i]->charge_max << endl;
			o_game_file << ship_owned[i]->charge_usage << endl;
			o_game_file << ship_owned[i]->charge_wait << endl;
			o_game_file << ship_owned[i]->engine_force << endl;
			o_game_file << ship_owned[i]->engine_mass << endl;
			o_game_file << ship_owned[i]->engine_usage << endl;
			o_game_file << ship_owned[i]->enrgy_max << endl;
			o_game_file << ship_owned[i]->enrgy_mtr_mass << endl;
			o_game_file << ship_owned[i]->enrgy_mtr_rate << endl;
			o_game_file << ship_owned[i]->total_mass << endl;
			o_game_file << ship_owned[i]->total_price << endl;
			o_game_file << ship_owned[i]->trash_mass << endl;
			o_game_file << ship_owned[i]->turner_force << endl;
			o_game_file << ship_owned[i]->turner_mass << endl;
			o_game_file << ship_owned[i]->w_accuracy << endl;
			o_game_file << ship_owned[i]->w_damage << endl;
			o_game_file << ship_owned[i]->w_distortion << endl;
			o_game_file << ship_owned[i]->w_mass << endl;
			o_game_file << ship_owned[i]->w_shot_wait << endl;
			o_game_file << ship_owned[i]->w_usage << endl;

			for(int w=0;w<9;w++)
			{
				o_game_file << ship_owned[i]->part[w].ab_force << endl;
				o_game_file << ship_owned[i]->part[w].ab_mass << endl;
				o_game_file << ship_owned[i]->part[w].ab_usage << endl;
				o_game_file << ship_owned[i]->part[w].antimatter_mass << endl;
				o_game_file << ship_owned[i]->part[w].armour_mass << endl;
				o_game_file << ship_owned[i]->part[w].armour_protection << endl;
				o_game_file << ship_owned[i]->part[w].charge_count << endl;
				o_game_file << ship_owned[i]->part[w].charge_force << endl;
				o_game_file << ship_owned[i]->part[w].charge_mass << endl;
				o_game_file << ship_owned[i]->part[w].charge_max << endl;
				o_game_file << ship_owned[i]->part[w].charge_usage << endl;
				o_game_file << ship_owned[i]->part[w].charge_wait << endl;
				o_game_file << ship_owned[i]->part[w].engine_force << endl;
				o_game_file << ship_owned[i]->part[w].engine_mass << endl;
				o_game_file << ship_owned[i]->part[w].engine_usage << endl;
				o_game_file << ship_owned[i]->part[w].enrgy_max << endl;
				o_game_file << ship_owned[i]->part[w].enrgy_mtr_mass << endl;
				o_game_file << ship_owned[i]->part[w].enrgy_mtr_rate << endl;
				o_game_file << ship_owned[i]->part[w].price << endl;
				o_game_file << ship_owned[i]->part[w].trash_mass << endl;
				o_game_file << ship_owned[i]->part[w].turner_force << endl;
				o_game_file << ship_owned[i]->part[w].turner_mass << endl;
				o_game_file << ship_owned[i]->part[w].w_accuracy << endl;
				o_game_file << ship_owned[i]->part[w].w_damage << endl;
				o_game_file << ship_owned[i]->part[w].w_distortion << endl;
				o_game_file << ship_owned[i]->part[w].w_mass << endl;
				o_game_file << ship_owned[i]->part[w].w_shot_wait << endl;
				o_game_file << ship_owned[i]->part[w].w_usage << endl;
			}
		}
		else
		{
			o_game_file << "NULLSHIP" << endl;
		}
	}

	o_game_file.close();
}

void create_ai_ships(int amount, double difficulty, double dif_variance, bool &charges, bool &ab, bool &weap, int ship_type, bool all_ships)
{	
	max_ai = amount;
	if( max_ai == -1 ) max_ai = 0;

	int shift=1, dif_var=0;

	dif_variance*=((difficulty+10)/35);
	dif_var = dif_variance;

	if( amount==-1 )
	{
		for(int i=0;i<9;i++)
		{
			if( ship_owned[i] && i != Ship_Selected )
			{
				Object *owned = new Object();

				owned->ship_obj = ship_owned[i];
				owned->ship_obj->charge_count = owned->ship_obj->charge_max;
				owned->ship_obj->parent_obj = owned;
				owned->bmp_obj = owned->ship_obj->bmp_ship_obj;

				owned->X = 320 + ((40*shift) * ((max_ai%2*2)-1) );
				shift+=max_ai%2;
				owned->Y = 250;
				owned->speed_X = 0;
				owned->speed_Y = 0;
				owned->angle = 180;

				owned->ship_obj->cur_node = 0;

				owned->ship_obj->energy = owned->ship_obj->enrgy_max;

				owned->ship_obj->CalculateMass();

				owned->ship_obj->type = 1;

				max_ai++;
			}
		}
	}
	else
	{
		for(int i=0;i<amount;i++)
		{
			Ship *ai = new Ship();

			if( dif_var > 0 )
			{
				difficulty+=((rand()%dif_var)-(dif_var*.5));
				if( difficulty<0.0 ) difficulty=0.0;
			}

			ai->parent_obj->X = 320 + ((40*shift) * ((i%2*2)-1) );
			shift+=i%2;
			ai->parent_obj->Y = 250;
			ai->parent_obj->speed_X = 0;
			ai->parent_obj->speed_Y = 0;
			ai->cur_node = 0;

			if( all_ships ) { ai->parent_obj->bmp_obj = bmp_ship[i]; ai->type = i; }
			else if( ship_type == -1 ) { ai->type = rand()%9; ai->parent_obj->bmp_obj = bmp_ship[ai->type]; }
			else { ai->parent_obj->bmp_obj = bmp_ship[ship_type]; ai->type = ship_type; }
			ai->parent_obj->angle = 180;
			ai->parent_obj->dest_angle = 180;
			ai->parent_obj->mass = 2.5;

			ai->engine_force = (difficulty*0.107)+0.325;
			ai->engine_mass = 7.5;
			ai->engine_usage = difficulty*0.02;

			ai->enrgy_max = (difficulty*10)+200;
			ai->enrgy_mtr_rate = (difficulty*0.1)+0.2;
			ai->enrgy_mtr_mass = 5;
			ai->energy = ai->enrgy_max;

			ai->turner_force = (difficulty*4)+25;
			ai->turner_mass = 5;

			if( ab )
			{
				ai->ab_force = (0.14*difficulty)+0.6;
				ai->ab_mass = 3;
				ai->ab_usage = 0.63;
			}
			if( charges )
			{
				ai->charge_count = 0;
				ai->charge_max = 0;
				ai->charge_usage = 70;
				ai->charge_mass = 3;
				ai->charge_force = (difficulty*10)+22;
				ai->charge_tick = 0;
			}
			if( weap )
			{
				ai->armour_mass = 2;
				ai->armour_protection = ((difficulty*2)*0.01)+0.4;

				ai->w_accuracy = (difficulty*3.2)+10;
				ai->w_damage = (difficulty*0.8)+3;
				ai->w_distortion = (difficulty*3.5)+30;
				ai->w_mass = 2;
				ai->w_shot_wait = (150-(difficulty*5))+40;
				ai->w_usage = 25;
			}

			ai->hull = 100;

			ai->CalculateMass();

	//		player_obj = ai->parent_obj;
		}
	}
}

void create_random_track(int p_nodes, int angle_variation, int node_dist, bool dist_var)
{
	max_nodes = p_nodes;

	path_node[0] = new Object();

	path_node[0]->X = 320;
	path_node[0]->Y = 350;
	path_node[0]->speed_X = 0;
	path_node[0]->speed_Y = 0;
	path_node[0]->bmp_obj = (BITMAP *)data[ls_node_FST].dat; // load_pcx("node_FST.pcx",NULL);
	path_node[0]->angle = 180;

	for(int i=1;i<p_nodes;i++)
	{
		if( angle_variation> 0 )
		{
			double_math[0] = path_node[i-1]->angle+(rand()%angle_variation-(angle_variation*0.5));
			if(double_math[0]>360)double_math[0]-=360;
			else if(double_math[0]<0)double_math[0]+=360;
		}
		else double_math[0] = 180;

		if(dist_var) double_math[1] = node_dist*((100-(rand()%31-15))*0.01);
		else double_math[1] = node_dist;

		if( detail_lvl > 3)
		{
			for(int j=0;j<2;j++)
			{
				Object *no = new Object(2);

				int_math[9] = rand()%3;
	
				no->angle = rand()%360;
				no->bmp_obj = spacething[int_math[9]];
				no->Z = .3;

				int_math[8] = rand()%360;
				double_math[8] = double_math[1]*((100-(rand()%200-100))*0.01);
				no->X = (path_node[i-1]->X*1.97)-(MoveToValue(double_math[0]+int_math[8],false)*(double_math[8]) );
				no->Y = (path_node[i-1]->Y*1.97)-(MoveToValue(double_math[0]+int_math[8],true)*(double_math[8]) );
			}
		}

		path_node[i] = new Object();

		path_node[i]->X = path_node[i-1]->X-(MoveToValue(double_math[0],false)*double_math[1]);
		path_node[i]->Y = path_node[i-1]->Y-(MoveToValue(double_math[0],true)*double_math[1]);
		path_node[i]->speed_X = 0;
		path_node[i]->angle = double_math[0];
		path_node[i]->speed_Y = 0;

		if(i != p_nodes-1) path_node[i]->bmp_obj = (BITMAP *)data[ls_node_NO].dat; // load_pcx("node_NO.pcx",NULL);
		else path_node[i]->bmp_obj = (BITMAP *)data[ls_node_LST].dat; // load_pcx("node_LST.pcx",NULL); }
	}
}

void __inline race_input()
{
	if( key[KEY_ESC] )
	{
		if( !DownKey )
		{
			DownKey = true;

			racing = false;
			position = -1;
			times_done = 50;
		}
	}
	else if( key[KEY_RSHIFT] )
	{
		if( !DownKey )
		{
			DownKey = true;

			if(player_obj->ship_obj->charge_force>0) player_obj->ship_obj->UseCharge();
		}
	}
	else { DownKey = false; }
	
	if( key[KEY_RCONTROL] && player_obj->ship_obj->energy>player_obj->ship_obj->ab_usage && player_obj->ship_obj->ab_force>0 ) { player_obj->ship_obj->Accelerate(player_obj->ship_obj->ab_force,0,true,true,3); player_obj->ship_obj->energy-=player_obj->ship_obj->ab_usage; }
	else if( key[KEY_UP] && player_obj->ship_obj->energy>player_obj->ship_obj->engine_usage && player_obj->ship_obj->engine_force>0 ) { player_obj->ship_obj->Accelerate(player_obj->ship_obj->engine_force,0,true); player_obj->ship_obj->energy-=player_obj->ship_obj->engine_usage; }
	else if( key[KEY_DOWN] && player_obj->ship_obj->energy > player_obj->ship_obj->engine_usage && player_obj->ship_obj->engine_force>0 ) { player_obj->ship_obj->Accelerate(player_obj->ship_obj->engine_force*0.6,180,true); player_obj->ship_obj->energy-=player_obj->ship_obj->engine_usage; }
	else { stop_sample(SND_engine); eng_playing = false; }

	if( key[KEY_RIGHT] && player_obj->ship_obj->turner_force>0 ) player_obj->ship_obj->Turn(false);
	else if( key[KEY_LEFT] && player_obj->ship_obj->turner_force>0 ) player_obj->ship_obj->Turn(true);

	if( key[KEY_ENTER] && player_obj->ship_obj->targetting ) player_obj->ship_obj->Fire(player_obj->ship_obj->targetting);
}

void __inline do_objects()
{
//	int i=0;

	position = 1; locked_player = false;
	double_math[20] = 45;
	player_obj->ship_obj->targetting = NULL;

	circle(buffer,960,240,103,WhiteFade[20]);

	for(scan=F_Obj.next_obj;scan!=&L_Obj;scan=scan->next_obj)
	{
		scan->Update();
//		if(!racing)return;
		scan->Draw_Obj();
	}

	if( player_obj->ship_obj->targetting ) 
	{
		double_math[10] = (player_obj->ship_obj->targetting->X-Screen_X)+640-(player_obj->ship_obj->targetting->bmp_obj->w*.5);
		double_math[11] = (player_obj->ship_obj->targetting->Y-Screen_Y)-(player_obj->ship_obj->targetting->bmp_obj->h*.5);
		rect(buffer,double_math[10],double_math[11],double_math[10]+player_obj->ship_obj->targetting->bmp_obj->w,double_math[11]+player_obj->ship_obj->targetting->bmp_obj->h,RedFade[150]);
	}

	if( locked_player ) rect(buffer,945,225,975,255,RedFade[150]);

//	textprintf(buffer,font,640,0,65535,"%i",i);
}

void race_game()
{
	save_game();

	racing = true;

	eng_playing = false;

	show_mouse(NULL);

	player_obj->ship_obj->hull = 100;

	Object *scan = F_Obj.next_obj;

	bool waiting = true;

	//df << "Starting the race game..." << endl;

	clear_bitmap(screen);
	clear_bitmap(buffer);

	circle(buffer,960,240,103,WhiteFade[20]);

	for(;scan!=&L_Obj;scan=scan->next_obj)
		scan->Draw_Obj();

	position = 1;

	draw_gui();

	while( ticks < 240 )
	{
		c_tick = retrace_count;

		ticks++;
		
		if(ticks==60) play_sample(SND_beep,255,128,1000,false);
		else if(ticks==120) play_sample(SND_beep,255,128,1000,false);
		else if(ticks==180) play_sample(SND_beep,255,128,1300,false);
		else if(ticks==239) play_sample(SND_beep,255,128,2000,false);

		if(ticks>=60) circlefill(buffer,220+640,50,35,RedFade[225]);
		else circlefill(buffer,220+640,50,25,RedFade[75]);
		if(ticks>=120) circlefill(buffer,320+640,50,35,RedFade[225]);
		else circlefill(buffer,320+640,50,25,RedFade[75]);
		if(ticks>=180) circlefill(buffer,420+640,50,35,YellowFade[225]);
		else circlefill(buffer,420+640,50,25,YellowFade[75]);

		blit(buffer,screen,640,0,0,0,640,480);

		while( !(retrace_count - c_tick) ) { yield_timeslice(); }
	}

	ticks=0;

	while( racing )
	{
		c_tick = retrace_count;

		ticks++;
		if( ticks >= 60 ) { seconds++; ticks=0; }
		if( seconds >= 60 ) { minutes++; seconds=0; }

		//df << "Acquiring screen.." << endl;
		acquire_screen();
		//df << "Doing objects.." << endl;
		do_objects();
//		if(!racing)break;
		//df << "Drawing objects.." << endl;
		draw_gui();
//		vsync();
		//df << "Blitting screen.." << endl;
		blit(buffer,screen,640,0,0,0,640,480);
		clear_bitmap(buffer);
		//df << "Releasing screen.." << endl;
		release_screen();
		//df << "Inputting controls.." << endl;
		race_input();

		while( !(retrace_count - c_tick) ) { yield_timeslice(); }
	}

	//df << "Race game over, showing results.." << endl;

	release_screen();

	show_mouse(NULL);

	stop_sample(SND_engine);

	if( race[race_num].num_of_races>0 && position != -1 )
	{
		if( position == 1 )
		{
			masked_blit(end_1,screen,0,0,220,195,200,50);
			textprintf_centre(screen,font,320,250,65535,"Points: 5");
			point_holder[9]+=5;
			textprintf_centre(screen,font,320,260,WhiteFade[100],"Press [ESC] to continue.");
			play_sample(SND_fp,255,128,1000,false);

			if( race[race_num].dif>=24 && player_obj->ship_obj->stars<4 ) player_obj->ship_obj->stars=4;
			else if( race[race_num].dif>=18 && player_obj->ship_obj->stars<3 ) player_obj->ship_obj->stars=3;
			else if( race[race_num].dif>=12 && player_obj->ship_obj->stars<2 ) player_obj->ship_obj->stars=2;
			else if( race[race_num].dif>=5 && player_obj->ship_obj->stars<1 ) player_obj->ship_obj->stars=1;
		}
		else if( position == 2 )
		{
			masked_blit(end_2,screen,0,0,220,195,200,50);
			textprintf_centre(screen,font,320,250,65535,"Points: 3");
			point_holder[9]+=3;
			textprintf_centre(screen,font,320,260,WhiteFade[100],"Press [ESC] to continue.");
			play_sample(SND_sp,255,128,1000,false);

			if( race[race_num].dif>=21 && player_obj->ship_obj->stars<3 ) player_obj->ship_obj->stars=3;
			else if( race[race_num].dif>=15 && player_obj->ship_obj->stars<2 ) player_obj->ship_obj->stars=2;
			else if( race[race_num].dif>=8 && player_obj->ship_obj->stars<1 ) player_obj->ship_obj->stars=1;
		}
		else if( position == 3 )
		{
			masked_blit(end_3,screen,0,0,220,195,200,50);
			textprintf_centre(screen,font,320,250,65535,"Points: 1");
			point_holder[9]+=1;
			textprintf_centre(screen,font,320,260,WhiteFade[100],"Press [ESC] to continue.");
			play_sample(SND_tp,255,128,1000,false);

			if( race[race_num].dif>=17 && player_obj->ship_obj->stars<2 ) player_obj->ship_obj->stars=2;
			else if( race[race_num].dif>=10 && player_obj->ship_obj->stars<1 ) player_obj->ship_obj->stars=1;
		}
		else
		{
			masked_blit(end_out,screen,0,0,220,195,200,50);
			textprintf_centre(screen,font,320,250,65535,"Points: 0");
			textprintf_centre(screen,font,320,260,WhiteFade[100],"Press [ESC] to continue.");
			play_sample(SND_out,255,128,1000,false);
		}

		//df << "Starting placement..." << endl;

		Object *scan2;

		for(scan=F_Obj.next_obj;scan!=&L_Obj;scan=scan->next_obj)
		{
			if( scan->ship_obj )
			{
				//df << "Found a ship of type " << scan->ship_obj->type << endl;

				scan->ship_obj->use_ab = false;

				if( scan != player_obj )
				{
					//df << "Is not the player.." << endl;

					scan->ship_obj->position = 1;

					if( scan->ship_obj->cur_node<max_nodes-1 )
					{
						//df << "Calculating distance for the node " << scan->ship_obj->cur_node << " to " << scan->ship_obj->cur_node+1 << endl;

						int_math[9] = abs(scan->X-path_node[scan->ship_obj->cur_node+1]->X) + abs(scan->Y-path_node[scan->ship_obj->cur_node+1]->Y);

						for(scan2=F_Obj.next_obj;scan2!=&L_Obj;scan2=scan2->next_obj)
						{
							if( scan != scan2 )
							{
								if( scan2->ship_obj )
								{
									if( scan2->ship_obj->cur_node<max_nodes-1 )
									{
										//df << "Comparing that distance to another ship of type " << scan2->ship_obj->type << endl;

										int_math[8] = abs(scan2->X-path_node[scan2->ship_obj->cur_node+1]->X) + abs(scan2->Y-path_node[scan2->ship_obj->cur_node+1]->Y);

										//df << "Created the int_math[8]" << endl;

										if(	int_math[9] > int_math[8] && scan->ship_obj->cur_node == scan2->ship_obj->cur_node || scan->ship_obj->cur_node < scan2->ship_obj->cur_node ) scan->ship_obj->position++;

										//df << "Made the comparison." << endl;
									}
									else scan->ship_obj->position++;
								}
							}

							//df << "Going to next scan2 object..." << endl;
						}

						//df << "Done with the loop." << endl;
					}

					if( scan->ship_obj->position == 1 ) point_holder[scan->ship_obj->type]+=5;
					if( scan->ship_obj->position == 2 ) point_holder[scan->ship_obj->type]+=3;
					else if( scan->ship_obj->position == 3 ) point_holder[scan->ship_obj->type]+=1;

					//df << "Now has points of " << point_holder[scan->ship_obj->type] << endl;
				}
			}
		}

		//df << "Creating place variable..," << endl;

		Object *place[4];

		for(int i=0;i<4;i++)
		{
			int_math[0] = 0;

			//df << "Setting place " << i << endl;

			if( !(i==3 && !player_obj->ship_obj->use_ab) )
			{
				for(scan=F_Obj.next_obj;scan!=&L_Obj;scan=scan->next_obj)
				{
					if( scan->ship_obj )
					{
						//df << "Found a ship of type " << scan->ship_obj->type << endl;

						if( !scan->ship_obj->use_ab )
						{
							if( int_math[0] <= point_holder[scan->ship_obj->type] )
							{
								int_math[0] = point_holder[scan->ship_obj->type];
								place[i] = scan;
							}
						}
					}
				}

				//df << "Assigning the position" << endl;

				place[i]->ship_obj->use_ab = true;
				place[i]->ship_obj->position = i;
				if( place[i] == player_obj ) position = (i+1);
			}
			else
			{
				//df << "Found player in last place." << endl;
				place[3] = player_obj;
				place[3]->ship_obj->use_ab = true;
				position = 4;
			}

			//df << "Drawing graphic..." << endl;
			masked_blit(place[i]->bmp_obj,screen,0,0,240,300+(35*i),place[i]->bmp_obj->w,place[i]->bmp_obj->h);
			//df << "Printing line..." << endl;
			textprintf(screen,font,260,315+(35*i),(place[i]==player_obj)?GreenFade[250]:WhiteFade[250],"Place[%i] Points[%i]",(place[i]==player_obj)?position:(i+1),point_holder[place[i]->ship_obj->type]);
		}

		//df << "Done printing stuff..." << endl;

		if( (race[race_num].num_of_races+1)==(times_done+2) )
		{
			while( !key[KEY_ESC] ) { yield_timeslice(); }

			clear_bitmap(screen);

			textprintf_centre(screen,font,320,80,65535,"[ Championship Results ]");

			if( position == 1 )
			{ 
				//df << "Showing 1st place..." << endl;
				credits+=max_purse;
				masked_blit(end_1,screen,0,0,220,195,200,50);
				textprintf_centre(screen,font,320,250,65535,"Winnings: %.3f",max_purse);
				textprintf_centre(screen,font,320,260,WhiteFade[100],"Press [ESC] to return.");
				play_sample(SND_fp,255,128,1000,false);

				if( race[race_num].dif >= 24 ) player_obj->ship_obj->stars = 5;
			}
			else if( position == 2 )
			{
				//df << "Showing 2nd place..." << endl;
				credits+=(max_purse*0.6);
				masked_blit(end_2,screen,0,0,220,195,200,50);
				textprintf_centre(screen,font,320,250,65535,"Winnings: %.3f",max_purse*0.6);
				textprintf_centre(screen,font,320,260,WhiteFade[100],"Press [ESC] to return.");
				play_sample(SND_sp,255,128,1000,false);
			}
			else if( position == 3 )
			{
				//df << "Showing 3rd place..." << endl;
				credits+=(max_purse*0.3);
				masked_blit(end_3,screen,0,0,220,195,200,50);
				textprintf_centre(screen,font,320,250,65535,"Winnings: %.3f",max_purse*0.3);
				textprintf_centre(screen,font,320,260,WhiteFade[100],"Press [ESC] to return.");
				play_sample(SND_tp,255,128,1000,false);
			}
			else
			{
				//df << "Showing out..." << endl;
				masked_blit(end_out,screen,0,0,220,195,200,50);
				textprintf_centre(screen,font,320,250,65535,"Winnings: 0");
				textprintf_centre(screen,font,320,260,WhiteFade[100],"Press [ESC] to return.");
				play_sample(SND_out,255,128,1000,false);
			}
		}
	}
	else if( max_purse == 0 )
	{
		masked_blit(end_comp,screen,0,0,220,215,200,50);
		textprintf_centre(screen,font,320,260,WhiteFade[100],"Press [ESC] to return.");
		play_sample(SND_comp,255,128,1000,false);
	}
	else if( position == 1 && max_ai > 0 )
	{ 
		//df << "Showing 1st place..." << endl;
		credits+=max_purse;
		masked_blit(end_1,screen,0,0,220,195,200,50);
		textprintf_centre(screen,font,320,250,65535,"Winnings: %.3f",max_purse);
		textprintf_centre(screen,font,320,260,WhiteFade[100],"Press [ESC] to return.");
		play_sample(SND_fp,255,128,1000,false);

		if( race[race_num].dif>=24 && player_obj->ship_obj->stars<4 ) player_obj->ship_obj->stars=4;
		else if( race[race_num].dif>=18 && player_obj->ship_obj->stars<3 ) player_obj->ship_obj->stars=3;
		else if( race[race_num].dif>=12 && player_obj->ship_obj->stars<2 ) player_obj->ship_obj->stars=2;
		else if( race[race_num].dif>=5 && player_obj->ship_obj->stars<1 ) player_obj->ship_obj->stars=1;
	}
	else if( position == 2 && max_ai > 1 )
	{
		//df << "Showing 2nd place..." << endl;
		credits+=(max_purse*0.6);
		masked_blit(end_2,screen,0,0,220,195,200,50);
		textprintf_centre(screen,font,320,250,65535,"Winnings: %.3f",max_purse*0.6);
		textprintf_centre(screen,font,320,260,WhiteFade[100],"Press [ESC] to return.");
		play_sample(SND_sp,255,128,1000,false);

		if( race[race_num].dif>=21 && player_obj->ship_obj->stars<3 ) player_obj->ship_obj->stars=3;
		else if( race[race_num].dif>=15 && player_obj->ship_obj->stars<2 ) player_obj->ship_obj->stars=2;
		else if( race[race_num].dif>=8 && player_obj->ship_obj->stars<1 ) player_obj->ship_obj->stars=1;
	}
	else if( position == 3 && max_ai > 2 )
	{
		//df << "Showing 3rd place..." << endl;
		credits+=(max_purse*0.3);
		masked_blit(end_3,screen,0,0,220,195,200,50);
		textprintf_centre(screen,font,320,250,65535,"Winnings: %.3f",max_purse*0.3);
		textprintf_centre(screen,font,320,260,WhiteFade[100],"Press [ESC] to return.");
		play_sample(SND_tp,255,128,1000,false);

		if( race[race_num].dif>=17 && player_obj->ship_obj->stars<2 ) player_obj->ship_obj->stars=2;
		else if( race[race_num].dif>=10 && player_obj->ship_obj->stars<1 ) player_obj->ship_obj->stars=1;
	}
	else
	{
		//df << "Showing out..." << endl;
		masked_blit(end_out,screen,0,0,220,195,200,50);
		textprintf_centre(screen,font,320,250,65535,"Winnings: 0");
		textprintf_centre(screen,font,320,260,WhiteFade[100],"Press [ESC] to return.");
		play_sample(SND_out,255,128,1000,false);
	}

	//df << "Entering ENTER loop..." << endl;
	while( key[KEY_ESC] ) { yield_timeslice(); }

	while( !key[KEY_ESC] ) { yield_timeslice(); }

	//df << "Done." << endl;
	
	FreeMemory();

	//reset_lists();

	//df << "Back to the main menu..." << endl;
}

void init_stars()
{
	int star_amt=40;
	if( detail_lvl < 3 ) star_amt=20;

	for(int i=0;i<star_amt;i++)
	{
		stars[i] = new Particle(-1,65535);

		stars[i]->parent_obj->Z = (rand()%4+1)*.2;
		stars[i]->parent_obj->X = rand()%640/stars[i]->parent_obj->Z;
		stars[i]->parent_obj->Y = rand()%480/stars[i]->parent_obj->Z;
		stars[i]->parent_obj->speed_X = 0;
		stars[i]->parent_obj->speed_Y = 0;
		stars[i]->cur_color = WhiteFade[(int)((stars[i]->parent_obj->Z)*250)];
		stars[i]->stay_on_screen = true;
		stars[i]->max_life = -1;
	}
}

void load_ships(int slot)
{
	if( slot==1 ) game_file = "game1.sav";
	else if( slot==2 ) game_file = "game2.sav";
	else if( slot==3 ) game_file = "game3.sav";
	else if( slot==4 ) game_file = "game4.sav";
	else if( slot==5 ) game_file = "game5.sav";
	else if( slot==6 ) game_file = "game6.sav";
	else if( slot==7 ) game_file = "game7.sav";
	else if( slot==8 ) game_file = "game8.sav";
	else if( slot==9 ) game_file = "game9.sav";

	for(int i=0;i<9;i++)
		ship_owned[i] = NULL;

	if( exists(game_file.c_str()) )
	{
		load_game();
	}
	else
	{
		credits=200;
		debt=2500;
		debt_days=100;

		ship_owned[0] = new Ship();

		ship_owned[0]->bmp_ship_obj = bmp_ship[6];
		ship_owned[0]->type = 6;
		ship_owned[0]->engine_force = 0.425;
		ship_owned[0]->engine_mass = 8.0;
		ship_owned[0]->engine_usage = 0.065;

		ship_owned[0]->enrgy_max = 215;
		ship_owned[0]->enrgy_mtr_rate = 0.1;
		ship_owned[0]->enrgy_mtr_mass = 6;

		ship_owned[0]->turner_force = 25;
		ship_owned[0]->turner_mass = 6;

		ship_owned[0]->CalculateMass();
	}

}

int pick_slot()
{
	clear_bitmap(screen);

	double the_credits=0;

	char ch_buf[20];
	string loading_file = "";
	string number = "";

	for(int i=1;i<10;i++)
	{
		number = itoa(i,ch_buf,10);
		loading_file = "game" + number + ".sav";

		textprintf_centre(screen,font,320,125,BlueFade[250],"[ Light Speed v2.4 - Choose Game Slot ]");

		if( exists(loading_file.c_str()) )
		{
			ifstream credit_check;
			credit_check.open(loading_file.c_str());
			credit_check >> the_credits;
			textprintf_centre(screen,font,320,(200+(i*10)),GreenFade[200],"[%i] - Slot %i - Credits[%.3f]",i,i,the_credits);
			credit_check.close();
		}
		else textprintf_centre(screen,font,320,(200+(i*10)),RedFade[150],"[%i] - Slot %i - Empty",i,i);
	}

	textprintf_centre(screen,font,320,340,BlueFade[250],"Press the desired slot number to continue.");

	while( true )
	{
		readkey();

		if( key[KEY_1] ) return 1;
		if( key[KEY_2] ) return 2;
		if(	key[KEY_3] ) return 3;
		if( key[KEY_4] ) return 4;
		if( key[KEY_5] ) return 5;
		if( key[KEY_6] ) return 6;
		if( key[KEY_7] ) return 7;
		if( key[KEY_8] ) return 8;
		if( key[KEY_9] ) return 9;
	}
}

void reset_player()
{
	player_obj = new Object();

	player_obj->ship_obj = ship_owned[Ship_Selected];
	player_obj->ship_obj->charge_count = player_obj->ship_obj->charge_max;
	player_obj->ship_obj->parent_obj = player_obj;
	player_obj->bmp_obj = player_obj->ship_obj->bmp_ship_obj;

	player_obj->X = 320;
	player_obj->Y = 250;
	player_obj->speed_X = 0;
	player_obj->speed_Y = 0;
	player_obj->angle = 180;
	player_obj->ship_obj->charge_tick = 0;

	player_obj->ship_obj->cur_node = 0;

	player_obj->ship_obj->energy = player_obj->ship_obj->enrgy_max;

	ticks = 0;
	minutes = 0;
	seconds = 0;

	player_obj->ship_obj->CalculateMass();

	player_obj->ship_obj->type = 9;

	Screen_X = player_obj->X-320;
	Screen_Y = player_obj->Y-240;
}

void main()
{
	//df.open("debug.log");
	//df.precision(5);

	//df << "Installing stuff.." << endl;

	allegro_init();

	install_keyboard();
	install_timer();
	install_mouse();

	install_sound(DIGI_AUTODETECT,MIDI_NONE,NULL);

	srand( time(NULL) );

	//df << "Resetting lists.." << endl;

	reset_lists();
	//df << "Init graphics.." << endl;
	init_graphics();
	//df << "Load ships.." << endl;
	load_ships( pick_slot() );

	play_sample(SND_click,255,128,1000,false);
	//df << "Reset lists again.." << endl;
	//reset_lists();
	FreeMemory();
	//df << "Set stars.." << endl;

	main_menu();

	Quit();
}

END_OF_MAIN();