#define __GTHREAD_HIDE_WIN32API 1

#include <allegro.h>
#include <string>

#include "types.h"
#include "prepare.h"
#include "objects.h"
#include "game.h"
#include "level.h"
#include "player.h"

using namespace std;

// ###########################################################
// ######   FUNKCJE KLASY PLAYER   ###########################
// ###########################################################

Player::Player(Game *aGame)
{
  classes = "/Obj/SpaceObj/MovableObj/Player/";

  for(direction d = dirNorth; d <= dirWest; d = (direction)((int)d + 1))
    assignImage(player_sprite[3 - d], d);

  turned = dirNorth;
  flat = 0;
  objectHeight = 20;
  myGame = aGame;
  movesMade = 0;
}

// #####################################

void Player::die(char *reason)
{
  parent->popObj();
  myGame->endFlag = 1;
  myGame->endReason = "Something has fallen on his head.";
}

// #####################################

void Player::turn(direction todir)
{
  direction resDir, d;

  turned = todir;

  for(d = dirNorth; d <= dirWest; d = (direction)((int)d + 1))
  {
    resDir = (direction)((turned + 4 - d) % 4);
    assignImage(player_sprite[resDir], d);
  }
}

// #####################################

void Player::receive_key(int key, direction camDir)
{
  enum {meaninglessKey, directionKey, actionKey} keyType;

  direction dirPressed;
  actResult res;

  switch(key)
  {
    case KEY_UP:
    case KEY_9_PAD:
      keyType = directionKey;
      dirPressed = dirEast;
      break;

    case KEY_RIGHT:
    case KEY_6_PAD:
      keyType = directionKey;
      dirPressed = dirSouth;
      break;

    case KEY_DOWN:
    case KEY_5_PAD:
      keyType = directionKey;
      dirPressed = dirWest;
      break;

    case KEY_LEFT:
    case KEY_8_PAD:
      keyType = directionKey;
      dirPressed = dirNorth;
      break;

    case KEY_SPACE:
    case KEY_0_PAD:
      keyType = actionKey;
      break;

    default:
      keyType = meaninglessKey;
  }

  dirPressed = (direction)((dirPressed + camDir) % 4);

  switch(keyType)
  {
    case directionKey:
      if (turned != dirPressed)
        turn(dirPressed);
      else
      {
        res = move(dirPressed);
        if (res!=arRefuse) movesMade++;
      }
      break;

    case actionKey:
      if (parent->neighbour(turned))
      {
        Obj *obj = parent->neighbour(turned)->topObj();
        if (obj)
        {
          res = obj -> doSpaceAction(this, turned);
          if (res!=arRefuse) movesMade++;
        }
      }
      break;
  }
}

// #####################################

actResult Player::receiveAction(actKind kind, Obj *sender, int param)
{
  direction dir;
  dir = (direction) param;

  switch(kind)
  {
    case akMoveAgainst:
      if (dir != dirDown)
        return arRefuse;
      else
      {
        die("Something has fallen on his head.");
        return arAccept;
      }
    default:
      return arAccept;
  }
}

