#define __GTHREAD_HIDE_WIN32API 1

#include <allegro.h>

#include <string>

#include "types.h"
#include "level.h"
#include "objects.h"

using namespace std;

// #######################################################
// ###  FUNKCJE KLASY OBJ  ###############################
// #######################################################

Obj::Obj()
{
  subh = 0;
}

// ##############################

void Obj::assignImage(BITMAP *bmp, direction dir)
{
  if (dir == dirAll)
  {
    for(dir = dirNorth; dir <= dirWest; dir = (direction)((int)dir + 1))
      assignImage(bmp, dir);
  }
  else
  {
    image[dir] = bmp;
    imageHeight[dir] = bmp->h - 1;
  }
}

// ##############################

void Obj::draw(BITMAP *bmp, int x, int y, direction camDir)
{
  draw_sprite(bmp, image[camDir], x, y - subh - imageHeight[camDir]);
}

// ##############################

actResult Obj::doSpaceAction(Player *sender, direction dir)
{
  return arRefuse;
}

// ##############################

char Obj::ofClass(string match)
{
  int res = classes.find("/" + match + "/");
  if (res >= 0)
    return 1;
  else
    return 0;
}

// ###########################################################
// ######   FUNKCJE KLASY MOVABLEOBJ   #######################
// ###########################################################

actResult MovableObj::move(direction dir)
{
   ObjList &changes = parent->lv->changed;

   if (find(changes.begin(), changes.end(), this) == changes.end())
     changes.push_front(this);

   actResult res;
   Obj *old_standing = standingOn;
   Cell *target_cell = parent->neighbour(dir);
   Cell *target_below_cell = (target_cell) ? target_cell->neighbour(dirDown) : NULL;
   Cell *old_above = parent->neighbour(dirUp);
   char wasMoveOn = 0;

   if (!target_cell) return arRefuse;
   if (parent->lv->height[target_cell->levx][target_cell->levy]==-1) return arRefuse;

   if (standingOn)
   {
     res = standingOn->receiveAction(akLeave, this, dir);
     if (res!=arAccept) return res;
   }

   if (!target_cell->empty())
   {
     for(int i = 0; i < target_cell->objsFirstFree; i++)
     {
       Obj *o = target_cell->objs[i];
       if (o->flat)
       {
         res = o->receiveAction(akMoveOn, this, dir);
         wasMoveOn = 1;
       }
       else
   		res = o->receiveAction(akMoveAgainst, this, dir);
       if (res!=arAccept) return res;
     }
   }

   if ((!wasMoveOn) && target_below_cell)
   {
     Obj *o = target_below_cell->topObj();
     if (o)
     {
       res = o->receiveAction(akMoveOn, this, dir);
       if (res!=arAccept) return res;
     }
   }

   parent->popObj();
   target_cell->pushObj(this);

   if (old_standing) old_standing->receiveAction(akLeft, this, dir);
   if (standingOn) standingOn->receiveAction(akMovedOn, this, dir);

   if (dir != dirUp && old_above && (!old_above->empty()))
     if (old_above->topObj()->ofClass("MovableObj"))
       ((MovableObj *)(old_above->topObj()))->move(dir);

   return arAccept;
}


