#define __GTHREAD_HIDE_WIN32API 1

#include "types.h"
#include "objects.h"
#include "level.h"
#include "game.h"

#include "prepare.h"
#include "helpers.h"

// ######################################################
// ###   FUNKCJE KLASY CELL   ###########################
// ######################################################

Cell::Cell(LevelMap *lev, int lx, int ly, int lh)
{
  for(int i = 0; i < 3; i++)
    objs[i] = NULL;
  objsFirstFree = 0;
  objsHeight = 0;
  lv = lev;
  levx = lx; levy = ly; levh = lh;
}

// ##############################

Cell::~Cell()
{
  if (!empty())
    for(int i = 0; i < objsFirstFree; i++)
      delete objs[i];
}

// ##############################

void Cell::draw(BITMAP *bmp, int x, int y, direction camDir)
{
  if (!empty())
    for (int i = 0; i < objsFirstFree; i++)
      objs[i]->draw(bmp, x, y, camDir);
}

// ##############################

Cell* Cell::neighbour(direction dir)
{
  switch(dir)
  {
    case dirWest:  return (levx > 0) ? lv->c[levx - 1][levy][levh] : NULL;
    case dirNorth: return (levy > 0) ? lv->c[levx][levy - 1][levh] : NULL;
    case dirDown:  return (levh > 0) ? lv->c[levx][levy][levh - 1] : NULL;
    case dirEast:  return (levx < lv->size[0] - 1) ? lv->c[levx + 1][levy][levh] : NULL;
    case dirSouth: return (levy < lv->size[1] - 1) ? lv->c[levx][levy + 1][levh] : NULL;
    case dirUp:    return (levh < lv->size[2] - 1) ? lv->c[levx][levy][levh + 1] : NULL;
  }
}

// ##############################

char Cell::empty()
{
  return !objsFirstFree;
}

// ##############################

void Cell::pushObj(Obj *o)
{
  if (objsFirstFree >= 3) return;
  
  if (empty())
  {
    Obj *sOnCandidate = (neighbour(dirDown) ? neighbour(dirDown)->topObj() : NULL);
    if (sOnCandidate && !(sOnCandidate->flat))
      o->standingOn = sOnCandidate;
    else
      o->standingOn = NULL;
    if (lv->height[levx][levy] < levh) lv->height[levx][levy] = levh;
  }
  else
    o->standingOn = topObj();

  o->subh = objsHeight;

  objs[objsFirstFree] = o;
  objsHeight += o->objectHeight;
  objsFirstFree++;

  o->parent = this;
}

// ##############################

Obj* Cell::popObj()
{
  Obj *retObj;
  int h;

  if (empty()) return NULL;

  objsFirstFree--;
  retObj = objs[objsFirstFree];
  objs[objsFirstFree] = NULL;
  objsHeight -= retObj->objectHeight;

  if (empty() && (lv->height[levx][levy] == levh))
  {
    for(h = levh; h > -1; h--)
      if (!lv->c[levx][levy][h]->empty()) break;
    lv->height[levx][levy] = h;
  }

  retObj->parent = NULL;
  retObj->standingOn = NULL;
  return retObj;
}

// ##############################

Obj* Cell::topObj()
{
  if (empty())
    return NULL;
  else
    return objs[objsFirstFree - 1];
}

// ##############################################################
// #######   FUNKCJE KLASY LEVELMAP   ###########################
// ##############################################################

LevelMap::LevelMap(Game *aGame, int size_x, int size_y, int size_h)
{
  myGame = aGame;

  size[0] = size_x; size[1] = size_y; size[2] = size_h;       // zapamietanie rozmiaru levelu

  int x, y, h;

  c = new Cell***[size_x];
  for(x = 0; x < size_x; x++)
  {
    c[x] = new Cell**[size_y];
    for(y = 0; y < size_y; y++)
      c[x][y] = new Cell*[size_h];
  }                                                 // stworzenie tablicy komorek

  height = new char*[size_x];
  for(x = 0; x < size_x; x++)
    height[x] = new char[size_y];                    // stworzenie tablicy wysokosci

  for(x = 0; x < size[0]; x++)
    for(y = 0; y < size[1]; y++)
    {
      for(h = 0; h < size[2]; h++)
      {
        c[x][y][h] = new Cell(this, x, y, h);
      }
      height[x][y] = -1;
    }

  camDir = dirNorth;
  recountRenderPos();
  needsFullRedraw = 1;
}

// ##############################

LevelMap::~LevelMap()
{
  int x, y, h;

  for (x = 0; x < size[0]; x++)
    for (y = 0; y < size[1]; y++)
      for (h = 0; h < size[2]; h++)
        delete c[x][y][h];

  for (x = 0; x < size[0]; x++)
  {
    for (y = 0; y < size[1]; y++)
      delete [] c[x][y];
    delete [] c[x];
    delete [] height[x];
  }
  delete [] c;
  delete [] height;
}

// ###############################

void LevelMap::render_it(BITMAP *bmp, int drawx, int drawy)
{
  int xstart, ystart;
  int x, y, h;

  drawx += renderX;
  drawy += renderY;
  
  switch(camDir)
  {
   case dirNorth:
    for(xstart = size[0] - 1; xstart > -size[1]; xstart--)
      for(x = xstart, y = 0; x < size[0] && y < size[1]; x++, y++)
        if (x>=0)
          for(h = 0; h <= height[x][y]; h++)
            if(!c[x][y][h]->empty())
              c[x][y][h]->draw(bmp, drawx + x * 16 + y * 16, drawy - x * 8 + y * 8 - h * 20, dirNorth);
    break;

   case dirEast:
    for(ystart = size[1] - 1; ystart > -size[0]; ystart--)
      for(y = ystart, x = size[0]-1; x >= 0 && y < size[1]; x--, y++)
        if (y>=0)
          for(h = 0; h <= height[x][y]; h++)
            if(!c[x][y][h]->empty())
              c[x][y][h]->draw(bmp, drawx + y * 16 - x * 16, drawy - x * 8 - y * 8 - h * 20, dirEast);
    break;

   case dirSouth:
    for(xstart = 0; xstart <= 2 * size[1]; xstart++)
      for(x = xstart, y = size[1]-1; x >= 0 && y >= 0; x--, y--)
        if (x < size[0])
          for(h = 0; h <= height[x][y]; h++)
            if (!c[x][y][h]->empty())
              c[x][y][h]->draw(bmp, drawx - y * 16 - x * 16, drawy + x * 8 - y * 8 - h * 20, dirSouth);
    break;

   case dirWest:
    for(ystart = 0; ystart <= 2 * size[1]; ystart++)
      for (y = ystart, x = 0; x < size[0] && y >= 0; x++, y--)
        if (y < size[1])
          for(h = 0; h <= height[x][y]; h++)
            if (!c[x][y][h]->empty())
              c[x][y][h]->draw(bmp, drawx + x * 16 + - y * 16, drawy + x * 8 + y * 8 - h * 20, dirWest);
    break;
  }
}

// ###############################

void LevelMap::recountRenderPos()
{
  switch(camDir)
  {
    case dirNorth:
     renderX = -(size[0] + size[1]) * 8;
     renderY = 12;
     break;

    case dirEast:
     renderX = -16;
     renderY = (size[0] + size[1] + 1) * 4;
     break;

    case dirSouth:
     renderX = (size[0] + size[1] - 4) * 8;
     renderY = 12;
     break;

    case dirWest:
     renderX = -16;
     renderY = -(size[0] + size[1] - 5) * 4;
     break;
  }
}

// ###############################

void LevelMap::getCellRenderXY(int x, int y, int h, int &dx, int &dy)
{
  switch(camDir)
  {
   case dirNorth:
    dx = renderX + x * 16 + y * 16;
    dy = renderY - x * 8 + y * 8 - h * 20;
    break;

   case dirEast:
    dx = renderX + y * 16 - x * 16;
    dy = renderY - x * 8 - y * 8 - h * 20;
    break;

   case dirSouth:
    dx = renderX - y * 16 - x * 16;
    dy = renderY + x * 8 - y * 8 - h * 20;
    break;

   case dirWest:
    dx = renderX + x * 16 + - y * 16;
    dy = renderY + x * 8 + y * 8 - h * 20;
    break;
  }
}

// ###############################

void LevelMap::neccessaryRedraw(BITMAP *bmp, int drawx, int drawy)
{
  if (needsFullRedraw)
    render_it(bmp, drawx, drawy);
  else
    render_it(bmp, drawx, drawy);
}

// ###############################

void LevelMap::gravityDaemon()
{
  ObjList::iterator iter, toErase;
  Obj *what;
  actResult res;

  while(!changed.empty())
  {
    for(iter = changed.begin(); iter != changed.end();)
    {
      what = (*iter);
      if (what->ofClass("MovableObj"))
      {
        res = ((MovableObj *) what)->move(dirDown);
        if (res==arRefuse)
        {
          toErase = iter;
          iter++;
          changed.erase(toErase);
        }
        else
          iter++;
      }
      else
      {
        toErase = iter;
        iter++;
        changed.erase(toErase);
      }
    }
  }
}

// #################################

void LevelMap::requirementsDaemon()
{
  list<RequireObj*>::iterator iter;
  RequireObj *r_obj;
  char allMet = 1;

  reqSum = requireObjsList.size();
  reqMet = 0;

  for(iter = requireObjsList.begin(); iter != requireObjsList.end(); iter++)
  {
    r_obj = (*iter);
    if (!(r_obj->checkRequirement()))
      allMet = 0;
    else
      reqMet++;
  }

  if(allMet)
  {
    myGame->endFlag = 2;
    myGame->endReason = "Level completed.";
  }
}

// ################################

void LevelMap::turnCameraAClockwise()
{
  camDir = (direction)((camDir + 1) % 4);
  recountRenderPos();
}

void LevelMap::turnCameraClockwise()
{
  camDir = (direction)((camDir + 3) % 4);
  recountRenderPos();
}

