#define __GTHREAD_HIDE_WIN32API 1

#include <allegro.h>

#include <string>
#include <iostream>
#include <fstream>
#include <stdlib.h>
#include <stdio.h>

#include "jpgalleg.h"
#include "prepare.h"

using namespace std;

char mousePolling;

DATAFILE *tiles_df, *ply_df, *backs_df, *fonts_df;
BITMAP *tile[12];
BITMAP *player_sprite[4];
BITMAP *buttonSprite[4][2];
BITMAP *gameBackground;

BITMAP *mouseSprite;
FONT *futuraFont;

BITMAP *sparescreen;

const int tile_Floor = 0, tile_Wall[3] = {1, 2, 3}, tile_Box = 4, tile_HeavyBox = 5;
const int tile_Mark = 6, tile_Stairs[4] = {7, 8, 9, 10};
const int tile_EditMark = 11;

const int buttExit = 0, buttReset = 1, buttCamAClock = 2, buttCamClock = 3;

void* get_dataf_object(DATAFILE *dataf, const char *name)
{
  return (find_datafile_object(dataf, name))[0].dat;
}

void read_dataf_button(DATAFILE *dataf, BITMAP **dest, const char *name)
{
  string hlName = name;
  hlName += "_hl";
  
  dest[0] = (BITMAP *) get_dataf_object(dataf, name);
  dest[1] = (BITMAP *) get_dataf_object(dataf, hlName.c_str());
}

void get_tiles()
{
  char buffer[50];
  string t;

  tile[tile_Floor]    = (BITMAP *) get_dataf_object(tiles_df, "floor");
  tile[tile_Box]      = (BITMAP *) get_dataf_object(tiles_df, "box");
  tile[tile_HeavyBox] = (BITMAP *) get_dataf_object(tiles_df, "box_heavy");
  tile[tile_Mark]     = (BITMAP *) get_dataf_object(tiles_df, "mark");

  for(int i = 0; i < 3; i++)
  {
    sprintf(buffer, "%d", i);
    t = buffer;
    tile[tile_Wall[i]] = (BITMAP *) get_dataf_object(tiles_df, ("wall_" + t).c_str());
  };

  for(int i = 0; i < 4; i++)
  {
    sprintf(buffer, "%d", i);
    t = buffer;
    tile[tile_Stairs[i]] = (BITMAP *) get_dataf_object(tiles_df, ("stairs_" + t).c_str());
  };

  tile[tile_EditMark] = (BITMAP *) get_dataf_object(tiles_df, "edit");

}

void get_player()
{
  player_sprite[ps_Stand_N]           = (BITMAP *) get_dataf_object(ply_df, "stand_north");
  player_sprite[ps_Stand_E]           = (BITMAP *) get_dataf_object(ply_df, "stand_east");
  player_sprite[ps_Stand_S]           = (BITMAP *) get_dataf_object(ply_df, "stand_south");
  player_sprite[ps_Stand_W]           = (BITMAP *) get_dataf_object(ply_df, "stand_west");
}

void get_backs()
{
  backs_df = load_datafile("data/backs.dat");
  gameBackground = load_memory_jpg(get_dataf_object(backs_df, "gameback"), NULL);
  unload_datafile(backs_df);
}

void get_fonts()
{
  futuraFont =  (FONT *)   get_dataf_object(fonts_df, "futura");
  mouseSprite = (BITMAP *) get_dataf_object(fonts_df, "mouse_sprite");

  read_dataf_button(fonts_df, buttonSprite[buttExit], "button_exit");
  read_dataf_button(fonts_df, buttonSprite[buttReset], "button_reset");
  read_dataf_button(fonts_df, buttonSprite[buttCamAClock], "button_camaclock");
  read_dataf_button(fonts_df, buttonSprite[buttCamClock], "button_camclock");
}

void game_init_all(char windowed)
{
  allegro_init();

  const int colDepths[4] = {32, 24, 16, 15};
  char gfxSuccess = 0;

  if (windowed)
  {
    int colDepth = desktop_color_depth();
    if (colDepth)
    {
      
      set_color_depth(colDepth);
      gfxSuccess = !(set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0));
      if (!gfxSuccess)
      {
        allegro_message("Unable to open a window on your desktop. Try fullscreen mode maybe?");
        exit(EXIT_FAILURE);
      }
    }
    else
    {
      for (int depth = 0; (depth < 4) && (!gfxSuccess); depth++)
      {
        set_color_depth(colDepths[depth]);
        gfxSuccess = !(set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0));
      }
      if (!gfxSuccess)
      {
        allegro_message("Unable to open a window on your desktop. Try fullscreen mode maybe?");
        exit(EXIT_FAILURE);
      }
    }
  }
  else
  {
    if (file_exists("data/fsgfx.cfg", 0, NULL))
    {
      int colDepth;
      ifstream("data/fsgfx.cfg", ios::in) >> colDepth;
      set_color_depth(colDepth);
      gfxSuccess = !(set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0));
      if (!gfxSuccess)
        delete_file("data/fsgfx.cfg");
    }

    if(!gfxSuccess)
    {
      for (int depth = 0; (depth < 4) && (!gfxSuccess); depth++)
      {
        set_color_depth(colDepths[depth]);
        gfxSuccess = !(set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0));
      }
      if (!gfxSuccess)
      {
        allegro_message("Unable to set any 640x480 fullscreen mode. Try using \"-w\" switch when running the program, this"
                        " will try to open a 640x480 window instead.");
        exit(EXIT_FAILURE);
      }
      else
        ofstream("data/fsgfx.cfg", ios::out) << bitmap_color_depth(screen);
    }
  }

  install_timer();
  install_mouse();
  rest(1000);
  install_keyboard();

  // mousePolling = 1;
  // poll_mouse();
  // this is for debug
  mousePolling = mouse_needs_poll();

  tiles_df = load_datafile("data/maintiles.dat");
  ply_df = load_datafile("data/player.dat");
  fonts_df = load_datafile("data/fonts.dat");

  get_tiles();
  get_player();
  get_backs();
  get_fonts();

  sparescreen = create_bitmap(screen->w, screen->h);
}

void game_done_all()
{
  destroy_bitmap(sparescreen);
  destroy_bitmap(gameBackground);
  unload_datafile(tiles_df);
  unload_datafile(ply_df);
  unload_datafile(fonts_df);
}

