#define __GTHREAD_HIDE_WIN32API 1

#include <allegro.h>
#include <string>

#include "menu.h"
#include "helpers.h"

void Menu::redrawMenu()
{
  text_mode(-1);
  if (withClear) clear(destScreen);
  textout_centre(destScreen, titlefont, title.c_str(), titleX, titleY, titleColor);
  for(int i = 0; i < optCount; i++)
  {
    if (i == chosen)
      rectfill(destScreen, displayX - bandWidth / 2, displayY + optionHeight * i + text_height(menufont) / 2 - bandHeight / 2,
      							 displayX + bandWidth / 2, displayY + optionHeight * i + text_height(menufont) / 2 + bandHeight / 2,
      							 bandColor);
    shadOutlineTextOut(destScreen, menufont, options[i].c_str(), displayX, displayY + optionHeight * i, textColor, textShadColor, jCentre);
  }
  updateFunc();
}

// ##################################

int Menu::menuChoose(char &c)
{
  int k;
  char exit = 0;

  while(!exit)
  {
    redrawMenu();
    while(!keypressed());
    k = readkey() >> 8;
    switch(k)
    {
      case KEY_UP:
        do
        {
          chosen--;
          if (chosen == -1) chosen = optCount - 1;
        } while (options[chosen]=="");
        break;
      case KEY_DOWN:
        do
        {
          chosen++;
          if (chosen == optCount) chosen = 0;
        } while (options[chosen]=="");
        break;
		default:
        c = (char) k;
        exit = 1;
    }
  }

  return chosen;
}


