#define __GTHREAD_HIDE_WIN32API 1

#include <allegro.h>

#include <iostream>
#include <fstream>
#include <string>

#include "types.h"
#include "level.h"
#include "game.h"
#include "advobj.h"
#include "player.h"
#include "levelio.h"

const char header[] = "SALVFILE", packheader[] = "SALVPACK", catheader[] = "LEVELCAT";
const unsigned char fileSysVersion = 1;

LevelMap *readLevelV1(ifstream &f, Game *theGame);
LevelMap *loadLevelFromStream(ifstream &f, Game *theGame);

// ############################################
//     FUNKCJE KLASY LEVELMANAGER
// ############################################

LevelManager::LevelManager()
{
  somethingAttached = 0;
}

// ############################

LevelManager::~LevelManager()
{
  if (somethingAttached)
    detachFromLevelPack();
}

// ############################

char LevelManager::attachToLevelPack(const string fileName)
{
  char buffer[40];

  if (somethingAttached)
    detachFromLevelPack();

  f.open(fileName.c_str(), ios::in | ios::binary);

  if (!f)
  {
    f.clear();
    f.close();
    return 1;
  }

  f.read(buffer, 8);
  buffer[8]='\0';
  if (strcmp(buffer, packheader))
  {
    f.close();
    return 2;
  }

  f.ignore(1);
  f.get(buffer, 40, '\0');
  packName = buffer;

  f.seekg(49, ios::beg);
  levelCount = f.get() * 256;
  levelCount += f.get();

  f.read(buffer, 8);
  buffer[8]='\0';
  if (strcmp(buffer, catheader))
  {
    f.close();
    return 2;
  }

  levelName = new string[levelCount];
  levelPos  = new long[levelCount];

  for(int i = 0; i < levelCount; i++)
  {
    f.seekg(59 + 44 * i, ios::beg);
    f.read((char *)(&levelPos[i]), 4);
    f.get(buffer, 40, '\0');
    levelName[i] = buffer;
  }

  somethingAttached = 1;

  return 0;
}

// ############################

void LevelManager::detachFromLevelPack()
{
  if (!somethingAttached) return;

  f.close();
  levelCount = -1;
  somethingAttached = 0;
  delete [] levelName;
  delete [] levelPos;
}

// ############################

LevelMap *LevelManager::loadLevel(int nr, Game *theGame)
{
  if (!somethingAttached) return NULL;
  if ((nr < 1) || (nr > levelCount)) return NULL;

  f.seekg(levelPos[nr-1], ios::beg);
  char buffer[160];
  LevelMap *retVal = loadLevelFromStream(f, theGame);

  return retVal;
}

// #############################################
//    LUZNE FUNKCJE
// #############################################

char saveLevelToDisk(const char *fileName, LevelMap *lv)
{
  ofstream f;
  int x, y, h, i;
  char maxHeight = 0;
  Obj *o;
  unsigned char saveByte;

  f.open(fileName, ios::out | ios::binary);

  f.write(header, strlen(header));                  // naglowek informujacy o tym, ze jest to plik z levelem
  f.put(fileSysVersion);                            // wersja systemu plikow gry uzyta do zapisania danego pliku
  for(i = 0; i < 3; i++) f.put(lv->size[i]);        // rozmiary levelu zawartego w pliku: x, y, h;

  for(x = 0; x < lv->size[0]; x++)
    for(y = 0; y < lv->size[1]; y++)
      if (lv->height[x][y] > maxHeight) maxHeight = lv->height[x][y];

  maxHeight++;
  f.put(maxHeight);                                 // liczba ZNACZACYCH (niepustych) warstw wysokosci w levelu

  for(h = 0; h < maxHeight; h++)
    for(y = 0; y < lv->size[1]; y++)
      for(x = 0; x < lv->size[0]; x++)
        for(i = 0; i < 3; i++)
        {
          o = lv->c[x][y][h]->objs[i];
          if (o)
          {
            if (o->ofClass("Stairs"))
            {
              Stairs *co = (Stairs *) o;
              saveByte = 0x50 + (char) co->upperEnd;
              f.put(saveByte);
              continue;
            }
            if (o->ofClass("Box"))
            {
              f.put(0x40);
              continue;
            }
            if (o->ofClass("XMark"))
            {
              f.put(0x30);
              continue;
            }
            if (o->ofClass("Player"))
            {
              f.put(0x20);
              continue;
				}
            if (o->ofClass("PlainWall"))
            {
              f.put(0x10);
              continue;
            }
            f.put(0xff);
            f.close();
            return 0;
          }
          else
            f.put(0x00);
        }
  f.close();
  return 1;
}

// ############################

LevelMap *loadLevelFromDisk(const char *fileName, Game *theGame)
{
  ifstream f(fileName, ios::in | ios::binary);

  LevelMap *retValue = loadLevelFromStream(f, theGame);

  f.close();

  return retValue;
}

// ############################

LevelMap *loadLevelFromStream(ifstream &f, Game *theGame)
{
  char buffer[9], ver;
  LevelMap* level;

  f.read(buffer, 8);
  buffer[8] = '\0';
  if (strcmp(buffer, header))
  {
    return NULL;
  }

  ver = f.get();

  switch(ver)
  {
    case 1:
      level = readLevelV1(f, theGame);
      break;
    default:
      return NULL;
  }

  return level;
}


// ############################

LevelMap *readLevelV1(ifstream &f, Game *theGame)
{
  char size[3];
  LevelMap *lv;
  char maxHeight, objIdent;
  int x, y, h, i;

  f.read(size, 3);

  lv = new LevelMap(theGame, size[0], size[1], size[2]);
  maxHeight = f.get();

  for(h = 0; h < maxHeight; h++)
    for(y = 0; y < lv->size[1]; y++)
      for(x = 0; x < lv->size[0]; x++)
        for(i = 0; i < 3; i++)
        {
          objIdent = f.get();

          switch(objIdent)
          {
            case 0x10:
            {
              PlainWall *no = new PlainWall(h);
              lv->c[x][y][h]->pushObj(no);
            }
              break;
            case 0x20:
            {
              Player *no = new Player(theGame);
              lv->c[x][y][h]->pushObj(no);
              if (theGame) theGame->ply = no;
            }
              break;
            case 0x30:
            {
              XMark *no = new XMark();
              lv->c[x][y][h]->pushObj(no);
              lv->requireObjsList.push_front(no);
            }
              break;
            case 0x40:
            {
              Box *no = new Box();
              lv->c[x][y][h]->pushObj(no);
            }
              break;
            case 0x50: case 0x51: case 0x52: case 0x53:
            {
              Stairs *no = new Stairs((direction)(objIdent - 0x50));
              lv->c[x][y][h]->pushObj(no);
            }
              break;
            case 0xff:
              delete lv;
              return NULL;
              break;
          }
        }

  return lv;
}
