#ifndef __GAME_INCLUDED__
#define __GAME_INCLUDED__

#define __GTHREAD_HIDE_WIN32API 1

#include <string>

#include "types.h"
#include "button.h"

using namespace std;

class Game
{
  private:

  LevelMap *level;

  char singleLevel;
  LevelManager * lastLM;
  int lastLevelNr;
  string levelFileName;
  
  ButtonList buttons;

  void update_screen();
  void drawStatusLine();
  void redrawButtons(char mShown);

  public:

  Player *ply;

  char endFlag;
  string endReason;

  Game();
  ~Game();

  void loadLevel(const char *fileName);
  void loadLevel(LevelManager *lm, int nr);
  void reloadLevel();
  void play();
};

#endif
