#define __GTHREAD_HIDE_WIN32API 1

#include <allegro.h>

#include <stdio.h>
#include <string>

#include "types.h"
#include "helpers.h"
#include "prepare.h"
#include "objects.h"
#include "game.h"
#include "player.h"
#include "level.h"
#include "advobj.h"
#include "levelio.h"

using namespace std;

// #######################################

Game::Game()
{
  level = NULL;
  ply = NULL;
  endFlag = 0;
  endReason = "";

  buttons.buttList.push_back(new Button(0, 24, 432, 48, 452, buttonSprite[buttExit][0], buttonSprite[buttExit][1]));
  buttons.buttList.push_back(new Button(1, 56, 431, 89, 453, buttonSprite[buttReset][0], buttonSprite[buttReset][1]));
  buttons.buttList.push_back(new Button(2, 99, 430, 120, 455, buttonSprite[buttCamAClock][0], buttonSprite[buttCamAClock][1]));
  buttons.buttList.push_back(new Button(3, 130, 430, 153, 453, buttonSprite[buttCamClock][0], buttonSprite[buttCamClock][1]));
}

// #######################################

Game::~Game()
{
  delete level;
}

// #######################################

void Game::update_screen()
{
  vsync();
  acquire_screen();
  scare_mouse();
  blit(sparescreen, screen, 0, 0, 0, 0, screen->w, screen->h);
  unscare_mouse();
  release_screen();
}

// #######################################

void Game::loadLevel(const char *fileName)
{
  level = loadLevelFromDisk(fileName, this);
  singleLevel = 1;
  levelFileName = fileName;
}

// #######################################

void Game::loadLevel(LevelManager *lm, int nr)
{
  level = lm->loadLevel(nr, this);
  singleLevel = 0;
  lastLM = lm;
  lastLevelNr = nr;
}

// #######################################

void Game::reloadLevel()
{
  if (singleLevel)
  {
    delete level;
    loadLevel(levelFileName.c_str());
  }
  else
  {
    delete level;
    loadLevel(lastLM, lastLevelNr);
  }
}

// ######################################

void Game::drawStatusLine()
{
  char buffer[10];

  blit(gameBackground, sparescreen, 210, 410, 210, 410, 430, 70);

  string levelNm = "";
  if (lastLevelNr < 10)
    levelNm = "0";
  sprintf(buffer, "%d", lastLevelNr);
  levelNm += buffer;
  levelNm += " - ";
  levelNm += lastLM->levelName[lastLevelNr - 1];
  shadOutlineTextOut(sparescreen, futuraFont, levelNm.c_str(), 517, 432, makecol(255, 255, 0), makecol(0, 0, 0), jCentre);

  itoa(ply->movesMade, buffer, 10);
  shadOutlineTextOut(sparescreen, futuraFont, buffer, 263, 433, makecol(255, 255, 0), makecol(0, 0, 0), jCentre);

  string done;
  sprintf(buffer, "%d", level->reqMet);
  done = buffer;
  done += "/";
  sprintf(buffer, "%d", level->reqSum);
  done += buffer;
  shadOutlineTextOut(sparescreen, futuraFont, done.c_str(), 356, 433, makecol(255, 255, 0), makecol(0, 0, 0), jCentre);

}

// #######################################

void Game::redrawButtons(char mShown)
{
  blit(gameBackground, sparescreen, 0, 410, 0, 410, 210, 70);
  buttons.draw(sparescreen, mShown);
}

// #######################################

void Game::play()
{
  int renderx, rendery;
  int mickeyX, mickeyY, mouseShown = 1;
  int oldMouseB, mouseB, hide;
  int key = 0;

  endFlag = 0;


  set_mouse_sprite(mouseSprite);
  show_mouse(screen);
  redrawButtons(mouseShown);

  while(1)
  {
    level->gravityDaemon();
    level->requirementsDaemon();

    if (endFlag) break;

    blit(gameBackground, sparescreen, 0, 0, 0, 0, 640, 410);
    level->neccessaryRedraw(sparescreen, 320, 215);
    drawStatusLine();
    redrawButtons(mouseShown);
    update_screen();
    clear_keybuf();

    hide = 1;
    while(!keypressed())
    {
      if (mousePolling) poll_mouse();
      get_mouse_mickeys(&mickeyX, &mickeyY);
      mouseB = mouse_b;

      if (mickeyX || mickeyY)
      {
        if (!mouseShown)
        {
          show_mouse(screen);
          mouseShown = 1;
        }
        redrawButtons(mouseShown);
        update_screen();
      }
      if (mouseB != oldMouseB && (mouseB == 1))
      {
        int buttNr = buttons.mouseOverButton();
        if (buttNr != -1) hide = 0;
        switch(buttNr)
        {
          case 0:
            simulate_keypress(KEY_ESC << 8); break;
          case 1:
            simulate_keypress(KEY_R << 8); break;
          case 2:
            simulate_keypress(KEY_Z << 8); break;
          case 3:
            simulate_keypress(KEY_X << 8); break;
        }
      }
      oldMouseB = mouseB;
    }

    key = readkey() >> 8;

    if(mouseShown && hide)
    {
      mouseShown = 0;
      show_mouse(NULL);
    }

    if (key == KEY_R)
      reloadLevel();
    if (key == KEY_Z)
      level->turnCameraAClockwise();
    if (key == KEY_X)
      level->turnCameraClockwise();
    if (key == KEY_ESC)
    {
      endFlag = 3;
      break;
    }
    ply->receive_key(key, level->camDir);

  }

  string topText;
  switch(endFlag)
  {
    case 1:
      topText = "Bob has died.";
      break;
    case 2:
      topText = "Well done!";
      break;
    case 3:
      topText = "Escape was pressed.";
      endReason = "Game aborted.";
      break;
    default:
      topText = "Game ended.";
      endReason = "For no particular reason. Peculiar.";
  }

  text_mode(-1);

  blit(gameBackground, sparescreen, 0, 0, 0, 0, 640, 480);
  level->render_it(sparescreen, 320, 215);
  drawStatusLine();
  redrawButtons(0);
  shadOutlineTextOut(sparescreen, futuraFont, topText.c_str(), 320, 220, makecol(255, 255, 0), makecol(0, 0, 0), jCentre);
  shadOutlineTextOut(sparescreen, futuraFont, endReason.c_str(), 320, 240, makecol(255, 255, 0), makecol(0, 0, 0), jCentre);
  shadOutlineTextOut(sparescreen, futuraFont, "Press any key.", 320, 260, makecol(255, 255, 0), makecol(0, 0, 0), jCentre);
  update_screen();
  waitKeyOrMouse();

  show_mouse(NULL);
}
