#define __GTHREAD_HIDE_WIN32API 1

#include <list>

#include <allegro.h>
#include "button.h"

using namespace std;

// ######################################
//   FUNKCJE KLASY BUTTON
// ######################################

inline void Button::draw(BITMAP *bmp, char hl)
{
  draw_sprite(bmp, hl ? imageHL : image, x1, y1);
}

// ######################################

inline char Button::inside(int x, int y)
{
  return (x >= x1) && (x <= x2) && (y >= y1) && (y <= y2);
}

Button::Button(int anr, int ax1, int ay1, int ax2, int ay2, BITMAP *i1, BITMAP *i2)
{
  nr = anr;
  x1 = ax1; x2 = ax2; y1 = ay1; y2 = ay2;
  image = i1; imageHL = i2;
}

// ######################################
//   FUNKCJE KLASY BUTTONLIST
// ######################################

ButtonList::~ButtonList()
{
  list<Button*>::iterator iter;

  for(iter = buttList.begin(); iter != buttList.end(); iter++)
    delete (*iter);
}

void ButtonList::draw(BITMAP *bmp, char hl)
{
  list<Button*>::iterator iter;
  int mouseX = mouse_x;
  int mouseY = mouse_y;

  for(iter = buttList.begin(); iter != buttList.end(); iter++)
    (*iter)->draw(bmp, hl && (*iter)->inside(mouseX, mouseY));
}

int ButtonList::mouseOverButton()
{
  list<Button*>::iterator iter;
  int mouseX = mouse_x;
  int mouseY = mouse_y;
  int i;

  for(iter = buttList.begin(); iter != buttList.end(); iter++)
    if ((*iter)->inside(mouseX, mouseY))
      return (*iter)->nr;
      
  return -1;
}
