#ifndef __ADVOBJ_INCLUDED__
#define __ADVOBJ_INCLUDED__

#define __GTHREAD_HIDE_WIN32API 1

#include "types.h"
#include "objects.h"

// ######################################################

class PlainFloor : public Obj
{
  public:

  PlainFloor();

  actResult receiveAction(actKind kind, Obj *sender, int param);
};

// ######################################################

class PlainWall : public Obj
{
  public:

  PlainWall(int floor);

  actResult receiveAction(actKind kind, Obj *sender, int param);
};

// #######################################################

class Box : public MovableObj
{
  public:

  Box();

  actResult receiveAction(actKind kind, Obj *sender, int param);
  actResult doSpaceAction(Player *sender, direction dir);
};

// #######################################################

class HeavyBox : public Box
{
  public:

  HeavyBox();

  actResult doSpaceAction(Player *sender, direction dir);
};

// #######################################################

class XMark : public PlainFloor, public RequireObj
{
  public:

  XMark();

  char checkRequirement();
};

// #######################################################

class Stairs : public Obj
{
  public:

  direction lowerEnd, upperEnd;

  Stairs(direction theUpperEnd);

  actResult receiveAction(actKind kind, Obj *sender, int param);
};

#endif
