#define __GTHREAD_HIDE_WIN32API 1

#include "types.h"
#include "prepare.h"
#include "objects.h"
#include "player.h"
#include "level.h"
#include "advobj.h"

// #######################################################
// ###  FUNKCJE KLASY PLAINFLOOR   #######################
// #######################################################

PlainFloor::PlainFloor()
{
  classes = "/Obj/PlainFloor/";
  assignImage(tile[tile_Floor], dirAll);
  flat = 1;
  objectHeight = 0;
}

// #####################################

actResult PlainFloor::receiveAction(actKind kind, Obj *sender, int param)
{
  direction dir;
  switch(kind)
  {
    case akLeave:
      dir = (direction) param;
      return (dir == dirDown) ? arRefuse : arAccept;

    default:
      return arAccept;
  }
}

// #######################################################
// ###  FUNKCJE KLASY PLAINWALL   ########################
// #######################################################

PlainWall::PlainWall(int floor)
{
  classes = "/Obj/PlainWall/";
  assignImage(tile[tile_Wall[floor]], dirAll);
  flat = 0;
  objectHeight = 20;
}

actResult PlainWall::receiveAction(actKind kind, Obj *sender, int param)
{
  direction dir;
  switch(kind)
  {
    case akLeave:
      dir = (direction) param;
      return (dir == dirDown) ? arRefuse : arAccept;

    case akMoveOn:
      return arAccept;

    default:
      return arRefuse;
  }
}

// ###########################################################
// ######   FUNKCJE KLASY BOX   ##############################
// ###########################################################

Box::Box()
{
  classes = "/Obj/MovableObj/Box/";
  assignImage(tile[tile_Box], dirAll);
  flat = 0;
  objectHeight = 20;
}

// #####################################

actResult Box::receiveAction(actKind kind, Obj *sender, int param)
{
  direction dir;
  switch(kind)
  {
    case akMoveAgainst:
      if (sender->ofClass("Player"))
      {
        dir = (direction) param;
        if (dir==dirDown)
          return arRefuse;
        else
          return move(dir);
      }
      else
        return arRefuse;

    default:
      return arAccept;
  }
}

// ######################################

actResult Box::doSpaceAction(Player *sender, direction dir)
{
  actResult res;

  res = move(dir);

  if (res==arRefuse)
  {

    res = move(dirUp);

    if (res == arAccept)
    {
      res = move(dir);
      if (res == arAccept)
        sender->move(dir);
      else
        move(dirDown);
    }
  }

  return res;
}

// ########################################################
//     FUNKCJE KLASY HEAVYBOX
// ########################################################

HeavyBox::HeavyBox()
{
  classes = "/Obj/MovableObj/Box/HeavyBox";
  assignImage(tile[tile_HeavyBox], dirAll);
  flat = 0;
  objectHeight = 20;
}

// #####################################

actResult HeavyBox::doSpaceAction(Player *sender, direction dir)
{
  return move(dir);
}

// ########################################################
// ###   FUNKCJE KLASY XMARK   ############################
// ########################################################

XMark::XMark() : PlainFloor()
{
  classes = "/Obj/RequireObj/PlainFloor/XMark/";
  assignImage(tile[tile_Mark], dirAll);
  requirementMet = 0;
  flat = 1;
}

// ######################################

char XMark::checkRequirement()
{
  Obj *standingOnMe = parent->topObj();
  if (standingOnMe && (standingOnMe->ofClass("Box")))
  {
    requirementMet = 1;
    return 1;
  }
  else
  {
    requirementMet = 0;
  return 0;
  }
}

// #########################################################
// ###   FUNKCJE KLASY STAIRS   ############################
// #########################################################

Stairs::Stairs(direction theUpperEnd)
{
  classes = "/Obj/SpaceObj/Stairs/";
  upperEnd = theUpperEnd;
  lowerEnd = (direction)((upperEnd + 2) % 4);

  direction resDir;
  for(direction d = dirNorth; d <= dirWest; d = (direction)((int)d + 1))
  {
    resDir = (direction)((upperEnd + 4 - d) % 4);
    assignImage(tile[tile_Stairs[resDir]], d);
  }

  flat = 0;
  objectHeight = 10;
}

// #######################################

actResult Stairs::receiveAction(actKind kind, Obj *sender, int param)
{
  direction dir;
  actResult res;

  dir = (direction)param;

  switch(kind)
  {
    case akMoveOn:
      if (sender->ofClass("Player"))
        if (dir != lowerEnd)
          return arRefuse;
        else
        {
          sender->parent->popObj();
          parent->pushObj(sender);
          return arOverride;
        }
      else
        return arRefuse;

    case akMoveAgainst:
      if (sender->ofClass("Player"))
        if (dir != upperEnd)
          return arRefuse;
        else
          return arAccept;
      else
        return arRefuse;

    case akLeave:
      if (dir != upperEnd && dir != lowerEnd)
        return arRefuse;

      if (dir == upperEnd)
        if (sender->parent == parent)
        {
          Cell *aboveCell = parent->neighbour(dirUp);
          if (aboveCell->empty())
          {
            Player *ply = (Player *) sender;
            parent->popObj();
            aboveCell->pushObj(ply);
            res = ply->move(upperEnd);

            if(res == arRefuse)
            {
              aboveCell->popObj();
              parent->pushObj(ply);
              return arRefuse;
            }

            return arOverride;
          }
          else
            return arRefuse;
        }
        else
          return arAccept;

      if (dir == lowerEnd)
        return arAccept;

    default:
      return arAccept;
  }
}

