#ifndef __OBJECTS_INCLUDED__
#define __OBJECTS_INCLUDED__

#define __GTHREAD_HIDE_WIN32API 1

#include <allegro.h>

#include <string>

#include "types.h"

using namespace std;

extern const int cell_size_x, cell_size_y, cell_size_h;

// #######################################################

class Obj
{
  public:
  string classes;                   // lista klas do ktorych nalezy obiekt

  Cell *parent;                     // komorka ktora zawiera obiekt
  Obj  *standingOn;                 // obiekt na ktorym ten obiekt stoi

  char flat;                        // czy obiekt jest plaski?

  BITMAP *image[4];                 // obrazy obiektu z czterech ujec
  int imageHeight[4];               // oraz ich wysokosci - 1.

  int objectHeight;                 // wysokosc samego obiektu
  int subh;                         // modyfikator wysokosci na ktorej polozony jest obiekt

  Obj();

  char ofClass(string match);                           // sprawdza czy obiekt jest danej klasy lub jest jej pochodna
  virtual void assignImage(BITMAP *bmp, direction dir); // przypisuje bitmape do obiektu, jednoczesnie modyfikujac image_h.
  virtual void draw(BITMAP *bmp, int x, int y, direction dir);  // rysuje obiekt na zadanej bitmapie, x i y.

  virtual actResult receiveAction(actKind kind, Obj *sender, int param) = 0;    // obsluga akcji i reakcji.
  virtual actResult doSpaceAction(Player *sender, direction dir);                   // akcja pod spacja
};

// ######################################################

class MovableObj : public Obj
{
  public:

  int falling_force;
  virtual actResult move(direction dir);            // przesuwa obiekt w zadanym kierunku
};

// ######################################################

class RequireObj
{
  public:

  char requirementMet;
  virtual char checkRequirement() = 0;
};

#endif
