#define __GTHREAD_HIDE_WIN32API 1

#include <allegro.h>

#include <string>

#include "prepare.h"
#include "objects.h"
#include "game.h"
#include "levelio.h"
#include "menu.h"

using namespace std;

void updateScr()
{
  vsync();
  acquire_screen();
  blit(sparescreen, screen, 0, 0, 0, 0, screen->w, screen->h);
  release_screen();
}

void main(int argc, char *argv[])
{
  char windowed = 0;
  string parser;
  string *menuops;
  int levCount;

  if(argc > 1)
  {
    for(int a = 1; a < argc; a++)
    {
      parser = argv[a];
      if (parser == "-w")
        windowed = 1;
    }
  }

  game_init_all(windowed);

  LevelManager manager;
  Menu m;
  Game gra;
  manager.attachToLevelPack("levels/standard.pck");


  levCount = manager.levelCount;
  menuops = new string[levCount + 2];
  for(int i = 0; i < levCount; i++)
  {
    menuops[i] = manager.levelName[i];
  }
  menuops[levCount] = "";
  menuops[levCount + 1] = "Exit";
  m.options = menuops;
  m.optCount = manager.levelCount + 2;
  m.destScreen = sparescreen;
  m.updateFunc = updateScr;
  m.withClear = 1;
  m.menufont = m.titlefont = futuraFont;
  m.displayX = screen->w / 2;
  m.displayY = 100;
  m.optionHeight = 32;
  m.bandHeight = 26;
  m.bandWidth = 260;
  m.textColor = makecol(255, 255, 0);
  m.textShadColor = makecol(0, 0, 0);
  m.bandColor = makecol(110, 60, 0);
  m.chosen = 0;
  m.title = "SELECT A LEVEL";
  m.titleX = screen->w / 2;
  m.titleY = 55;
  m.titleColor = makecol(255, 255, 255);

  int selected;
  char ky;

  while(1)
  {
    selected = m.menuChoose(ky);
    if ((ky == KEY_ENTER) || (ky == KEY_SPACE))
      if (selected < levCount)
      {
        gra.loadLevel(&manager, selected + 1);
        gra.play();
      }
      else
        break;
  }


  game_done_all();
  delete [] menuops;
}

END_OF_MAIN();

