#define __GTHREAD_HIDE_WIN32API 1

#ifndef __LEVEL_INCLUDED__
#define __LEVEL_INCLUDED__

#include <list>

#include "types.h"
#include "advobj.h"

using namespace std;

typedef list<Obj*> ObjList;

// ##############################

class LevelMap
{
  public:
  Cell ****c;              // to bedzie 3-wymiarowa tablica wskaznikow do komorek. Boze, ile tych gwiazdek :\.
  char **height;				// a to 2-wymiarowa tablica wysokosci
  char size[3];				// to zas wymiary calego levelu w x, y, h

  Game *myGame;            // gra ktora zawiera dany level

  list<RequireObj*> requireObjsList;  // lista obiektow ktore musza byc zaspokojone aby level byl wygrany ;).
  int reqMet, reqSum;                 // do wyswietlania na statusline

  ObjList changed;                    // lista obiektow zmienionych w ostatniej turze (do uzytku gravity_daemon)

  LevelMap(Game *aGame, int size_x, int size_y, int size_h);
  ~LevelMap();

  direction camDir;             // kierunek w ktorym jest zwrocona kamera (polnoc kamery)
  void turnCameraAClockwise();
  void turnCameraClockwise();

  char needsFullRedraw;
  int renderX, renderY;
  void recountRenderPos();
  void getCellRenderXY(int x, int y, int h, int &dx, int &dy); 
  void redrawCell(BITMAP *bmp, int drawx, int drawy, int cellx, int celly, int cellh);
  void neccessaryRedraw(BITMAP *bmp, int drawx, int drawy);
  void render_it(BITMAP *bmp, int drawx, int drawy);   // rysuje level na ekranie

  void gravityDaemon();         // odpowiada za spadanie obiektow ktore zakoncza swoja ture w powietrzu
  void requirementsDaemon();    // odpowiada za sprawdzanie, czy level nie zostal juz wygrany
};

// ##############################

class Cell{
  public:

  Obj *objs[3];
  char objsFirstFree;
  char objsHeight;

  LevelMap *lv;                    // level do ktorego nalezy ta komorka
  char levx, levy, levh;				  // wspolrzedne tej komorki w levelu

  Cell(LevelMap *lev, int lx, int ly, int lh);   // konstruktor
  ~Cell();													 // destruktor

  Cell* neighbour(direction dir);            // zwraca komorka znajdujace sie o 1 dalej w okreslonym kierunku
  char empty();										// zwraca TRUE gdy komorka nie zawiera obiektow.
  void draw(BITMAP *bmp, int x, int y, direction camDir); // rysuje komorke na zadanej bitmapie, x i y.

  void pushObj(Obj *o);
  Obj* popObj();
  Obj* topObj();
};

#endif
