#include <allegro.h>
#include "prepare.h"
#include "helpers.h"

void waitKey()
{
  clear_keybuf();
  while(!keypressed());
  clear_keybuf();
}

void waitMouse()
{
  while(mouse_b)
    if (mousePolling)
      poll_mouse();
  while(!mouse_b)
    if (mousePolling)
      poll_mouse();
}

void waitKeyOrMouse()
{
  if (mousePolling)
    poll_mouse();

  while(mouse_b)
    if (mousePolling)
      poll_mouse();

  clear_keybuf();

  while((!mouse_b) && (!keypressed()))
    if (mousePolling)
      poll_mouse();

  clear_keybuf();
}

void outlineTextOut(BITMAP *bmp, const FONT *fnt, const char *t, int x, int y, long col1, long col2, justify j)
{
  void (*to)(BITMAP*, const FONT*, const char*, int, int, int);

  switch(j)
  {
    case jLeft:   to = textout;
    		         break;
    case jCentre: to = textout_centre;
    					break;
    case jRight:  to = textout_right;
    					break;
  }

  text_mode(-1);
  to(bmp, fnt, t, x-1, y-1, col2);
  to(bmp, fnt, t, x+1, y-1, col2);
  to(bmp, fnt, t, x-1, y+1, col2);
  to(bmp, fnt, t, x+1, y+1, col2);
  to(bmp, fnt, t, x, y,     col1);
}

void shadOutlineTextOut(BITMAP *bmp, const FONT *fnt, const char *t, int x, int y, long col1, long col2, justify j)
{
  outlineTextOut(bmp, fnt, t, x + 1, y + 1, col1, col2, j);
  outlineTextOut(bmp, fnt, t, x, y, col1, col2, j);
}
