#define __GTHREAD_HIDE_WIN32API 1

#include <allegro.h>

#include <string>

#include "types.h"
#include "prepare.h"
#include "objects.h"
#include "level.h"
#include "player.h"
#include "advobj.h"
#include "levelio.h"

using namespace std;


LevelMap *lv;
int edx=0, edy=0, edh=0;

struct PredefObj
{
  char name[20];
  Obj *o;
};

PredefObj obTable[11] =
{
  "Wall(0)", NULL,
  "Wall(1)", NULL,
  "Wall(2)", NULL,
  "Player(NULL)", NULL,
  "XMark()", NULL,
  "Box()", NULL,
  "HeavyBox()", NULL,
  "Stairs(N)", NULL,
  "Stairs(E)", NULL,
  "Stairs(S)", NULL,
  "Stairs(W)", NULL,
};

const int predefsCount = 11;

string input_string(BITMAP *bmp, int x, int y, string prompt, long color)
{
  string inp("");
  char k;

  text_mode(0);
  while(1)
  {
    textprintf(bmp, font, x, y, color, "%s%s| ", prompt.c_str(), inp.c_str());
    while(!keypressed());
    k = (char) readkey();

    if (k==0x0d)
      break;

    if ((k==0x08) && (inp.size() > 0))
    {
      inp = inp.substr(0, inp.size() - 1);
      continue;
    }

    inp = inp + k;
  }
  textprintf(bmp, font, x, y, color, "%s%s ", prompt.c_str(), inp.c_str());
  return inp;
}

Obj *provide_obj(int nr)
{
  switch(nr)
  {
    case 0:  return new PlainWall(0);
    case 1:  return new PlainWall(1);
    case 2:  return new PlainWall(2);
    case 3:  return new Player(NULL);
    case 4:  return new XMark();
    case 5:  return new Box();
    case 6:  return new HeavyBox();
    case 7:  return new Stairs(dirNorth);
    case 8:  return new Stairs(dirEast);
    case 9:  return new Stairs(dirSouth);
    case 10: return new Stairs(dirWest);
  }
}

void new_level()
{
  int ssx, ssy, ssh;

  ssx = atoi(input_string(screen, 0,  0, "Level X size:", makecol(255, 255, 0)).c_str());
  ssy = atoi(input_string(screen, 0, 10, "Level Y size:", makecol(255, 255, 0)).c_str());
  ssh = atoi(input_string(screen, 0, 20, "Level H size:", makecol(255, 255, 0)).c_str());

  lv = new LevelMap(NULL, ssx, ssy, ssh);
}

void display_edit_cell()
{
  int dispX, dispY;
  lv->getCellRenderXY(edx, edy, edh, dispX, dispY);
  draw_sprite(screen, tile[tile_EditMark], 320 + dispX, 240 + dispY - tile[tile_EditMark]->h);
}

void main(int argc, char *argv[])
{
  game_init_all(1);

  new_level();

  int ky;
  char exit = 0;
  int selNr = 0;
  string fname;

  while(!exit)
  {
    clear(screen);
    lv->render_it(screen, 320, 240);
    display_edit_cell();
    textprintf(screen, font, 0, 0, makecol(255, 255, 255), "%s", obTable[selNr].name);
    while(!keypressed());
    ky = readkey() >> 8;
    switch(ky)
    {
      case KEY_Q:
        exit = 1;
        break;
      case KEY_7_PAD:
        if (edy > 0) edy--;
        break;
      case KEY_3_PAD:
        if (edy < lv->size[1] - 1) edy++;
        break;
      case KEY_1_PAD:
        if (edx > 0) edx--;
        break;
      case KEY_9_PAD:
        if (edx < lv->size[0] - 1) edx++;
        break;
      case KEY_8_PAD:
        if (edh < lv->size[2] - 1) edh++;
        break;
      case KEY_2_PAD:
        if (edh > 0) edh--;
        break;
      case KEY_0_PAD:
        lv->c[edx][edy][edh]->pushObj(provide_obj(selNr));
        break;
      case KEY_DEL_PAD:
        lv->c[edx][edy][edh]->popObj();
        break;
      case KEY_MINUS_PAD:
        selNr--;
        if (selNr < 0) selNr = predefsCount - 1;
        break;
      case KEY_PLUS_PAD:
        selNr++;
        if (selNr == predefsCount) selNr = 0;
        break;
      case KEY_S:
        fname = input_string(screen, 20, 460, "Nazwa pliku do zapisu: ", makecol(255, 0, 0));
        saveLevelToDisk(fname.c_str(), lv);
        break;
      case KEY_L:
        fname = input_string(screen, 20, 460, "Nazwa pliku do odczytu: ", makecol(0, 255, 0));
        delete lv;
        lv = loadLevelFromDisk(fname.c_str(), NULL);
        break;
    }
  }

  delete lv;
  game_done_all();
}

END_OF_MAIN();

