//menu.cc
#include "supermax.h"


//extern DATAFILE *data;
//extern BITMAP *buffer;
DATAFILE *data;
BITMAP *buffer;

bool MENU_QUIT;
int menu_cursor; // This is the y coordinate of the menu cursor.
int blink_on;  // This will be used to implement the blinking.
void menu_helper();


// This is going to be the user's portal so to speak.
// From here, the user can enter a level, or exit the game
// completely.
void menu()
{
FONT* MENU_FONT; 
MENU_FONT = (FONT*) data[MAXFONT1].dat;
FONT* MENU_OPTIONS;
MENU_OPTIONS = (FONT*) data[MAXFONT3].dat;
MENU_QUIT = false;
menu_cursor = 75;
blink_on = 0;
text_mode(-1);
   
 while (!MENU_QUIT)
   {
     textout_centre(buffer, MENU_FONT, "MENU", 160, 10, -1);

     if ((menu_cursor == 75) && (blink_on == 1))
       rectfill(buffer, 130, 75, 130 + (5*12), 75 + 12, 255); 

     if ((menu_cursor == 95) && (blink_on == 1))
       rectfill(buffer, 112, 95, 112 + (8*12), 95+12, 255);

     if ((menu_cursor == 115) && (blink_on == 1))
       rectfill(buffer, 87, 115, 87 + (12*12), 115+12, 255);

     textout_centre(buffer, MENU_OPTIONS, "START", 160, 75, -1);
     textout_centre(buffer, MENU_OPTIONS, "PASSWORD", 160, 95, -1);
     textout_centre(buffer, MENU_OPTIONS, "CUSTOM LEVEL", 160, 115, -1);

     if (blink_on == 1)
       blink_on = 0;
     else
       blink_on = 1;


     blit(buffer, screen, 0, 0, 0, 0, 320, 200);
  
     clear_bitmap(buffer);
     if (keypressed())
       menu_helper();     

     rest(100);
   }

}

void menu_helper()
{
  switch (readkey() >> 8)
    {
    case KEY_ESC:
      MENU_QUIT = true;
      break;
    
    case KEY_UP:
      if (menu_cursor == 75)
	menu_cursor = 115;
      else
	menu_cursor -= 20;
      break;

    case KEY_DOWN:
      if (menu_cursor == 115)
	menu_cursor = 75;
      else
	menu_cursor += 20;
      break;
  
    default:
      break;
    }
}

//  This is only for testing the menu
//  menu.cc will not be integrated into the game
//  until the game is completed.
//
//  This file will also be linked with password.cc
//  and used as an entry sector to test the password.cc
int main(int argc, char *argv[])
{
allegro_init();
install_keyboard();

data = load_datafile("supermax.dat");  
if (set_gfx_mode(GFX_AUTODETECT, 320, 240, 320, 240) != 0) {
   set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
   allegro_message("Unable to set any graphic mode\n%s\n", allegro_error);
   return 1;
}
buffer = create_bitmap(SCREEN_W, SCREEN_H);
set_color_conversion(COLORCONV_NONE);
set_palette( (const RGB*) data[SUPER_PAL].dat);

menu();

return 0;
}
