// max.cc
#include "supermax.h"

extern DATAFILE *data;
extern bool QUIT;
extern int scroll_x;
extern int scroll_y;
extern BITMAP *buffer;
extern BITMAP *buffer2;
extern BITMAP *buffer3;
extern int scroll_x_1;
extern int scroll_x_2;
extern int scroll_x_3;
extern bool scroll_on;
extern vector<MaxBullet> maxbullets;
extern int global_x;
extern int global_y;

Max::Max(int &x, int &y)
{
  string name = "MAX";
  bool fallthruname = true;
  int xs1 = 2;
  int ys1 = 0;
  int strength1 = 50;
  set_values(x, y, xs1, ys1, strength1, fallthruname, name);
  Character::image = (RLE_SPRITE *) data[MAX1].dat;  
  display_x = 130;
  display_y = 100;
  running_frame = 0;
  standing_frame = 0;
  diagonal_frame = 0;
  Character::d = right;
}

void add_bullet(int input_x0, int input_y0, int input_xs, int input_ys,string input_type)
{
  MaxBullet temp_bullet(input_x0, input_y0, input_xs, input_ys, input_type);
  maxbullets.push_back(temp_bullet);
}

void Max::firegun()
{
  int random_red = rand()%63;
  int random_green = rand()%63;
  int random_blue = rand()%63;
  RGB random_color = {random_red, random_green, random_blue};
  set_color(4, &random_color);
  standing_frame = 10;
  
  if (Character::xs > 0)
    {
      Character::d = right;
      Character::image = (RLE_SPRITE *) data[FMAX1].dat;
      add_bullet(x+global_x+55, y+global_y+38, 2, 0, "MACHINE_GUN");
    }
  else
    {
      Character::d = left;
      Character::image = (RLE_SPRITE *) data[FMAX2].dat;
      add_bullet(x+global_x, y+global_y+38, -2, 0, "MACHINE_GUN");
    }
}

void Max::diagonal_translate(int &xs, int &ys)
{
  int random_red = rand()%63;
  int random_green = rand()%63;
  int random_blue = rand()%63;
  RGB random_color = {random_red, random_green, random_blue};
  set_color(4, &random_color);

  if ( (xs > 0) && (ys > 0))
    {
      standing_frame = 10;
      Character::d = right;
      add_bullet(x+global_x+55, y+global_y, 2, -2, "MACHINE_GUN");
      
      if (diagonal_frame > 3)
	Character::image = (RLE_SPRITE *) data[MAX1A1].dat;
      else
	Character::image = (RLE_SPRITE *) data[MAX1B1].dat;
	  
      diagonal_frame--;

      if (diagonal_frame <= 0)
	diagonal_frame = 6;
    }
  if ( (xs < 0) && (ys > 0))
    {
      standing_frame = 10;
      Character::d = left;
      add_bullet(x+global_x,y+global_y,-2,-2,"MACHINE_GUN");

      if (diagonal_frame > 3)
	Character::image = (RLE_SPRITE *) data[MAX2A1].dat;
      else
	Character::image = (RLE_SPRITE *) data[MAX2B1].dat;
	  
      diagonal_frame--;

      if (diagonal_frame <= 0)
	diagonal_frame = 6;
    }


  if ( (xs > 0) && (ys == 0))
    {
      standing_frame = 10;
      Character::d = right;
      add_bullet(x+global_x+55,y+global_y+38,2,0,"MACHINE_GUN");
      
	  if (diagonal_frame > 3)
	    Character::image = (RLE_SPRITE *) data[MAX1A2].dat;
	  else
	    Character::image = (RLE_SPRITE *) data[MAX1B2].dat;
	  
	  diagonal_frame--;

	  if (diagonal_frame <= 0)
	    diagonal_frame = 6;
    }

  if ( (xs < 0) && (ys == 0))
    {
      standing_frame = 10;
      Character::d = left;
      add_bullet(x+global_x,y+global_y+38,-2,0,"MACHINE_GUN");
      
	  if (diagonal_frame > 3)
	    Character::image = (RLE_SPRITE *) data[MAX2A2].dat;
	  else
	    Character::image = (RLE_SPRITE *) data[MAX2B2].dat;
	  
	  diagonal_frame--;

	  if (diagonal_frame <= 0)
	    diagonal_frame = 6;
    }

}

void Max::translate(int &xs, int &ys)
{
  Character::xs = xs;

  if (xs > 0)
    {
      standing_frame = 10;
      Character::d = right;

      if (running_frame > 3)
	Character::image = (RLE_SPRITE *) data[MAX1A].dat;
      else
	Character::image = (RLE_SPRITE *) data[MAX1B].dat;
	  
      running_frame--;

      if (running_frame <= 0)
	running_frame = 6;
    }
  if (xs < 0)
    {
      standing_frame = 10;
      Character::d = left;

      if (running_frame > 3)
	Character::image = (RLE_SPRITE *) data[MAX2A].dat;
      else
	Character::image = (RLE_SPRITE *) data[MAX2B].dat;
	  
      running_frame--;

      if (running_frame <= 0)
	running_frame = 6;
    }
}

void Max::standstill()
{
  standing_frame--;
  
  if (standing_frame <= 0)
    {
      if (Character::d == right)
	Character::image = (RLE_SPRITE *) data[MAX1].dat;
      else
	Character::image = (RLE_SPRITE *) data[MAX2].dat;
    }
}

void Max::display()
{
  draw_rle_sprite(buffer, Character::image, display_x-scroll_x_1,display_y);
  draw_rle_sprite(buffer2,Character::image, display_x-scroll_x_2,display_y);
  draw_rle_sprite(buffer3,Character::image, display_x-scroll_x_3,display_y);
}



