//level.cc
#include "supermax.h"
#include <fstream>

extern DATAFILE *data;
extern BITMAP *buffer;
extern BITMAP *buffer2;
extern BITMAP *buffer3;
extern int scroll_x;
extern int scroll_y;
extern int scroll_x_1;
extern int scroll_x_2;
extern bool scroll_on;

Level::Level(string level_name)
{
  string input_string, input_texture;
  int input_int;

  int input_x, input_y, input_x1, input_y1;

  ifstream input_level(level_name.c_str());

  ofstream debug_output("debuglevel.txt");
  
  input_level >> input_int;
  max_x = input_int;

  input_level >> input_int;
  max_y = input_int;

  input_level >> input_string;
  if (input_string.compare("DUNE1") == 0)
  background = (BITMAP *) data[DUNE1].dat;
  
  input_level >> input_string;
  if (input_string.compare("yes") == 0)
    scroll_x_enable = true;
  else
    scroll_x_enable = false;

  input_level >> input_string;
  if (input_string.compare("yes") == 0)
    scroll_y_enable = true;
  else
    scroll_y_enable = false;
  
  input_level >> input_string;
  if (input_string.compare("yes") == 0)
    circle_x_enable = true;
  else
    circle_x_enable = false;

  input_level >> input_string;
  if (input_string.compare("yes") == 0)
    circle_y_enable = true;
  else
    circle_y_enable = false;

  input_level >> input_string;
  if (input_string.compare("yes") == 0)
    go_back_x_enable = true;
  else
    go_back_x_enable = false;

  input_level >> input_string;
  if (input_string.compare("yes") == 0)
    go_back_y_enable = true;
  else
    go_back_y_enable = false;

  input_level >> input_int;
  minimum_x = input_int;
  
  input_level >> input_int;
  maximum_x = input_int;

  input_level >> input_int;
  minimum_y = input_int;

  input_level >> input_int;
  maximum_y = input_int;

  input_level >> input_string;
  level_x_direction = input_string;
 
  input_level >> input_string;
  level_y_direction = input_string;

  input_level >> input_string;
  if (input_string.compare("yes") == 0)
    boss_enable = true;
  else
    boss_enable = false;

  input_level >> input_string;
  //  if (input_string.compare("ROBO1")==0)
  //  boss_name = data[ROBO1].dat;

  input_level >> input_string;
  if (input_string.compare("DUNE1")==0)
    boss_background == data[DUNE1].dat;

  //=============End of loading header part==============//
  //=============Now loading background objects==========//
  input_level >> input_string; // the break after the header
  
  input_level >> input_string;
  if (input_string.compare("BREAK") != 0)
    {
      while (input_string.compare("BREAK") != 0)
	{
	  input_x = atoi(input_string.c_str());
	  input_level >> input_y;
	  input_level >> input_x1;
	  input_level >> input_y1;
	  input_level >> input_texture;
	  input_level >> input_string;
	
	  Object temp_obj(input_x, input_y, input_x1, input_y1, input_texture);
		
	  bg_objs.push_back(temp_obj);	
	}
    }

  //============Now load solid objects====================//
  input_level >> input_string;
  if (input_string.compare("BREAK") != 0)
    {
      while (input_string.compare("BREAK") != 0)
      {
	input_x = atoi(input_string.c_str());
	input_level >> input_y;
	input_level >> input_x1;
	input_level >> input_y1;
	input_level >> input_texture;
	input_level >> input_string;
	
	Solid_Object temp_obj(input_x, input_y, input_x1, input_y1, input_texture);
		
	solid_objs.push_back(temp_obj);
	  }
    }

  //============Load Fall_Thru objects===================//
 input_level >> input_string;
  if (input_string.compare("BREAK") != 0)
    {
    while (input_string.compare("BREAK") != 0)
      {



      }
    }

  //==========Load BIG background objects================//
  input_level >> input_string;
  if (input_string.compare("BREAK") != 0)
    {
      while (input_string.compare("BREAK") != 0)
	{
	  input_x = atoi(input_string.c_str());
	  input_level >> input_y;
	  input_level >> input_x1;
	  input_level >> input_y1;
	  input_level >> input_texture;
	  input_level >> input_string;
	  
	  if (input_texture.compare("PALMTREE")==0)
	    {
	      int leftleaf_x1 = input_x;
	      int palm_y = input_y;
	      string leftleaf_texture = "PALMS2";
	      Object leftleaf1(leftleaf_x1, palm_y, leftleaf_x1, palm_y, leftleaf_texture);
	      bg_objs.push_back(leftleaf1);

	      int leftleaf_x2 = input_x+20;
	      string leftleaf_texture2 = "PALMS1";
	      Object leftleaf2(leftleaf_x2, palm_y, leftleaf_x2, palm_y, leftleaf_texture2);
	      bg_objs.push_back(leftleaf2);

	      int rightleaf_x1 = leftleaf_x2+30;
	      string rightleaf_texture = "PALMS2";
	      Object rightleaf1(rightleaf_x1, palm_y, rightleaf_x1, palm_y, rightleaf_texture);
	      bg_objs.push_back(rightleaf1);

	      int rightleaf_x2 = rightleaf_x1+20;
	      string rightleaf_texture2 = "PALMS1";
	      Object rightleaf2(rightleaf_x2, palm_y, rightleaf_x2, palm_y, rightleaf_texture2);
	      bg_objs.push_back(rightleaf2);

	      int tree_x = leftleaf_x2+15;
	      int tree_y1 = 40;
	      string tree_texture = "BARK2";
	      int tree_y2 = tree_y1 + 120;
	      Object trunk(tree_x, tree_y1, tree_x, tree_y2, tree_texture);
	      bg_objs.push_back(trunk);

	      int topleaf_y1 = tree_y1-20;
	      string topleaf_texture1 = "PALMT1";
	      Object topleaf1(tree_x, topleaf_y1 ,tree_x, topleaf_y1, topleaf_texture1);
	      bg_objs.push_back(topleaf1);

	      int topleaf_y2 = topleaf_y1-20;
	      string topleaf_texture2 = "PALMT2";
	      Object topleaf2(tree_x, topleaf_y2, tree_x, topleaf_y2, topleaf_texture2);
	      bg_objs.push_back(topleaf2);

	      int bottomleaf_y1 = tree_y1;
	      string bottomleaf_texture = "PALMT2";
	      Object bottomleaf1(tree_x, bottomleaf_y1 ,tree_x, bottomleaf_y1, bottomleaf_texture);
	      bg_objs.push_back(bottomleaf1);
	      
	      int bottomleaf_y2 = bottomleaf_y1+20;
	      string bottomleaf_texture2 = "PALMT1";
	      Object bottomleaf2(tree_x, bottomleaf_y2 ,tree_x, bottomleaf_y2, bottomleaf_texture2);
	      bg_objs.push_back(bottomleaf2);
	    }
	}
    }

  //============Load Enemies=============================//
 input_level >> input_string;
  if (input_string.compare("BREAK") != 0)
    {
    while (input_string.compare("BREAK") != 0)
      {
	  input_x = atoi(input_string.c_str());
	  input_level >> input_y;
	  input_level >> input_texture;
	  input_level >> input_string;
	
	  Enemy temp_obj(input_x, input_y, input_texture);
		
	  enemy_objs.push_back(temp_obj);	
      }
    }
  debug_output << input_string << endl;

}

void Level::display()
{
      blit(background, buffer, 0, 0, 0, 0, 320, 200);
      blit(background,buffer2, 0, 0, 0, 0, 320, 200);
      blit(background,buffer3, 0, 0, 0, 0, 320, 200);

      for (int index = 0; index < bg_objs.size(); index++)
	bg_objs[index].display();

      for (int index = 0; index < solid_objs.size(); index++)
	solid_objs[index].display();

      for (int index = 0; index < enemy_objs.size(); index++)
	enemy_objs[index].display();
}

void Level::update()
{
  //Remember our ABC's.
  // 1. move characters.
  for (int index = 0; index < enemy_objs.size(); index++)
    enemy_objs[index].update();

  for (int index = 0; index < bg_objs.size(); index++)
    bg_objs[index].update();

}

bool Level::scroll_x_violation_check(int x, int xs)
{

  return scroll_x_violation;
}


bool Level::scroll_y_violation_check(int y, int ys)
{

  return scroll_y_violation;
}

bool Level::enemy_violation_check(int x, int y)
{

  return enemy_violation;
}

bool Level::boundary_x_violation_check(int x, int y, int xs, int ys)
{
  boundary_x_violation = false;
  for (int index = 0; index < solid_objs.size(); index++)
    {
      bool checkvalue = solid_objs[index].boundary_x_check(x,y,xs,ys);
      boundary_x_violation = boundary_x_violation || checkvalue;
      }
  return boundary_x_violation;
}

bool Level::boundary_x_violation_check(int x, int y, int xs, int ys)
{
  boundary_y_violation = false;
  for (int index = 0; index < solid_objs.size(); index++)
    {
      bool checkvalue = solid_objs[index].boundary_y_check(x,y,xs,ys);
      boundary_y_violation = boundary_y_violation || checkvalue;
      }
  return boundary_y_violation;
}
