/*  supermax.h
 *  
 *  Copyright 2003 by Scott Stinson
 *
 *  All Rights reserved
 */

//*************Includes below***************************************
#include <list>
#include <vector>
#include <string>

using namespace std;

#include <allegro.h>    // The game library that we use.
#include "data.h"       // An index to access the data objects with.



//************Global Variables below*******************************

extern DATAFILE *data;


//*************Abstract Data types below****************************


/* This class is going to be a superclass
 * for all the characters in the game.
 * For instance, For any character, goodguy
 * or badguy, we want him to stay within the
 * boundaries and not go through brick walls;
 * unless that character is a ghost.
 *
 * For the exceptions like ghosts going through
 * boundaries, we create subclasses and overload
 * certain methods.
 */

class Character
{
 protected:
  void set_values(int &input_x, int &input_y, int &input_xs, int &input_ys, int &input_strength, bool &input_fall_thru, string &input_name)
    {
      x0 = input_x;
      y0 = input_y;
      x = input_x;
      y = input_y;
      xs = input_xs;
      ys = input_ys;
      strength = input_strength;
      fall_thru = input_fall_thru;
      name = input_name;
    };
  int x, y, xs, ys, strength, x0, y0;
  bool fall_thru;
  RLE_SPRITE *image; 
  string name;
  enum direction{left, right, up, down};
  direction d;

 public:
  Character();
  Character(int &input_x, int &input_y, string &input_name);
  void display();
  void translate(int &input_xs, int &input_ys);

};

class Enemy : public Character
{
  string type;
  int speed_frame;
  // We need to regulate the speed of the enemy

  int display_frame;

 public:
  Enemy();  
  Enemy(int &input_x, int &input_y, string &input_name);
  void update();
  void display();
};

class Zombie : public Enemy
{
  
};

class Guerilla : public Enemy
{

};

class Laserman : public Enemy
{

};

class Lepercaun : public Enemy
{

};

/* Max, the main character is going to be a subclass of
 * Character.  Difference between Max and the other
 * characters is that translate_xs or translate_ys will result
 * in a h_scroll or v_scroll if those are defined for the level.
*/
class Max : public Character
{
 private:
  RLE_SPRITE *image; 
  int display_x, display_y;
  int running_frame, standing_frame, diagonal_frame;
  bool in_air;  // This indicates if Max is jumping or not

 public:
  Max(int &x, int &y);
  void translate(int &xs, int &ys);
  void display();
  void standstill();
  void firegun();
  
  // function to move the character and 
  // shoot gun in a diagonal direction
  void diagonal_translate(int &xs, int &ys);

};

class Boss : public Character
{

  // public:
  // Boss(int &x, int &y, int &xs, int &ys, string &boss_name);

};


class Snake : public Enemy
{

};

class Robo : public Boss
{

};

class Rayden : public Boss
{

};

class Object
{
 protected:
  void set_values(int &x, int &y, int &x1, int &y1, string &object_name)
    { 
      min_x = x;
      min_y = y;
      max_x = x1;
      max_y = y1;
      
      object_name1 = object_name;

      if (object_name.compare("SAND4")==0)
	sprite_texture = (RLE_SPRITE *) data[SAND4A].dat;
      
      if (object_name.compare("GRASS1")==0)
	sprite_texture = (RLE_SPRITE *) data[GRASS1].dat;

      if (object_name.compare("BARK1")==0)
	sprite_texture = (RLE_SPRITE *) data[BARK1].dat;

      if (object_name.compare("BARK2")==0)
	sprite_texture = (RLE_SPRITE *) data[BARK2].dat;

      if (object_name.compare("PALMT1")==0)
	sprite_texture = (RLE_SPRITE *) data[PALMT1].dat;

      if (object_name.compare("PALMT2")==0)
	sprite_texture = (RLE_SPRITE *) data[PALMT2].dat;

      if (object_name.compare("PALMS1")==0)
	sprite_texture = (RLE_SPRITE *) data[PALMS1].dat;

      if (object_name.compare("PALMS2")==0)
	sprite_texture = (RLE_SPRITE *) data[PALMS2].dat;

      if (object_name.compare("DIRT")==0)
	sprite_texture = (RLE_SPRITE *) data[DIRT].dat;
      
      if (object_name.compare("DIRT2")==0)
	sprite_texture = (RLE_SPRITE *) data[DIRT2].dat;

      if (object_name.compare("TENT1")==0)
	sprite_texture = (RLE_SPRITE *) data[TENT1].dat;

      if (object_name.compare("TENTZ")==0)
	sprite_texture = (RLE_SPRITE *) data[TENTZ].dat;

      if (object_name.compare("TENT2")==0)
	sprite_texture = (RLE_SPRITE *) data[TENT2].dat;

      if (object_name.compare("TENT3")==0)
	sprite_texture = (RLE_SPRITE *) data[TENT3].dat;

      if (object_name.compare("TENT2A")==0)
	sprite_texture = (RLE_SPRITE *) data[TENT2A].dat;

      if (object_name.compare("TENT3A")==0)
	sprite_texture = (RLE_SPRITE *) data[TENT3A].dat;

      if (object_name.compare("BONE")==0)
	sprite_texture = (RLE_SPRITE *) data[BONE].dat;

      if (object_name.compare("BONE2")==0)
	sprite_texture = (RLE_SPRITE *) data[BONE2].dat;

      if (object_name.compare("FLAME")==0)
	sprite_texture = (RLE_SPRITE *) data[FLAME1].dat;

      if (object_name.compare("BRASS")==0)
	sprite_texture = (RLE_SPRITE *) data[BRASS2].dat;

      if (object_name.compare("FLOOR1")==0)
	sprite_texture = (RLE_SPRITE *) data[FLOOR1].dat;

      if (object_name.compare("TILE5A")==0)
	sprite_texture = (RLE_SPRITE *) data[TILE5A].dat;

      if (object_name.compare("TILE3A")==0)
	sprite_texture = (RLE_SPRITE *) data[TILE3A].dat;

      display_frame = 10;
    };
  //  This is only because derived classes do not inherit the base
  //  constructors.  In a way, this almost defeats one of the goals
  //  of Object Oriented Programming which is inheritance.


  string pic_type;  // Either RLE or BMP
  BITMAP *bitmap_texture;
  RLE_SPRITE *sprite_texture;

  int min_x, min_y, max_x, max_y, display_frame;
  string object_name1;

 public:
  Object();
  Object(int &x, int &y, int &x1, int &y1, string &object_name);
  void display();
  void update();
};


class Solid_Object : public Object
{
 public:
  Solid_Object(int &x, int &y, int &x1, int &y1, string &object_name);
  bool boundary_x_check(int &x, int &y, int &xs, int &ys);
  bool boundary_y_check(int &x, int &y, int &xs, int &ys);
};


/* The Only difference between Solid_Object
 * and Fall_Thru_Object is that the character will
 * be able to fall through this object.
 *
 * To fall through this type of object, a character's
 * fall_thru flag must be set and the y_velocity must
 * be positive.
 */ 
class Fall_Thru_Object : public Object
{
 public:
  Fall_Thru_Object(int &x, int &y, int &x1, int &y1);
  bool boundary_x_check(int &x, int &xs);
  bool boundary_y_check(int &y, int &ys);
};


/* 08/18/03
 *  The class for Max's bullets.
 *
 *  The way that we're going to handle Max's bullets is to
 *  have a global list of MaxBullets.  During the enemy
 *  update functions, the function will check to see if a
 *  boundary violation occured between the enemy and any 
 *  of the bullets.  If there is a boundary violation,
 *  the enemy life will be subtracted and the corresponding
 *  bullet will be removed from the list.
*/
class MaxBullet
{
 private:
  int x0, y0, x, y, xs, ys;
  int speed_frame, image_frame;
  RLE_SPRITE *image;
  string bullet_type;
  bool hit_object;

 public:
  MaxBullet(int &input_x, int &input_y, int &input_xs, int &input_ys, string &input_type);
  bool boundary_check(int x1, int y1, int x2, int y2);
  void display();
  void translate();
  void update();
}; 


/* The class for the levels.
 *
 * First, we have some meta-data at the beginning
 * to indicate static information about the level such
 * as the level_number, horizontal max and min, vertical
 * max and min, and whether to enable scrolling or not.
 *
 * 5/23/03
 * I'll continue after I get back to Texas.  First thing is
 * to look up syntax for vector or list and to create a list
 * of objects for the level.  The other list will be for the
 * enemies in the level.  To initialize the lists, we will
 * read the numbers and bitmap names from a data file.
*/
class Level
{
private:
  
  // Below variables are in the header of the datafile
  int max_x;
  int max_y;
  BITMAP *background;
  bool scroll_x_enable;
  bool scroll_y_enable;
  bool circle_x_enable;
  bool circle_y_enable;
  bool go_back_x_enable;
  bool go_back_y_enable;
  int minimum_x;
  int maximum_x;
  int minimum_y;
  int maximum_y;
  string level_x_direction;
  string level_y_direction;
  bool boss_enable;
  RLE_SPRITE *boss_name;
  BITMAP *boss_background;

  //below variables are in the datafile
  vector<Object> bg_objs;  // background objects.
  vector<Solid_Object> solid_objs;
  vector<Fall_Thru_Object> fall_thru_objs;
  vector<Enemy> enemy_objs;


  // Below variables are going to be used to indicate
  // how the character relates to the other characters
  // and objects on the level.
  bool boundary_x_violation;   // Did the character hit a boundary?
  bool boundary_y_violation;
  bool floor_violation;      // Is there a floor under the character?
  bool enemy_violation;      // Did the character hit a enemy?
  bool scroll_x_violation;     // Is character able to scroll?
  bool scroll_y_violation;

public:
  Level(string level_name);
  void display();
  void update();

  //Functions to check for violations
  bool scroll_x_violation_check(int x, int xs);
  bool scroll_y_violation_check(int y, int ys);
  bool enemy_violation_check(int x, int y);
  bool boundary_x_violation_check(int x, int y, int xs, int ys);
  bool boundary_y_violation_check(int x, int y, int xs, int ys);
};


//************Function declarations below**************************
void intro();
void game_loop(Level &level, Max &max);
void game_loop_helper(Level &level, Max &max);










