//supermax.cc

#include "supermax.h"

bool scroll_on;
//This will only be on for DOS.
//The values which will be used if scroll is not on:
int scroll_x_1;
int scroll_x_2;
int scroll_x_3;
DATAFILE *data;
bool MIDI_OUTPUT;
bool QUIT;
BITMAP *buffer;
BITMAP *buffer2;
BITMAP *buffer3;
int scroll_x;
int scroll_y;

// These variables are self explanatory.
// They represent a frame of reference for all
// the objects in the game.  These variables only move when the
// screen scrolls.
int global_x;
int global_y;
int shift_x;
int shift_y;

vector<MaxBullet> maxbullets;


//Some function declarations
void game_loop(Level &level, Max &max);
void game_loop_helper(Level &level, Max &max);
void begin_level(Level &level, Max &max);

// This one is for controlling the overall game speed
volatile int game_time;
void game_timer(void)
{
  game_time++;
}
END_OF_FUNCTION(game_timer);



int main(int argc, char *argv[])
{

// I will have scroll_on = false for Linux and MacOS X and have it true
// for DJGPP.
scroll_on = false;
scroll_x_1 = 0;
scroll_x_2 = 320;
scroll_x_3 = -320;
global_x = 0;
global_y = 0;
shift_x = 0;
shift_y = 0;


//************Initialization code below.********************
//
// The initialization steps include doing the allegro init,
// setting the graphics mode, loading the datafile, setting
// the palette and then after these usual steps, we must
// initialize the game info.
//
srand(time(NULL));
allegro_init();
install_keyboard();
install_timer();
data = load_datafile("supermax.dat");

QUIT = false;

//set gfx mode
if (set_gfx_mode(GFX_AUTODETECT, 320, 240, 320, 240) != 0) {
   set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
   allegro_message("Unable to set any graphic mode\n%s\n", allegro_error);
   return 1;
}
buffer = create_bitmap(SCREEN_W, SCREEN_H);
buffer2 = create_bitmap(SCREEN_W, SCREEN_H);
buffer3 = create_bitmap(SCREEN_W, SCREEN_H);
scroll_x = 0;

set_color_conversion(COLORCONV_NONE);
set_palette( (const RGB*) data[SUPER_PAL].dat);

//set up the timer interrupts.
LOCK_VARIABLE(game_time);
LOCK_FUNCTION((void*) game_timer);
install_int(game_timer, 30);
intro();
release_screen();

 Level debug_level("level1.dat");

 int max_x = 130;
 int max_y = 100;
 Max max(max_x, max_y);
 begin_level(debug_level, max);
 readkey();

remove_int(game_timer);
return 0;
}
END_OF_MAIN();


void begin_level(Level &level, Max &max)
{
  // A set of if statements and calls to helper functions
  // for the story line.

  // Enter the game
  game_loop(level, max);

  // A set of if statements for calls to helper functions
  // for the story line.

}


//Below we must do the game loop
void game_loop(Level &level, Max &max)
{
  while (!QUIT)
    {
  //  First we need to do an update to the level.
  //  1. move all the characters (exluding max)
  //  2. move the objects.
  //  3. and then scroll the screen.
      for (int index = 0; index < maxbullets.size(); index++)
	maxbullets[index].update();

      level.update();

  //  Then we need to display the background and
  //  the characters/objects within sight of max,
  //  and then draw max himself.
      level.display();
      
      for (int index = 0; index < maxbullets.size(); index++)
	maxbullets[index].display();

      max.Max::display();

      blit(buffer, screen, 0, 0, scroll_x_1, 0, 320, 200);
      blit(buffer2,screen, 0, 0, scroll_x_2, 0, 320, 200);
      blit(buffer3,screen, 0, 0, scroll_x_3, 0, 320, 200);

      rest(1);

  //  Finally we need to handle the user input
  //  through our helper function.
      max.standstill();
      if (keypressed())
	game_loop_helper(level, max);
    }
}


//Below is for handling the user input.
void game_loop_helper(Level &level, Max &max)
{
  switch (readkey() >> 8)
    {      
      // This key is for quitting the game.
    case KEY_ESC:
      QUIT = true;
      break;

      // This key is for jumping.
    case KEY_X:
      
      break;

      //This key if for firing gun.
    case KEY_D:
      max.firegun();
      break;

      // This key is for switching weapon.
    case KEY_S:
      
      break;


      // With the left and right keys, we must do a
      // scroll_violation check before moving character.
    case KEY_LEFT:
      
      if ( (!key[KEY_LCONTROL]) && (!key[KEY_UP]))
	{
	  scroll_x_1 += 2;
	  scroll_x_2 += 2;
	  scroll_x_3 += 2;
	  global_x -= 2;
 
	  if (scroll_x_1 == 320)
	    {
	    scroll_x_1 = 0;
	    scroll_x_2 = 320;
	    scroll_x_3 = -320;
	    }
	  int temp_x1a;
      int temp_y1a;
      temp_x1a = -2;
      temp_y1a = 0;
      max.translate(temp_x1a, temp_y1a);
	
	}

      break;

    case KEY_RIGHT:

      if ( (!key[KEY_LCONTROL]) && (!key[KEY_UP]))
	{	
	  scroll_x_1 -= 2;
	  scroll_x_2 -= 2;
	  scroll_x_3 -= 2;
	  global_x += 2;

	  if (scroll_x_1 == -320)
	    {
	    scroll_x_1 = 0;
	    scroll_x_2  = 320;
	    scroll_x_3 = -320;
	    }
	  int temp_x1;
	  int temp_y1;
	  temp_x1 = 2;
	  temp_y1 = 0;
	  max.translate(temp_x1, temp_y1);
	
	}
      break;

    case KEY_DOWN:
      break;

    case KEY_UP:

      break;

    default:
      break;
    }

  if ( (key[KEY_RIGHT] && key[KEY_LCONTROL]) && (!key[KEY_UP]))
    {
	  scroll_x_1 -= 2;
	  scroll_x_2 -= 2;
	  scroll_x_3 -= 2;
	  global_x += 2;

	  if (scroll_x_1 == -320)
	    {
	    scroll_x_1 = 0;
	    scroll_x_2 = 320;
	    scroll_x_3 = -320;
	    }

      int temp_x1;
      int temp_y1;
      temp_x1 = 2;
      temp_y1 = 0;

      max.diagonal_translate(temp_x1, temp_y1);
    }

  if ( (key[KEY_LEFT] && key[KEY_LCONTROL]) && (!key[KEY_UP]))
    {
	  scroll_x_1 += 2;
	  scroll_x_2 += 2;
	  scroll_x_3 += 2;
	  global_x -= 2;

	  if (scroll_x_1 == 320)
	    {
	    scroll_x_1 = 0;
	    scroll_x_2 = 320;
	    scroll_x_3 = -320;
	    }
      
      int temp_x1;
      int temp_y1;
      temp_x1 = -2;
      temp_y1 = 0;

      max.diagonal_translate(temp_x1, temp_y1);
    }


  if ( (key[KEY_UP] && key[KEY_RIGHT]) && key[KEY_LCONTROL])
    { 
	  scroll_x_1 -= 2;
	  scroll_x_2 -= 2;
	  scroll_x_3 -= 2;
	  global_x += 2;

	  if (scroll_x_1 == -320)
	    {
	    scroll_x_1 = 0;
	    scroll_x_2 = 320;
	    scroll_x_3 = -320;
	    }

      int temp_x1;
      int temp_y1;
      temp_x1 = 2;
      temp_y1 = 1;

      max.diagonal_translate(temp_x1, temp_y1);
    }    

 if ( (key[KEY_UP] && key[KEY_LEFT]) && key[KEY_LCONTROL])
    { 
	  scroll_x_1 += 2;
	  scroll_x_2 += 2;
	  scroll_x_3 += 2;
	  global_x -= 2;

	  if (scroll_x_1 == 320)
	    {
	    scroll_x_1 = 0;
	    scroll_x_2 = 320;
	    scroll_x_3 = -320;
	    }
      
      int temp_x1;
      int temp_y1;
      temp_x1 = -2;
      temp_y1 = 1;

      max.diagonal_translate(temp_x1, temp_y1);
    }    
}

