//object.cc

#include "supermax.h"
#include <fstream>

extern DATAFILE *data;
extern BITMAP *buffer;
extern BITMAP *buffer2;
extern BITMAP *buffer3;
extern int global_x;
extern int global_y;
extern int scroll_x_1;
extern int scroll_x_2;
extern int scroll_x_3;

Object::Object()
{
 ofstream defaultobject("default_object.txt");
 defaultobject << "Calling default object()\n";
}

Object::Object(int &x, int &y, int &x1, int &y1, string &object_name)
{
  min_x = x;
  min_y = y;
  max_x = x1;
  max_y = y1;

  /* My apologies for the excessive amounts of if
     statements below, but I don't know of any way
     in C++ to write something like,

     sprite_texture = (RLE_SPRITE *) data[$object_name].dat;

     And no, I won't make the datafiles C++ files.  I want the
     levels to be modifiable without having to do recompilation.
     Nonetheless I will get this game done with less than
     10,000 lines of code.
  */
  object_name1 = object_name;
  
  if (object_name.compare("SAND4")==0)
    sprite_texture = (RLE_SPRITE *) data[SAND4_RLE].dat;

  if (object_name.compare("GRASS1")==0)
    sprite_texture = (RLE_SPRITE *) data[GRASS1].dat;
  
  if (object_name.compare("BARK1")==0)
    sprite_texture = (RLE_SPRITE *) data[BARK1].dat;

  if (object_name.compare("BARK2")==0)
    sprite_texture = (RLE_SPRITE *) data[BARK2].dat;

  if (object_name.compare("PALMT1")==0)
    sprite_texture = (RLE_SPRITE *) data[PALMT1].dat;

  if (object_name.compare("PALMT2")==0)
    sprite_texture = (RLE_SPRITE *) data[PALMT2].dat;

  if (object_name.compare("PALMS1")==0)
    sprite_texture = (RLE_SPRITE *) data[PALMS1].dat;

  if (object_name.compare("PALMS2")==0)
    sprite_texture = (RLE_SPRITE *) data[PALMS2].dat;

  if (object_name.compare("DIRT")==0)
    sprite_texture = (RLE_SPRITE *) data[DIRT].dat;
  
  if (object_name.compare("DIRT2")==0)
    sprite_texture = (RLE_SPRITE *) data[DIRT2].dat;

  if (object_name.compare("TENT1")==0)
    sprite_texture = (RLE_SPRITE *) data[TENT1].dat;

  if (object_name.compare("TENTZ")==0)
    sprite_texture = (RLE_SPRITE *) data[TENTZ].dat;

  if (object_name.compare("TENT2")==0)
    sprite_texture = (RLE_SPRITE *) data[TENT2].dat;

  if (object_name.compare("TENT3")==0)
    sprite_texture = (RLE_SPRITE *) data[TENT3].dat;

  if (object_name.compare("TENT2A")==0)
    sprite_texture = (RLE_SPRITE *) data[TENT2A].dat;
  
  if (object_name.compare("TENT3A")==0)
    sprite_texture = (RLE_SPRITE *) data[TENT3A].dat;

  if (object_name.compare("BONE")==0)
    sprite_texture = (RLE_SPRITE *) data[BONE].dat;

  if (object_name.compare("BONE2")==0)
    sprite_texture = (RLE_SPRITE *) data[BONE2].dat;

  if (object_name.compare("FLAME")==0)
    sprite_texture = (RLE_SPRITE *) data[FLAME1].dat;

  if (object_name.compare("BRASS")==0)
    sprite_texture = (RLE_SPRITE *) data[BRASS2].dat;

  if (object_name.compare("FLOOR1")==0)
    sprite_texture = (RLE_SPRITE *) data[FLOOR1].dat;

  if (object_name.compare("TILE5A")==0)
    sprite_texture = (RLE_SPRITE *) data[TILE5A].dat;

  if (object_name.compare("TILE3A")==0)
    sprite_texture = (RLE_SPRITE *) data[TILE3A].dat;

  display_frame = 10;
}

void Object::update()
{
  if (object_name1.compare("FLAME")==0)
    {
      display_frame--;
      if (display_frame <= 0)
	display_frame = 10;
      
      if (display_frame > 5)
	sprite_texture = (RLE_SPRITE *) data[FLAME2].dat;
      else
	sprite_texture = (RLE_SPRITE *) data[FLAME1].dat;
    }
}

void Object::display()
{
  //int draw_x = min_x + 160;
  //int draw_y = min_y;

  for (int draw_y = min_y; draw_y <= max_y; draw_y += 20)
  for (int draw_x = min_x + 160; draw_x <= max_x+160; draw_x += 20)
      {
	draw_rle_sprite(buffer, (RLE_SPRITE *) sprite_texture, draw_x-global_x-scroll_x_1, draw_y);

	if (sprite_texture == data[SAND4A].dat)
	  draw_rle_sprite(buffer, (RLE_SPRITE *) sprite_texture, draw_x-global_x-scroll_x_1, draw_y-2);
	

	draw_rle_sprite(buffer2, (RLE_SPRITE *) sprite_texture, draw_x-global_x-scroll_x_2, draw_y);

	if (sprite_texture == data[SAND4A].dat)
	  draw_rle_sprite(buffer2, (RLE_SPRITE *) sprite_texture, draw_x-global_x-scroll_x_2, draw_y-2);

	draw_rle_sprite(buffer3, (RLE_SPRITE *) sprite_texture, draw_x-global_x-scroll_x_3, draw_y);

	if (sprite_texture == data[SAND4A].dat)
	  draw_rle_sprite(buffer3, (RLE_SPRITE *) sprite_texture, draw_x-global_x-scroll_x_3, draw_y-2);
      }

}

Solid_Object::Solid_Object(int &x, int &y, int &x1, int &y1, string &object_name)
{
  set_values(x, y, x1, y1, object_name);
}

/* There is a subtle difference between boundary-x-check and
   boundary-y-check.
   With the x-check, we determine if character hits object from
   side.  With y-check, we determine if character his object from
   above/below.
*/
bool Solid_Object::boundary_x_check(int &x, int &y, int &xs, int &ys)
{
  bool boundary_violation = false;
  if ( (x+xs > min_x) && (x+xs < max_x))
    {
      if ( (y>min_y) && (y<max_y) )
	boundary_violation = true;
    }
    return boundary_violation;
}

bool Solid_Object::boundary_y_check(int &x, int &y, int &xs, int &ys)
{
  bool boundary_violation = false;
  if ( (y+ys > min_y) && (y+ys < max_y))
    {
      if ( (x>min_x) && (x<max_x) )
	boundary_violation = true;
    }
    return boundary_violation;
}
