//Enemy.cc
#include "supermax.h"
#include <fstream>

extern DATAFILE *data;
extern BITMAP *buffer;
extern BITMAP *buffer2;
extern BITMAP *buffer3;
extern int global_x;
extern int global_y;
extern int shift_x;
extern int shift_y;

Enemy::Enemy(int &input_x, int &input_y, string &input_name)
{
  if (input_name.compare("ZOMBIE")==0)
    {
      Character::d = left;
      speed_frame = 0;
      display_frame = 50;
      int input_xs = -1;
      int input_ys = 0;
      int input_strength = 10;
      bool input_fall_thru = false;
      Character::set_values(input_x, input_y, input_xs, input_ys, input_strength, input_fall_thru, input_name);
      Character::image = (RLE_SPRITE *) data[ZOMBIE1].dat;
    }
}

void Enemy::display()
{
  Character::display();
}

void Enemy::update()
{
  //Every enemy is going to be handled differently.
  if (Character::name.compare("ZOMBIE")==0)
    {
      //Should ZOMBIE change direction? 
      int relative_x = global_x+160+shift_x;

      if (relative_x < x-50) 
	Character::d = left;

      if (relative_x > x+80)
	Character::d = right;

      if ((speed_frame == 0) && (Character::d == left))
	xs = -1;
      if ((speed_frame == 0) && (Character::d == right))
	xs = 1;
      
      if (speed_frame > 0)
      	xs = 0;
     
      if (display_frame < 25)
	{
	  if (Character::d == left)
	    Character::image = (RLE_SPRITE *) data[ZOMBIE1A].dat;
	  if (Character::d == right)
	    Character::image = (RLE_SPRITE *) data[ZOMBIE2A].dat;
	}   
	else
	  {
	    if (Character::d == left)
	      Character::image = (RLE_SPRITE *) data[ZOMBIE1].dat;
	    if (Character::d == right)
	      Character::image = (RLE_SPRITE *) data[ZOMBIE2].dat;
	  }
      speed_frame--;
      display_frame--;

      if (speed_frame < 0)
	speed_frame = 3;
      
      if (display_frame < 0)
	display_frame = 50;

      Character::translate(xs, ys);

    }

}
