// "Hello! Allegro!" DemoHack entry header file,
// Copyright 2003 Kenneth Thornton. All rights reserved.
//
// Please use in good health.
//
//

#include <allegro.h>


#define __DOS            1               // uncomment for DOS build
//#define __WIN          1               // uncomment for WIN32 build
//#define __LIN          1               // uncomment for Linux build

#define BIT_WRAP         0xFF            // Standard 8-bit wrapping tag
#define EVEN_ODD         0x01            // For determining even/odd status
#define MAX_ISO          10              // Total number of iso fields
#define MAX_ISO_X        20              // Number of ISO rows
#define MAX_ISO_Y        23              // Number of ISO columns
#define MAX_TEXT         1500            // Maximum number of text strings
#define MAX_LOGO         14              // Maximum letters in rolling logo
#define MAX_CELS         471             // Maximum number of ISO field cels


extern BITMAP *screenbuf;                // Screen buffer
extern BITMAP *construct;                // For constructing rolling logo
extern BITMAP *_32x_textures;            // For holding 32x32 textures
extern BITMAP *_font;                    // Standard scrollie font
extern BITMAP *iso_backs[10];            // Backgrounds for iso field
extern BITMAP *scrollie[60];             // Bitmap text for scrollie
extern BITMAP *logo[54];                 // Bitmap text for rolling logo
extern BITMAP *subs;                     // For working with sub bitmaps
extern BITMAP *trash;                    // For loading and splicing bitmap

extern COLOR_MAP shadows_1;              // Holds shadow maps for backdrops
extern COLOR_MAP shadows_2;              //
extern COLOR_MAP shadows_3;              //
extern COLOR_MAP shadows_4;              //
extern COLOR_MAP shadows_5;              //
extern COLOR_MAP shadows_6;              //
extern COLOR_MAP shadows_7;              //
extern COLOR_MAP shadows_8;              //
extern COLOR_MAP shadows_9;              //
extern COLOR_MAP shadows_10;             //
extern COLOR_MAP lights_1;               // Holds light maps for backdrops
extern COLOR_MAP lights_2;               //
extern COLOR_MAP lights_3;               //
extern COLOR_MAP lights_4;               //
extern COLOR_MAP lights_5;               //
extern COLOR_MAP lights_6;               //
extern COLOR_MAP lights_7;               //
extern COLOR_MAP lights_8;               //
extern COLOR_MAP lights_9;               //
extern COLOR_MAP lights_10;              //
extern COLOR_MAP trashmap;               // Yep, it's for trash collection

extern PALETTE palette;                  // Palette for ground (127-)
extern PALETTE tinted;                   // Palette for ground AFTER tint
extern PALETTE junk;                     // For garbage collection, etc.
extern PALETTE iso_pal[MAX_ISO];         // Palette to dump trash into :)

extern MIDI *muzak;                      // Holds midi data




// Demo-specific data containers
//
extern char *__text;                     // Pointer to physical space for text
extern char *_shadows[11];               // Holds pointers to shadow maps
extern char *_lights[11];                // Holds pointers to light maps



// Contained in HA_MAIN.CPP
//
extern void extract_resource(char *file, long offset, long len);
                                         // Loads data from resource file
extern void HA_final_pass(BITMAP *buf);  // Sends back buffer to video memory
extern void HA_status_log_i(const char *__textstring, int value);
                                         // For painfully slow DOS debugging!




// Contained in HA_REDK.CPP
//
extern void RK_intro();




// Structures/ classes follow
//
typedef struct FLAG
{
    bool vsync;                          // boolean: TRUE if vsync is enabled
    bool exit;                           // boolean: TRUE if exit is triggered
    bool no_audio;                       // bollean: TRUE if no audio is available
    int ticks;                           // Counts cpu ticks for demo timing
    int tocks;                           // Counts cpu ticks for demo timing
    int logo_spawn[MAX_LOGO];            // Points at which letters are spawned
    int scrollie_pos;                    // Current position within scrollie text
    int dot_pos;                         // Current highlight position within dot background
    short move_cels;                     // Counter for moving ISO field cels
    short move_logo;                     // Counter for moving rolling logo
    short iso_mode;                      // 1 = scatter, 2 = rise/fall, 3 = ???
    short iso_pic;                       // Current pic used as ISO field backdrop
    short tint_pending;                  // > 0 if palette tint is pending
    short sine;                          // Tracks offset for fsin calcs
    short pause_sine;                    // If > 0, pause sine tracking for x cycles
    float logo_sine[MAX_LOGO];           // tracks logo offsets for fsin calcs
    
} FLAG;




typedef struct SNAPSHOT
{
    int scroll;                          // Mirror of flags.scrollie_pos;
    int tint;                            // Mirror of flags.tint_pending;

} SNAPSHOT;




typedef struct CEL
{
    short x[MAX_CELS];                   // BASE x position of iso cel
    short y[MAX_CELS];                   // BASE y position of iso cel
    short at_x[MAX_CELS];                // Physical x position of cel
    short at_y[MAX_CELS];                // Physical y position of cel
    short dir[MAX_CELS];                 // Direction of travel (0-7 clockwise)
    short dist[MAX_CELS];                // Distance left to travel (in pixels)

} CEL;




typedef struct LOGO
{
    bool active[MAX_LOGO];               // boolean: TRUE if letter is active
    short x[MAX_LOGO];                   // BASE x position of letter
    short y[MAX_LOGO];                   // BASE y position of letter
    short index[MAX_LOGO];               // Current index in path array
    short value[MAX_LOGO];               // Current (char) value of letter
    fixed at_x[MAX_LOGO];                // Physical x position of letter
    fixed at_y[MAX_LOGO];                // Physical y position of letter
    
} LOGO;

