// "HelLO! AllEgRo!" DemoHack entry, Copyright 2003 Kenneth Thornton.
// All rights reserved; all wrongs reversed, free at last.
// Another lo-res, lo-color, socially-conscious-metaphor-free
// RedKarma production.
//
//
// PRODUCTION NOTES:
//
// This is the source code to my Allegro DemoHack entry... entitled
// "HelLO! AllEgRo!" This was coded over the course of two partial days,
// with no more than four hours per day spent on the code. So, if this
// isn't up to your strenuous standards, or isn't optimized properly, feel
// free to choke on my schlong :)
//
// I wonder if there's a 'c' in schlong. Hmmm....
//
//
//
// YOU ARE HERE ------> X (ha_main.cpp)
//
//
// HA_MAIN.CPP : Contains entry and exit code for demo, as well as basic
//               variable init code, timers... pretty much everything.
//
// Please note that before compilation you need to uncomment the *appropriate*
// DEFINE in HA_DEMO.H, otherwise the compiler will not know whether to use
// DOS, Win32, or Linux commands. Also, I make *extensive* use of casts to
// promote the best possible portability across multiple compilers. Due to
// time constraints, hardware accel was not implemented at all, and there is
// a bare minimum of optimization involved. Code stresses readability as
// opposed to performance.
//
// Compiling under DJGPP will produce warnings due to the timers not being
// declared as blah(...). This makes MingW happy, but pisses off DJGPP. Small
// price to pay for ruling the world, says I.
//
// This doesn't have any exception handling! If something goes wrong, it
// all goes kablooie.
//
//
// No programmers were harmed during the production of this demo.
//




#include "ha_demo.h"
#include <allegro.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>




// - STRUCTURES -
//
// The following structures apprear in this source file, and are
// declared in HA_DEMO.H.
//
FLAG flags;                              // Contains data for demo flags
CEL  cels;                               // Contains data for ISO field cels
SNAPSHOT snap;                           // Contains frame snapshot data
LOGO _logo;                              // Contains logo position data




// - ALLEGRO SPECIFICS -
//
// The following Allegro-specific objects appear in this source file,
// and are declared in HA_DEMO.H.
//
BITMAP *screenbuf;                       // Double buffering backbuffer
BITMAP *construct;                       // For constructing rolling logo
BITMAP *_32x_textures;                   // For holding 32x32 textures
BITMAP *_font;                           // Standard scrollie font
BITMAP *iso_backs[10];                   // Backgrounds for iso field
BITMAP *scrollie[60];                    // Bitmap text for scrollie
BITMAP *logo[54];                        // Bitmap text for rolling logo
BITMAP *subs;                            // For working with sub bitmaps
BITMAP *trash;                           // For loading and splicing bitmap

COLOR_MAP shadows_1;                     // Holds shadow maps for backdrops
COLOR_MAP shadows_2;                     //
COLOR_MAP shadows_3;                     //
COLOR_MAP shadows_4;                     //
COLOR_MAP shadows_5;                     //
COLOR_MAP shadows_6;                     //
COLOR_MAP shadows_7;                     //
COLOR_MAP shadows_8;                     //
COLOR_MAP shadows_9;                     //
COLOR_MAP shadows_10;                    //
COLOR_MAP lights_1;                      // Holds light maps for backdrops
COLOR_MAP lights_2;                      //
COLOR_MAP lights_3;                      //
COLOR_MAP lights_4;                      //
COLOR_MAP lights_5;                      //
COLOR_MAP lights_6;                      //
COLOR_MAP lights_7;                      //
COLOR_MAP lights_8;                      //
COLOR_MAP lights_9;                      //
COLOR_MAP lights_10;                     //
COLOR_MAP trashmap;                      // Yep, it's for trash collection

PALETTE palette;                         // Standard all-purpose palette
PALETTE tinted;                          // For holding tinted pal data
PALETTE junk;                            // For throw-away stuff... heh
PALETTE iso_pal[MAX_ISO];                // Might come in handy :)

MIDI *muzak;                             // Holds midi data




// - DATA CONTAINERS & VARIABLES -
//
// The following arrays, pointers, and variables appear in this
// source file:
//
char *__text;                            // Pointer to physical space for text
char *_shadows[11];                      // Array of pointers to shadowmaps
char *_lights[11];                       // Array of pointers to lightmaps




// - DECLARATIONS -
//
// The following routines are found in no particular order throughout
// this source file:
//

void HA_track_stuff();                   // Timer routine for maintaining demo speed
void HA_track_logo();                    // Timer routine for moving rolling logo
void HA_track_transition();              // Checks for ISO field pic change
void HA_move_cels();                     // Moves ISO field cels
void HA_demo_loop();                     // This is where the mojo is workin'
void HA_draw_iso_field(BITMAP *buf);     // Draws isometric height field to backbuffer
void HA_draw_scrollie(BITMAP *buf);      // Draws scrollie data to backbuffer
void HA_draw_extras(BITMAP *buf);        // Draws other, unplanned stuff
void HA_draw_dots(BITMAP *buf);          // Draws dot background
void HA_assign_iso_field(int mode);      // Sets initial values for ISO cels
void HA_modify_palette(PALETTE _pal);    // Checks for impending palette tint
void HA_read_color_maps();               // Load color map data
void HA_startup();                       // Initializes Allegro back-end
void HA_shutdown();                      // Shuts Allegro down, and kills the demo
void HA_take_snapshot();                 // Takes snapshot of data for frame
void HA_initialize_variables();          // Does what it says, says what it does
void HA_load_resources();                // Loads any external data files
void HA_tint_palette(PALETTE _pal, int red, int green, int blue, int percent, int luma, int full);
                                         // Tints 8bpp palette to given values




// - ROUTINES -
//
// The routines that make stuff happen. Yep.
//

void HA_track_logo()
{
 short i;                                // Loop control variable

 // Increment sine index
 // This needs to be a float for extra precision
 //
 for(i=0; i<MAX_LOGO; i++) {
     flags.logo_sine[i] += 0.20;
     if(flags.logo_sine[i] > 255.00) { flags.logo_sine[i] -= 255.00; }
                           }
 
 // Check for logo movement at this point
 //
 flags.move_logo++;
 if(flags.move_logo > 4) {
     flags.move_logo = 0;
     for(i=0; i<MAX_LOGO; i++) {
         _logo.at_x[i] += fsin(ftofix(flags.logo_sine[i])) * 2;
         _logo.at_y[i] += fcos(ftofix(flags.logo_sine[i])) * 2;
                               }
                         }

 // Check for any spawning letters
 //
 for(i=0; i<MAX_LOGO; i++) {
     if(flags.logo_spawn[i] == flags.ticks) {
         _logo.at_x[i] = itofix(63);
         _logo.at_y[i] = itofix(85);
         _logo.index[i] = 0;
         _logo.active[i] = 1;
         flags.logo_sine[i] = 0.0;
         flags.logo_spawn[i] = -1;
                                            }
                           }

 return;
}

END_OF_FUNCTION(HA_track_logo);




void HA_track_stuff()
{
 short i;                                // Loop control variable

 // Increment demo 'heartbeats'
 //
 flags.ticks++;
 flags.tocks++;

 // Check for pending palette_tints
 //
 if(flags.tint_pending > -1) {
     flags.tint_pending--;
     // If tint is over, restore original palette
     // (just to be safe)
     if(flags.tint_pending < 1) { flags.tint_pending = -2; }
                             }

                           
 if(!flags.pause_sine) {
     flags.sine++; flags.sine &= BIT_WRAP;
     // If we've completed one loop... pause and reset cel positions.
     // We have to do this due to lack of precision :(
     //
     if(flags.sine == 255) {
         flags.pause_sine = 70;
         HA_assign_iso_field(flags.iso_mode);
                           }
                       }
 else { flags.pause_sine--; }


 // Move scrollie through the buffer
 //
 flags.scrollie_pos++;

 // Move the dot background through its cycle
 //
 flags.dot_pos++;
 if(flags.dot_pos == 200) { flags.dot_pos = 0; }

 // Move cels along their designated path
 //
 HA_move_cels();

 return;
}

END_OF_FUNCTION(HA_track_stuff);




void HA_move_cels()
{
 short i;                                // Loop control variable
 short _sine;                            // Helper variable

 // Now for ISO cel movement
 //
 if(!flags.pause_sine) {
     flags.move_cels++;
     if(flags.move_cels > 4) {           // 60 / 4 gives a nice round number

         // Jumble cels in circular path
         //
         if(flags.iso_mode == 1) {

             // We want nice, angular movements (so avoid proper casting)
             //
             flags.move_cels = 0;
             for(i=0; i<MAX_CELS; i++) {
                 switch(cels.dir[i]) {
                     case 0: cels.at_x[i] += fixtoi(fsin(itofix(flags.sine)));
                             cels.at_y[i] += fixtoi(fcos(itofix(flags.sine)));
                             break;
                         
                     case 1: cels.at_x[i] -= fixtoi(fsin(itofix(flags.sine)));
                             cels.at_y[i] += fixtoi(fcos(itofix(flags.sine)));
                             break;
                         
                     case 2: cels.at_x[i] += fixtoi(fsin(itofix(flags.sine)));
                             cels.at_y[i] -= fixtoi(fcos(itofix(flags.sine)));
                             break;
                         
                     case 3: cels.at_x[i] -= fixtoi(fsin(itofix(flags.sine)));
                             cels.at_y[i] -= fixtoi(fcos(itofix(flags.sine)));
                             break;
                                     }
                                       }
                                       
                                 }

         // Slide cels up/down
         //
         if(flags.iso_mode == 2) {

             flags.move_cels = 0;
             for(i=0; i<MAX_CELS; i++) {
                 _sine = cels.dir[i] + flags.sine;
                 _sine &= BIT_WRAP;
                 cels.at_y[i] += fixtoi(fsin(itofix(_sine)));
                                       }
                                       
                                 }


         // Slide cels left/right
         //
         if(flags.iso_mode == 3) {

             flags.move_cels = 0;
             for(i=0; i<MAX_CELS; i++) {
                 _sine = cels.dir[i] + flags.sine;
                 _sine &= BIT_WRAP;
                 cels.at_x[i] += fixtoi(fsin(itofix(_sine)));
                                       }
                                       
                                 }

         // Slide diagonal
         if(flags.iso_mode == 4) {
         
             flags.move_cels = 0;
             for(i=0; i<MAX_CELS; i++) {
                 switch(cels.dir[i]) {
                     case 0: cels.at_x[i] += fixtoi(fsin(itofix(flags.sine)));
                             cels.at_y[i] += fixtoi(fsin(itofix(flags.sine)));
                             break;
                         
                     case 1: cels.at_x[i] -= fixtoi(fsin(itofix(flags.sine)));
                             cels.at_y[i] += fixtoi(fsin(itofix(flags.sine)));
                             break;
                         
                     case 2: cels.at_x[i] += fixtoi(fsin(itofix(flags.sine)));
                             cels.at_y[i] -= fixtoi(fsin(itofix(flags.sine)));
                             break;
                         
                     case 3: cels.at_x[i] -= fixtoi(fsin(itofix(flags.sine)));
                             cels.at_y[i] -= fixtoi(fsin(itofix(flags.sine)));
                             break;
                                     }
                                       }
                                       
                                 }


                                 
                             }
                        }

 return;
}

END_OF_FUNCTION(HA_move_cels);




// NOTE: Sets initial values for ISO field cels
//
void HA_assign_iso_field(int mode)
{
 short i,j;                              // Loop control variables
 short _x,_y;                            // Starting x,y coords for iso cel
 short s_x = 18;                         // Starting x coord for iso field
 short s_y = 4;                          // Starting y coord for iso field
 short x_off[2] = { 0, -7 };             // x offset for even number cel rows
 short accum = 0;                        // For tracking cel data table index
 short _sine;
 
 for(i=0; i<MAX_ISO_Y; i++) {
 
     // Locate starting position
     //
     _x = s_x + x_off[i & EVEN_ODD];
     _y = s_y + (8 * i);
     
     for(j=0; j<(MAX_ISO_X + (i & EVEN_ODD)); j++) {
         cels.x[accum]    = _x + (14 * j);
         cels.y[accum]    = _y;
         cels.at_x[accum] = _x + (14 * j);
         cels.at_y[accum] = _y;
         cels.dist[accum] = 0;
         cels.dir[accum]  = ((rand() % 512) / 128);
         accum++;
                                                   }
                            }

 // If in up/down mode, we need to give initial offsets for cels
 //
 if(mode == 2) {
     for(i=0; i<MAX_CELS; i++) {
         cels.dir[i] = (rand() % 1024) / 4;
                               }
               }

 // If in left/right mode, we need to give initial offsets for cels
 //
 if(mode == 3) {
     for(i=0; i<MAX_CELS; i++) {
         cels.dir[i] = (rand() % 1024) / 4;
                               }
               }
               
 return;
}

END_OF_FUNCTION(HA_assign_iso_field);




void main()
{
 HA_startup();
 RK_intro();
 HA_demo_loop();
 HA_shutdown();

 return;
}

END_OF_MAIN();




// NOTE: Loops through endless demo until ESCAPE key is pressed
//
void HA_demo_loop()
{
 short i;
 
 flags.ticks = 0;
 
 HA_assign_iso_field(flags.iso_mode);

 // Install our timers
 //
 install_int_ex(HA_track_logo,BPS_TO_TIMER(120));
 install_int_ex(HA_track_stuff,BPS_TO_TIMER(60));
 
 set_palette(iso_pal[flags.iso_pic]);

 play_midi(muzak, 1);
 
 // Loop until Escape key shows up...
 //
 do {

   clear(screenbuf);
   HA_track_transition();
   HA_take_snapshot();
   HA_draw_dots(screenbuf);
   HA_draw_iso_field(screenbuf);
   HA_draw_scrollie(screenbuf);
   HA_draw_extras(screenbuf);
   HA_modify_palette(palette);
   HA_final_pass(screenbuf);

   // Too lazy to rewrite my repeater code, so this will have to do...
   //
   if(key[KEY_1]) { flags.vsync = 1; }
   if(key[KEY_2]) { flags.vsync = 0; }
   
   if(flags.exit) { goto ending; }
   
    } while(!key[KEY_ESC]);

 // Escape key pressed, now wait for release...
 //
 do {

   clear(screenbuf);
   HA_track_transition();
   HA_take_snapshot();
   HA_draw_dots(screenbuf);
   HA_draw_iso_field(screenbuf);
   HA_draw_scrollie(screenbuf);
   HA_draw_extras(screenbuf);
   HA_modify_palette(palette);
   HA_final_pass(screenbuf);

    } while(key[KEY_ESC]);

 // If program terminates after completing a loop, it'll jump here
 //
 ending:
 
 fade_out(4);
 remove_int(HA_track_stuff);
 remove_int(HA_track_logo);
 stop_midi();
 
 return;
}




void HA_startup()
{
 allegro_init();
 install_timer();
 install_keyboard();

 rest(0);
 HA_initialize_variables();

 HA_load_resources();


 #ifdef __WIN
 set_color_depth(8);
 set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);
 #endif

 #ifdef __DOS
 set_gfx_mode(GFX_AUTODETECT, 320, 240, 0, 0);
 #endif

 if(install_sound(DIGI_NONE, MIDI_AUTODETECT, "..") != 0) {
             printf("Sorry, MIDI is unavailable\r\n");
             flags.no_audio = 1;
                                                          }

 // In DOS, this is *pretty* important!
 //
 LOCK_FUNCTION(HA_move_cels);
 LOCK_FUNCTION(HA_track_logo);
 LOCK_FUNCTION(HA_track_stuff);
 LOCK_FUNCTION(HA_assign_iso_field);

 // Set volume: digital unchanged, midi maximum
 //
 set_volume(-1,255);

 return;
}




void HA_shutdown()
{
 short i;                                // Loop control variable

 // destroy bitmaps
 //
 destroy_bitmap(screenbuf);
 destroy_bitmap(construct);

 for(i=0; i<MAX_ISO; i++) { destroy_bitmap(iso_backs[i]); }

 for(i=0; i<60; i++) { destroy_bitmap(scrollie[i]); }
 for(i=0; i<54; i++) { destroy_bitmap(logo[i]); }

 return;
}




// NOTE: Loads bitmaps and other resources needed by the demo
//       A bit clunky, but it works...
//
void HA_load_resources()
{
 short i,j,k;                            // Loop control + shortcut variables
 
 // Load color maps from secondary resource file
 //
 HA_read_color_maps();

 // Load 10 backgrounds
 //
 extract_resource("res.dat", 28178, 30141);
 iso_backs[0] = load_pcx("tempola.xyz",iso_pal[0]);
 _shadows[0] = (char *)&shadows_1; _lights[0] = (char *)&lights_1;
 for(j=0; j<256; j++) { shadows_1.data[0][j] = j; lights_1.data[0][j] = j; }
  remove("tempola.xyz");

 extract_resource("res.dat", 422835, 48168);
 iso_backs[1] = load_pcx("tempola.xyz",iso_pal[1]);
 _shadows[1] = (char *)&shadows_2; _lights[1] = (char *)&lights_2;
 for(j=0; j<256; j++) { shadows_2.data[0][j] = j; lights_2.data[0][j] = j; }
  remove("tempola.xyz");

 extract_resource("res.dat", 113306, 29764);
 iso_backs[2] = load_pcx("tempola.xyz",iso_pal[2]);
 _shadows[2] = (char *)&shadows_3; _lights[2] = (char *)&lights_3;
 for(j=0; j<256; j++) { shadows_3.data[0][j] = j; lights_3.data[0][j] = j; }
  remove("tempola.xyz");

 extract_resource("res.dat", 143070, 39651);
 iso_backs[3] = load_pcx("tempola.xyz",iso_pal[3]);
 _shadows[3] = (char *)&shadows_4; _lights[3] = (char *)&lights_4;
 for(j=0; j<256; j++) { shadows_4.data[0][j] = j; lights_4.data[0][j] = j; }
  remove("tempola.xyz");

 extract_resource("res.dat", 182721, 63070);
 iso_backs[4] = load_pcx("tempola.xyz",iso_pal[4]);
 _shadows[4] = (char *)&shadows_5; _lights[4] = (char *)&lights_5;
 for(j=0; j<256; j++) { shadows_5.data[0][j] = j; lights_5.data[0][j] = j; }
  remove("tempola.xyz");

 extract_resource("res.dat", 245794, 60422);
 iso_backs[5] = load_pcx("tempola.xyz",iso_pal[5]);
 _shadows[5] = (char *)&shadows_6; _lights[5] = (char *)&lights_6;
 for(j=0; j<256; j++) { shadows_6.data[0][j] = j; lights_6.data[0][j] = j; }
  remove("tempola.xyz");

 extract_resource("res.dat", 306216, 35218);
 iso_backs[6] = load_pcx("tempola.xyz",iso_pal[6]);
 _shadows[6] = (char *)&shadows_7; _lights[6] = (char *)&lights_7;
 for(j=0; j<256; j++) { shadows_7.data[0][j] = j; lights_7.data[0][j] = j; }
  remove("tempola.xyz");

 extract_resource("res.dat", 341434, 54495);
 iso_backs[7] = load_pcx("tempola.xyz",iso_pal[7]);
 _shadows[7] = (char *)&shadows_8; _lights[7] = (char *)&lights_8;
 for(j=0; j<256; j++) { shadows_8.data[0][j] = j; lights_8.data[0][j] = j; }
  remove("tempola.xyz");

 extract_resource("res.dat", 395929, 16318);
 iso_backs[8] = load_pcx("tempola.xyz",iso_pal[8]);
 _shadows[8] = (char *)&shadows_9; _lights[8] = (char *)&lights_9;
 for(j=0; j<256; j++) { shadows_9.data[0][j] = j; lights_9.data[0][j] = j; }
  remove("tempola.xyz");

 extract_resource("res.dat", 58319, 54987);
 iso_backs[9] = load_pcx("tempola.xyz",iso_pal[9]);
 _shadows[9] = (char *)&shadows_10; _lights[9] = (char *)&lights_10;
 for(j=0; j<256; j++) { shadows_10.data[0][j] = j; lights_10.data[0][j] = j; }
  remove("tempola.xyz");

 // I don't like sub-bitmaps, so we'll do it this way instead.
 //
 extract_resource("res.dat", 0, 14249);
 trash = load_pcx("tempola.xyz",junk);
 for(i=0; i<6; i++) {
     for(j=0; j<10; j++) {
         k = (i * 10) + j;
         scrollie[k] = create_bitmap(31,19);
         blit(trash,scrollie[k],(32 * j),(20 * i),0,0,31,19);
                         }
                    }
 destroy_bitmap(trash);
  remove("tempola.xyz");

 
 // Logo font receives the same treatment
 //
 extract_resource("res.dat", 14249, 13929);
 trash = load_pcx("tempola.xyz",junk);
 for(i=0; i<6; i++) {
     for(j=0; j<9; j++) {
         k = (i * 9) + j;
         logo[k] = create_bitmap(32,29);
         blit(trash,logo[k],(33 * j)+1,(30 * i)+1,0,0,32,29);
                        }
                    }
 destroy_bitmap(trash);
  remove("tempola.xyz");

 // Now extract our midi file ^.^
 //
 extract_resource("res.dat", 471003, 34189);
 muzak = load_midi("tempola.xyz");

 return;
}




// NOTE: Takes pixels from source bitmap and uses them to draw a ISO
//       height field inside bitmap *BUF. Cannot blit due to non-rectangular
//       sources, which kinda sucks :(
//
void HA_draw_iso_field(BITMAP *buf)
{
 short i,j,k;                            // Loop control variables
 short _x,_y;                            // Starting x,y coords for iso cel
 short x,y;                              // Physical x,y coords for iso cel
 short s_x = 18;                         // Starting x coord for iso field
 short s_y = 7;                          // Starting y coord for iso field
 short x_off[2] = { 0, -7 };             // x offset for even number cel rows
 short p = flags.iso_pic;                // Code shortcut
 
 for(i=0; i<MAX_CELS; i++) {
         // *Hardly* efficient, but easy to follow. I could have opted to
         // create a large array of sub-bitmaps, and copy the contents of
         // each cel to its own sub-bitmap, but I just didn't feel like
         // going the extra distance just to keep the code clean ^.^
         //
         _x = cels.x[i];
         _y = cels.y[i];
         x = cels.at_x[i];
         y = cels.at_y[i];
     
         for(k=0; k<2; k++)  { putpixel(buf,x+6+k,y,iso_backs[p]->line[_y][_x+6+k]); }
         for(k=0; k<4; k++)  { putpixel(buf,x+5+k,y+1,iso_backs[p]->line[_y+1][_x+5+k]); }
         for(k=0; k<6; k++)  { putpixel(buf,x+4+k,y+2,iso_backs[p]->line[_y+2][_x+4+k]); }
         for(k=0; k<8; k++)  { putpixel(buf,x+3+k,y+3,iso_backs[p]->line[_y+3][_x+3+k]); }
         for(k=0; k<10; k++) { putpixel(buf,x+2+k,y+4,iso_backs[p]->line[_y+4][_x+2+k]); }
         for(k=0; k<12; k++) { putpixel(buf,x+1+k,y+5,iso_backs[p]->line[_y+5][_x+1+k]); }
         for(k=0; k<14; k++) { putpixel(buf,x+k,y+6,iso_backs[p]->line[_y+6][_x+k]); }
         for(k=0; k<14; k++) { putpixel(buf,x+k,y+7,iso_backs[p]->line[_y+7][_x+k]); }
         for(k=0; k<12; k++) { putpixel(buf,x+1+k,y+8,iso_backs[p]->line[_y+8][_x+1+k]); }
         for(k=0; k<10; k++) { putpixel(buf,x+2+k,y+9,iso_backs[p]->line[_y+9][_x+2+k]); }
         for(k=0; k<8; k++)  { putpixel(buf,x+3+k,y+10,iso_backs[p]->line[_y+10][_x+3+k]); }
         for(k=0; k<6; k++)  { putpixel(buf,x+4+k,y+11,iso_backs[p]->line[_y+11][_x+4+k]); }
         for(k=0; k<4; k++)  { putpixel(buf,x+5+k,y+12,iso_backs[p]->line[_y+12][_x+5+k]); }
         for(k=0; k<2; k++)  { putpixel(buf,x+6+k,y+13,iso_backs[p]->line[_y+13][_x+6+k]); }
                           }

 return;
}




// NOTE: This routine blits large scrollie text to the backbuffer.
//       It keeps time with the demo via FLAGS.SCROLLIE_POS.
//
// NOTE: This could be greatly optimized... assuming I was really bored.
//
void HA_draw_scrollie(BITMAP *buf)
{
 int j;                                  // Stores individual characters
 int i,k;                                // Loop control + shortcut variables
 int pos;                                // Tracks index inside text string

 pos = (snap.scroll * 2);

 // Quick n' dirty method for lazy fooks like myself ;)
 //
 for(i=0; i<MAX_TEXT; i++) {

     k = (32 * i) - pos;
     if(k > 0 || k < 320) {
     
         j = toupper(__text[i]);
         // Standard text
         if(j > 64 && j < 91) { masked_blit(scrollie[j-65],buf,0,0,k,205,31,19); }
         // Digits
         if(j > 47 && j < 58) { masked_blit(scrollie[j-18],buf,0,0,k,205,31,19); }
         // Colon
         if(j == 58) { masked_blit(scrollie[43],buf,0,0,k,205,31,19); }
         // Exclamation
         if(j == 33) { masked_blit(scrollie[44],buf,0,0,k,205,31,19); }
         // Period
         if(j == 46) { masked_blit(scrollie[40],buf,0,0,k,205,31,19); }
         // Comma
         if(j == 44) { masked_blit(scrollie[41],buf,0,0,k,205,31,19); }
         // Apostrophe
         if(j == 39) { masked_blit(scrollie[42],buf,0,0,k,205,31,19); }
         
                          }
                     }

 return;
}




// NOTE: Draws dot background. Cute. Very cute.
//
void HA_draw_dots(BITMAP *buf)
{
 short i,j,k;                            // Loop control variables + trackers
 short color;                            // Tracks color of dots per line
                                         // Links colors with offsets
 short lut[34] = { 224,225,226,227,228,229,230,231,
                   232,233,234,235,236,237,238,239,
                   239,238,237,236,235,234,233,232,
                   231,230,229,228,227,226,225,224,
                   224,224 };            // :)
 
 for(i=0; i<200; i+=2) {
 
     // Calculate new line color
     //
     k = (i + flags.dot_pos);
     if(k > 200) { k -= 200; }
     color = lut[k / 6];
     
     for(j=0; j<320; j+=2) {
         putpixel(buf,j,i,color);
                           }
                       }

 return;
}




// NOTE: Anything not involving the iso field or scrolly goes here.
//
void HA_draw_extras(BITMAP *buf)
{
 short i;                                // Loop control variable
 short conv;                             // For variable conversions

 // This same effect could be accomplished with two sprites (and less code)
 // with the proper color assignments, but doing shit OTF is more
 // in the spirit of the demoscene...
 //
 drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
 color_map = (COLOR_MAP *)_shadows[flags.iso_pic];

 // Left side
 //
 for(i=0; i<40; i++) { hline(buf,0,200+i,5,75); }
 for(i=0; i<40; i++) { hline(buf,6,200+i,10,130); }
 for(i=0; i<40; i++) { hline(buf,11,200+i,15,175); }
 for(i=0; i<40; i++) { hline(buf,16,200+i,20,225); }
 
 // Right side
 //
 for(i=0; i<40; i++) { hline(buf,300,200+i,304,225); }
 for(i=0; i<40; i++) { hline(buf,305,200+i,309,175); }
 for(i=0; i<40; i++) { hline(buf,310,200+i,314,130); }
 for(i=0; i<40; i++) { hline(buf,315,200+i,319,75); }

 drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);


 // Finally, we can take care of the top logo. This must be rotated to
 // match the circular path taken by the logo. Unfortunately, due to lack
 // of precision, and low resolution, this won't look spectacular. But it
 // *will* get the job done.
 //
 // There are more efficient ways to get this job done, but I'm short on
 // time, so fuck it. I really really really HATE doing things like this,
 // but draw_trans_sprite doesn handle rotation at the same time :(
 //
 color_map = (COLOR_MAP *)_lights[flags.iso_pic];
 clear(construct);
 
 for(i=0; i<MAX_LOGO; i++) {
     if(_logo.active[i]) {
         conv = (255 - (int)flags.logo_sine[i]);
         conv += 64;
         conv &= BIT_WRAP;
         rotate_sprite(construct, logo[_logo.value[i]],fixtoi(_logo.at_x[i]),fixtoi(_logo.at_y[i]), itofix(conv));
                         }
                           }
 draw_trans_sprite(buf,construct,0,0);

 return;
}




// NOTE: Having successfully completed our drawing pass, make
//       any necessary transformations to the backbuffer, and
//       transfer it to video memory. Noonch!
//
void HA_final_pass(BITMAP *buf)
{

 #ifdef __DOS
 if(flags.vsync) { vsync(); }
 blit(buf,screen,0,0,0,0,320,240);
 #endif

 #ifdef __WIN
 if(flags.vsync) { vsync(); }
 stretch_blit(buf,screen,0,0,320,240,0,0,640,480);
 #endif

 // Why you'd want to do this is... beyond me.
 //
 if(key[KEY_SPACE]) { save_pcx("capture.pcx",buf,palette); }

 return;
}




void HA_initialize_variables()
{
 int i;                                  // Loop control variable

 // Seed the rand() function
 //
 srand(time(0));

 // Create primary backbuffer
 //
 screenbuf = create_bitmap(320,240);
 
 // Create construction buffer for light-mapped logo
 //
 construct = create_bitmap(320,200);

 // Load scrollie text into buffer (laziness!)
 //
 __text = (char *)malloc(MAX_TEXT);
 strncpy(&__text[0],"HelLO! AllEgRo! Another fine waste of bandwidth courtesy of RedKarma.         Sirocco would like to thank:         Matthew Leverton           Our benevolent leader, and driving force behind the world's premier Allegro portal.            PoVRAZOR, for his unending support, and everyone else at RedKarma.         Let's also stop and thank everyone who has contributed to Allegro, and the community!                And now for some Miscellaneous greetz:      Layton    Senn    MuOn    Beelzebub    SCorpion    Obyam Ouch    Keeper of Death    The Led Zipper    Zeb    Mercen 505    Bongtastic!    Ethereal Cereal    Skywise    Tsu and the Emu    Mandrake    Golrien    Darkdread    JonA    Lbt1st    Stover    Retro    White Door    Pyrus    Bahamut    RATM    TOFU    Anthracks    Mikkom               Thank God for esperanto and secret handshakes...              The orange ones are candy.                See you soon, when Frenetic Plus goes public!                                   ",1000);

 // Always good practice to clear ALL variables before starting :)
 //
 for(i=0; i<MAX_CELS; i++) {
    cels.x[i]    = 0;
    cels.y[i]    = 0;
    cels.at_x[i] = 0;
    cels.at_y[i] = 0;
    cels.dir[i]  = 0;
    cels.dist[i] = 0;
                           }

 // Set initial values for our demo flags
 //
 flags.scrollie_pos = -100;
 flags.dot_pos      = 0;
 flags.iso_mode     = 4;
 flags.iso_pic      = 0;
 flags.exit         = 0;
 flags.move_cels    = 0;
 flags.move_logo    = 0;
 flags.sine         = 0;
 flags.pause_sine   = 0;
 flags.no_audio     = 0;

 #ifdef __DOS
 flags.vsync        = 1;
 #endif

 #ifdef __WIN
 flags.vsync        = 0;
 #endif


 // Set initial values for logo letters to be spawned
 //
 for(i=0; i<MAX_LOGO; i++) { flags.logo_spawn[i] = -1; }
 // Allegro!
 flags.logo_spawn[0] = -1;     _logo.value[0] = 27;
 flags.logo_spawn[1] = 35;     _logo.value[1] = 14;
 flags.logo_spawn[2] = 70;     _logo.value[2] = 17;
 flags.logo_spawn[3] = 105;    _logo.value[3] = 6;
 flags.logo_spawn[4] = 140;    _logo.value[4] = 4;
 flags.logo_spawn[5] = 175;    _logo.value[5] = 11;
 flags.logo_spawn[6] = 210;    _logo.value[6] = 11;
 flags.logo_spawn[7] = 245;    _logo.value[7] = 0;

 // Hello!
 flags.logo_spawn[8] = 350;    _logo.value[8] = 27;
 flags.logo_spawn[9] = 385;    _logo.value[9] = 14;
 flags.logo_spawn[10] = 420;   _logo.value[10] = 11;
 flags.logo_spawn[11] = 455;   _logo.value[11] = 11;
 flags.logo_spawn[12] = 490;   _logo.value[12] = 4;
 flags.logo_spawn[13] = 525;   _logo.value[13] = 7;
 
 // Set values for initial letter
 //
 _logo.at_x[0]   = itofix(63);
 _logo.at_y[0]   = itofix(85);
 _logo.active[0] = 1;
 _logo.index[0]  = 0;

 // Now initialize all other letters
 //
 for(i=1; i<MAX_LOGO; i++) {
     _logo.at_x[i]   = itofix(-50);
     _logo.at_y[i]   = itofix(85);
     _logo.active[i] = 0;
     _logo.index[i]  = 0;
                           }

 return;
}




// NOTE: Calls upon palette tint routines if needed, and sets palette.
//       Otherwise, does nothing.
//
void HA_modify_palette(PALETTE _pal)
{
 // Nothing to do, so exit
 //
 if(snap.tint == -1) { return; }

 // Restore default palette
 //
 if(snap.tint == -2) {
     set_palette_range(iso_pal[flags.iso_pic],0,255,0);
     flags.tint_pending = -1;
     return;
                     }

 // Tint palette (white burst, although we could use any color)
 //
 HA_tint_palette(iso_pal[flags.iso_pic], 63, 63, 63, snap.tint, 0, 1);

 // we have to use this, otherwise vsync will be called
 //
 set_palette_range(tinted,0,255,0);

 return;
}




// NOTE: Tints specified palette with the given R,G,B values, and also
//       takes into consideration factors such as tint strength, and overall
//       palette luma value. Due to excessive math, this should NOT be called
//       inside a timer!
//
// NOTE: This code is veeeeeeeeeeeeery old. You've been warned.
//
void HA_tint_palette(PALETTE _pal, int red, int green, int blue, int percent, int luma, int full)
{
 // If LUMA !=0, adjust WORK_PALETTE to % strength value of LUMA (1-100)
 // if FULL !=0, do whole palette, otherwise only do latter half
 //
 int old_red, old_green, old_blue;
 int pal_reg = 0;
 int loop = 0;
 int start;
 float constant = (float)percent/100;
 float adjust = 0.0;

 if(full) { start = 0;   }
 else     { start = 128; }
 
 if(percent == 100) { constant = 0.000; }

 for(loop=start; loop<256; loop++) {
             old_red = _pal[loop].r;
             old_green = _pal[loop].g;
             old_blue = _pal[loop].b;

             tinted[loop].r = (unsigned char)(old_red+((int)red - (int)old_red)* constant);
             tinted[loop].g = (unsigned char)(old_green+((int)green - (int)old_green)* constant);
             tinted[loop].b = (unsigned char)(old_blue+((int)blue - (int)old_blue)* constant);

             if(luma && luma != 100) {
               adjust = (float)(((float)tinted[loop].r/100) * (float)luma);
                        tinted[loop].r = (int)adjust;
               adjust = (float)(((float)tinted[loop].g/100) * (float)luma);
                        tinted[loop].g = (int)adjust;
               adjust = (float)(((float)tinted[loop].b/100) * (float)luma);
                        tinted[loop].b = (int)adjust;
                                     }
                                   }

 return;
}




// Symify owns my soul. I suppose this has uses as well.
//
void HA_status_log_i(const char *__textstring, int value)
{
  FILE *logfile;

  logfile = fopen("logfile", "a+");      // Append new line at EOF
  fprintf(logfile, " %s %d\n",__textstring, value);
  fclose(logfile);

 return;
}




// NOTE: I prefer this approach to delta time for 2D applications. Mea culpa.
//
void HA_take_snapshot()
{
 snap.scroll = flags.scrollie_pos;
 snap.tint   = flags.tint_pending;
 
 return;
}




// NOTE: Uses demo heartbeat to time ISO field transitions
//
void HA_track_transition()
{
 short i;                                // Loop control variable
 
 if(flags.tocks > 1568) {
 
    // Change to next picture
    //
    if(flags.iso_pic < 9) { flags.iso_pic++; }
    else                  { flags.exit = 1;  return; }

    // Take care of any palette issues
    //
    set_palette_range(iso_pal[flags.iso_pic],0,255,0);
    flags.tint_pending = 100;

    // Randomly choose next ISO cel behavior
    //
    flags.iso_mode = 1 + (rand() % 1000) / 250;

    // Reset ISO field to default values
    //
    flags.tocks = 0;
    flags.sine = 0;
    flags.pause_sine = 45;
    HA_assign_iso_field(flags.iso_mode);

    // Due to a slight oversight on my part, the rolling logo tends to
    // drift upward as the demo rolls on. Probably just some shitty math.
    // We'll counter this by dropping the logo by four pixels per transition,
    // because in the midst of a palette flash we can hide the movement.
    //
    for(i=0; i<MAX_LOGO; i++) { _logo.at_y[i] += itofix(4); }
    
                        }

 return;
}




// NOTE: Ugly, but maybe I'll make it more elegant later... maybe.
//
void HA_read_color_maps()
{
 FILE *file;
 short i;
 
 file = fopen("res_2.dat","rb");

 for(i=0; i<256; i++) {
      lights_1.data[103][i] = fgetc(file);
      lights_1.data[176][i] = fgetc(file);
      shadows_1.data[75][i] = fgetc(file);
      shadows_1.data[130][i] = fgetc(file);
      shadows_1.data[175][i] = fgetc(file);
      shadows_1.data[225][i] = fgetc(file);

      lights_2.data[103][i] = fgetc(file);
      lights_2.data[176][i] = fgetc(file);
      shadows_2.data[75][i] = fgetc(file);
      shadows_2.data[130][i] = fgetc(file);
      shadows_2.data[175][i] = fgetc(file);
      shadows_2.data[225][i] = fgetc(file);

      lights_3.data[103][i] = fgetc(file);
      lights_3.data[176][i] = fgetc(file);
      shadows_3.data[75][i] = fgetc(file);
      shadows_3.data[130][i] = fgetc(file);
      shadows_3.data[175][i] = fgetc(file);
      shadows_3.data[225][i] = fgetc(file);

      lights_4.data[103][i] = fgetc(file);
      lights_4.data[176][i] = fgetc(file);
      shadows_4.data[75][i] = fgetc(file);
      shadows_4.data[130][i] = fgetc(file);
      shadows_4.data[175][i] = fgetc(file);
      shadows_4.data[225][i] = fgetc(file);

      lights_5.data[103][i] = fgetc(file);
      lights_5.data[176][i] = fgetc(file);
      shadows_5.data[75][i] = fgetc(file);
      shadows_5.data[130][i] = fgetc(file);
      shadows_5.data[175][i] = fgetc(file);
      shadows_5.data[225][i] = fgetc(file);

      lights_6.data[103][i] = fgetc(file);
      lights_6.data[176][i] = fgetc(file);
      shadows_6.data[75][i] = fgetc(file);
      shadows_6.data[130][i] = fgetc(file);
      shadows_6.data[175][i] = fgetc(file);
      shadows_6.data[225][i] = fgetc(file);

      lights_7.data[103][i] = fgetc(file);
      lights_7.data[176][i] = fgetc(file);
      shadows_7.data[75][i] = fgetc(file);
      shadows_7.data[130][i] = fgetc(file);
      shadows_7.data[175][i] = fgetc(file);
      shadows_7.data[225][i] = fgetc(file);

      lights_8.data[103][i] = fgetc(file);
      lights_8.data[176][i] = fgetc(file);
      shadows_8.data[75][i] = fgetc(file);
      shadows_8.data[130][i] = fgetc(file);
      shadows_8.data[175][i] = fgetc(file);
      shadows_8.data[225][i] = fgetc(file);

      lights_9.data[103][i] = fgetc(file);
      lights_9.data[176][i] = fgetc(file);
      shadows_9.data[75][i] = fgetc(file);
      shadows_9.data[130][i] = fgetc(file);
      shadows_9.data[175][i] = fgetc(file);
      shadows_9.data[225][i] = fgetc(file);

      lights_10.data[103][i] = fgetc(file);
      lights_10.data[176][i] = fgetc(file);
      shadows_10.data[75][i] = fgetc(file);
      shadows_10.data[130][i] = fgetc(file);
      shadows_10.data[175][i] = fgetc(file);
      shadows_10.data[225][i] = fgetc(file);
                      }
                      
 fclose(file);
 
 return;
}




// NOTE: Some *really* old code, because I dislike Allegro's datafiles. Yep.
//
void extract_resource(char *file, long offset, long len)
{
 FILE *write;                            // We don't *need* two handles,
 FILE *read;                             // but it looks nice :)

 unsigned char buffer[128000];           // We won't deal with anything larger than this
 long i;                                 // Loop control variable

 // Clear buffer of any garbage
 //
 for(i=0; i<128000; i++) { buffer[i] = 0; }

 // Open file and set offset
 //
 read = fopen(file,"rb");
 fseek(read,offset,SEEK_SET);

 for(i=0; i<len; i++) {
     buffer[i] = fgetc(read); 
                      }
 fclose(read);

 
 // Create temp file and write contents
 //
 write = fopen("tempola.xyz","wb");

 for(i=0; i<len; i++) {
     fputc(buffer[i],write);
                      }
 fclose(write);

 return;
}







