

#include "ship.h"


ship::ship(int elx,int ely,int d, bool explodes, int imType,bool invince, bool Kami,int spd,bool miss,bool PlS, FlightPattern * elFP,int ppn,bool joy):pHeading(d), pExplodesDuringCollision(explodes), pImageType(imType), pKamikaze(Kami), pImmune(invince), pSpeed(spd),pPatName(ppn),pMissileChucker(miss),pPlayerShot(PlS), pUsingJoy(joy)
{
	pStopped=false;
	pFrameToShow=0;
	pTargeted=false;	
	pLocal.x=itofix(elx);
	pLocal.y=itofix(ely);	
	pTarget=NULL;	
	pFP=elFP;
	pLoaded=false;
	pMissileLoaded=false;
	pMarked=false;
	pExploding=false;
	pDived=false;
	place=pFP->Start();
	pHardAngle=0;
	pSaucer=((invince)&&(!Kami));     //invincible and not kamikaze (i.e hardshooters and missilechuckers, but not missiles)
	pExTime=0;
//	ZeroChangeCount=0;
}

ship::~ship()
{

}

ship * ship::Target()
{
	return pTarget;
}
bool ship::MissileChucker()
{
	return pMissileChucker;
}

bool ship::Exploding()
{
	return pExploding;
}
void ship::Detarget()
{
	pTargeted=false;
}
bool ship::Targeted()
{
	return pTargeted;
}
bool ship::Immune()
{
	return pImmune;
}
bool ship::Dived()
{
	return pDived;
}
void ship::Dive()
{
	pDiveCount=0;
	pDived=true;
	pImageType=PLAYER_DIVED;
}

bool ship::PlayerShot()
{
	return pPlayerShot;
}
void ship::Explode()
{
	if (!pExploding)
	{
		pExploding=true;
		pFrameToShow=0;
		pImageType=EXPLOSION_IMAGE;
	}
}
void ship::Shoot()
{
	pLoaded=false;
}
void ship::Load()
{
	pLoaded=true;
}
bool ship::Loaded()
{
	return pLoaded;	
}
bool ship::MissileLoaded()
{
	return pMissileLoaded;
}
int ship::HardAngle()
{
	return pHardAngle;
}
void ship::ShootMissile()
{
	pMissileLoaded=false;
}
void ship::LoadMissile()
{
	pMissileLoaded=true;
}
void ship::SetTarget(ship*targ)
{
	if ((pPatName != TO_AND_FRO)&&(pPatName != TO_AND_FROWARD))
	{
		pTargeted=true;
		pTarget=targ;
	}
}
void ship::AI()
{
	if (pTargeted)   // try to kill target
	{
		int deltax1 = ((X()-pTarget->X())+(BACKGROUND_WIDTH*2))%BACKGROUND_WIDTH;
		int deltay1 = ((Y()-pTarget->Y())+(BACKGROUND_HEIGHT*2))%BACKGROUND_HEIGHT;
		int deltax2 = ((pTarget->X()-X())+(BACKGROUND_WIDTH*2))%BACKGROUND_WIDTH;
		int deltay2 = ((pTarget->Y()-Y())+(BACKGROUND_HEIGHT*2))%BACKGROUND_HEIGHT;
			
		int dx = (deltax1>deltax2) ? deltax2:deltax1 ;
		int dy = (deltay1>deltay2) ? deltay2:deltay1 ;
			
		fixed a = (fixdiv(itofix(dy),itofix(dx)));
		fixed ra2t= fixatan(a);        //reference angle to target
	//	bool turnPos=false;
			
			
		int headNeeded=fixtoi(ra2t);    //heading needed to chase target;
		
		if (deltax1<deltax2)
			headNeeded=128-headNeeded;
		if (deltay1<deltay2)
			headNeeded=256-headNeeded;

		int angle1=((pHeading-headNeeded)+512)%256;
		int angle2=((headNeeded-pHeading)+512)%256;
			
		if (angle1>angle2)
		{
			Rotate((angle1<3)? angle1:3);
		}
		else
		{
			Rotate((angle2<3)? angle2:-3);
		}
		//allegro_message("[%i/%i,%i]",(pTarget->Y()-fixtoi(pLocal.y)),(pTarget->X()-fixtoi(pLocal.x)),pHeading  );
		if (!pKamikaze)
		{
			
			if ((angle1<10)||(angle2<10))
			{
				if (pMissileChucker)
				{
					LoadMissile();	
				}
				else
				{
					Load();
				}
				pTargeted=false;			
				
			}
				
		}
	}
	else        //follow flight pattern
	{
		Rotate(place->r);
		place=place->next;
	}
}
void ship::FPErratik()
{
	Rotate(((rand() % 13) - 6)+ place->r);
	place=place->next;
}
bool ship::Marked()
{
	return pMarked;
}
bool ship::Saucer()
{
	return pSaucer;
}
void ship::Move(int px, int py)
{
	pLocal.x += pSpeed*fixcos(itofix(pHeading));
	pLocal.y += pSpeed*fixsin(itofix(pHeading));
	if ((!pExploding)&&(!pSaucer)&&(!pUsingJoy))     //no joystick
		pFrameToShow=STRAIGHT;
	if (pUsingJoy)              //joystick - don't immediately return to straight
	{
		if (ZeroChangeCount>=ZERO_CHANGE_THRESHOLD)
			if ((!pExploding)&&(!pSaucer))
				pFrameToShow=STRAIGHT;
		
	}
	
	
	
	if (X() >= BACKGROUND_WIDTH)
	{
		pLocal.x -= itofix(BACKGROUND_WIDTH) ;
	}
	else if (X() < 0)
	{
		pLocal.x += itofix(BACKGROUND_WIDTH) ;
	}
	if (Y() >= BACKGROUND_HEIGHT)
	{
		pLocal.y -= itofix(BACKGROUND_HEIGHT) ;
	}
	else if (Y() < 0)
	{
		pLocal.y += itofix(BACKGROUND_HEIGHT );
	}
	
	int deltax1 = ((X()-px)+(BACKGROUND_WIDTH*2))%BACKGROUND_WIDTH;
	int deltay1 = ((Y()-py)+(BACKGROUND_HEIGHT*2))%BACKGROUND_HEIGHT;
	int deltax2 = ((px-X())+(BACKGROUND_WIDTH*2))%BACKGROUND_WIDTH;
	int deltay2 = ((py-Y())+(BACKGROUND_HEIGHT*2))%BACKGROUND_HEIGHT;
			
	int dx = (deltax1>deltax2) ? deltax2:deltax1 ;
	int dy = (deltay1>deltay2) ? deltay2:deltay1 ;
	if ((dx>BORDER)||(dy>BORDER))
		pMarked=true;
	if (pExploding)
	{
		pExTime++;
		if (pExTime==CYCLES_PER_EXPLOSION_CHANGE)
		{
			pExTime=0;
			pFrameToShow++;
			if (pFrameToShow==8)
				pMarked=true;
		}
	}
	if (pDived)
	{
		pDiveCount++;
		if (pDiveCount==DIVE_LENGTH)
		{
			pDived=false;
			pImageType=PLAYER_IMAGE;
		//	play_sample(THE_SAMPLES[DIVE_UP],255,128,1000,false);
		}
			
	}
	pHardAngle+=SAUCER_ROTATION_RATE;
	if ((pSaucer)&&(pHardAngle%SAUCER_CHANGE_RATE==0)&&(!pExploding))
	{
		pFrameToShow++;
		pFrameToShow%=3;
	}
}
int ship::X()
{
	return fixtoi(pLocal.x);
}
int ship::Y()
{
	return fixtoi(pLocal.y);
}
void ship::Rotate(int delta)
{
	pHeading+=delta;
	while (pHeading<0)
		pHeading+=256;  //get it between 0 and 255
	while (pHeading>255)
		pHeading-=256;
	
	if ((!pExploding)&&(!pSaucer))
		if (delta>0)
		{
			ZeroChangeCount=0;
			pFrameToShow=RIGHT_BANK;
		}
		else if (delta<0)
		{
			ZeroChangeCount=0;
			pFrameToShow=LEFT_BANK;
		}
		else
		{
			ZeroChangeCount++;
			
		}
}
void ship::TurnTo(int angle)
{
	pHeading=angle;
	while (pHeading<0)
		pHeading+=256;  //get it between 0 and 255
	while (pHeading>255)
		pHeading-=256;
}
int ship::Heading()
{
	return pHeading;
}
int ship::Image()
{
	return pImageType;
}
int ship::Frame()
{
	return pFrameToShow;
}
